/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.gui.GComboBox;
import org.greenstone.gatherer.gui.tree.DragTree;

public class Filter
extends JPanel {
    private ArrayList others = null;
    private boolean first = true;
    private boolean ignore = false;
    private Filter this_filter = null;
    private JCheckBox checkbox = null;
    private GComboBox combobox = null;
    private JLabel label = null;
    private DragTree tree = null;
    private static final Dimension SIZE = new Dimension(100, 30);
    private static final String[] DEFAULTS = new String[]{"^.*\\.html?$", "^.*\\.xml$", "^.*\\.txt$", "(^.*\\.jpe?g$)|(^.*\\.png$)|(^.*\\.gif$)|(^.*\\.bmp$)|(^.*\\.tiff?$)", "^.*\\.pdf$", "(^.*\\.docx?$)|(^.*\\.pptx?$)|(^.*\\.xlsx?$)|(^.*\\.od(t|s|p)$)"};

    public Filter(DragTree dragTree) {
        this(dragTree, null);
    }

    public Filter(DragTree dragTree, ArrayList arrayList) {
        this.setComponentOrientation(Dictionary.getOrientation());
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.others = arrayList;
        this.others.add(this);
        this.this_filter = this;
        this.tree = dragTree;
        this.combobox = new GComboBox(true);
        try {
            this.combobox.add(new Entry());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < DEFAULTS.length; ++i) {
            try {
                Entry entry = new Entry(Dictionary.get("Filter." + i), Pattern.compile(DEFAULTS[i]));
                this.combobox.add(entry);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.label = new JLabel(Dictionary.get("Filter.Filter_Tree"));
        this.label.setComponentOrientation(Dictionary.getOrientation());
        this.label.setComponentOrientation(Dictionary.getOrientation());
        this.combobox.setToolTipText(Dictionary.get("Collection.Filter_Tooltip"));
        this.combobox.addActionListener(new ComboBoxListener());
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Before");
        this.add((Component)this.combobox, "Center");
    }

    @Override
    public void setEnabled(boolean bl) {
        this.ignore = true;
        this.combobox.setEnabled(bl);
        this.ignore = false;
    }

    public void setComboBoxModel(ComboBoxModel comboBoxModel) {
        this.combobox.setModel(comboBoxModel);
    }

    public void setComboBoxSelection(Entry entry) {
        this.ignore = true;
        this.combobox.setSelectedItem(entry);
        this.ignore = false;
    }

    public void setEditable(boolean bl) {
        this.combobox.setEditable(bl);
    }

    public void setFirst(boolean bl) {
        this.first = bl;
    }

    private String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '.': {
                    stringBuffer.append("\\.");
                    continue block5;
                }
                case '*': {
                    stringBuffer.append(".*");
                    continue block5;
                }
                case '?': {
                    stringBuffer.append(".");
                    continue block5;
                }
                default: {
                    stringBuffer.append(Character.toLowerCase(c));
                }
            }
        }
        return stringBuffer.toString();
    }

    private void setFilter(Pattern pattern) {
        Gatherer.g_man.wait(true);
        FileSystemModel fileSystemModel = (FileSystemModel)this.tree.getModel();
        if (pattern != null) {
            fileSystemModel.setFilter(pattern.pattern());
        } else {
            fileSystemModel.setFilter(null);
        }
        this.tree.refresh(null);
        Gatherer.g_man.wait(false);
    }

    private class Entry
    implements Comparable {
        private Pattern pattern = null;
        private String name = null;

        public Entry() {
        }

        public Entry(String string, Pattern pattern) {
            this.name = string;
            this.pattern = pattern;
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String toString() {
            String string = null;
            string = this.name != null ? this.name : (this.pattern == null ? Dictionary.get("Filter.All_Files") : this.pattern.pattern());
            return string;
        }
    }

    private class ComboBoxListener
    implements ActionListener {
        private ComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block8: {
                try {
                    Object object = Filter.this.combobox.getSelectedItem();
                    Entry entry = null;
                    if (object instanceof String) {
                        String string = (String)object;
                        if (!(string.equals(Dictionary.get("Filter.All_Files")) || string.equals(Dictionary.get("Filter.0")) || string.equals(Dictionary.get("Filter.1")) || string.equals(Dictionary.get("Filter.2")) || string.equals(Dictionary.get("Filter.3")) || string.equals(Dictionary.get("Filter.4")) || string.equals(Dictionary.get("Filter.5")))) {
                            int n;
                            boolean bl = false;
                            for (n = 0; n < Filter.this.combobox.getItemCount(); ++n) {
                                if (!string.equals(Filter.this.combobox.getItemAt(n).toString())) continue;
                                bl = true;
                                entry = (Entry)Filter.this.combobox.getItemAt(n);
                                break;
                            }
                            if (!bl) {
                                entry = new Entry(string, Pattern.compile(Filter.this.encode(string)));
                                n = Filter.this.combobox.getItemCount();
                                Filter.this.combobox.insertItemAt(entry, n);
                                Filter.this.combobox.setSelectedIndex(n);
                            }
                        }
                    } else {
                        entry = (Entry)object;
                    }
                    if (entry != null) {
                        Filter.this.setFilter(entry.getPattern());
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (!Filter.this.first) break block8;
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("Filter.Invalid_Pattern"), Dictionary.get("General.Error"), 0);
                }
            }
        }
    }
}

