/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileAssociationManager;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.GUIUtils;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.NonWhitespaceField;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.util.TableUtils;
import org.greenstone.gatherer.util.Utility;

public class FileAssociationDialog
extends ModalDialog {
    private static final Dimension SIZE = new Dimension(600, 450);
    private boolean ignore = false;
    private FileAssociationDialog self;
    private FileAssociationManager file_association_manager;
    private JButton add_button;
    private JButton browse_button;
    private JButton close_button;
    private JButton remove_button;
    private JButton replace_button;
    private JTable existing_associations_table;
    private JTextField command_field;
    private JTextField extension_field;

    public FileAssociationDialog(FileAssociationManager fileAssociationManager) {
        super(Gatherer.g_man);
        this.file_association_manager = fileAssociationManager;
        this.self = this;
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setModal(true);
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("FileAssociationDialog.Title"));
        this.setJMenuBar(new SimpleMenuBar("fileassociations"));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JTextArea jTextArea = new JTextArea(Dictionary.get("FileAssociationDialog.Instructions"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(5);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        this.existing_associations_table = new JTable(fileAssociationManager);
        this.existing_associations_table.setComponentOrientation(Dictionary.getOrientation());
        this.existing_associations_table.setAutoResizeMode(1);
        this.existing_associations_table.setColumnSelectionAllowed(false);
        this.existing_associations_table.setSelectionMode(0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("FileAssociationDialog.Extension"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        this.extension_field = new NonWhitespaceField();
        this.extension_field.setToolTipText(Dictionary.get("FileAssociationDialog.Extension_Tooltip"));
        JLabel jLabel2 = new JLabel(Dictionary.get("FileAssociationDialog.Command"));
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel6 = new JPanel();
        jPanel6.setComponentOrientation(Dictionary.getOrientation());
        this.command_field = new JTextField();
        this.command_field.setComponentOrientation(Dictionary.getOrientation());
        this.command_field.setToolTipText(Dictionary.get("FileAssociationDialog.Command_Tooltip"));
        this.browse_button = new GLIButton(Dictionary.get("FileAssociationDialog.Browse"));
        this.browse_button.setEnabled(!Utility.isMac());
        if (Utility.isMac()) {
            this.browse_button.setToolTipText(Dictionary.get("FileAssociationDialog.Browse_Tooltip_Mac"));
        } else {
            this.browse_button.setToolTipText(Dictionary.get("FileAssociationDialog.Browse_Tooltip"));
        }
        JPanel jPanel7 = new JPanel();
        jPanel7.setComponentOrientation(Dictionary.getOrientation());
        this.add_button = new GLIButton(Dictionary.get("FileAssociationDialog.Add"), Dictionary.get("FileAssociationDialog.Add_Tooltip"));
        this.add_button.setEnabled(false);
        this.replace_button = new GLIButton(Dictionary.get("FileAssociationDialog.Replace"), Dictionary.get("FileAssociationDialog.Replace_Tooltip"));
        this.replace_button.setEnabled(false);
        this.remove_button = new GLIButton(Dictionary.get("FileAssociationDialog.Remove"), Dictionary.get("FileAssociationDialog.Remove_Tooltip"));
        this.remove_button.setEnabled(false);
        this.close_button = new GLIButton(Dictionary.get("FileAssociationDialog.Close"), Dictionary.get("FileAssociationDialog.Close_Tooltip"));
        this.add_button.addActionListener(new AddButtonListener());
        this.browse_button.addActionListener(new BrowseButtonListener());
        this.close_button.addActionListener(new CloseButtonListener());
        this.remove_button.addActionListener(new RemoveButtonListener());
        this.replace_button.addActionListener(new ReplaceButtonListener());
        CommandOrExtensionFieldListener commandOrExtensionFieldListener = new CommandOrExtensionFieldListener();
        this.command_field.getDocument().addDocumentListener(commandOrExtensionFieldListener);
        this.extension_field.getDocument().addDocumentListener(commandOrExtensionFieldListener);
        commandOrExtensionFieldListener = null;
        this.existing_associations_table.getSelectionModel().addListSelectionListener(new ExistingAssociationsTableListener());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        jPanel5.setLayout(new BorderLayout(5, 0));
        jPanel5.add((Component)jLabel, "Before");
        jPanel5.add((Component)this.extension_field, "Center");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)this.command_field, "Center");
        jPanel6.add((Component)this.browse_button, "After");
        jPanel4.setBorder(BorderFactory.createTitledBorder(Dictionary.get("FileAssociationDialog.Details")));
        jPanel4.setLayout(new GridLayout(3, 1));
        jPanel4.add(jPanel5);
        jPanel4.add(jLabel2);
        jPanel4.add(jPanel6);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jPanel7.setLayout(new GridLayout(2, 3));
        jPanel7.add(this.add_button);
        jPanel7.add(this.replace_button);
        jPanel7.add(this.remove_button);
        JPanel jPanel8 = new JPanel();
        jPanel8.setComponentOrientation(Dictionary.getOrientation());
        jPanel7.add(jPanel8);
        jPanel8 = new JPanel();
        jPanel8.setComponentOrientation(Dictionary.getOrientation());
        jPanel7.add(jPanel8);
        jPanel7.add(this.close_button);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jPanel7, "South");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.existing_associations_table);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)jScrollPane, "North");
        jPanel.add((Component)jPanel2, "Center");
        Rectangle rectangle = Gatherer.g_man.getBounds(null);
        this.setLocation((int)(rectangle.getX() + (rectangle.getWidth() - (double)FileAssociationDialog.SIZE.width) / 2.0), (int)(rectangle.getY() + (rectangle.getHeight() - (double)FileAssociationDialog.SIZE.height) / 2.0));
        rectangle = null;
    }

    public void destroy() {
        this.file_association_manager = null;
        this.self = null;
    }

    public String display(String string) {
        this.existing_associations_table.clearSelection();
        if (string != null) {
            this.extension_field.setText(string);
        }
        this.setVisible(true);
        if (string != null) {
            return this.file_association_manager.getCommandString(string);
        }
        return null;
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 205) {
            TableUtils.fixColumnToPreferredWidth(this.existing_associations_table, 0);
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    private class ReplaceButtonListener
    implements ActionListener {
        private ReplaceButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileAssociationDialog.this.file_association_manager.setCommand(FileAssociationDialog.this.extension_field.getText(), FileAssociationDialog.this.command_field.getText());
            FileAssociationDialog.this.replace_button.setEnabled(false);
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileAssociationDialog.this.file_association_manager.setCommand(FileAssociationDialog.this.extension_field.getText(), null);
            FileAssociationDialog.this.add_button.setEnabled(true);
            FileAssociationDialog.this.remove_button.setEnabled(false);
        }
    }

    private class ExistingAssociationsTableListener
    implements ListSelectionListener {
        private ExistingAssociationsTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting() && !FileAssociationDialog.this.ignore) {
                int n = -1;
                n = FileAssociationDialog.this.existing_associations_table.getSelectionModel().getMinSelectionIndex();
                if (n != -1) {
                    String string = FileAssociationDialog.this.file_association_manager.getExtension(n);
                    FileAssociationDialog.this.extension_field.setText(string);
                    FileAssociationDialog.this.command_field.setText(FileAssociationDialog.this.file_association_manager.getCommandString(string));
                    string = null;
                    FileAssociationDialog.this.remove_button.setEnabled(true);
                } else {
                    FileAssociationDialog.this.extension_field.setText("");
                    FileAssociationDialog.this.command_field.setText("");
                    FileAssociationDialog.this.remove_button.setEnabled(false);
                }
                FileAssociationDialog.this.add_button.setEnabled(false);
                FileAssociationDialog.this.replace_button.setEnabled(false);
            }
        }
    }

    private class ExecutableFileFilter
    extends FileFilter {
        private ExecutableFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".exe");
        }

        @Override
        public String getDescription() {
            return Dictionary.get("FileAssociationDialog.Executable_File");
        }
    }

    private class CommandOrExtensionFieldListener
    implements DocumentListener {
        private CommandOrExtensionFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        private void changed() {
            FileAssociationDialog.this.ignore = true;
            String string = FileAssociationDialog.this.extension_field.getText();
            String string2 = FileAssociationDialog.this.command_field.getText();
            int n = -1;
            n = FileAssociationDialog.this.existing_associations_table.getSelectionModel().getMinSelectionIndex();
            if (n != -1) {
                String string3 = FileAssociationDialog.this.file_association_manager.getExtension(n);
                String string4 = FileAssociationDialog.this.file_association_manager.getCommandString(string3);
                if (string.equals(string3)) {
                    FileAssociationDialog.this.remove_button.setEnabled(true);
                    if (string4.length() == 0) {
                        FileAssociationDialog.this.add_button.setEnabled(true);
                        FileAssociationDialog.this.replace_button.setEnabled(false);
                    } else if (!string2.equals(string4)) {
                        FileAssociationDialog.this.add_button.setEnabled(false);
                        FileAssociationDialog.this.replace_button.setEnabled(true);
                    } else {
                        FileAssociationDialog.this.add_button.setEnabled(false);
                        FileAssociationDialog.this.replace_button.setEnabled(false);
                    }
                } else {
                    FileAssociationDialog.this.existing_associations_table.clearSelection();
                    FileAssociationDialog.this.add_button.setEnabled(true);
                    FileAssociationDialog.this.remove_button.setEnabled(false);
                    FileAssociationDialog.this.replace_button.setEnabled(false);
                }
            } else {
                int n2 = -1;
                for (int i = 0; n2 == -1 && i < FileAssociationDialog.this.file_association_manager.size(); ++i) {
                    String string5 = FileAssociationDialog.this.file_association_manager.getExtension(i);
                    if (!string5.equals(string)) continue;
                    n2 = i;
                }
                if (n2 != -1) {
                    FileAssociationDialog.this.existing_associations_table.setRowSelectionInterval(n2, n2);
                    FileAssociationDialog.this.add_button.setEnabled(false);
                    FileAssociationDialog.this.remove_button.setEnabled(true);
                    FileAssociationDialog.this.replace_button.setEnabled(true);
                } else if (string.length() > 0 && string2.length() > 0) {
                    FileAssociationDialog.this.add_button.setEnabled(true);
                    FileAssociationDialog.this.remove_button.setEnabled(false);
                    FileAssociationDialog.this.replace_button.setEnabled(false);
                } else {
                    FileAssociationDialog.this.add_button.setEnabled(false);
                    FileAssociationDialog.this.remove_button.setEnabled(false);
                    FileAssociationDialog.this.replace_button.setEnabled(false);
                }
            }
            FileAssociationDialog.this.ignore = false;
        }
    }

    private class CoreObjectModelFileFilter
    extends FileFilter {
        private CoreObjectModelFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".com");
        }

        @Override
        public String getDescription() {
            return Dictionary.get("FileAssociationDialog.Command_File");
        }
    }

    private class CloseButtonListener
    implements ActionListener {
        private CloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileAssociationDialog.this.existing_associations_table.clearSelection();
            FileAssociationDialog.this.add_button.setEnabled(false);
            FileAssociationDialog.this.remove_button.setEnabled(false);
            FileAssociationDialog.this.replace_button.setEnabled(false);
            FileAssociationDialog.this.self.dispose();
        }
    }

    private class BrowseButtonListener
    implements ActionListener {
        private BrowseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(new File(Gatherer.getGLIUserDirectoryPath()));
            GUIUtils.disableRename(jFileChooser);
            jFileChooser.setDialogTitle(Dictionary.get("FileAssociationDialog.Browse_Title"));
            jFileChooser.setFileFilter(new BatchFileFilter());
            jFileChooser.setFileFilter(new CoreObjectModelFileFilter());
            jFileChooser.setFileFilter(new ExecutableFileFilter());
            jFileChooser.setAcceptAllFileFilterUsed(true);
            if (jFileChooser.showOpenDialog(Gatherer.g_man) == 0) {
                FileAssociationDialog.this.command_field.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class BatchFileFilter
    extends FileFilter {
        private BatchFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".bat");
        }

        @Override
        public String getDescription() {
            return Dictionary.get("FileAssociationDialog.Batch_File");
        }
    }

    private class AddButtonListener
    implements ActionListener {
        private AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = FileAssociationDialog.this.extension_field.getText();
            FileAssociationDialog.this.file_association_manager.setCommand(string, FileAssociationDialog.this.command_field.getText());
            int n = -1;
            for (int i = 0; n == -1 && i < FileAssociationDialog.this.file_association_manager.size(); ++i) {
                if (!FileAssociationDialog.this.file_association_manager.getExtension(i).equals(string)) continue;
                n = i;
            }
            if (n > -1) {
                FileAssociationDialog.this.existing_associations_table.setRowSelectionInterval(n, n);
            }
            FileAssociationDialog.this.add_button.setEnabled(false);
            FileAssociationDialog.this.remove_button.setEnabled(true);
        }
    }
}

