/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.ArgumentControl;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Plugin;
import org.greenstone.gatherer.collection.Collection;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.collection.ScriptOptions;
import org.greenstone.gatherer.feedback.Base64;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.SimpleResultDialog;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;

public class ExplodeMetadataDatabasePrompt
extends ModalDialog
implements GShellListener {
    private static Dimension SIZE = new Dimension(675, 350);
    private JDialog self = this;
    private File metadata_file = null;
    private Argument plugin_arg = null;
    private ScriptOptions options = null;
    private JPanel options_pane = null;
    private StringBuffer error_message = null;
    private boolean successful;

    public ExplodeMetadataDatabasePrompt(File file) {
        super((Frame)Gatherer.g_man, true);
        this.metadata_file = file;
        this.setComponentOrientation(Dictionary.getOrientation());
        ArrayList arrayList = CollectionDesignManager.plugin_manager.getExploderPlugins(file);
        if (arrayList.size() == 0) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("ExplodeMetadataPrompt.NotExplodable"), Dictionary.get("ExplodeMetadataPrompt.Title"), 0);
            return;
        }
        this.plugin_arg = this.createPluginArgument(arrayList);
        this.setJMenuBar(new SimpleMenuBar("explodingmetadata"));
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("ExplodeMetadataPrompt.Title"));
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Options/>";
        Document document = XMLTools.parseXML(new StringReader(string));
        this.options = new ScriptOptions(document.getDocumentElement(), "explode_metadata_database.pl");
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setOpaque(true);
        this.options_pane = new JPanel();
        this.options_pane.setComponentOrientation(Dictionary.getOrientation());
        this.addScriptOptions(this.options_pane);
        JScrollPane jScrollPane = new JScrollPane(this.options_pane);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        JTextArea jTextArea = new JTextArea(Dictionary.get("ExplodeMetadataPrompt.Instructions"));
        jTextArea.setComponentOrientation(Dictionary.getOrientation());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(5);
        jTextArea.setWrapStyleWord(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        GLIButton gLIButton = new GLIButton(Dictionary.get("ExplodeMetadataPrompt.Explode"), Dictionary.get("ExplodeMetadataPrompt.Explode_Tooltip"));
        GLIButton gLIButton2 = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        gLIButton2.addActionListener(new CancelListener());
        gLIButton.addActionListener(new ExplodeListener());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(gLIButton);
        jPanel2.add(gLIButton2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTextArea, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - ExplodeMetadataDatabasePrompt.SIZE.width) / 2, (dimension.height - ExplodeMetadataDatabasePrompt.SIZE.height) / 2);
        TestingPreparation.setNamesRecursively(this);
        this.setVisible(true);
    }

    public void destroy() {
    }

    @Override
    public synchronized void message(GShellEvent gShellEvent) {
        String string = gShellEvent.getMessage();
        if (string.startsWith("explode_metadata_database.pl>")) {
            string = string.substring(29);
            this.error_message.append(string);
            this.error_message.append("\n");
        }
    }

    @Override
    public synchronized void processBegun(GShellEvent gShellEvent) {
    }

    @Override
    public synchronized void processComplete(GShellEvent gShellEvent) {
        this.successful = false;
        if (gShellEvent.getStatus() == 1) {
            this.successful = true;
        }
    }

    private Argument createPluginArgument(ArrayList arrayList) {
        Argument argument = new Argument();
        argument.setName("plugin");
        argument.setDescription(Dictionary.get("ExplodeMetadataPrompt.Plugin"));
        argument.setRequired(true);
        argument.setType((byte)0);
        for (int i = 0; i < arrayList.size(); ++i) {
            Plugin plugin = (Plugin)arrayList.get(i);
            argument.addOption(plugin.getName(), plugin.getName());
        }
        return argument;
    }

    private void addScriptOptions(JPanel jPanel) {
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = Configuration.getMode();
        int n2 = this.options.getArgumentCount();
        ArgumentControl argumentControl = new ArgumentControl(this.plugin_arg, true, null);
        argumentControl.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        jPanel.add(argumentControl);
        for (int i = 0; i < n2; ++i) {
            Argument argument = this.options.getArgument(i);
            if (argument.isHiddenGLI() || argument.getModeLevel() > n) continue;
            if (argument.getName().equals("metadata_set")) {
                argument.setType((byte)8);
                argumentControl = new ArgumentControl(argument, true, "Exploded Metadata Set (exp)");
            } else {
                argumentControl = new ArgumentControl(argument, false, null);
            }
            argumentControl.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
            jPanel.add(argumentControl);
        }
    }

    private void updateScriptOptions() {
        for (int i = 0; i < this.options_pane.getComponentCount(); ++i) {
            Component component = this.options_pane.getComponent(i);
            if (!(component instanceof ArgumentControl)) continue;
            ArgumentControl argumentControl = (ArgumentControl)component;
            String string = argumentControl.getArgumentName();
            String string2 = argumentControl.getValue();
            boolean bl = argumentControl.isEnabled();
            if (!bl && string2 == null) {
                this.options.removeValue(string);
                continue;
            }
            if (string2.equals("")) {
                this.options.setValue(string, false, string2);
                continue;
            }
            this.options.setValue(string, bl, string2);
        }
    }

    private int explodeMetadata() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
        }
        arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "explode_metadata_database.pl");
        if (Gatherer.GS3) {
            arrayList.add("-site");
            arrayList.add(Configuration.site_name);
        }
        arrayList.add("-collection");
        arrayList.add(Gatherer.c_man.getCollection().getName());
        arrayList.add("-use_collection_plugin_options");
        String[] stringArray = this.options.getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(this.metadata_file.getPath());
        } else {
            String string = CollectionManager.getLoadedCollectionName();
            object = CollectionManager.getCollectionDirectoryPath(string);
            String string2 = Gatherer.remoteGreenstoneServer.getPathRelativeToDirectory(this.metadata_file, (String)object);
            string2 = string2.replace(File.separatorChar, '|');
            arrayList.add("-file");
            arrayList.add(Base64.encodeBytes(string2.getBytes()));
            arrayList.add(string);
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        this.error_message = new StringBuffer();
        object = new GShell(stringArray2, 6, 3, this, null, GShell.GSHELL_EXPLODE);
        ((GShell)object).run();
        if (this.successful) {
            return 0;
        }
        return -1;
    }

    private void resultPrompt(final boolean bl, final String string) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("ExplodeMetadataDatabasePrompt.resultPrompt()", true, new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    JOptionPane.showMessageDialog(null, Dictionary.get("ExplodeMetadataPrompt.Successful_Explode", ExplodeMetadataDatabasePrompt.this.metadata_file.getName()), Dictionary.get("ExplodeMetadataPrompt.Successful_Title"), 1);
                } else {
                    String string3 = Dictionary.get("ExplodeMetadataPrompt.Failed_Title");
                    String string2 = Dictionary.get("ExplodeMetadataPrompt.Failed_Explode", ExplodeMetadataDatabasePrompt.this.metadata_file.getName());
                    SimpleResultDialog simpleResultDialog = new SimpleResultDialog(string3, string2, string);
                    TestingPreparation.setNamesRecursively(simpleResultDialog);
                    simpleResultDialog.setVisible(true);
                    simpleResultDialog.dispose();
                    simpleResultDialog = null;
                }
            }
        });
    }

    private class ExplodeMetadataDatabaseTask
    extends Thread {
        @Override
        public void run() {
            int n = ExplodeMetadataDatabasePrompt.this.explodeMetadata();
            if (n == 0) {
                if (Gatherer.isGsdlRemote) {
                    Utility.delete(ExplodeMetadataDatabasePrompt.this.metadata_file.getParentFile());
                    Gatherer.remoteGreenstoneServer.downloadCollectionFile(CollectionManager.getLoadedCollectionName(), ExplodeMetadataDatabasePrompt.this.metadata_file.getParentFile());
                }
                Collection collection = Gatherer.c_man.getCollection();
                MetadataXMLFileManager.loadMetadataXMLFiles(ExplodeMetadataDatabasePrompt.this.metadata_file.getParentFile(), collection.toSkimFile());
                Gatherer.g_man.refreshCollectionTree(2);
                ExplodeMetadataDatabasePrompt.this.resultPrompt(true, ExplodeMetadataDatabasePrompt.this.error_message.toString());
            } else {
                ExplodeMetadataDatabasePrompt.this.resultPrompt(false, ExplodeMetadataDatabasePrompt.this.error_message.toString());
            }
            ExplodeMetadataDatabasePrompt.this.error_message = null;
            Gatherer.g_man.wait(false);
        }
    }

    private class ExplodeListener
    implements ActionListener {
        private ExplodeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Gatherer.g_man.wait(true);
            ExplodeMetadataDatabasePrompt.this.updateScriptOptions();
            ExplodeMetadataDatabasePrompt.this.self.dispose();
            new ExplodeMetadataDatabaseTask().start();
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExplodeMetadataDatabasePrompt.this.self.dispose();
        }
    }
}

