/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionTree;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.gui.Filter;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.MetadataSetDialog;
import org.greenstone.gatherer.gui.MetadataValueTablePane;
import org.greenstone.gatherer.gui.MetadataValueTreePane;
import org.greenstone.gatherer.metadata.FilenameEncoding;
import org.greenstone.gatherer.metadata.MetadataValueTableEntry;
import org.greenstone.gatherer.metadata.MetadataValueTreeNode;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;

public class EnrichPane
extends JPanel
implements TreeSelectionListener {
    private static Dimension MINIMUM_SIZE = new Dimension(100, 100);
    private static Dimension COLLECTION_TREE_SIZE = new Dimension(250, 500);
    private boolean has_focus = false;
    private CollectionTree collection_tree = null;
    private CollectionTreeNode[] file_nodes = null;
    private Filter collection_filter = null;
    private JLabel collection_label;
    private JPanel collection_pane = null;
    private JScrollPane collection_scroll = null;
    private JSplitPane external_split;
    private MetadataValueTablePane metadata_value_table_pane = null;
    private MetadataValueTreePane metadata_value_tree_pane = null;

    public EnrichPane() {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.metadata_value_tree_pane = new MetadataValueTreePane();
        this.metadata_value_tree_pane.addMetadataValueTreeSelectionListener(new MetadataValueTreeSelectionListener());
        this.metadata_value_table_pane = new MetadataValueTablePane();
        this.metadata_value_table_pane.addMetadataValueTableListSelectionListener(new MetadataValueTableListSelectionListener());
        this.metadata_value_table_pane.addMetadataValueTableMouseListener(new MetadataValueTableMouseListener());
        this.metadata_value_table_pane.addMetadataValueTextFieldDocumentListener(new MetadataValueTextFieldDocumentListener());
        this.metadata_value_table_pane.addMetadataValueTextFieldKeyListener(new MetadataValueTextFieldKeyListener());
    }

    public void afterDisplay() {
        if (Dictionary.getOrientation().isLeftToRight()) {
            this.external_split.setDividerLocation(0.3);
        } else {
            this.external_split.setDividerLocation(0.7);
        }
    }

    public void display() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        GLIButton gLIButton = new GLIButton(Dictionary.get("EnrichPane.ManageMetadataSets"), Dictionary.get("EnrichPane.ManageMetadataSets_Tooltip"));
        gLIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetadataSetDialog metadataSetDialog = new MetadataSetDialog();
                if (metadataSetDialog.setsChanged()) {
                    EnrichPane.this.valueChanged(null);
                }
            }
        });
        this.collection_pane = new JPanel(new BorderLayout());
        this.collection_pane.setMinimumSize(MINIMUM_SIZE);
        this.collection_pane.setPreferredSize(COLLECTION_TREE_SIZE);
        this.collection_label = new JLabel(Dictionary.get("Collection.No_Collection"));
        this.collection_label.setComponentOrientation(Dictionary.getOrientation());
        this.collection_label.setOpaque(true);
        this.collection_tree = Gatherer.c_man.getCollectionTree();
        this.collection_tree.getSelectionModel().setSelectionMode(4);
        this.collection_tree.addTreeSelectionListener(this);
        this.collection_tree.setComponentOrientation(Dictionary.getOrientation());
        this.collection_filter = this.collection_tree.getFilter();
        this.external_split = new JSplitPane(1);
        this.external_split.setComponentOrientation(Dictionary.getOrientation());
        this.collection_pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLoweredBevelBorder()));
        this.collection_pane.setMinimumSize(MINIMUM_SIZE);
        this.collection_pane.setPreferredSize(new Dimension(Gatherer.g_man.getSize().width / 3, Gatherer.g_man.getSize().height));
        this.collection_pane.setComponentOrientation(Dictionary.getOrientation());
        this.collection_pane.add((Component)this.collection_label, "North");
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jSplitPane.setDividerSize(8);
        jSplitPane.setComponentOrientation(Dictionary.getOrientation());
        jSplitPane.add((Component)this.metadata_value_table_pane, "top");
        jSplitPane.add((Component)this.metadata_value_tree_pane, "bottom");
        jSplitPane.setDividerLocation(250);
        jPanel.add((Component)this.collection_pane, "Center");
        jPanel.add((Component)gLIButton, "South");
        if (Dictionary.getOrientation().isLeftToRight()) {
            this.external_split.add((Component)jPanel, "left");
            this.external_split.add((Component)jSplitPane, "right");
        } else {
            this.external_split.add((Component)jPanel, "right");
            this.external_split.add((Component)jSplitPane, "left");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.external_split, "Center");
    }

    public void gainFocus() {
        this.has_focus = true;
        this.collection_scroll = new JScrollPane(this.collection_tree);
        this.collection_pane.add((Component)this.collection_scroll, "Center");
        this.collection_pane.add((Component)this.collection_filter, "South");
        if (this.collection_tree.getSelectionPaths() == null && this.collection_tree.getRowCount() > 0) {
            this.collection_tree.setImmediate(true);
            this.collection_tree.setSelectionRow(0);
            this.collection_tree.setImmediate(false);
            return;
        }
        this.valueChanged(null);
    }

    public void loseFocus() {
        this.metadata_value_table_pane.stopEditingAndRebuild(this.file_nodes);
        MetadataXMLFileManager.saveMetadataXMLFiles();
        this.collection_pane.remove(this.collection_scroll);
        this.collection_pane.remove(this.collection_filter);
        this.has_focus = false;
    }

    public void modeChanged(int n) {
        this.collection_filter.setEditable(n >= 2);
    }

    public void refresh(int n, boolean bl) {
        if (bl) {
            this.collection_label.setText(Dictionary.get("Collection.Collection"));
            this.collection_label.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
            this.collection_label.setForeground(Configuration.getColor("coloring.collection_heading_foreground", false));
            if (n == 0) {
                this.collection_tree.setModel(Gatherer.c_man.getCollectionTreeModel());
            }
            this.collection_filter.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        } else {
            this.collection_label.setText(Dictionary.get("Collection.No_Collection"));
            this.collection_label.setBackground(Color.lightGray);
            this.collection_label.setForeground(Color.black);
            this.collection_tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Error")));
            this.collection_filter.setBackground(Color.lightGray);
        }
        this.collection_tree.setEnabled(bl);
        this.collection_filter.setEnabled(bl);
        if (n == 3) {
            this.metadata_value_table_pane.stopEditingAndRebuild(this.file_nodes);
        }
    }

    public void stopEditingAndRebuild() {
        this.metadata_value_table_pane.stopEditingAndRebuild(this.file_nodes);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (FilenameEncoding.isRefreshRequired()) {
            return;
        }
        if (!this.has_focus) {
            return;
        }
        if (this.collection_tree.getSelectionCount() == 0) {
            this.file_nodes = null;
        } else {
            TreePath[] treePathArray = this.collection_tree.getSelectionPaths();
            this.file_nodes = new CollectionTreeNode[treePathArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                this.file_nodes[i] = (CollectionTreeNode)treePathArray[i].getLastPathComponent();
            }
        }
        this.metadata_value_table_pane.stopEditingAndRebuild(this.file_nodes);
    }

    private class MetadataValueTreeSelectionListener
    implements TreeSelectionListener {
        private MetadataValueTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            MetadataValueTreeNode metadataValueTreeNode = EnrichPane.this.metadata_value_tree_pane.getSelectedMetadataValueTreeNode();
            if (metadataValueTreeNode != null) {
                EnrichPane.this.metadata_value_table_pane.setMetadataValueTextFieldValue(metadataValueTreeNode.getFullValue());
            }
        }
    }

    private class MetadataValueTextFieldKeyListener
    extends KeyAdapter {
        private MetadataValueTextFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                MetadataValueTreeNode metadataValueTreeNode = EnrichPane.this.metadata_value_tree_pane.getSelectedMetadataValueTreeNode();
                if (metadataValueTreeNode != null) {
                    EnrichPane.this.metadata_value_table_pane.setMetadataValueTextFieldValue(metadataValueTreeNode.getFullValue());
                }
                keyEvent.consume();
            }
            if (keyEvent.getKeyCode() == 10) {
                EnrichPane.this.metadata_value_table_pane.stopEditingAndAddBlankRowForSelectedMetadataElement();
            }
        }
    }

    private class MetadataValueTextFieldDocumentListener
    implements DocumentListener {
        private MetadataValueTextFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.validate(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.validate(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.validate(documentEvent);
        }

        private void validate(DocumentEvent documentEvent) {
            try {
                Document document = documentEvent.getDocument();
                String string = document.getText(0, document.getLength());
                EnrichPane.this.metadata_value_tree_pane.selectBestPathForMetadataValue(string);
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }
    }

    private class MetadataValueTableMouseListener
    extends MouseAdapter {
        private MetadataValueTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!EnrichPane.this.metadata_value_table_pane.isMouseEventForInheritedMetadataValueTableColumn(mouseEvent)) {
                return;
            }
            MetadataValueTableEntry metadataValueTableEntry = EnrichPane.this.metadata_value_table_pane.getSelectedMetadataValueTableEntry();
            if (metadataValueTableEntry.isInheritedMetadata()) {
                EnrichPane.this.collection_tree.setSelection(metadataValueTableEntry.getFolderMetadataInheritedFrom());
            }
        }
    }

    private class MetadataValueTableListSelectionListener
    implements ListSelectionListener {
        private MetadataValueTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            EnrichPane.this.metadata_value_tree_pane.rebuild(EnrichPane.this.metadata_value_table_pane.getSelectedMetadataValueTableEntry());
        }
    }
}

