/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.WorkspaceTree;
import org.greenstone.gatherer.gui.GLIButton;

public class CreateShortcutPrompt
extends JDialog
implements ActionListener,
KeyListener {
    static final Dimension DIALOG_SIZE = new Dimension(400, 120);
    private boolean cancelled = false;
    private JButton cancel_button = null;
    private JButton ok_button = null;
    private JTextField name_field = null;

    public CreateShortcutPrompt(WorkspaceTree workspaceTree, File file) {
        super(Gatherer.g_man);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setModal(true);
        this.setSize(DIALOG_SIZE);
        this.setTitle(Dictionary.get("MappingPrompt.Title"));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("MappingPrompt.File"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel2 = new JLabel(file.getAbsolutePath());
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel3 = new JLabel(Dictionary.get("MappingPrompt.Name"));
        jLabel3.setComponentOrientation(Dictionary.getOrientation());
        this.name_field = new JTextField(file.getName());
        this.name_field.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.ok_button.setEnabled(this.name_field.getText().length() > 0);
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        this.cancel_button.addActionListener(this);
        this.ok_button.addActionListener(this);
        this.name_field.addKeyListener(this);
        jPanel3.setLayout(new GridLayout(2, 1, 5, 0));
        jPanel3.add(jLabel);
        jPanel3.add(jLabel3);
        jPanel4.setLayout(new GridLayout(2, 1, 5, 0));
        jPanel4.add(jLabel2);
        jPanel4.add(this.name_field);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jPanel2.setLayout(new BorderLayout(5, 0));
        jPanel2.add((Component)jPanel3, "Before");
        jPanel2.add((Component)jPanel4, "Center");
        jPanel5.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel5.add(this.ok_button);
        jPanel5.add(this.cancel_button);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel5, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - CreateShortcutPrompt.DIALOG_SIZE.width) / 2, (dimension.height - CreateShortcutPrompt.DIALOG_SIZE.height) / 2);
        this.setVisible(true);
        if (!this.cancelled) {
            workspaceTree.addDirectoryMapping(this.name_field.getText(), file);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancel_button) {
            this.cancelled = true;
        }
        this.dispose();
    }

    public void destroy() {
        this.cancel_button = null;
        this.ok_button = null;
        this.name_field = null;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.ok_button.setEnabled(this.name_field.getText().length() > 0);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

