/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.collection.Collection;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.OptionsPane;
import org.greenstone.gatherer.gui.PreviewButton;
import org.greenstone.gatherer.gui.WarnIncrBuildDialog;
import org.greenstone.gatherer.shell.GBuildProgressMonitor;
import org.greenstone.gatherer.shell.GImportProgressMonitor;
import org.greenstone.gatherer.shell.GScheduleProgressMonitor;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;
import org.greenstone.gatherer.shell.GShellProgressMonitor;
import org.greenstone.gatherer.util.AppendLineOnlyFileDocument;
import org.greenstone.gatherer.util.Utility;

public class CreatePane
extends JPanel
implements GShellListener {
    private static Dimension ARGUMENT_SIZE = new Dimension(800, 90);
    private static final int THRESHOLD = 3;
    private static String CONTROL = "Control";
    private static String PROGRESS = "Progress";
    private static String SIMPLE = "Simple";
    public boolean processing = false;
    public OptionsPane options_pane = null;
    private AppendLineOnlyFileDocument document;
    private CardLayout card_layout = null;
    private Collection previous_collection = null;
    private GShellProgressMonitor build_monitor = null;
    private GShellProgressMonitor import_monitor = null;
    private GShellProgressMonitor schedule_monitor = null;
    private JButton build_button = null;
    private JButton cancel_button = null;
    private JButton schedule_button = null;
    private JButton preview_button = null;
    private JButton simple_build_button;
    private JButton simple_cancel_button;
    private JButton simple_preview_button;
    private JRadioButton full_build_radio_button;
    private JRadioButton incremental_build_radio_button;
    private JRadioButton sfull_build_radio_button;
    private JRadioButton sincremental_build_radio_button;
    private JLabel document_count = null;
    private JLabel progress_build_label = null;
    private JLabel progress_import_label = null;
    private JPanel bar_area;
    private JPanel button_pane;
    private JPanel control_pane = null;
    private JPanel main_pane = null;
    private JPanel progress_pane = null;
    private JPanel right = null;
    private JPanel sargument_configuration_panel;
    private JPanel sbutton_panel;
    private JSplitPane simple_panel;
    private JPanel slower_panel;
    private JPanel sinner_panel;
    private JScrollPane log_scroll;
    private JScrollPane sargument_configuration_scroll;
    private JScrollPane scroll_pane;
    private JTextArea log_textarea;
    private OptionTree tree = null;
    private String[] args = null;
    public String homepage = null;
    private GShell shell = null;

    public CreatePane() {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.log_textarea = new JTextArea();
        this.log_scroll = new JScrollPane(this.log_textarea);
        this.card_layout = new CardLayout();
        this.control_pane = new JPanel();
        this.control_pane.setComponentOrientation(Dictionary.getOrientation());
        this.tree = new OptionTree();
        this.tree.setComponentOrientation(Dictionary.getOrientation());
        this.button_pane = new JPanel();
        this.button_pane.setComponentOrientation(Dictionary.getOrientation());
        this.progress_pane = new JPanel();
        this.progress_pane.setComponentOrientation(Dictionary.getOrientation());
        this.bar_area = new JPanel();
        this.bar_area.setComponentOrientation(Dictionary.getOrientation());
        this.progress_import_label = new JLabel(Dictionary.get("CreatePane.Import_Progress"));
        this.progress_import_label.setComponentOrientation(Dictionary.getOrientation());
        this.import_monitor = new GImportProgressMonitor();
        Gatherer.c_man.registerImportMonitor(this.import_monitor);
        this.progress_build_label = new JLabel(Dictionary.get("CreatePane.Build_Progress"));
        this.progress_build_label.setComponentOrientation(Dictionary.getOrientation());
        this.build_monitor = new GBuildProgressMonitor(this.import_monitor.getSharedProgress());
        Gatherer.c_man.registerBuildMonitor(this.build_monitor);
        this.schedule_monitor = new GScheduleProgressMonitor();
        Gatherer.c_man.registerScheduleMonitor(this.schedule_monitor);
        this.slower_panel = new JPanel();
        this.sbutton_panel = new JPanel();
        this.sinner_panel = new JPanel();
        this.slower_panel.setComponentOrientation(Dictionary.getOrientation());
        this.sbutton_panel.setComponentOrientation(Dictionary.getOrientation());
        this.sinner_panel.setComponentOrientation(Dictionary.getOrientation());
        this.incremental_build_radio_button = new JRadioButton(Dictionary.get("CreatePane.Minimal_Build"));
        this.incremental_build_radio_button.setComponentOrientation(Dictionary.getOrientation());
        this.incremental_build_radio_button.setToolTipText(Dictionary.get("CreatePane.Minimal_Build_Tooltip"));
        this.full_build_radio_button = new JRadioButton(Dictionary.get("CreatePane.Full_Build"));
        this.full_build_radio_button.setComponentOrientation(Dictionary.getOrientation());
        this.full_build_radio_button.setToolTipText(Dictionary.get("CreatePane.Full_Build_Tooltip"));
        this.sincremental_build_radio_button = new JRadioButton(Dictionary.get("CreatePane.Minimal_Build"));
        this.sincremental_build_radio_button.setComponentOrientation(Dictionary.getOrientation());
        this.sincremental_build_radio_button.setToolTipText(Dictionary.get("CreatePane.Minimal_Build_Tooltip"));
        this.sfull_build_radio_button = new JRadioButton(Dictionary.get("CreatePane.Full_Build"));
        this.sfull_build_radio_button.setComponentOrientation(Dictionary.getOrientation());
        this.sfull_build_radio_button.setToolTipText(Dictionary.get("CreatePane.Full_Build_Tooltip"));
        this.full_build_radio_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreatePane.this.sfull_build_radio_button.setSelected(CreatePane.this.full_build_radio_button.isSelected());
            }
        });
        this.sfull_build_radio_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreatePane.this.full_build_radio_button.setSelected(CreatePane.this.sfull_build_radio_button.isSelected());
            }
        });
        this.incremental_build_radio_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreatePane.this.sincremental_build_radio_button.setSelected(CreatePane.this.incremental_build_radio_button.isSelected());
            }
        });
        this.sincremental_build_radio_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreatePane.this.incremental_build_radio_button.setSelected(CreatePane.this.sincremental_build_radio_button.isSelected());
            }
        });
        BuildButtonListener buildButtonListener = new BuildButtonListener();
        CancelButtonListener cancelButtonListener = new CancelButtonListener();
        this.build_button = new GLIButton(Dictionary.get("CreatePane.Build_Collection"), Dictionary.get("CreatePane.Build_Collection_Tooltip"));
        this.build_button.addActionListener(buildButtonListener);
        this.cancel_button = new GLIButton(Dictionary.get("CreatePane.Cancel_Build"), Dictionary.get("CreatePane.Cancel_Build_Tooltip"));
        this.cancel_button.addActionListener(cancelButtonListener);
        this.cancel_button.setEnabled(false);
        this.preview_button = new PreviewButton(Dictionary.get("CreatePane.Preview_Collection"), Dictionary.get("CreatePane.Preview_Collection_Tooltip"));
        boolean bl = Gatherer.c_man.built();
        if (Gatherer.c_man != null) {
            this.preview_button.setEnabled(bl);
        } else {
            this.preview_button.setEnabled(false);
        }
        BuildSimpleButtonListener buildSimpleButtonListener = new BuildSimpleButtonListener();
        this.simple_build_button = new GLIButton(Dictionary.get("CreatePane.Build_Collection"), Dictionary.get("CreatePane.Build_Collection_Tooltip"));
        this.simple_build_button.addActionListener(buildSimpleButtonListener);
        this.simple_cancel_button = new GLIButton(Dictionary.get("CreatePane.Cancel_Build"), Dictionary.get("CreatePane.Cancel_Build_Tooltip"));
        this.simple_cancel_button.addActionListener(cancelButtonListener);
        this.simple_cancel_button.setEnabled(false);
        this.simple_preview_button = new PreviewButton(Dictionary.get("CreatePane.Preview_Collection"), Dictionary.get("CreatePane.Preview_Collection_Tooltip"));
        if (Gatherer.c_man != null) {
            this.simple_preview_button.setEnabled(bl);
        } else {
            this.simple_preview_button.setEnabled(false);
        }
        buildButtonListener = null;
        buildSimpleButtonListener = null;
        cancelButtonListener = null;
    }

    public void setGShell(GShell gShell) {
        this.shell = gShell;
    }

    public void destroy() {
        if (this.document != null) {
            this.document.destroy();
        }
    }

    public void display() {
        int n = Configuration.getMode();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.incremental_build_radio_button);
        buttonGroup.add(this.full_build_radio_button);
        this.full_build_radio_button.setSelected(true);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.sincremental_build_radio_button);
        buttonGroup2.add(this.sfull_build_radio_button);
        this.sfull_build_radio_button.setSelected(true);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add(this.full_build_radio_button);
        jPanel.add(this.incremental_build_radio_button);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add(this.sfull_build_radio_button);
        jPanel2.add(this.sincremental_build_radio_button);
        if (Gatherer.isGsdlRemote) {
            this.full_build_radio_button.setEnabled(false);
            this.incremental_build_radio_button.setEnabled(false);
            this.sfull_build_radio_button.setEnabled(false);
            this.sincremental_build_radio_button.setEnabled(false);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.tree, "Center");
        jPanel3.add((Component)jPanel, "South");
        this.right = new JPanel();
        this.right.setComponentOrientation(Dictionary.getOrientation());
        this.right.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        this.right.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(Dictionary.get("CreatePane.Options_Title"))));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Before");
        jPanel4.add((Component)this.right, "Center");
        this.button_pane = new JPanel();
        this.button_pane.setComponentOrientation(Dictionary.getOrientation());
        this.button_pane.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.button_pane.setLayout(new GridLayout(1, 4));
        this.button_pane.add(this.build_button);
        this.button_pane.add(this.cancel_button);
        this.button_pane.add(this.preview_button);
        this.control_pane.setLayout(new BorderLayout());
        this.control_pane.add((Component)jPanel4, "Center");
        this.control_pane.add((Component)this.button_pane, "South");
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.setLayout(new GridLayout(2, 1, 0, 5));
        jPanel5.add(this.progress_import_label);
        jPanel5.add(this.progress_build_label);
        JPanel jPanel6 = new JPanel();
        jPanel6.setComponentOrientation(Dictionary.getOrientation());
        jPanel6.setLayout(new GridLayout(2, 1, 0, 5));
        jPanel6.add(this.import_monitor.getProgress());
        jPanel6.add(this.build_monitor.getProgress());
        this.bar_area.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.bar_area.setLayout(new BorderLayout(5, 5));
        this.bar_area.add((Component)jPanel5, "Before");
        this.bar_area.add((Component)jPanel6, "Center");
        this.progress_pane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.progress_pane.setLayout(new BorderLayout());
        this.progress_pane.add((Component)this.bar_area, "North");
        if (n >= 3) {
            this.progress_pane.add((Component)this.log_scroll, "Center");
        }
        this.sbutton_panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.sbutton_panel.setLayout(new GridLayout(1, 3));
        this.sbutton_panel.add(this.simple_build_button);
        this.sbutton_panel.add(this.simple_cancel_button);
        this.sbutton_panel.add(this.simple_preview_button);
        JPanel jPanel7 = new JPanel(new GridLayout(2, 1));
        jPanel7.setComponentOrientation(Dictionary.getOrientation());
        jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel7.add(this.import_monitor.getSharedProgress());
        jPanel7.add(this.sbutton_panel);
        this.sinner_panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.sinner_panel.setLayout(new BorderLayout());
        this.sinner_panel.add((Component)jPanel2, "Before");
        this.sinner_panel.add((Component)jPanel7, "Center");
        if (this.options_pane != null) {
            this.sargument_configuration_panel = this.options_pane.buildImport(null);
            this.sargument_configuration_panel = this.options_pane.buildBuild(this.sargument_configuration_panel);
        } else {
            this.sargument_configuration_panel = new JPanel();
        }
        this.sargument_configuration_panel.setComponentOrientation(Dictionary.getOrientation());
        this.sargument_configuration_scroll = new JScrollPane(this.sargument_configuration_panel);
        this.sargument_configuration_scroll.setPreferredSize(ARGUMENT_SIZE);
        this.sargument_configuration_scroll.setComponentOrientation(Dictionary.getOrientation());
        this.slower_panel.setLayout(new BorderLayout());
        this.slower_panel.add((Component)this.sinner_panel, "North");
        if (n < 3) {
            this.slower_panel.add((Component)this.log_scroll, "Center");
        }
        this.simple_panel = new JSplitPane(0, this.sargument_configuration_scroll, this.slower_panel);
        this.simple_panel.setComponentOrientation(Dictionary.getOrientation());
        this.main_pane = new JPanel(this.card_layout);
        this.main_pane.setComponentOrientation(Dictionary.getOrientation());
        if (n < 3) {
            this.main_pane.add((Component)this.simple_panel, SIMPLE);
        }
        this.main_pane.add((Component)this.control_pane, CONTROL);
        this.main_pane.add((Component)this.progress_pane, PROGRESS);
        if (n >= 3) {
            this.main_pane.add((Component)this.simple_panel, SIMPLE);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.main_pane, "Center");
    }

    public void gainFocus() {
        if (Configuration.getMode() < 3) {
            this.card_layout.show(this.main_pane, SIMPLE);
        } else if (!this.processing) {
            this.control_pane.add((Component)this.button_pane, "South");
            this.card_layout.show(this.main_pane, CONTROL);
        } else {
            this.progress_pane.add((Component)this.button_pane, "South");
            this.card_layout.show(this.main_pane, PROGRESS);
        }
        TreePath treePath = this.tree.getSelectionPath();
        this.tree.clearSelection();
        this.tree.setSelectionPath(treePath);
    }

    public void loseFocus() {
        this.tree.valueChanged(null);
    }

    @Override
    public synchronized void message(final GShellEvent gShellEvent) {
        if (gShellEvent.getMessage().startsWith("import.pl> RecPlug - ")) {
            return;
        }
        Gatherer.invokeInEDT_replacesProceedInCurrThread("CreatePane.message()", true, new Runnable(){

            @Override
            public void run() {
                CreatePane.this.document.appendLine(gShellEvent.getMessage());
                CreatePane.this.log_textarea.setCaretPosition(CreatePane.this.document.getLengthToNearestLine());
            }
        });
    }

    public void modeChanged(int n) {
        if (Configuration.getMode() < 3) {
            this.simple_panel.remove(this.sargument_configuration_scroll);
            if (this.options_pane != null) {
                this.sargument_configuration_panel = this.options_pane.buildImport(null);
                this.sargument_configuration_panel = this.options_pane.buildBuild(this.sargument_configuration_panel);
            } else {
                this.sargument_configuration_panel = new JPanel();
            }
            this.sargument_configuration_scroll = new JScrollPane(this.sargument_configuration_panel);
            this.sargument_configuration_panel.setComponentOrientation(Dictionary.getOrientation());
            this.sargument_configuration_scroll.setComponentOrientation(Dictionary.getOrientation());
            this.sargument_configuration_scroll.setPreferredSize(ARGUMENT_SIZE);
            this.simple_panel.setTopComponent(this.sargument_configuration_scroll);
            this.progress_pane.remove(this.log_scroll);
            this.slower_panel.add((Component)this.log_scroll, "Center");
            this.card_layout.show(this.main_pane, SIMPLE);
        } else {
            this.slower_panel.remove(this.log_scroll);
            this.progress_pane.add((Component)this.log_scroll, "Center");
            if (!this.processing) {
                this.control_pane.add((Component)this.button_pane, "South");
                this.card_layout.show(this.main_pane, CONTROL);
            } else {
                this.progress_pane.add((Component)this.button_pane, "South");
                this.card_layout.show(this.main_pane, PROGRESS);
            }
        }
        this.tree.valueChanged(null);
    }

    @Override
    public synchronized void processBegun(GShellEvent gShellEvent) {
    }

    @Override
    public synchronized void processComplete(GShellEvent gShellEvent) {
        DebugStream.println("In CreatePane::processComplete(" + gShellEvent.getType() + ")...");
        boolean bl = Gatherer.c_man.built();
        if (gShellEvent.getStatus() == 1) {
            if (gShellEvent.getType() == 8) {
                this.processing = false;
                this.build_button.setEnabled(true);
                this.cancel_button.setEnabled(false);
                this.preview_button.setEnabled(bl);
                this.simple_build_button.setEnabled(true);
                this.simple_cancel_button.setEnabled(false);
                this.simple_preview_button.setEnabled(bl);
                int n = gShellEvent.getStatus();
                this.document.setSpecialCharacter('d');
                this.options_pane.resetFileEntry();
                this.build_monitor.reset();
                this.import_monitor.reset();
                if (Configuration.getMode() >= 3) {
                    this.control_pane.add((Component)this.button_pane, "South");
                    this.card_layout.show(this.main_pane, CONTROL);
                }
            } else if (gShellEvent.getType() == 0) {
                this.processing = false;
                this.build_button.setEnabled(true);
                this.cancel_button.setEnabled(false);
                this.preview_button.setEnabled(bl);
                this.simple_build_button.setEnabled(true);
                this.simple_cancel_button.setEnabled(false);
                this.simple_preview_button.setEnabled(bl);
                int n = gShellEvent.getStatus();
                this.document.setSpecialCharacter('s');
                this.options_pane.resetFileEntry();
                this.build_monitor.reset();
                this.import_monitor.reset();
                if (Configuration.getMode() >= 3) {
                    this.control_pane.add((Component)this.button_pane, "South");
                    this.card_layout.show(this.main_pane, CONTROL);
                }
            }
        } else {
            this.processing = false;
            this.cancel_button.setEnabled(false);
            this.build_button.setEnabled(true);
            this.preview_button.setEnabled(bl);
            this.simple_build_button.setEnabled(true);
            this.simple_cancel_button.setEnabled(false);
            this.simple_preview_button.setEnabled(bl);
            if (gShellEvent.getType() == 1 && (gShellEvent.getStatus() == 2 || gShellEvent.getStatus() == 0)) {
                this.moveAnyKeepOldToArchives();
            }
            if (gShellEvent.getStatus() == 2) {
                this.document.setSpecialCharacter('c');
            } else {
                this.document.setSpecialCharacter('u');
            }
            this.options_pane.resetFileEntry();
            if (Configuration.getMode() >= 3) {
                this.control_pane.add((Component)this.button_pane, "South");
                this.card_layout.show(this.main_pane, CONTROL);
            }
        }
    }

    private void moveAnyKeepOldToArchives() {
        String string = CollectionManager.getLoadedCollectionArchivesKeepOldDirectoryPath();
        File file = new File(string);
        if (file.exists()) {
            String string2 = "archives_keepold folder detected. Attempting to restore it as archives...";
            this.log_textarea.setCaretPosition(this.document.getLengthToNearestLine());
            this.document.appendLine(string2);
            String string3 = CollectionManager.getLoadedCollectionArchivesDirectoryPath();
            File file2 = new File(string3);
            if (file2.exists() && !Utility.delete(file2)) {
                string2 = "Failed to delete " + file2 + "  in attempt to rename archives_keepold to archives";
                this.document.appendLine(string2);
            }
            if (!file2.exists() && !file.renameTo(file2)) {
                string2 = "Failed to rename " + file + "\n  to " + file2;
                this.document.appendLine(string2);
            }
            this.log_textarea.setCaretPosition(this.document.getLengthToNearestLine());
        }
    }

    public void refresh(int n, boolean bl) {
        if (Gatherer.c_man == null || !bl) {
            return;
        }
        Collection collection = Gatherer.c_man.getCollection();
        if (collection != this.previous_collection && !Gatherer.c_man.isImporting()) {
            Document document;
            this.options_pane = new OptionsPane(collection.import_options, collection.build_options, collection.schedule_options);
            if (this.previous_collection != null && (document = this.log_textarea.getDocument()) instanceof AppendLineOnlyFileDocument) {
                ((AppendLineOnlyFileDocument)document).destroy();
            }
            this.previous_collection = collection;
        }
        if (Configuration.getMode() < 3) {
            this.simple_panel.remove(this.sargument_configuration_scroll);
            this.sargument_configuration_panel = this.options_pane.buildImport(null);
            this.sargument_configuration_panel = this.options_pane.buildBuild(this.sargument_configuration_panel);
            this.sargument_configuration_scroll = new JScrollPane(this.sargument_configuration_panel);
            this.sargument_configuration_scroll.setComponentOrientation(Dictionary.getOrientation());
            this.sargument_configuration_scroll.setPreferredSize(ARGUMENT_SIZE);
            this.simple_panel.setTopComponent(this.sargument_configuration_scroll);
        }
        this.tree.valueChanged(null);
        boolean bl2 = Gatherer.c_man.built();
        if (bl2 && Configuration.library_url != null) {
            this.preview_button.setEnabled(true);
            this.simple_preview_button.setEnabled(true);
        } else {
            this.preview_button.setEnabled(false);
            this.simple_preview_button.setEnabled(false);
        }
    }

    private class ToolTipTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ToolTipTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof OptionTreeNode && (string = ((OptionTreeNode)object).getToolTipText()) != null) {
                this.setToolTipText(string);
            }
            return this;
        }
    }

    private class OptionTreeNode
    extends DefaultMutableTreeNode
    implements Comparable {
        private String title = null;
        private String tool_tip = null;

        public OptionTreeNode(String string) {
            this.title = string;
        }

        public int compareTo(Object object) {
            return this.title.compareTo(object.toString());
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public String getToolTipText() {
            return this.tool_tip;
        }

        public void setToolTipText(String string) {
            this.tool_tip = string;
        }

        @Override
        public String toString() {
            return this.title;
        }
    }

    private class OptionTree
    extends JTree
    implements TreeSelectionListener {
        private DefaultTreeModel model = null;
        private JPanel previous_pane = null;
        private OptionTreeNode building = null;
        private OptionTreeNode importing = null;
        private OptionTreeNode scheduling = null;
        private OptionTreeNode log = null;
        private OptionTreeNode options = null;

        public OptionTree() {
            this.setComponentOrientation(Dictionary.getOrientation());
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addTreeSelectionListener(this);
            this.getSelectionModel().setSelectionMode(1);
            this.setCellRenderer(new ToolTipTreeCellRenderer());
            this.setRootVisible(false);
            this.setToggleClickCount(1);
            this.building = new OptionTreeNode(Dictionary.get("CreatePane.Build"));
            this.building.setToolTipText(Dictionary.get("CreatePane.Build_Tooltip"));
            this.importing = new OptionTreeNode(Dictionary.get("CreatePane.Import"));
            this.importing.setToolTipText(Dictionary.get("CreatePane.Import_Tooltip"));
            if (CollectionManager.canDoScheduling()) {
                this.scheduling = new OptionTreeNode(Dictionary.get("CreatePane.Schedule"));
                this.scheduling.setToolTipText(Dictionary.get("CreatePane.Schedule_Tooltip"));
            }
            this.log = new OptionTreeNode(Dictionary.get("CreatePane.Log"));
            this.log.setToolTipText(Dictionary.get("CreatePane.Log_Tooltip"));
            this.options = new OptionTreeNode(Dictionary.get("CreatePane.Options"));
            this.model = new DefaultTreeModel(this.options);
            this.setModel(this.model);
            this.model.insertNodeInto(this.importing, this.options, 0);
            this.model.insertNodeInto(this.building, this.options, 1);
            if (CollectionManager.canDoScheduling()) {
                this.model.insertNodeInto(this.scheduling, this.options, 2);
                this.model.insertNodeInto(this.log, this.options, 3);
            } else {
                this.model.insertNodeInto(this.log, this.options, 2);
            }
            this.expandPath(new TreePath(this.options));
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = null;
            OptionTreeNode optionTreeNode = null;
            treePath = this.getSelectionPath();
            if (treePath != null) {
                optionTreeNode = (OptionTreeNode)treePath.getLastPathComponent();
            }
            if (this.previous_pane != null) {
                CreatePane.this.options_pane.update(this.previous_pane);
                if (CreatePane.this.scroll_pane != null) {
                    CreatePane.this.right.remove(CreatePane.this.scroll_pane);
                } else {
                    CreatePane.this.right.remove(this.previous_pane);
                }
                this.previous_pane = null;
                CreatePane.this.scroll_pane = null;
            }
            if (optionTreeNode != null && optionTreeNode.equals(this.log)) {
                CreatePane.this.build_button.setActionCommand(Dictionary.get("CreatePane.Build_Collection"));
                CreatePane.this.build_button.setText(Dictionary.get("CreatePane.Build_Collection"));
            }
            if (optionTreeNode != null && optionTreeNode.equals(this.building)) {
                CreatePane.this.build_button.setActionCommand(Dictionary.get("CreatePane.Build_Collection"));
                CreatePane.this.build_button.setText(Dictionary.get("CreatePane.Build_Collection"));
                this.previous_pane = CreatePane.this.options_pane.buildBuild(null);
                CreatePane.this.scroll_pane = new JScrollPane(this.previous_pane);
                CreatePane.this.right.add((Component)CreatePane.this.scroll_pane, "Center");
            } else if (optionTreeNode != null && optionTreeNode.equals(this.importing)) {
                CreatePane.this.build_button.setActionCommand(Dictionary.get("CreatePane.Build_Collection"));
                CreatePane.this.build_button.setText(Dictionary.get("CreatePane.Build_Collection"));
                this.previous_pane = CreatePane.this.options_pane.buildImport(null);
                CreatePane.this.scroll_pane = new JScrollPane(this.previous_pane);
                CreatePane.this.right.add((Component)CreatePane.this.scroll_pane, "Center");
            } else if (optionTreeNode != null && CollectionManager.canDoScheduling() && optionTreeNode.equals(this.scheduling)) {
                CreatePane.this.build_button.setActionCommand(Dictionary.get("CreatePane.Schedule_Build"));
                CreatePane.this.build_button.setText(Dictionary.get("CreatePane.Schedule_Build"));
                this.previous_pane = CreatePane.this.options_pane.buildSchedule(null);
                CreatePane.this.scroll_pane = new JScrollPane(this.previous_pane);
                CreatePane.this.right.add((Component)CreatePane.this.scroll_pane, "Center");
            } else if (CreatePane.this.options_pane != null) {
                this.previous_pane = CreatePane.this.options_pane.buildLog();
                CreatePane.this.right.add((Component)this.previous_pane, "Center");
                CreatePane.this.right.updateUI();
            }
            CreatePane.this.right.validate();
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CreatePane.this.build_button.setEnabled(false);
            CreatePane.this.cancel_button.setEnabled(false);
            CreatePane.this.preview_button.setEnabled(false);
            CreatePane.this.simple_build_button.setEnabled(false);
            CreatePane.this.simple_cancel_button.setEnabled(false);
            CreatePane.this.simple_preview_button.setEnabled(false);
            CreatePane.this.processing = false;
            CreatePane.this.document.setSpecialCharacter('c');
            if (Configuration.getMode() >= 3) {
                CreatePane.this.control_pane.add((Component)CreatePane.this.button_pane, "South");
                CreatePane.this.card_layout.show(CreatePane.this.main_pane, CONTROL);
            }
            CreatePane.this.import_monitor.setStop(true);
            CreatePane.this.import_monitor.reset();
            CreatePane.this.build_monitor.setStop(true);
            CreatePane.this.build_monitor.reset();
            if (CreatePane.this.shell != null) {
                CreatePane.this.shell.cancel();
            }
            if (CollectionManager.isSolrCollection()) {
                // empty if block
            }
        }
    }

    private class BuildSimpleButtonListener
    implements ActionListener {
        private BuildSimpleButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collection collection = Gatherer.c_man.getCollection();
            String string = collection.getName();
            CollectionDesignManager.setCompleteBuild(CreatePane.this.full_build_radio_button.isSelected());
            this.prepareForBuild();
            Gatherer.c_man.importCollection();
        }

        private void prepareForBuild() {
            CreatePane.this.tree.valueChanged(null);
            if (Configuration.getMode() < 3) {
                CreatePane.this.options_pane.update(CreatePane.this.sargument_configuration_panel);
            }
            CreatePane.this.build_button.setEnabled(false);
            CreatePane.this.cancel_button.setEnabled(true);
            CreatePane.this.preview_button.setEnabled(false);
            CreatePane.this.simple_build_button.setEnabled(false);
            CreatePane.this.simple_cancel_button.setEnabled(true);
            CreatePane.this.simple_preview_button.setEnabled(false);
            CreatePane.this.document = CreatePane.this.options_pane.createNewLogDocument();
            CreatePane.this.log_textarea.setDocument(CreatePane.this.document);
            CreatePane.this.options_pane.log_textarea.setDocument(CreatePane.this.document);
            CreatePane.this.processing = true;
            if (Configuration.getMode() >= 3) {
                CreatePane.this.progress_pane.add((Component)CreatePane.this.button_pane, "South");
                CreatePane.this.card_layout.show(CreatePane.this.main_pane, PROGRESS);
            }
            ((GBuildProgressMonitor)CreatePane.this.build_monitor).reset();
            CreatePane.this.import_monitor.setStop(false);
        }
    }

    private class BuildButtonListener
    implements ActionListener {
        private BuildButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collection collection = Gatherer.c_man.getCollection();
            String string = collection.getName();
            File file = new File(CollectionManager.getLoadedCollectionArchivesKeepOldDirectoryPath());
            if (file.exists()) {
                WarnIncrBuildDialog warnIncrBuildDialog = new WarnIncrBuildDialog();
                int n = warnIncrBuildDialog.display();
                warnIncrBuildDialog.dispose();
                warnIncrBuildDialog = null;
                if (n == 0) {
                    return;
                }
            }
            if (actionEvent.getActionCommand().equals(Dictionary.get("CreatePane.Build_Collection"))) {
                CollectionDesignManager.setCompleteBuild(CreatePane.this.full_build_radio_button.isSelected());
                this.prepareForBuild();
                if (CollectionManager.isSolrCollection()) {
                    // empty if block
                }
                Gatherer.c_man.importCollection();
            } else {
                this.prepareForBuild();
                Gatherer.c_man.scheduleBuild();
            }
        }

        private void prepareForBuild() {
            CreatePane.this.tree.valueChanged(null);
            if (Configuration.getMode() < 3) {
                CreatePane.this.options_pane.update(CreatePane.this.sargument_configuration_panel);
            }
            CreatePane.this.build_button.setEnabled(false);
            CreatePane.this.cancel_button.setEnabled(true);
            CreatePane.this.preview_button.setEnabled(false);
            CreatePane.this.simple_build_button.setEnabled(false);
            CreatePane.this.simple_cancel_button.setEnabled(true);
            CreatePane.this.simple_preview_button.setEnabled(false);
            CreatePane.this.document = CreatePane.this.options_pane.createNewLogDocument();
            CreatePane.this.log_textarea.setDocument(CreatePane.this.document);
            CreatePane.this.options_pane.log_textarea.setDocument(CreatePane.this.document);
            CreatePane.this.processing = true;
            if (Configuration.getMode() >= 3) {
                CreatePane.this.progress_pane.add((Component)CreatePane.this.button_pane, "South");
                CreatePane.this.card_layout.show(CreatePane.this.main_pane, PROGRESS);
            }
            ((GBuildProgressMonitor)CreatePane.this.build_monitor).reset();
            CreatePane.this.import_monitor.setStop(false);
        }
    }
}

