/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.greenstone3;

import java.util.Properties;

public class LibraryAddressProperties {
    private static final String FALLBACK_PROTOCOL = "http";
    private static final String FALLBACK_HTTP_PORT = "8383";
    private static final String FALLBACK_HTTPS_PORT = "8443";
    private String defaultPortPropertyName = "localhost.port.http";
    private String localHttpURL;
    private String externalURL;

    public String getLocalHttpAddress() {
        return this.localHttpURL;
    }

    public String getExternalAddress() {
        return this.externalURL;
    }

    public LibraryAddressProperties(Properties properties) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = true;
        boolean bl2 = false;
        string4 = properties.getProperty("localhost.port.http");
        if (string4 == null || string4.equals("")) {
            stringBuffer.append("compulsory property localhost.port.http has no value (must be set to a valid port number not already in use). Falling back to 8383");
            string4 = FALLBACK_HTTP_PORT;
        }
        if ((string = properties.getProperty("server.protocols")) == null || string.equals("")) {
            stringBuffer.append("\nserver.protocols not set. Falling back to http");
            string2 = FALLBACK_PROTOCOL;
            string3 = string4;
        } else {
            if (!string.contains(FALLBACK_PROTOCOL)) {
                stringBuffer.append("server.protocols must contain http or https, or both (in order of preference) separated by commas. Falling back to  http");
                string2 = FALLBACK_PROTOCOL;
                string3 = string4;
            }
            if (string.contains("https")) {
                bl2 = true;
                string5 = properties.getProperty("tomcat.port.https");
                if (string5 == null || string5.equals("")) {
                    stringBuffer.append("server.protocols includes https but property tomcat.port.https has no value (must be set to a valid port number not already in use). Falling back to 8443");
                    string5 = FALLBACK_HTTPS_PORT;
                }
            }
            if (string.matches("http(,|\\s+|$)")) {
                bl = false;
            }
            if (string.matches("^[,\\s]*https")) {
                string2 = "https";
                string3 = string5;
            } else {
                string2 = FALLBACK_PROTOCOL;
                string3 = string4;
            }
        }
        String string6 = properties.getProperty("greenstone.context", "greenstone3");
        boolean bl3 = false;
        String string7 = properties.getProperty("revproxy.domain");
        String string8 = properties.getProperty("revproxy.protocol");
        String string9 = properties.getProperty("revproxy.opt_port");
        String string10 = properties.getProperty("revproxy.context");
        if (string7 != null && string7.equals("")) {
            bl3 = true;
            if (!string8.matches("^https?$")) {
                stringBuffer.append("\nInvalid revproxy.protocol, setting it to https");
                string8 = "https";
            }
            if (string10 == null || string10.equals("")) {
                string10 = string6;
            }
            if (string9 == null || string9.equals("")) {
                string9 = null;
            }
        }
        if (string4 != null) {
            try {
                Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                stringBuffer.append("\nInvalid localhost.port.http specified: must be numeric.");
                if (string3 == string4) {
                    string4 = FALLBACK_HTTP_PORT;
                    string3 = FALLBACK_HTTP_PORT;
                }
                string4 = null;
                stringBuffer.append("\nNot using this port");
            }
        }
        if (string5 != null) {
            try {
                Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                stringBuffer.append("\nInvalid port specified for over https (tomcat.port.https): must be numeric.");
                if (string3 == string5) {
                    string5 = FALLBACK_HTTPS_PORT;
                    string3 = FALLBACK_HTTPS_PORT;
                }
                string5 = null;
                stringBuffer.append("\nNot using this port");
            }
        }
        if (bl3 && string9 != null) {
            try {
                Integer.parseInt(string9);
            }
            catch (NumberFormatException numberFormatException) {
                stringBuffer.append("\nInvalid port specified for revproxy.opt_port: must be numeric.");
                stringBuffer.append("\nSetting it to be empty.");
                string9 = null;
            }
        }
        if (string3 == string5) {
            this.defaultPortPropertyName = "tomcat.port.https";
        }
        stringBuffer.append("\nUsing port ").append(string3).append(" and protocol ").append(string2).append(".");
        this.localHttpURL = "http://" + properties.getProperty("localhost.server.http", "127.0.0.1");
        if (!string4.equals("80")) {
            this.localHttpURL = this.localHttpURL + ":" + string4;
        }
        this.localHttpURL = this.localHttpURL + "/" + string6;
        if (bl3) {
            String string11 = "";
            if (string9 != null) {
                string11 = ":" + string9;
            }
            this.externalURL = string8 + "://" + string7 + string11 + "/" + string10;
        } else {
            this.externalURL = string2 + "://" + properties.getProperty("tomcat.server", "127.0.0.1") + ":" + string3 + "/" + string6;
        }
        System.err.println("LibraryAddressProperties Initialisation info/errors:");
        System.err.println(stringBuffer.toString());
    }
}

