/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.greenstone;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import javax.swing.JOptionPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.util.PortFinder;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.Utility;

public class LocalLibraryServer {
    private static final int WAITING_TIME = 20;
    private static final String ADD_COMMAND = "?a=config&cmd=add-collection&c=";
    private static final String RELEASE_COMMAND = "?a=config&cmd=release-collection&c=";
    private static final String QUIT_COMMAND = "?a=config&cmd=kill";
    private static final String RESTART_COMMAND = "?a=config&cmd=restart";
    private static LLSSiteConfig llssite_cfg_file = null;
    private static File local_library_server_file = null;
    private static boolean running = false;
    private static String ID = "greenstone-server";
    private static int port;
    private static Socket clientSocket;
    private static Writer clientSocketWriter;
    private static boolean isPersistentServer;

    public static boolean isPersistentServer() {
        return isPersistentServer;
    }

    public static void addCollection(String string) {
        if (isPersistentServer) {
            LocalLibraryServer.config(ADD_COMMAND + string);
        }
    }

    private static void config(String string) {
        if (!isPersistentServer) {
            return;
        }
        if (Configuration.library_url == null) {
            System.err.println("Error: Trying to configure local library with null Configuration.library_url!");
            return;
        }
        try {
            URL uRL = new URL(Configuration.library_url.toString() + string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            InputStream inputStream = httpURLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                DebugStream.println("Local library server output: " + string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            int n = httpURLConnection.getResponseCode();
            if (n >= 200 && n < 300) {
                DebugStream.println("200 - Complete.");
            } else {
                DebugStream.println("404 - Failed.");
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    private static boolean sendMessageToServer(String string) {
        if (isPersistentServer) {
            return false;
        }
        if (port == -1) {
            return false;
        }
        try {
            if (clientSocket == null) {
                clientSocket = new Socket("localhost", port);
            }
            if (clientSocketWriter == null) {
                clientSocketWriter = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream()));
            }
            clientSocketWriter.write(string);
            clientSocketWriter.flush();
        }
        catch (Exception exception) {
            System.err.println("An exception occurred when trying to send the message: " + string + "\nto the LocalLibraryServer.\n" + exception);
            return false;
        }
        return true;
    }

    public static boolean isRunning() {
        if (!running) {
            return false;
        }
        llssite_cfg_file.load(true);
        String string = llssite_cfg_file.getURL();
        return string != null;
    }

    public static void releaseCollection(String string) {
        if (isPersistentServer) {
            LocalLibraryServer.config(RELEASE_COMMAND + string);
        }
    }

    public static boolean start(String string, String string2) {
        String string3;
        Object object;
        if (string2 == null) {
            return false;
        }
        local_library_server_file = new File(string2);
        if (local_library_server_file.exists()) {
            if (local_library_server_file.getName().equals("server.exe")) {
                isPersistentServer = true;
            }
        } else {
            DebugStream.println("No local library at given file path.");
            if (Utility.isWindows()) {
                local_library_server_file = new File(string + "server.exe");
                if (local_library_server_file.exists()) {
                    isPersistentServer = true;
                } else {
                    local_library_server_file = new File(string + "gs2-web-server.bat");
                    if (!local_library_server_file.exists()) {
                        DebugStream.println("No local library at all.");
                        return false;
                    }
                }
            } else {
                local_library_server_file = new File(string + "gs2-server.sh");
                if (!local_library_server_file.exists()) {
                    DebugStream.println("No local library at all.");
                    return false;
                }
            }
        }
        if (!(isPersistentServer || ((File)(object = new File(string, "apache-httpd"))).exists() || ((File)object).isDirectory())) {
            DebugStream.println("The web server does not exist at " + ((File)object).getAbsolutePath() + "\nNo local library at all. Trying web library");
            return false;
        }
        llssite_cfg_file = new LLSSiteConfig(local_library_server_file);
        if (!llssite_cfg_file.isConfigFileSet()) {
            return false;
        }
        if (LocalLibraryServer.isURLPending()) {
            return true;
        }
        if (llssite_cfg_file.isIndependentGSI()) {
            running = true;
            return true;
        }
        object = Utility.isWindows() ? "\"" : "";
        String string4 = (String)object + local_library_server_file.getAbsolutePath() + (String)object + LocalLibraryServer.getExtraLaunchArguments(llssite_cfg_file);
        if (Utility.isWindows() && !isPersistentServer) {
            string4 = "cmd.exe /c start \"GSI\" " + string4;
        }
        if ((string3 = llssite_cfg_file.getURL()) != null) {
            try {
                Configuration.library_url = new URL(string3);
                running = true;
                Gatherer.spawnApplication(string4, ID);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                DebugStream.printStackTrace(malformedURLException);
            }
        }
        Gatherer.spawnApplication(string4, ID);
        try {
            LocalLibraryServer.testServerRunning();
        }
        catch (IOException iOException) {
            try {
                Configuration.library_url = new URL(llssite_cfg_file.getLocalHostURL());
                DebugStream.println("Try connecting to server on local host: '" + Configuration.library_url + "'");
                URLConnection uRLConnection = Configuration.library_url.openConnection();
                uRLConnection.getContent();
                running = true;
            }
            catch (IOException iOException2) {
                DebugStream.println("Can't connect to server on either address.");
                Configuration.library_url = null;
                running = false;
            }
        }
        return true;
    }

    public static void reconfigure() {
        if (isPersistentServer) {
            llssite_cfg_file.load(true);
            String string = Gatherer.getCollectDirectoryPath();
            string = string.substring(0, string.length() - 1);
            llssite_cfg_file.put("collecthome", string);
            LocalLibraryServer.llssite_cfg_file.save();
            if (LocalLibraryServer.checkServerRunning()) {
                return;
            }
            if (running) {
                LocalLibraryServer.config(RESTART_COMMAND);
            }
            return;
        }
        if (llssite_cfg_file.isIndependentGSI()) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("Server.Reconfigure"), Dictionary.get("General.Reconfigure"), 1);
            return;
        }
        if (LocalLibraryServer.checkServerRunning()) {
            return;
        }
        if (running && LocalLibraryServer.sendMessageToServer("RECONFIGURE\n")) {
            if (running) {
                running = false;
                if (LocalLibraryServer.sendMessageToServer("RESTART\n")) {
                    llssite_cfg_file.setLastModified();
                    int n = 0;
                    while (!llssite_cfg_file.isModified()) {
                        new OneSecondWait();
                        if (++n != 20) continue;
                    }
                    try {
                        LocalLibraryServer.testServerRunning();
                    }
                    catch (IOException iOException) {
                        try {
                            Configuration.library_url = new URL(llssite_cfg_file.getLocalHostURL());
                            DebugStream.println("Try connecting to server on local host: '" + Configuration.library_url + "'");
                            URLConnection uRLConnection = Configuration.library_url.openConnection();
                            uRLConnection.getContent();
                            running = true;
                        }
                        catch (IOException iOException2) {
                            DebugStream.println("Can't connect to server on either address.");
                            Configuration.library_url = null;
                            running = false;
                        }
                    }
                }
            }
        } else {
            System.err.println("GLI was unable to send a reconfigure request to the local library server.\nPlease reconfigure and restart the local Greenstone server manually.");
        }
    }

    public static void stop() {
        if (!running) {
            return;
        }
        if (llssite_cfg_file.isIndependentGSI()) {
            return;
        }
        if (isPersistentServer) {
            LocalLibraryServer.config(QUIT_COMMAND);
        } else {
            boolean n = LocalLibraryServer.sendMessageToServer("QUIT\n");
            try {
                if (clientSocketWriter != null) {
                    clientSocketWriter.close();
                    clientSocketWriter = null;
                }
                clientSocket = null;
            }
            catch (Exception exception) {
                System.err.println("An exception occurred when trying to close the socket\nto the LocalLibraryServer.\n" + exception);
            }
            if (n) {
                Gatherer.terminateApplication(ID);
            } else {
                System.err.println("Unable to stop the server, since there's no communication port to send the quit msg over.\nPlease stop the local Greenstone server manually.");
            }
        }
        llssite_cfg_file.load(false);
        boolean bl = false;
        String string = llssite_cfg_file.getURL();
        while (string != null && !string.equals("URL_pending")) {
            new OneSecondWait();
            llssite_cfg_file.load(false);
            if ((n2 += 1) == 20) {
                int n = JOptionPane.showConfirmDialog(Gatherer.g_man, Dictionary.get("Server.QuitTimeOut", Integer.toString(20)), Dictionary.get("General.Warning"), 0);
                if (n == 1) {
                    return;
                }
                int n2 = 0;
            }
            string = llssite_cfg_file.getURL();
        }
        llssite_cfg_file.restore();
        string = llssite_cfg_file.getURL();
        if (string != null && !string.equals("URL_pending")) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("Server.QuitManual"), Dictionary.get("General.Error"), 0);
        }
        running = false;
    }

    public static void forceStopServer() {
        SafeProcess safeProcess = null;
        safeProcess = Utility.isWindows() ? new SafeProcess("cmd /C \"cd \"" + Configuration.gsdl_path + File.separator + "\" && gsicontrol.bat web-stop\"") : new SafeProcess(new String[]{"/bin/bash", "-c", "cd \"" + Configuration.gsdl_path + "\" && ./gsicontrol.sh web-stop"});
        System.err.println("Issuing stop command to GS2 Local Library Server. Waiting for GS2 server to stop...");
        int n = safeProcess.runProcess();
        if (n == 0) {
            System.err.println("Successfully stopped GS2 server.");
        } else {
            System.err.println("********** FAILED TO SUCCESSFULLY stop THE GS2 SERVER ON EXIT");
        }
        safeProcess = null;
    }

    private static String getExtraLaunchArguments(LLSSiteConfig lLSSiteConfig) {
        String string = " --mode=gli " + lLSSiteConfig.getSiteConfigFilename();
        if (isPersistentServer) {
            return string;
        }
        try {
            PortFinder portFinder = new PortFinder(50100, 100);
            port = portFinder.findPortInRange(false);
        }
        catch (Exception exception) {
            System.err.println("Exception when trying to find an available port: " + exception);
            port = -1;
        }
        return string + " --quitport=" + port;
    }

    private static void testServerRunning() throws IOException {
        llssite_cfg_file.load(false);
        int n = 0;
        while (llssite_cfg_file.getURL() == null) {
            new OneSecondWait();
            llssite_cfg_file.load(false);
            if (++n != 20) continue;
            int n2 = JOptionPane.showConfirmDialog(Gatherer.g_man, Dictionary.get("Server.StartUpTimeOut", Integer.toString(20)), Dictionary.get("General.Warning"), 0);
            if (n2 == 1) {
                return;
            }
            n = 0;
        }
        try {
            Configuration.library_url = new URL(llssite_cfg_file.getURL());
        }
        catch (MalformedURLException malformedURLException) {
            DebugStream.printStackTrace(malformedURLException);
        }
        try {
            DebugStream.println("Try connecting to server on config url: '" + Configuration.library_url + "'");
            URLConnection uRLConnection = Configuration.library_url.openConnection();
            uRLConnection.getContent();
            running = true;
        }
        catch (IOException iOException) {
            System.err.println("Unable to open a connection to " + Configuration.library_url + "\nCheck whether the port may already be in use. If so, change your\nGreenstone port number in the Greenstone Server Interface(GSI).");
            throw iOException;
        }
    }

    public static boolean isURLPending() {
        llssite_cfg_file.load(true);
        String string = llssite_cfg_file.getURL();
        if (string != null) {
            if (string.equals("URL_pending")) {
                running = false;
                return true;
            }
            try {
                Configuration.library_url = new URL(string);
                running = true;
            }
            catch (MalformedURLException malformedURLException) {
                running = false;
                malformedURLException.printStackTrace();
                DebugStream.printStackTrace(malformedURLException);
            }
            return false;
        }
        return false;
    }

    public static boolean checkServerRunning() {
        boolean bl = false;
        if (!running) {
            return false;
        }
        llssite_cfg_file.load(true);
        String string = llssite_cfg_file.getURL();
        if (string != null) {
            if (string.equals("URL_pending")) {
                running = false;
                return false;
            }
            try {
                Configuration.library_url = new URL(string);
                running = true;
            }
            catch (MalformedURLException malformedURLException) {
                running = false;
                DebugStream.printStackTrace(malformedURLException);
                malformedURLException.printStackTrace();
            }
        } else {
            if (llssite_cfg_file.usingGSImode()) {
                string = llssite_cfg_file.getURL();
                running = !string.equals("URL_pending");
                return false;
            }
            llssite_cfg_file.useGLImode();
            if (clientSocket != null) {
                clientSocket = null;
            }
            if (clientSocketWriter != null) {
                try {
                    clientSocketWriter.close();
                    clientSocketWriter = null;
                }
                catch (Exception exception) {
                    System.err.println("Unable to close the client socket outputstream.");
                }
                finally {
                    clientSocketWriter = null;
                }
            }
            running = false;
            String string2 = Utility.isWindows() ? "\"" : "";
            String string3 = string2 + local_library_server_file.getAbsolutePath() + string2 + LocalLibraryServer.getExtraLaunchArguments(llssite_cfg_file);
            if (Utility.isWindows() && !isPersistentServer) {
                string3 = "cmd.exe /c start \"GSI\" " + string3;
            }
            Gatherer.spawnApplication(string3, ID);
            try {
                LocalLibraryServer.testServerRunning();
                bl = true;
            }
            catch (IOException iOException) {
                DebugStream.println("Can't connect to server on address " + Configuration.library_url);
                running = false;
            }
        }
        return bl;
    }

    static {
        clientSocket = null;
        clientSocketWriter = null;
        isPersistentServer = false;
    }

    public static class LLSSiteConfig
    extends LinkedHashMap {
        private File configFile;
        private String autoenter_initial;
        private String start_browser_initial;
        private long lastModified = 0L;
        private boolean isIndependentGSI;
        private static final String GLI_PREFIX = "gli";
        private static final String GSI_AUTOENTER = "autoenter";
        private static final String AUTOENTER = "gli.autoenter";
        private static final String COLON = ":";
        private static final String ENTERLIB = "enterlib";
        private static final String FALSE = "0";
        private static final String GSDL = "greenstone";
        private static final String LLSSITE_CFG = "llssite.cfg";
        private static final String LOCAL_HOST = "http://localhost";
        private static final String PORTNUMBER = "portnumber";
        private static final String SEPARATOR = "/";
        private static final String SPECIFIC_CONFIG = "--config=";
        private static final String STARTBROWSER = "gli.start_browser";
        private static final String GSI_STARTBROWSER = "start_browser";
        private static final String TRUE = "1";
        private static final String URL = "gli.url";
        private static final String GSI_URL = "url";
        private static final String COLLECTHOME = "collecthome";
        private static final String GLIMODE = "--mode=gli";
        public static final String URL_PENDING = "URL_pending";

        public LLSSiteConfig(File file) {
            Object object;
            this.debug("New LLSSiteConfig for: " + file.getAbsolutePath());
            this.configFile = new File(file.getParentFile(), LLSSITE_CFG);
            if (!this.configFile.exists()) {
                object = new File(file.getParentFile(), "llssite.cfg.in");
                if (((File)object).exists()) {
                    LLSSiteConfig.copyConfigFile((File)object, this.configFile, true);
                } else {
                    this.debug("File llssite.cfg.in can't be found. Can't create llssite.cfg frrom llssite.cfg.in.");
                }
            }
            if (this.configFile.exists()) {
                if (!this.usingGSImode()) {
                    this.useGLImode();
                }
            } else {
                System.err.println("**** ERROR. Configfile is null.");
                this.configFile = null;
            }
            this.autoenter_initial = null;
            this.start_browser_initial = null;
            object = Configuration.getString("general.open_collection_gs2", true);
            String string = Gatherer.getCollectDirectoryPath();
            String string2 = Gatherer.getDefaultGSCollectDirectoryPath(true);
            if (((String)object).equals("")) {
                return;
            }
            if (!(((String)object).startsWith(string) && string.equals(string2) || !isPersistentServer)) {
                this.put(COLLECTHOME, string);
                this.save();
                this.lastModified = this.configFile.lastModified();
            }
        }

        public void useGLImode() {
            this.isIndependentGSI = false;
            this.load(true);
        }

        public boolean usingGSImode() {
            this.load(false);
            this.isIndependentGSI = true;
            if (this.getURL() == null) {
                this.isIndependentGSI = false;
                return false;
            }
            this.lastModified = this.configFile.lastModified();
            return true;
        }

        public boolean isConfigFileSet() {
            return this.configFile != null && this.configFile.exists();
        }

        public boolean isIndependentGSI() {
            return this.isIndependentGSI;
        }

        public boolean exists() {
            return this.configFile.exists();
        }

        public String getLocalHostURL() {
            StringBuffer stringBuffer = new StringBuffer(LOCAL_HOST);
            stringBuffer.append(COLON);
            stringBuffer.append((String)this.get(PORTNUMBER));
            String string = (String)this.get(ENTERLIB);
            if (!isPersistentServer || string == null || string.length() == 0) {
                stringBuffer.append(SEPARATOR);
                stringBuffer.append(GSDL);
            } else {
                if (!string.startsWith(SEPARATOR)) {
                    stringBuffer.append(SEPARATOR);
                }
                stringBuffer.append(string);
            }
            string = null;
            this.debug("Found Local Library Address: " + stringBuffer.toString());
            return stringBuffer.toString();
        }

        public String getSiteConfigFilename() {
            return SPECIFIC_CONFIG + this.configFile.getAbsolutePath();
        }

        public String getURL() {
            String string = this.isIndependentGSI() ? GSI_URL : URL;
            String string2 = (String)this.get(string);
            if (string2 != null && string2.equals(URL_PENDING)) {
                return string2;
            }
            if (!isPersistentServer) {
                return string2;
            }
            if (string2 != null) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append(COLON);
                stringBuffer.append((String)this.get(PORTNUMBER));
                String string3 = (String)this.get(ENTERLIB);
                if (string3 == null || string3.length() == 0) {
                    stringBuffer.append(SEPARATOR);
                    stringBuffer.append(GSDL);
                } else {
                    if (!string3.startsWith(SEPARATOR)) {
                        stringBuffer.append(SEPARATOR);
                    }
                    stringBuffer.append(string3);
                }
                string3 = null;
                string2 = stringBuffer.toString();
            }
            this.debug("Found Local Library Address: " + string2);
            return string2;
        }

        public void setLastModified() {
            if (this.isModified()) {
                this.lastModified = this.configFile.lastModified();
            }
        }

        public boolean isModified() {
            return this.lastModified != this.configFile.lastModified();
        }

        public void load(boolean bl) {
            if (this.configFile == null) {
                this.debug(this.configFile.getAbsolutePath() + " cannot be found!");
            }
            if (this.isModified()) {
                this.lastModified = this.configFile.lastModified();
            } else if (bl) {
                return;
            }
            if (this.configFile.exists()) {
                this.debug("Load: " + this.configFile.getAbsolutePath());
                this.clear();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.configFile));
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        String string2 = null;
                        String string3 = null;
                        int n = -1;
                        n = string.indexOf("=");
                        if (n != -1 && string.length() >= n + 1) {
                            string2 = string.substring(0, n);
                            string3 = string.substring(n + 1);
                        } else {
                            string2 = string;
                        }
                        this.put(string2, string3);
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.debug(this.configFile.getAbsolutePath() + " cannot be found!");
            }
        }

        public void restore() {
            if (this.configFile != null) {
                String string = this.isIndependentGSI() ? GSI_URL : URL;
                this.remove(string);
                this.remove("gsdlhome");
                this.remove(COLLECTHOME);
                this.remove("gdbmhome");
                this.remove("logfilename");
                if (this.get(GSI_AUTOENTER) == null) {
                    this.put(GSI_AUTOENTER, FALSE);
                }
                if (this.get(GSI_STARTBROWSER) == null) {
                    this.put(GSI_STARTBROWSER, TRUE);
                }
                if (this.get(AUTOENTER) == null) {
                    this.put(AUTOENTER, TRUE);
                }
                if (this.get(STARTBROWSER) == null) {
                    this.put(STARTBROWSER, FALSE);
                }
                this.save();
            } else {
                String string = this.isIndependentGSI() ? GSI_URL : URL;
                this.debug("Restore Initial Settings");
                this.put(AUTOENTER, this.autoenter_initial);
                this.put(STARTBROWSER, this.start_browser_initial);
                this.remove(string);
                this.save();
            }
        }

        public void set() {
            this.debug("Set Session Settings");
            if (this.autoenter_initial == null) {
                this.autoenter_initial = (String)this.get(AUTOENTER);
                this.debug("Remember autoenter was: " + this.autoenter_initial);
            }
            this.put(AUTOENTER, TRUE);
            if (this.start_browser_initial == null) {
                this.start_browser_initial = (String)this.get(STARTBROWSER);
                this.debug("Remember start_browser was: " + this.start_browser_initial);
            }
            this.put(STARTBROWSER, FALSE);
            this.save();
        }

        private void debug(String string) {
        }

        private void save() {
            this.debug("Save: " + this.configFile.getAbsolutePath());
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.configFile, false));
                for (String string : this.keySet()) {
                    String string2 = (String)this.get(string);
                    bufferedWriter.write(string, 0, string.length());
                    if (string2 != null) {
                        bufferedWriter.write(61);
                        if (this.isIndependentGSI && (string == GSI_AUTOENTER || string == GSI_STARTBROWSER)) {
                            if (string == GSI_AUTOENTER) {
                                bufferedWriter.write(this.autoenter_initial, 0, this.autoenter_initial.length());
                            } else {
                                bufferedWriter.write(this.start_browser_initial, 0, this.start_browser_initial.length());
                            }
                        } else {
                            bufferedWriter.write(string2, 0, string2.length());
                        }
                    }
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private static void copyConfigFile(File file, File file2, boolean bl) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2, false));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (bl) {
                        if (string.startsWith(AUTOENTER)) {
                            string = "gli.autoenter=1";
                        } else if (string.startsWith(STARTBROWSER)) {
                            string = "gli.start_browser=0";
                        }
                    }
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                bufferedReader.close();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception occurred when trying to copy the config file " + file.getName() + " to " + file2.getName() + ": " + exception);
                exception.printStackTrace();
            }
        }
    }

    private static class OneSecondWait {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OneSecondWait() {
            OneSecondWait oneSecondWait = this;
            synchronized (oneSecondWait) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

