/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gems.MetadataSetEvent;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetListener;
import org.greenstone.gatherer.gems.MetadataSetManager;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.TestingPreparation;

public class OpenMetadataSetPrompt
extends ModalDialog {
    private static Dimension SIZE = new Dimension(500, 500);
    private ArrayList available_metadata_sets;
    private ArrayList listeners;
    private JButton open_button = null;
    private JButton cancel_button = null;
    private JButton browse_button = null;
    private JList available_set_list = null;
    private OpenMetadataSetPrompt self = this;
    private MetadataSetManager meta_manager;
    private JTextArea description_textarea = null;
    private boolean cancelled = false;

    public OpenMetadataSetPrompt(Frame frame, MetadataSetManager metadataSetManager) {
        super(frame, true);
        this.meta_manager = metadataSetManager;
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("GEMS.OpenMetadataSetPrompt.Title"));
        this.listeners = new ArrayList();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setOpaque(true);
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("GEMS.OpenMetadataSetPrompt.Available_Sets"));
        jLabel.setOpaque(true);
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        this.available_set_list = new JList();
        this.available_set_list.setCellRenderer(new MetadatSetListCellRenderer());
        this.available_set_list.setSelectionMode(0);
        this.available_set_list.setFixedCellHeight(20);
        this.available_set_list.addListSelectionListener(new MetadataSetListSelectionListener());
        this.available_set_list.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)new JScrollPane(this.available_set_list), "Center");
        JLabel jLabel2 = new JLabel(Dictionary.get("GEMS.Set_Description"));
        jLabel2.setOpaque(true);
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        this.description_textarea = new JTextArea();
        this.description_textarea.setOpaque(true);
        this.description_textarea.setEditable(false);
        this.description_textarea.setLineWrap(true);
        this.description_textarea.setWrapStyleWord(true);
        this.description_textarea.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jLabel2, "North");
        jPanel3.add((Component)new JScrollPane(this.description_textarea), "Center");
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        this.open_button = new GLIButton(Dictionary.get("GEMS.OpenMetadataSetPrompt.Open"), Dictionary.get("GEMS.OpenMetadataSetPrompt.Open_Tooltip"));
        this.open_button.setEnabled(true);
        this.browse_button = new GLIButton(Dictionary.get("General.Browse"));
        this.browse_button.setEnabled(true);
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        this.cancel_button.setEnabled(true);
        this.open_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenMetadataSetPrompt.this.notifyListeners();
                OpenMetadataSetPrompt.this.self.dispose();
            }
        });
        this.browse_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenMetadataSetPrompt.this.meta_manager;
                String string = MetadataSetManager.getCollectionPath();
                JFileChooser jFileChooser = new JFileChooser(new File(string));
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    String string2 = jFileChooser.getSelectedFile().toString();
                    MetadataSetInfo metadataSetInfo = OpenMetadataSetPrompt.this.meta_manager.getMetadataSet(string2);
                    metadataSetInfo.setNew(false);
                    MetadataSetEvent metadataSetEvent = new MetadataSetEvent(metadataSetInfo);
                    for (int i = 0; i < OpenMetadataSetPrompt.this.listeners.size(); ++i) {
                        MetadataSetListener metadataSetListener = (MetadataSetListener)OpenMetadataSetPrompt.this.listeners.get(i);
                        metadataSetListener.metadataSetChanged(metadataSetEvent);
                    }
                }
                OpenMetadataSetPrompt.this.notifyListeners();
                OpenMetadataSetPrompt.this.self.dispose();
            }
        });
        this.cancel_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenMetadataSetPrompt.this.cancelled = true;
                OpenMetadataSetPrompt.this.self.dispose();
            }
        });
        jPanel4.setLayout(new GridLayout(1, 3));
        jPanel4.add(this.open_button);
        jPanel4.add(this.browse_button);
        jPanel4.add(this.cancel_button);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - OpenMetadataSetPrompt.SIZE.width) / 2, (dimension.height - OpenMetadataSetPrompt.SIZE.height) / 2);
        this.setVisible(false);
    }

    public void display() {
        this.cancelled = false;
        this.available_metadata_sets = this.meta_manager.getAvailableMetadataSets();
        this.available_set_list.setListData(new Vector(this.available_metadata_sets));
        TestingPreparation.setNamesRecursively(this);
        this.setVisible(true);
    }

    public void addMetadataSetListener(MetadataSetListener metadataSetListener) {
        this.listeners.add(metadataSetListener);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void notifyListeners() {
        Object e = this.available_set_list.getSelectedValue();
        if (e != null && e instanceof MetadataSetInfo) {
            MetadataSetEvent metadataSetEvent = new MetadataSetEvent((MetadataSetInfo)e);
            for (int i = 0; i < this.listeners.size(); ++i) {
                MetadataSetListener metadataSetListener = (MetadataSetListener)this.listeners.get(i);
                metadataSetListener.metadataSetChanged(metadataSetEvent);
            }
        }
    }

    public void openMetadataSet(String string) {
        MetadataSetInfo metadataSetInfo = this.meta_manager.getMetadataSet(string);
        this.notifyListeners(metadataSetInfo);
    }

    private void notifyListeners(MetadataSetInfo metadataSetInfo) {
        MetadataSetEvent metadataSetEvent = new MetadataSetEvent(metadataSetInfo);
        for (int i = 0; i < this.listeners.size(); ++i) {
            MetadataSetListener metadataSetListener = (MetadataSetListener)this.listeners.get(i);
            metadataSetListener.metadataSetChanged(metadataSetEvent);
        }
    }

    private class MetadataSetListSelectionListener
    implements ListSelectionListener {
        private MetadataSetListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            Object e = OpenMetadataSetPrompt.this.available_set_list.getSelectedValue();
            if (e != null && e instanceof MetadataSetInfo) {
                MetadataSetInfo metadataSetInfo = (MetadataSetInfo)e;
                String string = metadataSetInfo.getMetadataSetDescription();
                OpenMetadataSetPrompt.this.description_textarea.setText(string);
            }
        }
    }

    private class MetadatSetListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MetadatSetListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "unknown";
            if (object instanceof MetadataSetInfo) {
                MetadataSetInfo metadataSetInfo = (MetadataSetInfo)object;
                string = metadataSetInfo.getMetadataSetName();
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

