/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gems.GEMSConstants;
import org.greenstone.gatherer.gems.MetadataSetEvent;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetListener;
import org.greenstone.gatherer.gems.MetadataSetManager;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.TestingPreparation;

public class NewMetadataSetPrompt
extends ModalDialog {
    private static Dimension SIZE = new Dimension(500, 320);
    private ArrayList available_metadata_sets;
    private ArrayList listeners;
    private JButton ok_button = null;
    private JButton cancel_button = null;
    private JComboBox base_metadata_combo;
    private NewMetadataSetPrompt self = this;
    private MetadataSetManager meta_manager;
    private JTextArea description_textarea = null;
    private JTextField title_field;
    private JTextField namespace_field;
    private boolean cancelled = false;

    public NewMetadataSetPrompt(Frame frame, MetadataSetManager metadataSetManager) {
        super(frame, true);
        this.listeners = new ArrayList();
        this.meta_manager = metadataSetManager;
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("GEMS.NewMetadataSetPrompt.Title"));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setOpaque(true);
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("GEMS.NewMetadataSetPrompt.Instructions"));
        jLabel.setOpaque(true);
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel2 = new JLabel(Dictionary.get("GEMS.NewMetadataSetPrompt.Metadata_Title"));
        jLabel2.setOpaque(true);
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        this.title_field = new JTextField();
        this.title_field.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add((Component)jLabel2, "Before");
        jPanel2.add((Component)this.title_field, "Center");
        JLabel jLabel3 = new JLabel(Dictionary.get("GEMS.NewMetadataSetPrompt.Metadata_Namespace"));
        jLabel3.setComponentOrientation(Dictionary.getOrientation());
        jLabel3.setOpaque(true);
        this.namespace_field = new JTextField();
        this.namespace_field.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.add((Component)jLabel3, "Before");
        jPanel3.add((Component)this.namespace_field, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.add((Component)jLabel, "North");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        JLabel jLabel4 = new JLabel(Dictionary.get("GEMS.Set_Description"));
        jLabel4.setOpaque(true);
        jLabel4.setComponentOrientation(Dictionary.getOrientation());
        this.description_textarea = new JTextArea();
        this.description_textarea.setComponentOrientation(Dictionary.getOrientation());
        this.description_textarea.setLineWrap(true);
        this.description_textarea.setWrapStyleWord(true);
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jLabel4, "North");
        jPanel5.add((Component)new JScrollPane(this.description_textarea), "Center");
        JLabel jLabel5 = new JLabel(Dictionary.get("GEMS.NewMetadataSetPrompt.Base_MetadataSet"));
        jLabel5.setOpaque(true);
        jLabel5.setComponentOrientation(Dictionary.getOrientation());
        this.base_metadata_combo = new JComboBox();
        this.base_metadata_combo.setRenderer(new MetadatSetListCellRenderer());
        this.base_metadata_combo.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
        jPanel6.setComponentOrientation(Dictionary.getOrientation());
        jPanel6.add((Component)jLabel5, "Before");
        jPanel6.add((Component)this.base_metadata_combo, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setComponentOrientation(Dictionary.getOrientation());
        this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        this.ok_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NewMetadataSetPrompt.this.createNewSet()) {
                    NewMetadataSetPrompt.this.self.dispose();
                }
            }
        });
        this.cancel_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewMetadataSetPrompt.this.cancelled = true;
                NewMetadataSetPrompt.this.self.dispose();
            }
        });
        jPanel7.setLayout(new GridLayout(1, 2));
        jPanel7.add(this.ok_button);
        jPanel7.add(this.cancel_button);
        JPanel jPanel8 = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel8.add(jPanel6);
        jPanel8.add(jPanel7);
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)jPanel5, "Center");
        jPanel.add((Component)jPanel8, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - NewMetadataSetPrompt.SIZE.width) / 2, (dimension.height - NewMetadataSetPrompt.SIZE.height) / 2);
        this.setVisible(false);
    }

    public void display() {
        this.cancelled = false;
        this.available_metadata_sets = this.meta_manager.getAvailableMetadataSets();
        Vector<String> vector = new Vector<String>(this.available_metadata_sets);
        vector.add(0, Dictionary.get("GEMS.NewMetadataSetPrompt.New_Metadata"));
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        this.title_field.setText("");
        this.namespace_field.setText("");
        this.description_textarea.setText("");
        this.base_metadata_combo.setModel(defaultComboBoxModel);
        TestingPreparation.setNamesRecursively(this);
        this.setVisible(true);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void addMetadataSetListener(MetadataSetListener metadataSetListener) {
        this.listeners.add(metadataSetListener);
    }

    private boolean createNewSet() {
        int n;
        String string = this.title_field.getText();
        String string2 = this.namespace_field.getText();
        String string3 = this.description_textarea.getText();
        if (string == null || string.trim().equals("")) {
            JOptionPane.showMessageDialog(this.self, Dictionary.get("GEMS.NewMetadataSetPrompt.Title_Error_Message"), Dictionary.get("GEMS.NewMetadataSetPrompt.Title_Error"), 0);
            return false;
        }
        if (string2 == null || string2.trim().equals("")) {
            JOptionPane.showMessageDialog(this.self, Dictionary.get("GEMS.NewMetadataSetPrompt.Namespace_Error_Message"), Dictionary.get("GEMS.NewMetadataSetPrompt.Namespace_Error"), 0);
            return false;
        }
        if (this.meta_manager.isNamespaceAlreadyUsed(string2) && (n = JOptionPane.showOptionDialog(null, Dictionary.get("GEMS.Namespace_Conflict_Message"), Dictionary.get("GEMS.Namespace_Conflict"), -1, 3, null, GEMSConstants.DIALOG_OPTIONS, GEMSConstants.DIALOG_OPTIONS[0])) != 0) {
            return false;
        }
        Object object = this.base_metadata_combo.getSelectedItem();
        if (object != null) {
            MetadataSetInfo metadataSetInfo = null;
            metadataSetInfo = object instanceof MetadataSetInfo ? (MetadataSetInfo)object : new MetadataSetInfo();
            metadataSetInfo.setNew(true);
            metadataSetInfo.setLanguageDependentAttributes(new ArrayList());
            metadataSetInfo.setMetadataSetName(string);
            metadataSetInfo.setMetadataSetDescription(string3);
            metadataSetInfo.setNamespace(string2);
            metadataSetInfo.setCurrentLanguage(this.meta_manager.getCurrentLanguage());
            this.notifyListeners(metadataSetInfo);
        }
        return true;
    }

    private void notifyListeners(MetadataSetInfo metadataSetInfo) {
        MetadataSetEvent metadataSetEvent = new MetadataSetEvent(metadataSetInfo);
        for (int i = 0; i < this.listeners.size(); ++i) {
            MetadataSetListener metadataSetListener = (MetadataSetListener)this.listeners.get(i);
            metadataSetListener.metadataSetChanged(metadataSetEvent);
        }
    }

    private class MetadatSetListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MetadatSetListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "unknown";
            if (object instanceof MetadataSetInfo) {
                MetadataSetInfo metadataSetInfo = (MetadataSetInfo)object;
                string = metadataSetInfo.getMetadataSetName();
                this.setText(string);
            } else {
                this.setText(object.toString());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

