/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gems.Attribute;
import org.greenstone.gatherer.gems.GEMSConstants;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetModel;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class MetadataSetManager {
    private ArrayList mds_list = new ArrayList();
    private MetadataSetModel metadata_set_model;
    private ArrayList languageList;
    private String current_language = GEMSConstants.DEFAULT_LANGUAGE;

    public MetadataSetManager(String string, String string2, String string3) {
        String string4 = System.getProperty("user.home") + File.separator;
        string4 = Utility.isWindows() ? string4 + "Application Data" + File.separator + "Greenstone" + File.separator + "GLI" + File.separator : string4 + ".gli" + File.separator;
        new Configuration(string4, string, string2, string3, null, null, null, null, null);
        this.current_language = Configuration.getLanguage();
        this.languageList = new ArrayList();
    }

    public MetadataSetManager() {
        this.current_language = Configuration.getLanguage();
        this.languageList = new ArrayList();
    }

    public ArrayList getLanguageList() {
        if (this.languageList.size() > 0) {
            return this.languageList;
        }
        Document document = XMLTools.parseXMLFile("xml/languages.xml", true);
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(GEMSConstants.LANGUAGE_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            this.languageList.add(element.getAttribute(GEMSConstants.CODE_ATTRIBUTE).toLowerCase() + "   " + element.getAttribute(GEMSConstants.NAME_ATTRIBUTE));
        }
        return this.languageList;
    }

    public boolean isAttributeRequired(String string) {
        String string2 = string.trim();
        for (int i = 0; i < GEMSConstants.SET_REQUIRED_ATTRIBUTES.length; ++i) {
            if (!string2.equals(GEMSConstants.SET_REQUIRED_ATTRIBUTES[i])) continue;
            return true;
        }
        return false;
    }

    public void save(boolean bl) {
        int n;
        MetadataSetInfo metadataSetInfo = this.metadata_set_model.getMetadataSetInfo();
        if (metadataSetInfo == null) {
            return;
        }
        if (bl && (n = JOptionPane.showConfirmDialog(null, Dictionary.get("GEMS.Confirm_Save"), Dictionary.get("GEMS.Confirm_Save_Title"), 0)) != 0) {
            return;
        }
        File file = null;
        if (metadataSetInfo.isNew()) {
            JFileChooser jFileChooser = new JFileChooser(new File(MetadataSetManager.getGLIMetadataDirectoryPath()));
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setSelectedFile(new File(MetadataSetManager.getGLIMetadataDirectoryPath(), metadataSetInfo.getNamespace() + GEMSConstants.METADATA_SET_FILE_EXTENSION));
            int n2 = jFileChooser.showSaveDialog(null);
            if (n2 == 0) {
                file = jFileChooser.getSelectedFile();
                metadataSetInfo.setFilePath(file.toString());
                metadataSetInfo.setNew(false);
            }
        } else {
            file = new File(metadataSetInfo.getFilePath());
        }
        if (file != null) {
            this.save(file);
        }
        for (int i = 0; i < this.mds_list.size(); ++i) {
            MetadataSetInfo metadataSetInfo2 = (MetadataSetInfo)this.mds_list.get(i);
            if (!metadataSetInfo2.getFilePath().trim().equals(metadataSetInfo.getFilePath().trim())) continue;
            this.mds_list.remove(metadataSetInfo2);
            this.mds_list.add(metadataSetInfo);
            break;
        }
    }

    private void save(File file) {
        try {
            XMLTools.writeXMLFile(file, this.metadata_set_model.getMetadataSetDocument());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Document getMetadataSetDocument(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        return XMLTools.parseXMLFile(string, true);
    }

    public void setMetadataSetModel(MetadataSetModel metadataSetModel) {
        this.metadata_set_model = metadataSetModel;
    }

    public MetadataSetModel getMetadataSetModel() {
        return this.metadata_set_model;
    }

    public ArrayList getAvailableMetadataSets() {
        this.mds_list.clear();
        File file = new File(MetadataSetManager.getGLIMetadataDirectoryPath());
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory() || !file2.getName().endsWith(GEMSConstants.METADATA_SET_FILE_EXTENSION)) continue;
                Document document = XMLTools.parseXMLFile(file2.toString(), true);
                MetadataSetInfo metadataSetInfo = this.constructMetadataInfo(document);
                metadataSetInfo.setFilePath(file2.toString());
                this.mds_list.add(metadataSetInfo);
            }
        }
        return this.mds_list;
    }

    public boolean isNamespaceAlreadyUsed(String string) {
        for (int i = 0; i < this.mds_list.size(); ++i) {
            MetadataSetInfo metadataSetInfo = (MetadataSetInfo)this.mds_list.get(i);
            if (!metadataSetInfo.getNamespace().trim().equals(string)) continue;
            return true;
        }
        return false;
    }

    public MetadataSetInfo getMetadataSet(String string) {
        MetadataSetInfo metadataSetInfo = this.constructMetadataInfo(XMLTools.parseXMLFile(string, true));
        ArrayList arrayList = metadataSetInfo.getLanguageDependentAttributes();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            Attribute attribute = (Attribute)arrayList.get(i);
            if (!attribute.getLanguage().equals(this.current_language)) continue;
            metadataSetInfo.setCurrentLanguage(this.current_language);
            bl = true;
            break;
        }
        if (!bl && arrayList.size() > 0) {
            metadataSetInfo.setCurrentLanguage(((Attribute)arrayList.get(0)).getLanguage());
        }
        metadataSetInfo.setFilePath(string);
        return metadataSetInfo;
    }

    public void deleteMetadataSet(MetadataSetInfo metadataSetInfo) {
        String string = metadataSetInfo.getFilePath();
        if (string != null && !string.trim().equals("")) {
            File file = new File(string);
            boolean bl = file.delete();
            if (!bl) {
                JOptionPane.showMessageDialog(null, Dictionary.get("GEMS.File_Deletion_Error_Message"), Dictionary.get("GEMS.File_Deletion_Error"), 0);
            } else {
                for (int i = 0; i < this.mds_list.size(); ++i) {
                    MetadataSetInfo metadataSetInfo2 = (MetadataSetInfo)this.mds_list.get(i);
                    if (!metadataSetInfo2.getFilePath().trim().equals(metadataSetInfo.getFilePath().trim())) continue;
                    this.mds_list.remove(metadataSetInfo2);
                    break;
                }
            }
        }
    }

    public String getCurrentLanguage() {
        return this.current_language;
    }

    private MetadataSetInfo constructMetadataInfo(Document document) {
        Object object;
        NamedNodeMap namedNodeMap = document.getDocumentElement().getAttributes();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        String string = null;
        boolean bl = false;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = (Attr)namedNodeMap.item(i);
            Attribute attribute = new Attribute(object.getName(), object.getValue());
            attribute.setRequired(this.isAttributeRequired(attribute.getName()));
            arrayList.add(attribute);
        }
        ArrayList arrayList2 = new ArrayList();
        object = document.getDocumentElement().getElementsByTagName(GEMSConstants.SET_LANGUAGE_ELEMENT);
        if (object.getLength() > 0) {
            for (int i = 0; i < object.getLength(); ++i) {
                Element element = (Element)object.item(i);
                string = element.getAttribute(GEMSConstants.CODE_ATTRIBUTE);
                this.setNameAndDescription(arrayList2, element, string);
            }
        } else {
            this.setNameAndDescription(arrayList2, document.getDocumentElement(), string);
        }
        MetadataSetInfo metadataSetInfo = new MetadataSetInfo();
        metadataSetInfo.setLanguageDependentAttributes(arrayList2);
        metadataSetInfo.setAttributes(arrayList);
        return metadataSetInfo;
    }

    private void setNameAndDescription(ArrayList arrayList, Element element, String string) {
        Object object;
        Object object2;
        ArrayList arrayList2 = XMLTools.getChildElementsByTagName(element, GEMSConstants.NAME_ELEMENT);
        String string2 = "";
        if (arrayList2.size() > 0) {
            object2 = (Element)arrayList2.get(0);
            object = new Attribute(GEMSConstants.NAME_ATTRIBUTE, XMLTools.getElementTextValue((Element)object2), true);
            if (string == null) {
                ((Attribute)object).setLanguage(object2.getAttribute(GEMSConstants.LANGUAGE_ATTRIBUTE));
                string2 = ((Attribute)object).getLanguage();
            } else {
                ((Attribute)object).setLanguage(string);
            }
            arrayList.add(object);
        }
        if (((ArrayList)(object2 = XMLTools.getChildElementsByTagName(element, GEMSConstants.DESCRIPTION_ELEMENT))).size() > 0) {
            object = (Element)((ArrayList)object2).get(0);
            Attribute attribute = new Attribute(GEMSConstants.DESCRIPTION_ATTRIBUTE, XMLTools.getElementTextValue((Element)object), true);
            if (string == null) {
                attribute.setLanguage(object.getAttribute(GEMSConstants.LANGUAGE_ATTRIBUTE));
            } else {
                attribute.setLanguage(string);
            }
            arrayList.add(attribute);
        } else {
            object = new Attribute(GEMSConstants.DESCRIPTION_ATTRIBUTE, "", true);
            if (string == null) {
                ((Attribute)object).setLanguage(string2);
            } else {
                ((Attribute)object).setLanguage(string);
            }
            arrayList.add(object);
        }
    }

    public static String getGLIDirectoryPath() {
        return System.getProperty("user.dir") + File.separator;
    }

    public static String getGLIMetadataDirectoryPath() {
        return MetadataSetManager.getGLIDirectoryPath() + "metadata" + File.separator;
    }

    public static String getCollectionPath() {
        if (Configuration.gsdl3_web_path != null && !Configuration.gsdl3_web_path.equals("")) {
            return Configuration.gsdl3_web_path + File.separator + "sites";
        }
        return Configuration.gsdl_path + File.separator + "collect";
    }
}

