/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetListener;
import org.greenstone.gatherer.gems.MetadataSetManager;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;

public class DeleteMetadataSetPrompt
extends ModalDialog {
    private static Dimension SIZE = new Dimension(500, 500);
    private ArrayList available_metadata_sets;
    private ArrayList listeners;
    private JCheckBox confirmation = null;
    private JButton delete_button = null;
    private JButton close_button = null;
    private JList available_set_list = null;
    private DefaultListModel list_model = null;
    private JTextArea description_textarea = null;
    private DeleteMetadataSetPrompt self = this;
    private MetadataSetManager meta_manager;

    public DeleteMetadataSetPrompt(Frame frame, MetadataSetManager metadataSetManager) {
        super(frame, true);
        this.meta_manager = metadataSetManager;
        this.listeners = new ArrayList();
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("GEMS.DeleteMetadataSetPrompt.Title"));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setOpaque(true);
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("GEMS.DeleteMetadataSetPrompt.Available_Sets"));
        jLabel.setOpaque(true);
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        this.list_model = new DefaultListModel();
        this.available_set_list = new JList();
        this.available_set_list.setSelectionMode(0);
        this.available_set_list.setModel(this.list_model);
        this.available_set_list.setCellRenderer(new MetadatSetListCellRenderer());
        this.available_set_list.setFixedCellHeight(20);
        this.available_set_list.addListSelectionListener(new MetadataSetListSelectionListener());
        this.available_set_list.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)new JScrollPane(this.available_set_list), "Center");
        JLabel jLabel2 = new JLabel(Dictionary.get("GEMS.Set_Description"));
        jLabel2.setOpaque(true);
        this.description_textarea = new JTextArea();
        this.description_textarea.setOpaque(true);
        this.description_textarea.setEditable(false);
        this.description_textarea.setLineWrap(true);
        this.description_textarea.setWrapStyleWord(true);
        this.description_textarea.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jLabel2, "North");
        jPanel3.add((Component)new JScrollPane(this.description_textarea), "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        this.delete_button = new GLIButton(Dictionary.get("GEMS.DeleteMetadataSetPrompt.Delete"), Dictionary.get("GEMS.DeleteMetadataSetPrompt.Delete_Tooltip"));
        this.delete_button.setEnabled(false);
        this.confirmation = new JCheckBox(Dictionary.get("GEMS.DeleteMetadataSetPrompt.Confirm_Delete"));
        this.confirmation.setEnabled(false);
        this.confirmation.setSelected(false);
        this.confirmation.setComponentOrientation(Dictionary.getOrientation());
        this.close_button = new GLIButton(Dictionary.get("General.Close"), Dictionary.get("General.Close_Tooltip"));
        this.close_button.setEnabled(true);
        this.confirmation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteMetadataSetPrompt.this.delete_button.setEnabled(DeleteMetadataSetPrompt.this.confirmation.isSelected());
            }
        });
        this.delete_button.addActionListener(new DeleteButtonListener());
        this.close_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteMetadataSetPrompt.this.self.dispose();
            }
        });
        jPanel4.setLayout(new GridLayout(1, 2));
        jPanel4.add(this.delete_button);
        jPanel4.add(this.close_button);
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.confirmation, "North");
        jPanel5.add((Component)jPanel4, "Center");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel5, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - DeleteMetadataSetPrompt.SIZE.width) / 2, (dimension.height - DeleteMetadataSetPrompt.SIZE.height) / 2);
        this.setVisible(false);
    }

    public void display() {
        this.available_metadata_sets = this.meta_manager.getAvailableMetadataSets();
        for (int i = 0; i < this.available_metadata_sets.size(); ++i) {
            this.list_model.addElement(this.available_metadata_sets.get(i));
        }
        this.delete_button.setEnabled(false);
        this.confirmation.setEnabled(false);
        this.confirmation.setSelected(false);
        this.setVisible(true);
    }

    public void addMetadataSetListener(MetadataSetListener metadataSetListener) {
        this.listeners.add(metadataSetListener);
    }

    private class MetadataSetListSelectionListener
    implements ListSelectionListener {
        private MetadataSetListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            DeleteMetadataSetPrompt.this.delete_button.setEnabled(false);
            Object e = DeleteMetadataSetPrompt.this.available_set_list.getSelectedValue();
            if (e != null && e instanceof MetadataSetInfo) {
                MetadataSetInfo metadataSetInfo = (MetadataSetInfo)e;
                DeleteMetadataSetPrompt.this.description_textarea.setText(metadataSetInfo.getMetadataSetDescription());
                DeleteMetadataSetPrompt.this.confirmation.setEnabled(true);
                DeleteMetadataSetPrompt.this.confirmation.setSelected(false);
            } else {
                DeleteMetadataSetPrompt.this.confirmation.setEnabled(false);
                DeleteMetadataSetPrompt.this.description_textarea.setText(Dictionary.get("GEMS.DeleteMetadataSetPrompt.No_Set"));
            }
        }
    }

    private class MetadatSetListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MetadatSetListCellRenderer() {
            this.setOpaque(true);
            this.setComponentOrientation(Dictionary.getOrientation());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "unknown";
            if (object instanceof MetadataSetInfo) {
                MetadataSetInfo metadataSetInfo = (MetadataSetInfo)object;
                string = metadataSetInfo.getMetadataSetName();
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private class DeleteButtonListener
    implements ActionListener {
        private DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object e = DeleteMetadataSetPrompt.this.available_set_list.getSelectedValue();
            if (e != null && e instanceof MetadataSetInfo) {
                ((MetadataSetInfo)e).deleteMetadataSet();
                DeleteMetadataSetPrompt.this.list_model.removeElement(e);
            }
            DeleteMetadataSetPrompt.this.delete_button.setEnabled(false);
            DeleteMetadataSetPrompt.this.confirmation.setEnabled(false);
            DeleteMetadataSetPrompt.this.confirmation.setSelected(false);
            DeleteMetadataSetPrompt.this.description_textarea.setText(Dictionary.get("GEMS.DeleteMetadataSetPrompt.No_Set"));
        }
    }
}

