/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gems.Attribute;
import org.greenstone.gatherer.gems.AttributeContainer;
import org.greenstone.gatherer.gems.AttributeEvent;
import org.greenstone.gatherer.gems.AttributeListener;
import org.greenstone.gatherer.gems.GEMSConstants;
import org.greenstone.gatherer.gems.MetadataElementEvent;
import org.greenstone.gatherer.gems.MetadataElementListener;
import org.greenstone.gatherer.gems.MetadataElementModel;
import org.greenstone.gatherer.gems.MetadataSetEvent;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetListener;

public class AttributeTable
extends JTable
implements MetadataElementListener,
MetadataSetListener,
ActionListener {
    JTable this_table;
    private ArrayList listeners = new ArrayList();
    private JTextField metadata_value_text_field = new JTextField();
    private boolean language_dependent;

    public AttributeTable(boolean bl) {
        this.setRowHeight(20);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.metadata_value_text_field.setComponentOrientation(Dictionary.getOrientation());
        this.language_dependent = bl;
        this.metadata_value_text_field.setBorder(null);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(this.metadata_value_text_field);
        defaultCellEditor.setClickCountToStart(1);
        this.setDefaultEditor(String.class, defaultCellEditor);
        this.this_table = this;
        this.setSelectionMode(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(GEMSConstants.ADD_ATTRIBUTE)) {
            this.addAttribute();
            return;
        }
        if (string.equals(GEMSConstants.DELETE_ATTRIBUTE)) {
            this.deleteAttribute();
        }
    }

    public void addNewLanguage(String string) {
        AttributeTableModel attributeTableModel = (AttributeTableModel)this.getModel();
        attributeTableModel.addNewLanguage(string);
    }

    @Override
    public void metadataElementChanged(MetadataElementEvent metadataElementEvent) {
        MetadataElementModel metadataElementModel = metadataElementEvent.getMetadataElementModel();
        if (metadataElementModel == null) {
            this.setModel(new DefaultTableModel());
            return;
        }
        this.populateAttributeTable(metadataElementModel);
    }

    @Override
    public void metadataSetChanged(MetadataSetEvent metadataSetEvent) {
        MetadataSetInfo metadataSetInfo = metadataSetEvent.getMetadataSetInfo();
        if (metadataSetInfo == null) {
            this.setModel(new DefaultTableModel());
            return;
        }
        this.populateAttributeTable(metadataSetInfo);
    }

    public void addAttributeListener(AttributeListener attributeListener) {
        if (!this.listeners.contains(attributeListener)) {
            this.listeners.add(attributeListener);
        }
    }

    public void removeAttributeListener(AttributeListener attributeListener) {
        this.listeners.remove(attributeListener);
    }

    private void addAttribute() {
        AttributeTableModel attributeTableModel = (AttributeTableModel)this.getModel();
        attributeTableModel.addNewRow();
    }

    private void deleteAttribute() {
        int n = this.getSelectedRow();
        AttributeTableModel attributeTableModel = (AttributeTableModel)this.getModel();
        attributeTableModel.deleteRow(n);
    }

    private void populateAttributeTable(AttributeContainer attributeContainer) {
        AttributeTableModel attributeTableModel = new AttributeTableModel(attributeContainer, this.language_dependent);
        this.setModel(attributeTableModel);
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (this.language_dependent) {
            tableColumnModel.getColumn(0).setPreferredWidth(100);
            tableColumnModel.getColumn(1).setPreferredWidth(50);
            tableColumnModel.getColumn(2).setPreferredWidth(350);
        } else {
            tableColumnModel.getColumn(0).setPreferredWidth(100);
            tableColumnModel.getColumn(1).setPreferredWidth(400);
        }
    }

    private void notifyListeners(Attribute attribute) {
        AttributeEvent attributeEvent = new AttributeEvent(attribute);
        for (int i = 0; i < this.listeners.size(); ++i) {
            AttributeListener attributeListener = (AttributeListener)this.listeners.get(i);
            attributeListener.attributeChanged(attributeEvent);
        }
    }

    protected class AttributeTableModel
    extends AbstractTableModel {
        AttributeContainer attribute_container;
        ArrayList attributes;
        boolean language_dependent;
        String[] column_names;

        public AttributeTableModel(AttributeContainer attributeContainer, boolean bl) {
            this.attribute_container = attributeContainer;
            this.language_dependent = bl;
            if (this.language_dependent) {
                this.attributes = attributeContainer.getLanguageDependentAttributes();
                this.column_names = GEMSConstants.LANG_DEPENDENT_ATTRIBUTES_COLUMN_NAMES;
            } else {
                this.attributes = attributeContainer.getAttributes();
                this.column_names = GEMSConstants.ATTRIBUTES_COLUMN_NAMES;
            }
        }

        @Override
        public int getRowCount() {
            return this.attributes.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.column_names[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.column_names.length;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            Attribute attribute = (Attribute)this.attributes.get(n);
            return n2 != 0 || !attribute.isRequired();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < this.attributes.size()) {
                Attribute attribute = (Attribute)this.attributes.get(n);
                if (n2 == 0) {
                    return attribute.getName();
                }
                if (this.language_dependent) {
                    if (n2 == 1) {
                        return attribute.getLanguage();
                    }
                    if (n2 == 2) {
                        return attribute.getValue();
                    }
                } else if (n2 == 1) {
                    return attribute.getValue();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n < this.attributes.size() && this.attributes.size() > 0) {
                Attribute attribute = (Attribute)this.attributes.get(n);
                if (attribute.isRequired() && ((String)object).trim().equals("") && !this.getValueAt(n, n2).equals("")) {
                    JOptionPane.showMessageDialog(null, Dictionary.get("GEMS.Attribute_Edition_Error_Message"), Dictionary.get("GEMS.Attribute_Edition_Error"), 0);
                    return;
                }
                if (n2 == 0) {
                    attribute.setName((String)object);
                } else if (this.language_dependent) {
                    if (n2 == 1) {
                        attribute.setLanguage((String)object);
                    } else if (n2 == 2) {
                        attribute.setValue((String)object);
                    }
                } else if (n2 == 1) {
                    attribute.setValue((String)object);
                }
                AttributeTable.this.notifyListeners(attribute);
                if (this.attribute_container instanceof MetadataElementModel) {
                    if (attribute.getName().trim().equals(GEMSConstants.NAME_ATTRIBUTE)) {
                        ((MetadataElementModel)this.attribute_container).setName((String)object);
                    }
                } else if (this.attribute_container instanceof MetadataSetInfo) {
                    ((MetadataSetInfo)this.attribute_container).infoChanged();
                }
            }
        }

        public void addNewLanguage(String string) {
            if (!this.language_dependent) {
                return;
            }
            int n = this.attribute_container.languageExists(string);
            if (n >= 0) {
                AttributeTable.this.this_table.getSelectionModel().setSelectionInterval(n, n);
                Rectangle rectangle = AttributeTable.this.this_table.getCellRect(n, 0, true);
                AttributeTable.this.this_table.scrollRectToVisible(rectangle);
            } else {
                Object object;
                int n2;
                String[] stringArray = this.attribute_container.getLanguageDependentAttributeNames();
                if (stringArray == null) {
                    JOptionPane.showMessageDialog(null, Dictionary.get("GEMS.Add_Lang_Depend_Attr_Error_Message"), Dictionary.get("GEMS.Add_Lang_Depend_Attr_Error"), 0);
                    return;
                }
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    object = new Attribute(stringArray[n2].trim(), "", true);
                    ((Attribute)object).setLanguage(string);
                    this.attributes.add(object);
                    AttributeTable.this.notifyListeners((Attribute)object);
                }
                this.fireTableDataChanged();
                n2 = this.attributes.size() - stringArray.length;
                AttributeTable.this.this_table.editCellAt(n2, 2);
                if (AttributeTable.this.this_table.isEditing()) {
                    AttributeTable.this.this_table.getEditorComponent().requestFocus();
                }
                AttributeTable.this.this_table.getSelectionModel().setSelectionInterval(this.attributes.size() - stringArray.length, this.attributes.size() - 1);
                object = AttributeTable.this.this_table.getCellRect(this.attributes.size() - 1, 0, true);
                AttributeTable.this.this_table.scrollRectToVisible((Rectangle)object);
            }
        }

        public void addNewRow() {
            Attribute attribute = new Attribute();
            this.attributes.add(attribute);
            this.fireTableDataChanged();
            AttributeTable.this.this_table.getSelectionModel().setSelectionInterval(this.attributes.size() - 1, this.attributes.size() - 1);
            Rectangle rectangle = AttributeTable.this.this_table.getCellRect(this.attributes.size() - 1, 0, true);
            AttributeTable.this.this_table.scrollRectToVisible(rectangle);
        }

        public void deleteRow(int n) {
            if (n < this.attributes.size() && n >= 0) {
                Attribute attribute = (Attribute)this.attributes.get(n);
                if (attribute.isRequired()) {
                    JOptionPane.showMessageDialog(null, Dictionary.get("GEMS.Attribute_Deletion_Error_Message"), Dictionary.get("GEMS.Attribute_Deletion_Error"), 0);
                    return;
                }
                AttributeTable.this.notifyListeners(attribute);
                this.attributes.remove(n);
                this.fireTableDataChanged();
            }
        }
    }
}

