/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.collection.CollectionTree;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.collection.FullCollectionTreeNode;
import org.greenstone.gatherer.file.FileCopiedSuccessListener;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.file.FileQueue;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.file.RecycleBin;
import org.greenstone.gatherer.file.WorkspaceTreeNode;
import org.greenstone.gatherer.gui.ExplodeMetadataDatabasePrompt;
import org.greenstone.gatherer.gui.GProgressBar;
import org.greenstone.gatherer.gui.NewFolderOrFilePrompt;
import org.greenstone.gatherer.gui.RenamePrompt;
import org.greenstone.gatherer.gui.ReplaceSrcDocWithHtmlPrompt;
import org.greenstone.gatherer.gui.tree.DragTree;
import org.greenstone.gatherer.util.DragComponent;
import org.greenstone.gatherer.util.Utility;
import org.webswing.toolkit.api.WebswingUtil;

public class FileManager {
    private static FileQueue file_queue = null;
    public static final int COPY = 0;
    public static final int MOVE = 1;
    public static final int FILE_TYPE = 0;
    public static final int DUMMY_TYPE = 1;
    public static final int FOLDER_TYPE = 2;
    protected static File startup_directory = null;

    public FileManager() {
        file_queue = new FileQueue();
        file_queue.start();
    }

    public void action(DragComponent dragComponent, FileNode[] fileNodeArray, DragComponent dragComponent2, FileNode fileNode) {
        if (fileNodeArray == null || fileNodeArray.length == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (dragComponent == dragComponent2) {
            new FileTask(l, dragComponent, fileNodeArray, dragComponent2, fileNode, 3).start();
            return;
        }
        if (!(dragComponent2 instanceof RecycleBin)) {
            new FileTask(l, dragComponent, fileNodeArray, dragComponent2, fileNode, 1).start();
            return;
        }
        boolean bl = false;
        if (dragComponent.toString().equals("Workspace")) {
            bl = true;
            String string = Gatherer.getGLIUserCacheDirectoryPath();
            for (int i = 0; i < fileNodeArray.length; ++i) {
                if (!fileNodeArray[i].getFile().getAbsolutePath().startsWith(string)) {
                    bl = true;
                    break;
                }
                bl = false;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("FileActions.Read_Only"), Dictionary.get("General.Error"), 0);
            return;
        }
        new FileTask(l, dragComponent, fileNodeArray, dragComponent2, fileNode, 2).start();
    }

    public void action(File file, File file2, int n) {
        new SimpleFileTask(file, file2, n).start();
    }

    public FileQueue getQueue() {
        return file_queue;
    }

    public void explodeMetadataDatabase(File file) {
        Gatherer.invokeInEDT_replacesThreadStart("FileManager.explodeMetadataDatabase Task", false, new ExplodeMetadataDatabasePromptTask(file));
    }

    public void replaceSrcDocWithHtml(File[] fileArray) {
        Gatherer.invokeInEDT_replacesThreadStart("FileManager.replaceSrcDocWithHTML task", false, new ReplaceSrcDocWithHtmlPromptTask(fileArray));
    }

    public void openFileInExternalApplication(File file) {
        new OpenFileInExternalApplicationTask(file).start();
    }

    public void newDummyDoc(DragTree dragTree, FileNode fileNode) {
        this.newFolderOrDummyDoc(dragTree, fileNode, 1);
    }

    public void newEmptyFile(DragTree dragTree, FileNode fileNode) {
        this.newFolderOrDummyDoc(dragTree, fileNode, 0);
    }

    public void newFolder(DragTree dragTree, FileNode fileNode) {
        this.newFolderOrDummyDoc(dragTree, fileNode, 2);
    }

    protected void newFolderOrDummyDoc(DragTree dragTree, FileNode fileNode, int n) {
        new NewFolderOrDummyDocumentTask(dragTree, fileNode, n).start();
    }

    public void renameCollectionFile(DragTree dragTree, FileNode fileNode) {
        new RenameTask(dragTree, fileNode).start();
    }

    public void newCollectionFile(DragTree dragTree, FileNode fileNode) {
        new ReplaceOrNewTask(dragTree, fileNode, false).start();
    }

    public void replaceCollectionFile(DragTree dragTree, FileNode fileNode) {
        new ReplaceOrNewTask(dragTree, fileNode, true).start();
    }

    private class ReplaceOrNewTask
    extends Thread
    implements FileCopiedSuccessListener {
        private DragTree collection_tree = null;
        private FileNode collection_tree_node = null;
        private boolean replacing = false;

        public ReplaceOrNewTask(DragTree dragTree, FileNode fileNode, boolean bl) {
            this.collection_tree = dragTree;
            this.collection_tree_node = fileNode;
            this.replacing = bl;
        }

        @Override
        public void run() {
            FileNode fileNode;
            File file;
            JFileChooser jFileChooser = new JFileChooser(startup_directory);
            if (this.replacing) {
                jFileChooser.setDialogTitle(Dictionary.get("ReplacePrompt.Title"));
            } else {
                jFileChooser.setDialogTitle(Dictionary.get("NewPrompt.Title"));
            }
            File file2 = null;
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                file2 = jFileChooser.getSelectedFile();
            }
            if (file2 == null) {
                return;
            }
            startup_directory = file2.getParentFile();
            WorkspaceTreeNode workspaceTreeNode = new WorkspaceTreeNode(file2);
            boolean bl = false;
            if (this.replacing && this.collection_tree_node.getFile().getName().equals(file2.getName())) {
                DebugStream.println(" @@@ File Replace: New file has the same name as existing.");
                bl = true;
            }
            if (this.replacing) {
                file = this.collection_tree_node.getFile().getParentFile();
                fileNode = (FileNode)this.collection_tree_node.getParent();
            } else {
                file = this.collection_tree_node.getFile();
                fileNode = this.collection_tree_node;
            }
            FullCollectionTreeNode fullCollectionTreeNode = this.collection_tree instanceof CollectionTree ? new CollectionTreeNode(new File(file, file2.getName())) : new FullCollectionTreeNode(new File(file, file2.getName()));
            if (bl) {
                file_queue.addFileCopiedSuccessListener(this);
                file_queue.addJob(System.currentTimeMillis(), Gatherer.g_man.gather_pane.workspace_tree, new FileNode[]{workspaceTreeNode}, this.collection_tree, fileNode, (byte)1);
            } else {
                file_queue.addFileCopiedSuccessListener(this);
                file_queue.addJob(System.currentTimeMillis(), Gatherer.g_man.gather_pane.workspace_tree, new FileNode[]{workspaceTreeNode}, this.collection_tree, fileNode, (byte)8);
                if (this.replacing) {
                    file_queue.addJob(System.currentTimeMillis(), this.collection_tree, new FileNode[]{this.collection_tree_node}, this.collection_tree, fullCollectionTreeNode, (byte)7);
                }
            }
        }

        @Override
        public void fileCopiedSuccessfully(File file) {
            if (Gatherer.isGsdlRemote) {
                File file2 = this.replacing ? this.collection_tree_node.getFile().getParentFile() : this.collection_tree_node.getFile();
                File file3 = this.collection_tree_node.getFile();
                String string = CollectionManager.getLoadedCollectionName();
                if (this.replacing) {
                    Gatherer.remoteGreenstoneServer.deleteCollectionFile(string, file3);
                }
                Gatherer.remoteGreenstoneServer.uploadFilesIntoCollection(string, new File[]{file}, file2);
            }
            file_queue.removeFileCopiedSuccessListener(this);
        }
    }

    private class RenameTask
    extends Thread {
        private DragTree collection_tree = null;
        private FileNode collection_tree_node = null;
        RenamePrompt rename_prompt = null;

        public RenameTask(DragTree dragTree, FileNode fileNode) {
            this.collection_tree = dragTree;
            this.collection_tree_node = fileNode;
        }

        @Override
        public void run() {
            Gatherer.invokeInEDT_replacesProceedInCurrThread("FileManager - RenameTask.run()", true, new Runnable(){

                @Override
                public void run() {
                    RenameTask.this.rename_prompt = new RenamePrompt(RenameTask.this.collection_tree_node);
                    RenameTask.this.rename_prompt.display();
                }
            });
            String string = this.rename_prompt.getNewName();
            this.rename_prompt.dispose();
            this.rename_prompt = null;
            if (string != null) {
                File file = this.collection_tree_node.getFile();
                File file2 = new File(file.getParentFile(), string);
                FullCollectionTreeNode fullCollectionTreeNode = this.collection_tree instanceof CollectionTree ? new CollectionTreeNode(file2) : new FullCollectionTreeNode(file2);
                file_queue.addJob(System.currentTimeMillis(), this.collection_tree, new FileNode[]{this.collection_tree_node}, this.collection_tree, fullCollectionTreeNode, (byte)6);
                if (Gatherer.isGsdlRemote) {
                    Gatherer.remoteGreenstoneServer.moveCollectionFile(CollectionManager.getLoadedCollectionName(), file, file2);
                }
            }
        }
    }

    private class NewFolderOrDummyDocumentTask
    extends Thread {
        private DragTree tree = null;
        private FileNode parent_node = null;
        private int type;
        private NewFolderOrFilePrompt new_folder_prompt = null;

        public NewFolderOrDummyDocumentTask(DragTree dragTree, FileNode fileNode, int n) {
            this.tree = dragTree;
            this.parent_node = fileNode;
            this.type = n;
        }

        @Override
        public void run() {
            String string = "";
            if (this.type == 1) {
                string = ".nul";
            }
            if (this.type == 0) {
                string = ".txt";
            }
            final String string2 = string;
            Gatherer.invokeInEDT_replacesProceedInCurrThread("FileManager - NewFolderOrDummyDocumentTask.run()", true, new Runnable(){

                @Override
                public void run() {
                    NewFolderOrDummyDocumentTask.this.new_folder_prompt = new NewFolderOrFilePrompt(NewFolderOrDummyDocumentTask.this.parent_node, NewFolderOrDummyDocumentTask.this.type, string2);
                    NewFolderOrDummyDocumentTask.this.new_folder_prompt.display();
                    NewFolderOrDummyDocumentTask.this.new_folder_prompt.dispose();
                }
            });
            String string3 = this.new_folder_prompt.getNameOfNewFolderOrFile();
            this.new_folder_prompt = null;
            if (string3 != null) {
                FileSystemModel fileSystemModel = (FileSystemModel)this.tree.getModel();
                File file = new File(this.parent_node.getFile(), string3);
                if (file.exists()) {
                    if (this.type == 0 || this.type == 1) {
                        JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("FileActions.File_Already_Exists_No_Create", string3), Dictionary.get("General.Error"), 0);
                    } else {
                        JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("FileActions.Folder_Already_Exists", string3), Dictionary.get("General.Error"), 0);
                    }
                } else {
                    try {
                        if (this.type == 0 || this.type == 1) {
                            file.createNewFile();
                            if (Gatherer.isGsdlRemote) {
                                Gatherer.remoteGreenstoneServer.uploadCollectionFile(CollectionManager.getLoadedCollectionName(), file);
                            }
                        } else {
                            file.mkdirs();
                            if (Gatherer.isGsdlRemote) {
                                Gatherer.remoteGreenstoneServer.newCollectionDirectory(CollectionManager.getLoadedCollectionName(), file);
                            }
                        }
                        this.parent_node.refresh();
                        Gatherer.g_man.refreshWorkspaceTree(2);
                    }
                    catch (Exception exception) {
                        if (this.type == 0 || this.type == 1) {
                            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("FileActions.File_Create_Error", string3), Dictionary.get("General.Error"), 0);
                        }
                        JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("FileActions.Folder_Create_Error", string3), Dictionary.get("General.Error"), 0);
                    }
                }
                file = null;
                fileSystemModel = null;
            }
            string3 = null;
        }
    }

    private class OpenFileInExternalApplicationTask
    extends Thread {
        private File file = null;

        public OpenFileInExternalApplicationTask(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            if (Gatherer.isGsdlRemote) {
                if (this.file.getAbsolutePath().startsWith(Gatherer.getCollectDirectoryPath()) && this.file.length() == 0L && Gatherer.remoteGreenstoneServer.downloadCollectionFile(CollectionManager.getLoadedCollectionName(), this.file).equals("")) {
                    return;
                }
            } else if (Gatherer.isWebswing) {
                if (Gatherer.GS3) {
                    String string;
                    String string2 = this.file.getAbsolutePath();
                    if (string2.startsWith(string = Gatherer.getCollectDirectoryPath())) {
                        String string3 = string2.substring(string.length());
                        String string4 = CollectionManager.getLoadedCollectionGroupName();
                        String string5 = Configuration.library_url.toString();
                        String string6 = Configuration.site_name;
                        String string7 = string5 + "/sites/" + string6;
                        String string8 = string7 + "/collect";
                        if (string4 != null && !string4.equals("")) {
                            string8 = string8 + "/" + string4;
                        }
                        String string9 = string8 + "/" + string3;
                        WebswingUtil.getWebswingApi().sendActionEvent("downloadURL", string9, null);
                    } else {
                        System.err.println("Warning - OpenFileInExternalApplicationTask.run() unable to construct a URL to access the following file");
                        System.err.println("    " + string2);
                        System.err.println("Did not fall within " + string);
                        JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("FileActions.Webswing_Unable_To_Open", string2), Dictionary.get("General.Error"), 0);
                    }
                } else {
                    System.err.println("Error - Greenstone2 version of GLI using WebSwing does not currently support opening files externally");
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("FileActions.Webswing_Unable_To_Open_GS2"), Dictionary.get("General.Error"), 0);
                }
                return;
            }
            Gatherer.spawnApplication(this.file);
        }
    }

    private class ReplaceSrcDocWithHtmlPromptTask
    extends Thread {
        private File[] replace_these_srcdoc_files = null;

        public ReplaceSrcDocWithHtmlPromptTask(File[] fileArray) {
            this.replace_these_srcdoc_files = fileArray;
        }

        @Override
        public void run() {
            ReplaceSrcDocWithHtmlPrompt replaceSrcDocWithHtmlPrompt = new ReplaceSrcDocWithHtmlPrompt(this.replace_these_srcdoc_files);
        }
    }

    private class ExplodeMetadataDatabasePromptTask
    extends Thread {
        private File metadata_database_file = null;

        public ExplodeMetadataDatabasePromptTask(File file) {
            this.metadata_database_file = file;
        }

        @Override
        public void run() {
            ExplodeMetadataDatabasePrompt explodeMetadataDatabasePrompt = new ExplodeMetadataDatabasePrompt(this.metadata_database_file);
        }
    }

    private class FileTask
    extends Thread {
        private long id;
        private DragComponent source;
        private FileNode[] source_nodes;
        private DragComponent target;
        private FileNode target_node;
        private byte type;

        public FileTask(long l, DragComponent dragComponent, FileNode[] fileNodeArray, DragComponent dragComponent2, FileNode fileNode, byte by) {
            this.id = l;
            this.source = dragComponent;
            this.source_nodes = fileNodeArray;
            this.target = dragComponent2;
            this.target_node = fileNode;
            this.type = by;
        }

        @Override
        public void run() {
            GProgressBar gProgressBar = file_queue.getProgressBar();
            gProgressBar.reset();
            gProgressBar.setIndeterminate(true);
            boolean bl = file_queue.calculateSize(this.source_nodes);
            if (!bl) {
                file_queue.addJob(this.id, this.source, this.source_nodes, this.target, this.target_node, this.type);
                if (Gatherer.isGsdlRemote) {
                    String string = CollectionManager.getLoadedCollectionName();
                    if (this.type == 1) {
                        File[] fileArray = new File[this.source_nodes.length];
                        for (int i = 0; i < this.source_nodes.length; ++i) {
                            fileArray[i] = this.source_nodes[i].getFile();
                        }
                        Gatherer.remoteGreenstoneServer.uploadFilesIntoCollection(string, fileArray, this.target_node.getFile());
                    } else if (this.type == 2) {
                        for (int i = 0; i < this.source_nodes.length; ++i) {
                            Gatherer.remoteGreenstoneServer.deleteCollectionFile(string, this.source_nodes[i].getFile());
                        }
                    } else if (this.type == 3) {
                        for (int i = 0; i < this.source_nodes.length; ++i) {
                            Gatherer.remoteGreenstoneServer.moveCollectionFile(string, this.source_nodes[i].getFile(), this.target_node.getFile());
                        }
                    }
                }
            }
            gProgressBar.setIndeterminate(false);
            gProgressBar.clear();
        }
    }

    private class SimpleFileTask
    extends Thread {
        private File sourceFolder;
        private File targetFolder;
        int operation;

        public SimpleFileTask(File file, File file2, int n) {
            this.sourceFolder = file;
            this.targetFolder = file2;
            this.operation = n;
        }

        @Override
        public void run() {
            String string = Gatherer.getCollectDirectoryPath() + CollectionManager.getLoadedCollectionName();
            if (string.equals(this.sourceFolder.getAbsolutePath()) || string.equals(this.targetFolder.getAbsolutePath())) {
                Gatherer.g_man.saveThenCloseCurrentCollection();
            }
            if (this.operation == 1 && this.sourceFolder.renameTo(this.targetFolder)) {
                Gatherer.g_man.refreshWorkspaceTreeGreenstoneCollections();
                return;
            }
            GProgressBar gProgressBar = file_queue.getProgressBar();
            gProgressBar.reset();
            gProgressBar.setIndeterminate(true);
            String string2 = "FileActions.Moving";
            if (this.operation == 0) {
                string2 = "FileActions.Copying";
            }
            gProgressBar.setString(Dictionary.get(string2));
            file_queue.getFileStatus().setText(Dictionary.get(string2, file_queue.formatPath(string2, this.sourceFolder.getAbsolutePath(), file_queue.getFileStatus().getSize().width)));
            try {
                file_queue.copyDirectoryContents(this.sourceFolder, this.targetFolder);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(Gatherer.g_man, exception.getMessage(), "Can't perform file operation", 0);
                gProgressBar.setIndeterminate(false);
                gProgressBar.clear();
                return;
            }
            if (this.operation == 1) {
                Utility.delete(this.sourceFolder);
                Gatherer.g_man.refreshWorkspaceTreeGreenstoneCollections();
            }
            gProgressBar.setIndeterminate(false);
            gProgressBar.clear();
            file_queue.getFileStatus().setText(Dictionary.get("FileActions.No_Activity"));
            gProgressBar.setString(Dictionary.get("FileActions.No_Activity"));
        }
    }
}

