/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import javax.swing.tree.TreePath;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.util.DragComponent;

public class FileJob {
    public boolean done = false;
    public byte type = 0;
    public DragComponent source = null;
    public DragComponent target = null;
    private long id = 0L;
    private TreePath destination_path = null;
    private TreePath origin_path = null;
    public static final byte COPY = 1;
    public static final byte DELETE = 2;
    public static final byte MOVE = 3;
    public static final byte NEW_FOLDER = 4;
    public static final byte DELETE_EMPTY_DIRECTORY = 5;
    public static final byte RENAME = 6;
    public static final byte REPLACE = 7;
    public static final byte COPY_FILE_ONLY = 8;

    public FileJob(long l, DragComponent dragComponent, FileNode fileNode, DragComponent dragComponent2, FileNode fileNode2, byte by) {
        this.id = l;
        this.source = dragComponent;
        this.target = dragComponent2;
        this.type = by;
        if (fileNode2 != null) {
            this.destination_path = new TreePath(fileNode2.getPath());
        }
        if (fileNode != null) {
            this.origin_path = new TreePath(fileNode.getPath());
        }
    }

    public FileNode getDestination() {
        FileNode fileNode = null;
        if (this.destination_path != null) {
            if (this.target != null) {
                FileSystemModel fileSystemModel = this.target.getTreeModel();
                fileNode = fileSystemModel.getNode(this.destination_path);
            } else {
                fileNode = (FileNode)this.destination_path.getLastPathComponent();
            }
        }
        return fileNode;
    }

    public FileNode getOrigin() {
        FileNode fileNode = null;
        if (this.origin_path != null) {
            if (this.source != null) {
                FileSystemModel fileSystemModel = this.source.getTreeModel();
                fileNode = fileSystemModel.getNode(this.origin_path);
            } else {
                fileNode = (FileNode)this.origin_path.getLastPathComponent();
            }
        }
        return fileNode;
    }

    public long ID() {
        return this.id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        switch (this.type) {
            case 1: {
                stringBuffer.append("copy ");
                break;
            }
            case 2: {
                stringBuffer.append("delete ");
                break;
            }
            case 3: {
                stringBuffer.append("move ");
                break;
            }
            case 5: {
                stringBuffer.append("empty directory delete ");
                break;
            }
            default: {
                stringBuffer.append("unknown ");
            }
        }
        FileNode fileNode = this.getOrigin();
        if (fileNode != null) {
            stringBuffer.append(fileNode.getFile().getAbsolutePath());
        } else {
            stringBuffer.append("ERROR!");
        }
        if (this.type != 2 && this.type != 5) {
            stringBuffer.append(" -> ");
            FileNode fileNode2 = this.getDestination();
            if (fileNode2 != null) {
                stringBuffer.append(fileNode2.getFile().getAbsolutePath());
            } else {
                stringBuffer.append("Recycle Bin");
            }
        }
        return stringBuffer.toString();
    }
}

