/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.feedback;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class Movie
extends JDialog
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    private static ResourceBundle messages;
    private JLabel picture;
    private JFormattedTextField textField;
    private JSlider framesPerSecond;
    private int FPS_MIN = 0;
    private int FPS_MAX;
    private int FPS_INIT = 1;
    private int frameNumber;
    private int NUM_FRAMES;
    private ArrayList images;
    private int delay;
    private Timer timer;
    private boolean frozen = false;

    public Movie(ResourceBundle resourceBundle, ArrayList arrayList) {
        this.images = arrayList;
        this.NUM_FRAMES = arrayList.size();
        this.FPS_MAX = arrayList.size() * 2;
        messages = resourceBundle;
        this.setTitle(messages.getString("GenerateMovie"));
        this.setModal(true);
        this.setBackground(new Color(176, 208, 176));
    }

    public JPanel create_UI() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground(new Color(176, 208, 176));
        JButton jButton = new JButton(messages.getString("Close"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Movie.this.dispose();
                if (Movie.this.timer != null) {
                    Movie.this.timer.stop();
                }
            }
        });
        jButton.setDefaultCapable(true);
        jButton.setActionCommand(messages.getString("Close"));
        jButton.setBackground(new Color(176, 208, 176));
        if (this.images.size() <= 0) {
            JLabel jLabel = new JLabel("No Image to be displayed   ");
            jPanel.add(jLabel);
            jPanel.add(jButton);
            return jPanel;
        }
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.delay = 1000 / this.FPS_INIT;
        JLabel jLabel = new JLabel(messages.getString("FramesPerSecond") + ": ", 0);
        jLabel.setBackground(new Color(176, 208, 176));
        jLabel.setAlignmentX(0.5f);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(Integer.valueOf(this.FPS_MIN));
        numberFormatter.setMaximum(Integer.valueOf(this.FPS_MAX));
        this.textField = new JFormattedTextField(numberFormatter);
        this.textField.setBackground(new Color(224, 240, 224));
        this.textField.setValue(this.FPS_INIT);
        this.textField.setColumns(5);
        this.textField.addPropertyChangeListener(this);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.textField.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Movie.this.textField.isEditValid()) {
                    Toolkit.getDefaultToolkit().beep();
                    Movie.this.textField.selectAll();
                } else {
                    try {
                        Movie.this.textField.commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        this.framesPerSecond = new JSlider(0, this.FPS_MIN, this.FPS_MAX, this.FPS_INIT);
        this.framesPerSecond.addChangeListener(this);
        this.framesPerSecond.setBackground(new Color(176, 208, 176));
        this.framesPerSecond.setMajorTickSpacing(10);
        this.framesPerSecond.setMinorTickSpacing(1);
        this.framesPerSecond.setPaintTicks(true);
        this.framesPerSecond.setPaintLabels(true);
        this.framesPerSecond.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.picture = new JLabel();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width - 30;
        int n2 = (int)((double)dimension.height * 0.75);
        this.picture.setPreferredSize(new Dimension(n, n2));
        this.picture.setHorizontalAlignment(0);
        this.picture.setAlignmentX(0.5f);
        this.picture.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.picture.setBackground(new Color(176, 208, 176));
        this.updatePicture(0);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel);
        jPanel2.add(this.textField);
        jPanel2.add(jButton);
        jPanel2.setBackground(new Color(176, 208, 176));
        jPanel.add(this.picture);
        jPanel.add(this.framesPerSecond);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.timer = new Timer(this.delay, this);
        this.timer.setInitialDelay(this.delay * 7);
        this.timer.setCoalesce(true);
        this.timer.start();
        return jPanel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        if (!jSlider.getValueIsAdjusting()) {
            this.textField.setValue(n);
            if (n == 0) {
                if (!this.frozen) {
                    this.stopAnimation();
                }
            } else {
                this.delay = 1000 / n;
                this.timer.setDelay(this.delay);
                this.timer.setInitialDelay(this.delay * 10);
                if (this.frozen) {
                    this.startAnimation();
                }
            }
        } else {
            this.textField.setText(String.valueOf(n));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            Number number = (Number)propertyChangeEvent.getNewValue();
            if (this.framesPerSecond != null && number != null) {
                this.framesPerSecond.setValue(number.intValue());
            }
        }
    }

    public void startAnimation() {
        this.timer.start();
        this.frozen = false;
    }

    public void stopAnimation() {
        this.timer.stop();
        this.frozen = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.frameNumber = this.frameNumber == this.NUM_FRAMES - 1 ? 0 : ++this.frameNumber;
        this.updatePicture(this.frameNumber);
        if (this.frameNumber == this.NUM_FRAMES - 1 || this.frameNumber == this.NUM_FRAMES / 2 - 1) {
            this.timer.restart();
        }
    }

    protected void updatePicture(int n) {
        if (this.images.get(this.frameNumber) != null) {
            this.picture.setIcon((ImageIcon)this.images.get(this.frameNumber));
        } else {
            this.picture.setText(messages.getString("image") + " #" + this.frameNumber + " " + messages.getString("notfound"));
        }
    }
}

