/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.feedback;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.greenstone.gatherer.feedback.CompGroup;
import org.greenstone.gatherer.feedback.SaveToXML;
import org.greenstone.gatherer.feedback.UserComponent;

public class History
implements Serializable {
    private String date;
    private String command;
    private String title;
    private ArrayList component;
    private String image = null;
    private String imageName = "";
    private String height;
    private String width;

    public History(Date date, String string) {
        this.date = date.toString();
        this.command = string;
        this.component = new ArrayList();
    }

    public void setImage(String string, String string2, String string3) {
        this.image = string;
        this.height = string2;
        this.width = string3;
        StringTokenizer stringTokenizer = new StringTokenizer(this.date, ": ");
        while (stringTokenizer.hasMoreTokens()) {
            this.imageName = this.imageName + stringTokenizer.nextToken();
        }
        this.imageName = this.imageName + ".jpg";
    }

    public void addComponent(UserComponent userComponent, String string) {
        this.component.add(new CompGroup(userComponent, string));
    }

    public String getHeight() {
        return this.height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDate() {
        return this.date;
    }

    public String getCommand() {
        return this.command;
    }

    public ArrayList getArray() {
        return this.component;
    }

    public String getImage() {
        return this.image;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void sendXMLComm(SaveToXML saveToXML) {
        saveToXML.startContent(10);
        saveToXML.startContent(7);
        saveToXML.saveContent(this.date);
        saveToXML.closeContent(7);
        saveToXML.startContent(2);
        saveToXML.saveContent(this.title);
        saveToXML.closeContent(2);
        saveToXML.startContent(8);
        saveToXML.saveContent(this.command);
        saveToXML.closeContent(8);
        if (this.image != null) {
            saveToXML.startContent(6);
            saveToXML.saveImage(this.image, this.imageName, this.width, this.height);
            saveToXML.closeContent(6);
        }
        saveToXML.closeContent(10);
    }

    public void sendXML(SaveToXML saveToXML) {
        saveToXML.startContent(10);
        saveToXML.startContent(7);
        saveToXML.saveContent(this.date);
        saveToXML.closeContent(7);
        saveToXML.startContent(2);
        saveToXML.saveContent(this.title);
        saveToXML.closeContent(2);
        saveToXML.startContent(8);
        saveToXML.saveContent(this.command);
        saveToXML.closeContent(8);
        if (this.image != null) {
            saveToXML.startContent(6);
            saveToXML.saveImage(this.image, this.imageName, this.width, this.height);
            saveToXML.closeContent(6);
        }
        for (int i = 0; i < this.component.size(); ++i) {
            saveToXML.startContent(9);
            CompGroup compGroup = (CompGroup)this.component.get(i);
            saveToXML.startContent(8);
            saveToXML.saveContent(compGroup.getStatus());
            saveToXML.closeContent(8);
            saveToXML.startContent(0);
            compGroup.getComponent().sendingXML(saveToXML);
            saveToXML.closeContent(0);
            saveToXML.closeContent(9);
        }
        saveToXML.closeContent(10);
    }
}

