/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.feedback;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.greenstone.gatherer.feedback.CompListener;
import org.greenstone.gatherer.feedback.ComponentInformation;
import org.greenstone.gatherer.feedback.FeedbackInterface;
import org.greenstone.gatherer.feedback.History;
import org.greenstone.gatherer.feedback.Movie;
import org.greenstone.gatherer.feedback.ReportDetails;
import org.greenstone.gatherer.feedback.ScreenShot;
import org.greenstone.gatherer.feedback.ZipFile;
import org.greenstone.gatherer.util.JarTools;

public class ActionRecorderDialog
implements ActionListener,
TreeModelListener,
ItemListener,
ListDataListener,
ChangeListener,
ListSelectionListener,
MenuListener,
TableColumnModelListener,
TreeSelectionListener {
    private String myframe;
    private String feedbackframe;
    private ComponentInformation compInfo;
    private History log;
    private Window point;
    private static Vector vector;
    private static boolean savefinish;
    private Thread writeThread;
    private Thread saveThread;
    private Runtime run;
    private static ResourceBundle messages;
    private ScreenShot sh;
    private HashMap modelHash;
    private boolean start_rec = false;
    private boolean rec = false;
    private boolean stop_rec = true;
    private Thread saveallThread;
    private boolean start_fd = false;
    private MouseListener mouse_blocker_listener = new MouseAdapter(){};
    private FeedbackInterface frame;
    private CompListener compList;
    private KeyStroke shKey;
    private KeyStroke fdKey;
    private KeyStroke histKey;
    private KeyStroke sndfdKey;
    private Window activeWindow;
    private Window modalWindow;

    public ActionRecorderDialog(Locale locale) {
        messages = ResourceBundle.getBundle("feedback", locale);
        this.setup_UIManager();
        this.fdKey = KeyStroke.getKeyStroke("F2");
        this.histKey = KeyStroke.getKeyStroke("F3");
        this.shKey = KeyStroke.getKeyStroke("F5");
        this.sndfdKey = KeyStroke.getKeyStroke("F12");
        final ZipFile zipFile = new ZipFile();
        zipFile.unZipFile();
        vector = this.getPrev_log("history.log");
        this.sh = new ScreenShot();
        this.modelHash = new HashMap();
        this.compInfo = new ComponentInformation(this, locale, this.modelHash);
        this.compList = new CompListener(this, this.modelHash);
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        eventQueue.push(new MyEventQueue());
        this.run = Runtime.getRuntime();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    File file;
                    if (ActionRecorderDialog.this.stop_rec) {
                        file = new File("history.log");
                        FileOutputStream fileOutputStream = new FileOutputStream("history.log");
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                        objectOutputStream.writeObject(vector);
                        vector.removeAllElements();
                        ActionRecorderDialog.vector = ActionRecorderDialog.this.getPrev_log("temp_history.log");
                        objectOutputStream.writeObject(vector);
                        objectOutputStream.close();
                        file = new File("temp_history.log");
                        file.delete();
                    }
                    file = new File("feedbackhist.log");
                    file.delete();
                    file = new File("temp_feedbackhist.log");
                    file.delete();
                    zipFile.sendZipFile();
                    ActionRecorderDialog.this.writeThread = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.writeThread = new Thread(runnable);
        this.run.addShutdownHook(this.writeThread);
    }

    public void setLocale(Locale locale) {
        messages = ResourceBundle.getBundle("feedback", locale);
    }

    public void setup_UIManager() {
    }

    private void saving(final Component component, final String string) {
        if (string.equals(messages.getString("SendFeedback")) || string.equals("FastSend") && !this.stop_rec) {
            this.start_fd = true;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Date date = new Date();
                            ActionRecorderDialog.this.log = new History(date, string);
                            if (ActionRecorderDialog.this.start_fd && string.equals(messages.getString("WindowOpened"))) {
                                ActionRecorderDialog.this.start_rec = true;
                                ActionRecorderDialog.this.rec = true;
                                ActionRecorderDialog.this.start_fd = false;
                            }
                            ActionRecorderDialog.this.getFrame(component, string);
                            ActionRecorderDialog.this.saveState(string);
                            ActionRecorderDialog.this.saveLog();
                            if (ActionRecorderDialog.this.point != null && ActionRecorderDialog.this.rec && string.equals(messages.getString("WindowClosed")) && ActionRecorderDialog.this.point instanceof JDialog && ((JDialog)ActionRecorderDialog.this.point).isModal() && ActionRecorderDialog.this.point == ActionRecorderDialog.this.modalWindow) {
                                ActionRecorderDialog.this.frame.setComment(false);
                            }
                        }
                    };
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.saveallThread = new Thread(runnable);
        this.saveallThread.start();
    }

    public void saveImage(final History history) {
        Runnable runnable = new Runnable(){
            History hist;
            {
                this.hist = history;
            }

            @Override
            public void run() {
                String string;
                String string2;
                Rectangle rectangle;
                if (ActionRecorderDialog.this.point != null) {
                    int n = ActionRecorderDialog.this.sh.getWidth();
                    int n2 = ActionRecorderDialog.this.sh.getHeight();
                    int n3 = ActionRecorderDialog.this.point.getWidth();
                    int n4 = ActionRecorderDialog.this.point.getHeight();
                    try {
                        rectangle = new Rectangle(ActionRecorderDialog.this.point.getLocationOnScreen(), new Dimension(n3, n4));
                        if (n3 >= n) {
                            n3 = n - 50;
                        }
                        string2 = "" + n3;
                        if (n4 >= n2) {
                            n4 = n2 - 50;
                        }
                        string = "" + n4;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        rectangle = null;
                        string2 = null;
                        string = null;
                    }
                } else {
                    rectangle = null;
                    string2 = null;
                    string = null;
                }
                if (rectangle != null) {
                    String string3 = ActionRecorderDialog.this.sh.getImage(rectangle);
                    if (savefinish) {
                        this.hist.setImage(string3, string, string2);
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void setSavefinish(boolean bl) {
        savefinish = bl;
    }

    public JMenu makeMenu() {
        ImageIcon imageIcon = JarTools.getImage("fastsend.gif");
        JMenuItem jMenuItem = new JMenuItem(messages.getString("SendFeedback"), new ImageIcon(imageIcon.getImage().getScaledInstance(20, 20, 4)));
        jMenuItem.setActionCommand("FastSend");
        jMenuItem.addActionListener(this);
        jMenuItem.setMnemonic(78);
        jMenuItem.setAccelerator(this.sndfdKey);
        jMenuItem.setToolTipText("Send feedback now");
        JMenuItem jMenuItem2 = null;
        if (!this.rec) {
            ImageIcon imageIcon2 = JarTools.getImage("feedback.gif");
            jMenuItem2 = new JMenuItem("Report Feedback", new ImageIcon(imageIcon2.getImage().getScaledInstance(20, 20, 4)));
            jMenuItem2.setActionCommand(messages.getString("SendFeedback"));
            jMenuItem2.addActionListener(this);
            jMenuItem2.setMnemonic(70);
            jMenuItem2.setAccelerator(this.fdKey);
            jMenuItem2.setToolTipText("Report feedback");
        } else {
            ImageIcon imageIcon3 = JarTools.getImage("camera.gif");
            jMenuItem2 = new JMenuItem(messages.getString("ScreenShot"), new ImageIcon(imageIcon3.getImage().getScaledInstance(20, 20, 4)));
            jMenuItem2.setActionCommand("ScreenShot");
            jMenuItem2.setMnemonic(83);
            jMenuItem2.addActionListener(this);
            jMenuItem2.setAccelerator(this.shKey);
            jMenuItem2.setToolTipText("Take screenshot of the whole screen.");
        }
        ImageIcon imageIcon4 = JarTools.getImage("history.gif");
        JMenuItem jMenuItem3 = new JMenuItem(messages.getString("LookHistory"), new ImageIcon(imageIcon4.getImage().getScaledInstance(20, 20, 4)));
        jMenuItem3.setActionCommand(messages.getString("LookHistory"));
        jMenuItem3.addActionListener(this);
        jMenuItem3.setMnemonic(72);
        jMenuItem3.setAccelerator(this.histKey);
        jMenuItem3.setToolTipText(messages.getString("LookHistoryButton"));
        JMenu jMenu = new JMenu(messages.getString("Feedback"));
        jMenu.setMnemonic(68);
        if (jMenuItem2 != null) {
            jMenu.add(jMenuItem2);
        }
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem3);
        if (this.rec) {
            jMenu.setBackground(new Color(176, 209, 217));
        } else {
            jMenu.setBackground(new Color(204, 204, 204));
        }
        return jMenu;
    }

    public void refreshLocationAndSize(Window window) {
        window.setLocation(window.getX(), window.getY());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        if (window.getSize().width > n2 && window.getSize().height > n) {
            window.setSize(window.getPreferredSize());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setUI(Window window) {
        if (this.start_rec) {
            if (window instanceof JFrame) {
                JFrame jFrame = (JFrame)window;
                JMenuBar jMenuBar = jFrame.getJMenuBar();
                if (jMenuBar != null) {
                    JMenu jMenu = jMenuBar.getMenu(jMenuBar.getMenuCount() - 1);
                    jMenu.setBackground(new Color(176, 209, 217));
                    jMenu.remove(0);
                    ImageIcon imageIcon = JarTools.getImage("camera.gif");
                    JMenuItem jMenuItem = new JMenuItem(messages.getString("ScreenShot"), new ImageIcon(imageIcon.getImage().getScaledInstance(20, 20, 4)));
                    jMenuItem.setActionCommand("ScreenShot");
                    jMenuItem.setMnemonic(83);
                    jMenuItem.addActionListener(this);
                    jMenuItem.setAccelerator(this.shKey);
                    jMenuItem.setToolTipText("Take screenshot of this window");
                    jMenu.insert(jMenuItem, 0);
                }
                this.refreshLocationAndSize(jFrame);
                jFrame.validate();
                jFrame.repaint();
                return;
            } else if (window instanceof JDialog) {
                JDialog jDialog = (JDialog)window;
                JMenuBar jMenuBar = jDialog.getJMenuBar();
                if (jMenuBar != null) {
                    JMenu jMenu = jMenuBar.getMenu(jMenuBar.getMenuCount() - 1);
                    jMenu.setBackground(new Color(176, 209, 217));
                    jMenu.remove(0);
                    ImageIcon imageIcon = JarTools.getImage("camera.gif");
                    JMenuItem jMenuItem = new JMenuItem(messages.getString("ScreenShot"), new ImageIcon(imageIcon.getImage().getScaledInstance(20, 20, 4)));
                    jMenuItem.setActionCommand("ScreenShot");
                    jMenuItem.setMnemonic(83);
                    jMenuItem.addActionListener(this);
                    jMenuItem.setAccelerator(this.shKey);
                    jMenuItem.setToolTipText("Take screenshot of this window");
                    jMenu.insert(jMenuItem, 0);
                }
                this.refreshLocationAndSize(jDialog);
                jDialog.validate();
                jDialog.repaint();
                return;
            } else {
                if (!(window instanceof JWindow)) return;
                JWindow jWindow = (JWindow)window;
                ((JComponent)jWindow.getContentPane()).unregisterKeyboardAction(this.fdKey);
                ((JComponent)jWindow.getContentPane()).registerKeyboardAction(this, "ScreenShot", this.shKey, 2);
            }
            return;
        } else {
            if (!this.stop_rec || !this.rec) return;
            if (window instanceof JFrame) {
                JFrame jFrame = (JFrame)window;
                JMenuBar jMenuBar = jFrame.getJMenuBar();
                if (jMenuBar != null) {
                    JMenu jMenu = jMenuBar.getMenu(jMenuBar.getMenuCount() - 1);
                    jMenu.setBackground(new Color(204, 204, 204));
                    jMenu.remove(0);
                    ImageIcon imageIcon = JarTools.getImage("feedback.gif");
                    JMenuItem jMenuItem = new JMenuItem("Report Feedback", new ImageIcon(imageIcon.getImage().getScaledInstance(20, 20, 4)));
                    jMenuItem.setActionCommand(messages.getString("SendFeedback"));
                    jMenuItem.addActionListener(this);
                    jMenuItem.setMnemonic(70);
                    jMenuItem.setAccelerator(this.fdKey);
                    jMenuItem.setToolTipText(messages.getString("SendFeedbackButton"));
                    jMenu.insert(jMenuItem, 0);
                }
                jFrame.setSize(jFrame.getPreferredSize());
                jFrame.validate();
                jFrame.repaint();
                return;
            } else if (window instanceof JDialog) {
                JDialog jDialog = (JDialog)window;
                JMenuBar jMenuBar = jDialog.getJMenuBar();
                if (jMenuBar != null) {
                    JMenu jMenu = jMenuBar.getMenu(jMenuBar.getMenuCount() - 1);
                    jMenu.setBackground(new Color(204, 204, 204));
                    jMenu.remove(0);
                    ImageIcon imageIcon = JarTools.getImage("feedback.gif");
                    JMenuItem jMenuItem = new JMenuItem("Report Feedback", new ImageIcon(imageIcon.getImage().getScaledInstance(20, 20, 4)));
                    jMenuItem.setActionCommand(messages.getString("SendFeedback"));
                    jMenuItem.addActionListener(this);
                    jMenuItem.setMnemonic(70);
                    jMenuItem.setAccelerator(this.fdKey);
                    jMenuItem.setToolTipText(messages.getString("SendFeedbackButton"));
                    jMenu.insert(jMenuItem, 0);
                }
                jDialog.setSize(jDialog.getPreferredSize());
                jDialog.validate();
                jDialog.repaint();
                return;
            } else {
                if (!(window instanceof JWindow)) return;
                JWindow jWindow = (JWindow)window;
                ((JComponent)jWindow.getContentPane()).registerKeyboardAction(this, messages.getString("SendFeedback"), this.fdKey, 2);
                ((JComponent)jWindow.getContentPane()).unregisterKeyboardAction(this.shKey);
            }
        }
    }

    public ArrayList addToArrayList(Window[] windowArray, ArrayList arrayList) {
        for (int i = 0; i < windowArray.length; ++i) {
            arrayList.add(windowArray[i]);
        }
        return arrayList;
    }

    public void saveState(String string) {
        if (this.log == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            Window[] windowArray = frameArray[i].getOwnedWindows();
            arrayList = this.addToArrayList(windowArray, arrayList);
            for (int j = 0; j < windowArray.length; ++j) {
                Container container;
                Window window = windowArray[j];
                if (window == this.point) {
                    container = window.getParent();
                    if (container == null || !(container instanceof Window) || arrayList.contains(container) || container == this.point || container instanceof ReportDetails.View || container instanceof Movie) continue;
                    this.setUI((Window)container);
                    this.compList.getInside((Window)container);
                    arrayList.add(container);
                    continue;
                }
                if (window instanceof ReportDetails.View || window instanceof Movie || window == null || window == this.point) continue;
                this.setUI(window);
                if (this.rec) {
                    this.log.addComponent(this.compInfo.getInside(window), messages.getString("CurrentlyOpenWindow"));
                } else {
                    this.compList.getInside(window);
                }
                container = window.getParent();
                if (container == null || !(container instanceof Window) || container == this.point || arrayList.contains(container) || container instanceof ReportDetails.View || container instanceof Movie) continue;
                this.setUI((Window)container);
                this.compList.getInside((Window)container);
                arrayList.add(container);
            }
        }
    }

    public void getFrame(Component component, String string) {
        boolean bl = false;
        this.point = null;
        this.myframe = null;
        if (component == null) {
            return;
        }
        Container container = component instanceof Window ? (Container)component : SwingUtilities.getWindowAncestor(component);
        if (container instanceof Window) {
            this.point = (Window)container;
            this.point.addMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(3));
            if (container instanceof ReportDetails.View || container instanceof Movie) {
                this.log = null;
                return;
            }
            if (string.equals(messages.getString("WindowClosed"))) {
                bl = true;
                if (container instanceof FeedbackInterface) {
                    this.stop_rec = true;
                }
            }
            JMenu jMenu = string.equals(messages.getString("WindowOpened")) ? this.makeMenu() : null;
            if (container instanceof JFrame) {
                JFrame jFrame = (JFrame)container;
                this.myframe = jFrame.getTitle();
                if (jMenu != null) {
                    JMenuBar jMenuBar = jFrame.getJMenuBar();
                    if (jMenuBar == null) {
                        jMenuBar = new JMenuBar();
                        jMenuBar.add(jMenu);
                        jFrame.setJMenuBar(jMenuBar);
                    } else {
                        jMenuBar.add(jMenu);
                    }
                }
                if (jMenu != null) {
                    this.refreshLocationAndSize(jFrame);
                    jFrame.validate();
                    jFrame.repaint();
                }
            } else if (container instanceof JDialog) {
                JDialog jDialog = (JDialog)container;
                this.myframe = jDialog.getTitle();
                if (jMenu != null) {
                    JMenuBar jMenuBar = jDialog.getJMenuBar();
                    if (jMenuBar == null) {
                        jMenuBar = new JMenuBar();
                        jMenuBar.add(jMenu);
                        jDialog.setJMenuBar(jMenuBar);
                    } else {
                        jMenuBar.add(jMenu);
                    }
                }
                if (jMenu != null) {
                    this.refreshLocationAndSize(jDialog);
                    jDialog.validate();
                    jDialog.repaint();
                }
            } else if (container instanceof JWindow) {
                JWindow jWindow = (JWindow)container;
                if (jMenu != null) {
                    ((JComponent)jWindow.getContentPane()).registerKeyboardAction(this, messages.getString("LookHistory"), this.histKey, 2);
                    if (!this.rec) {
                        ((JComponent)jWindow.getContentPane()).registerKeyboardAction(this, messages.getString("SendFeedback"), this.fdKey, 2);
                        ((JComponent)jWindow.getContentPane()).unregisterKeyboardAction(this.shKey);
                    } else {
                        ((JComponent)jWindow.getContentPane()).unregisterKeyboardAction(this.fdKey);
                        ((JComponent)jWindow.getContentPane()).registerKeyboardAction(this, "ScreenShot", this.shKey, 2);
                    }
                }
                if (bl) {
                    ((JComponent)jWindow.getContentPane()).unregisterKeyboardAction(this.fdKey);
                    ((JComponent)jWindow.getContentPane()).unregisterKeyboardAction(this.shKey);
                }
            }
            this.compList.getInside(this.point);
            if (this.myframe == null) {
                this.myframe = " ";
            }
            this.log.setTitle(this.myframe);
            return;
        }
    }

    public void saveLog() {
        if (this.start_rec) {
            this.save_HistLog("history.log");
            vector.removeAllElements();
            System.gc();
            this.start_rec = false;
            this.stop_rec = false;
            this.rec = true;
        }
        if (this.log != null) {
            vector.add(0, this.log);
        }
        if (vector.size() > 30) {
            if (!this.rec) {
                this.save_tempHistLog("history.log");
            } else {
                this.save_tempHistLog("feedbackhist.log");
            }
            vector.removeAllElements();
            System.gc();
        }
        if (this.rec && this.stop_rec) {
            this.save_HistLog("feedbackhist.log");
            vector.removeAllElements();
            System.gc();
            vector = this.getPrev_log("history.log");
            File file = new File("feedbackhist.log");
            file.delete();
            file = new File("temp_feedbackhist.log");
            file.delete();
            this.start_rec = false;
            this.stop_rec = true;
            this.rec = false;
        }
        if (this.point != null) {
            this.point.setCursor(Cursor.getPredefinedCursor(0));
            this.point.removeMouseListener(this.mouse_blocker_listener);
        }
    }

    public void save_HistLog(String string) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(vector);
            vector.removeAllElements();
            System.gc();
            vector = this.getPrev_log("temp_" + string);
            objectOutputStream.writeObject(vector);
            objectOutputStream.close();
            file = new File("temp_" + string);
            file.delete();
            this.writeThread = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save_tempHistLog(String string) {
        try {
            File file = new File("temp_" + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(vector);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Vector getPrev_log(String string) {
        Vector vector = null;
        try {
            File file = new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                vector = (Vector)objectInputStream.readObject();
                Vector vector2 = null;
                try {
                    vector2 = (Vector)objectInputStream.readObject();
                }
                catch (EOFException eOFException) {
                    vector2 = null;
                }
                if (vector2 != null) {
                    File file2 = new File("temp_history.log");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(vector2);
                    objectOutputStream.close();
                    vector2.removeAllElements();
                    vector2 = null;
                    System.gc();
                }
                objectInputStream.close();
                return vector;
            }
            vector = new Vector();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("class exp");
        }
        return vector;
    }

    private static void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("something running");
    }

    public Vector getVector() {
        return vector;
    }

    public BufferedImage recreateEvent(Window window) {
        Rectangle rectangle;
        this.setup_UIManager();
        if (window != null) {
            int n = window.getWidth();
            int n2 = window.getHeight();
            try {
                rectangle = new Rectangle(window.getLocationOnScreen(), new Dimension(n, n2));
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                rectangle = null;
            }
        } else {
            rectangle = null;
        }
        if (rectangle != null) {
            BufferedImage bufferedImage = this.sh.captureScreen();
            return bufferedImage;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        int n3;
        double d;
        double d2;
        int n4;
        int n5;
        Dimension dimension;
        Object object;
        boolean bl;
        String string = actionEvent.getActionCommand();
        Component component = (Component)actionEvent.getSource();
        this.saving(component, string);
        if (this.myframe == null) {
            this.myframe = " ";
        }
        if ("FastSend".equals(actionEvent.getActionCommand())) {
            int n6;
            this.point.addMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(3));
            bl = false;
            object = this.recreateEvent(this.point);
            if (this.stop_rec) {
                this.feedbackframe = this.myframe;
                JDialog.setDefaultLookAndFeelDecorated(true);
                this.stop_rec = false;
                this.frame = null;
                this.frame = new FeedbackInterface(this.sh, this.feedbackframe, messages, this);
                if (object != null && savefinish) {
                    dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    n5 = (int)(dimension.getWidth() - 60.0);
                    n4 = (int)(dimension.getHeight() * 0.75) - 50;
                    d2 = (double)n5 / dimension.getWidth();
                    d = (double)n4 / dimension.getHeight();
                    n3 = (int)((double)this.point.getWidth() * d2);
                    n2 = (int)((double)this.point.getHeight() * d);
                    n6 = (int)((double)this.point.getLocationOnScreen().x * d2);
                    n = (int)((double)this.point.getLocationOnScreen().y * d);
                    this.frame.addScreenPanel(this.feedbackframe, (BufferedImage)object, n6, n, n3, n2);
                }
                this.frame.setVisible(false);
            } else if (object != null && savefinish) {
                dimension = Toolkit.getDefaultToolkit().getScreenSize();
                n5 = (int)(dimension.getWidth() - 60.0);
                n4 = (int)(dimension.getHeight() * 0.75) - 50;
                d2 = (double)n5 / dimension.getWidth();
                d = (double)n4 / dimension.getHeight();
                n3 = (int)((double)this.point.getWidth() * d2);
                n2 = (int)((double)this.point.getHeight() * d);
                n6 = (int)((double)this.point.getLocationOnScreen().x * d2);
                n = (int)((double)this.point.getLocationOnScreen().y * d);
                if (this.point instanceof JDialog) {
                    bl = ((JDialog)this.point).isModal();
                }
                this.feedbackframe = this.myframe;
                this.frame.addScreenPanel(this.feedbackframe, (BufferedImage)object, n6, n, n3, n2);
            }
            ActionEvent actionEvent2 = new ActionEvent(this.frame.send_button, 1001, messages.getString("Send"));
            this.frame.actionPerformed(actionEvent2);
            this.point.removeMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (messages.getString("SendFeedback").equals(actionEvent.getActionCommand())) {
            this.setup_UIManager();
            this.point.addMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(3));
            bl = false;
            object = this.recreateEvent(this.point);
            this.feedbackframe = this.myframe;
            if (this.point instanceof JDialog) {
                bl = ((JDialog)this.point).isModal();
            }
            JDialog.setDefaultLookAndFeelDecorated(true);
            this.stop_rec = false;
            this.frame = null;
            this.frame = new FeedbackInterface(this.sh, this.feedbackframe, messages, this);
            if (object != null && savefinish) {
                dimension = Toolkit.getDefaultToolkit().getScreenSize();
                n5 = (int)(dimension.getWidth() - 60.0);
                n4 = (int)(dimension.getHeight() * 0.75) - 50;
                d2 = (double)n5 / dimension.getWidth();
                d = (double)n4 / dimension.getHeight();
                n3 = (int)((double)this.point.getWidth() * d2);
                n2 = (int)((double)this.point.getHeight() * d);
                int n7 = (int)((double)this.point.getLocationOnScreen().x * d2);
                n = (int)((double)this.point.getLocationOnScreen().y * d);
                this.frame.addScreenPanel(this.feedbackframe, (BufferedImage)object, n7, n, n3, n2);
                this.frame.setComment(bl);
                if (bl) {
                    this.modalWindow = this.point;
                }
            }
            this.point.removeMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(0));
        }
        if ("ScreenShot".equals(actionEvent.getActionCommand())) {
            this.point.addMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(3));
            bl = false;
            object = this.recreateEvent(this.point);
            if (object != null && savefinish) {
                dimension = Toolkit.getDefaultToolkit().getScreenSize();
                n5 = (int)(dimension.getWidth() - 60.0);
                n4 = (int)(dimension.getHeight() * 0.75) - 50;
                d2 = (double)n5 / dimension.getWidth();
                d = (double)n4 / dimension.getHeight();
                n3 = (int)((double)this.point.getWidth() * d2);
                n2 = (int)((double)this.point.getHeight() * d);
                int n8 = (int)((double)this.point.getLocationOnScreen().x * d2);
                n = (int)((double)this.point.getLocationOnScreen().y * d);
                if (this.point instanceof JDialog) {
                    bl = ((JDialog)this.point).isModal();
                }
                this.feedbackframe = this.myframe;
                this.frame.addScreenPanel(this.feedbackframe, (BufferedImage)object, n8, n, n3, n2);
                this.frame.setComment(bl);
                if (bl) {
                    this.modalWindow = this.point;
                }
            }
            this.point.removeMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (messages.getString("LookHistory").equals(actionEvent.getActionCommand())) {
            this.point.addMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(3));
            this.setup_UIManager();
            object = new ReportDetails(vector, null, null, messages, this.rec);
            this.point.removeMouseListener(this.mouse_blocker_listener);
            this.point.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Component component;
        String string = messages.getString("ChangeState");
        Object object = changeEvent.getSource();
        if (object instanceof Component) {
            component = (Component)changeEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        this.saving(component, string);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Component component;
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        if (mutableTreeNode == null) {
            return;
        }
        Object object = treeSelectionEvent.getSource();
        if (object instanceof Component) {
            component = (Component)treeSelectionEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("Node") + " ";
        if (mutableTreeNode instanceof DefaultMutableTreeNode) {
            string = string + ((DefaultMutableTreeNode)mutableTreeNode).getUserObject() + " ";
        }
        string = string + messages.getString("ValueChanged");
        this.saving(component, string);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        Component component;
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        try {
            int n = treeModelEvent.getChildIndices()[0];
            mutableTreeNode = (MutableTreeNode)mutableTreeNode.getChildAt(n);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Object object = treeModelEvent.getSource();
        if (object instanceof Component) {
            component = (Component)treeModelEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("Node");
        if (mutableTreeNode instanceof DefaultMutableTreeNode) {
            string = string + " " + ((DefaultMutableTreeNode)mutableTreeNode).getUserObject();
        }
        string = string + " " + messages.getString("Change");
        this.saving(component, string);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        Component component;
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        try {
            int n = treeModelEvent.getChildIndices()[0];
            mutableTreeNode = (MutableTreeNode)mutableTreeNode.getChildAt(n);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Object object = treeModelEvent.getSource();
        if (object instanceof Component) {
            component = (Component)treeModelEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("Node");
        if (mutableTreeNode instanceof DefaultMutableTreeNode) {
            string = string + " " + ((DefaultMutableTreeNode)mutableTreeNode).getUserObject();
        }
        string = string + " " + messages.getString("Inserted");
        this.saving(component, string);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        Component component;
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        try {
            int n = treeModelEvent.getChildIndices()[0];
            mutableTreeNode = (MutableTreeNode)mutableTreeNode.getChildAt(n);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Object object = treeModelEvent.getSource();
        if (object instanceof Component) {
            component = (Component)treeModelEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("Node");
        if (mutableTreeNode instanceof DefaultMutableTreeNode) {
            string = string + " " + ((DefaultMutableTreeNode)mutableTreeNode).getUserObject();
        }
        string = string + " " + messages.getString("Removed");
        this.saving(component, string);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        Component component;
        Object object = treeModelEvent.getSource();
        if (object instanceof Component) {
            component = (Component)treeModelEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("TreeStructuredChanged");
        this.saving(component, string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Component component = (Component)itemEvent.getSource();
        String string = (String)itemEvent.getItem() + " " + messages.getString("ItemStateChanged");
        this.saving(component, string);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        Component component;
        Object object = listDataEvent.getSource();
        if (object instanceof Component) {
            component = (Component)listDataEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("ListChanged");
        this.saving(component, string);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        Component component;
        Object object = listDataEvent.getSource();
        if (object instanceof Component) {
            component = (Component)listDataEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("ListContentsAdded");
        this.saving(component, string);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        Component component;
        Object object = listDataEvent.getSource();
        if (object instanceof Component) {
            component = (Component)listDataEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("ListContentRemoved");
        this.saving(component, string);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Component component;
        Object object = listSelectionEvent.getSource();
        if (object instanceof Component) {
            component = (Component)listSelectionEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("ListValueChanged");
        this.saving(component, string);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        Component component = (Component)menuEvent.getSource();
        String string = messages.getString("MenuCanceled");
        this.saving(component, string);
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        Component component = (Component)menuEvent.getSource();
        String string = messages.getString("MenuDeselected");
        this.saving(component, string);
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Component component = (Component)menuEvent.getSource();
        String string = messages.getString("MenuSelected");
        this.saving(component, string);
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        Component component;
        Object object = tableColumnModelEvent.getSource();
        if (object instanceof Component) {
            component = (Component)tableColumnModelEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("ColumnIndex") + " " + tableColumnModelEvent.getToIndex() + messages.getString("AddedToTable");
        this.saving(component, string);
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        Component component;
        Object object = tableColumnModelEvent.getSource();
        if (object instanceof Component) {
            component = (Component)tableColumnModelEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("ColumnIndexFrom") + " " + tableColumnModelEvent.getFromIndex() + " " + messages.getString("MovedToColumnIndex") + " " + tableColumnModelEvent.getToIndex() + " " + messages.getString("InTheTable");
        this.saving(component, string);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        Component component;
        Object object = tableColumnModelEvent.getSource();
        if (object instanceof Component) {
            component = (Component)tableColumnModelEvent.getSource();
        } else if (this.modelHash.containsKey(object)) {
            component = (Component)this.modelHash.get(object);
        } else {
            component = null;
            System.out.println("weird" + object.toString());
        }
        String string = messages.getString("ColumnIndex") + " " + tableColumnModelEvent.getFromIndex() + " " + messages.getString("RemovedFromTheTable");
        this.saving(component, string);
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    static {
        savefinish = true;
    }

    class MyEventQueue
    extends EventQueue {
        MyEventQueue() {
        }

        @Override
        protected void dispatchEvent(AWTEvent aWTEvent) {
            super.dispatchEvent(aWTEvent);
            int n = aWTEvent.getID();
            if (n == 200 || n == 202) {
                String string = " ";
                if (n == 200) {
                    string = messages.getString("WindowOpened");
                } else if (n == 202) {
                    string = messages.getString("WindowClosed");
                }
                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                Window window = windowEvent.getWindow();
                if (window instanceof ReportDetails.View || window instanceof Movie) {
                    return;
                }
                ActionRecorderDialog.this.saving(window, string);
            }
        }
    }
}

