/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.download;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.download.Download;
import org.greenstone.gatherer.download.DownloadJob;
import org.greenstone.gatherer.util.SafeProcess;

public class DownloadScrollPane
extends Thread {
    private boolean debug = false;
    private boolean remove_complete_jobs = true;
    private JPanel filler_pane = null;
    private JPanel list_pane;
    private DownloadJob job = null;
    private JScrollPane list_scroll;
    private Vector job_queue = new Vector();
    private static final boolean simple = true;

    public DownloadScrollPane() {
        Color color = Configuration.getColor("coloring.collection_tree_background", false);
        this.filler_pane = new JPanel();
        this.filler_pane.setBackground(color);
        this.list_pane = new JPanel();
        this.list_pane.setLayout(new BoxLayout(this.list_pane, 1));
        this.list_pane.setBackground(color);
        this.list_scroll = new JScrollPane(this.list_pane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void old_deleteDownloadJob(DownloadJob downloadJob) {
        if (downloadJob == this.job) {
            try {
                DownloadJob downloadJob2 = downloadJob;
                synchronized (downloadJob2) {
                    if (!downloadJob.hasSignalledStop()) {
                        downloadJob.wait();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.finishedDownloadJob(downloadJob, true);
    }

    public void deleteDownloadJob(DownloadJob downloadJob) {
        if (downloadJob != this.job) {
            downloadJob.setState(3);
            SafeProcess.log("**************** Deleting job from download scroll pane");
            this.finishedDownloadJob(downloadJob, true);
        }
    }

    public void deleteCurrentDownloadJob(DownloadJob downloadJob) {
        if (downloadJob == this.job) {
            SafeProcess.log("**************** Deleting current job from download scroll pane");
            this.finishedDownloadJob(downloadJob, true);
        }
    }

    protected void finishedDownloadJob(final DownloadJob downloadJob, final boolean bl) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("DownloadScrollPane.finishedDownloadJob()", true, new Runnable(){

            @Override
            public void run() {
                if (downloadJob.hasSignalledStop()) {
                    if (bl) {
                        DownloadScrollPane.this.list_pane.remove(downloadJob.getProgressBar());
                        DownloadScrollPane.this.list_pane.remove(DownloadScrollPane.this.filler_pane);
                    }
                    DownloadScrollPane.this.job_queue.remove(downloadJob);
                    if (DownloadScrollPane.this.job_queue.size() > 0) {
                        Dimension dimension = downloadJob.getProgressBar().getPreferredSize();
                        Dimension dimension2 = DownloadScrollPane.this.list_pane.getSize();
                        int n = dimension2.height - DownloadScrollPane.this.job_queue.size() * dimension.height;
                        dimension = null;
                        if (n > 0) {
                            DownloadScrollPane.this.filler_pane.setPreferredSize(new Dimension(dimension2.width, n));
                            DownloadScrollPane.this.list_pane.add(DownloadScrollPane.this.filler_pane);
                        }
                        dimension2 = null;
                    }
                    DownloadScrollPane.this.list_pane.updateUI();
                } else {
                    DebugStream.println("Somehow we're trying to delete a job that is still running.");
                }
            }
        });
    }

    public synchronized void downloadComplete() {
        this.job.downloadComplete();
    }

    public synchronized void downloadFailed() {
        this.job.downloadFailed();
    }

    public synchronized void downloadWarning() {
        this.job.downloadWarning();
    }

    public JScrollPane getDownloadJobList() {
        return this.list_scroll;
    }

    public synchronized boolean hasSignalledStop() {
        return this.job.hasSignalledStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newDownloadJob(Download download, String string, Properties properties) {
        DebugStream.println("About to create a new job");
        DownloadJob downloadJob = new DownloadJob(download, Configuration.proxy_pass, Configuration.proxy_user, this, string, properties);
        downloadJob.setState(2);
        this.job_queue.add(downloadJob);
        this.list_pane.remove(this.filler_pane);
        Dimension dimension = downloadJob.getProgressBar().getPreferredSize();
        Dimension dimension2 = this.list_pane.getSize();
        int n = dimension2.height - this.job_queue.size() * dimension.height;
        dimension = null;
        this.list_pane.add(downloadJob.getProgressBar());
        if (n > 0) {
            this.filler_pane.setPreferredSize(new Dimension(dimension2.width, n));
            this.list_pane.add(this.filler_pane);
        }
        dimension2 = null;
        this.list_pane.updateUI();
        downloadJob = null;
        DownloadScrollPane downloadScrollPane = this;
        synchronized (downloadScrollPane) {
            this.notify();
        }
    }

    public synchronized void updateProgress(long l, long l2) {
        this.job.updateProgress(l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeThread() {
        DownloadScrollPane downloadScrollPane = this;
        synchronized (downloadScrollPane) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            if (this.job_queue.size() > 0) {
                while (!this.job_queue.isEmpty()) {
                    this.job = (DownloadJob)this.job_queue.firstElement();
                    if (this.job.getState() != 2) continue;
                    object = this.job;
                    String string = this.job.toString();
                    DebugStream.println("DownloadJob " + string + " Begun.");
                    System.err.println("DownloadJob " + this.job.port + " " + this.job.toString() + " Begun.");
                    this.job.callDownload();
                    this.finishedDownloadJob((DownloadJob)object, false);
                    System.err.println("DownloadJob " + string + " complete.");
                    DebugStream.println("DownloadJob " + string + " complete.");
                    this.job = null;
                    object = null;
                }
                try {
                    object = this;
                    synchronized (object) {
                        DebugStream.println("WGet thread is waiting for DownloadJobs.");
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                object = this;
                synchronized (object) {
                    DebugStream.println("WGet thread is waiting for DownloadJobs.");
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

