/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.collection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CommandTokenizer;
import org.greenstone.gatherer.util.Codec;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BasicCollectionConfiguration
implements Comparable {
    private File file;
    private String creator = "";
    private String description = "";
    private String maintainer = "";
    private String name = "";
    private String is_public = "";
    private String collectgroup = "false";
    private String short_name = "";
    private String site = null;

    public BasicCollectionConfiguration(File file) {
        this.file = file;
        try {
            String string;
            String string2;
            Object object;
            String string3;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string4 = file.getName().toLowerCase();
            if (!file.exists()) {
                return;
            }
            if (string4.endsWith(".cfg")) {
                object6 = new FileInputStream(file);
                object5 = new InputStreamReader((InputStream)object6, "UTF-8");
                object4 = new BufferedReader((Reader)object5);
                object3 = null;
                while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                    if (((String)object3).startsWith("#") || ((String)object3).length() <= 0) continue;
                    while (((String)object3).trim().endsWith("\\")) {
                        object3 = ((String)object3).substring(0, ((String)object3).lastIndexOf("\\"));
                        object2 = ((BufferedReader)object4).readLine();
                        if (object2 != null) {
                            object3 = (String)object3 + "\n" + (String)object2;
                        }
                        object2 = null;
                    }
                    object2 = new CommandTokenizer((String)object3, (BufferedReader)object4);
                    string3 = ((CommandTokenizer)object2).nextToken();
                    if (string3 == null) continue;
                    if ((string3 = string3.toLowerCase()).equals("creator")) {
                        this.creator = ((CommandTokenizer)object2).nextToken();
                    } else if (string3.equals("maintainer")) {
                        this.maintainer = ((CommandTokenizer)object2).nextToken();
                    } else if (string3.equals("collectgroup")) {
                        this.collectgroup = ((CommandTokenizer)object2).nextToken();
                    } else if (string3.equalsIgnoreCase("collectionmeta")) {
                        object = ((CommandTokenizer)object2).nextToken();
                        string2 = ((CommandTokenizer)object2).nextToken();
                        string = "en";
                        if (object != null && string2 != null) {
                            object = ((String)object).toLowerCase();
                            if (string2.startsWith("[") && string2.endsWith("]")) {
                                string = string2.substring(string2.indexOf("=") + 1, string2.length() - 1);
                                string = string.toLowerCase();
                                string2 = ((CommandTokenizer)object2).nextToken();
                            }
                            if (((String)object).equals("collectionname")) {
                                if (this.name == null || string.equals(Dictionary.getLanguage())) {
                                    this.name = Codec.transform(string2, "GREENSTONE_TO_TEXT");
                                }
                            } else if (((String)object).equals("collectionextra") && (this.description == null || string.equals(Dictionary.getLanguage()))) {
                                this.description = Codec.transform(string2, "GREENSTONE_TO_TEXT");
                            }
                        }
                        string = null;
                        string2 = null;
                        object = null;
                    } else {
                        while (((CommandTokenizer)object2).hasMoreTokens()) {
                            ((CommandTokenizer)object2).nextToken();
                        }
                    }
                    string3 = null;
                    object2 = null;
                }
                object3 = null;
                ((BufferedReader)object4).close();
                ((InputStreamReader)object5).close();
                object4 = null;
                object5 = null;
            }
            if (string4.endsWith(".xml")) {
                Object object7;
                Object object8;
                object6 = XMLTools.parseXMLFile(file);
                object5 = object6.getDocumentElement();
                object4 = XMLTools.getChildByTagName((Node)object5, "metadataList");
                object3 = XMLTools.getChildByTagName((Node)object5, "displayItemList");
                object2 = "en";
                string3 = Configuration.getLanguage();
                if (object4 != null) {
                    object = XMLTools.getChildElementsByTagName((Element)object4, "metadata");
                    string2 = "";
                    string = "";
                    String string5 = "";
                    for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                        object8 = (Element)((ArrayList)object).get(i);
                        object7 = object8.getAttribute("name");
                        Object object9 = object8.getAttribute("lang");
                        if (((String)object9).equals("")) {
                            object9 = object2;
                        }
                        if (((String)object7).equals("creator")) {
                            if (((String)object9).equals(string3)) {
                                this.creator = XMLTools.getNodeText((Element)object8);
                                continue;
                            }
                            if (((String)object9).equals(object2)) {
                                string2 = XMLTools.getNodeText((Element)object8);
                                continue;
                            }
                            if (!this.creator.equals("") || !string2.equals("")) continue;
                            string2 = XMLTools.getNodeText((Element)object8);
                            continue;
                        }
                        if (((String)object7).equals("maintainer")) {
                            if (((String)object9).equals(string3)) {
                                this.maintainer = XMLTools.getNodeText((Element)object8);
                                continue;
                            }
                            if (((String)object9).equals(object2)) {
                                string = XMLTools.getNodeText((Element)object8);
                                continue;
                            }
                            if (!this.maintainer.equals("") || !string.equals("")) continue;
                            string = XMLTools.getNodeText((Element)object8);
                            continue;
                        }
                        if (!((String)object7).equals("public")) continue;
                        if (((String)object9).equals(string3)) {
                            this.is_public = XMLTools.getNodeText((Element)object8);
                            continue;
                        }
                        if (((String)object9).equals(object2)) {
                            string5 = XMLTools.getNodeText((Element)object8);
                            continue;
                        }
                        if (!this.is_public.equals("") || !string5.equals("")) continue;
                        string5 = XMLTools.getNodeText((Element)object8);
                    }
                    if (this.creator.equals("")) {
                        this.creator = string2;
                    }
                    if (this.maintainer.equals("")) {
                        this.maintainer = string;
                    }
                    if (this.is_public.equals("")) {
                        this.is_public = string5;
                    }
                }
                if (object3 != null) {
                    object = XMLTools.getChildElementsByTagName((Element)object3, "displayItem");
                    string2 = "";
                    string = "";
                    for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                        Element element = (Element)((ArrayList)object).get(i);
                        object8 = element.getAttribute("name");
                        object7 = element.getAttribute("lang");
                        if (((String)object7).equals("")) {
                            object7 = object2;
                        }
                        if (((String)object8).equals("name")) {
                            if (((String)object7).equals(string3)) {
                                this.name = XMLTools.getNodeText(element);
                                continue;
                            }
                            if (((String)object7).equals(object2)) {
                                string2 = XMLTools.getNodeText(element);
                                continue;
                            }
                            if (!this.name.equals("") || !string2.equals("")) continue;
                            string2 = XMLTools.getNodeText(element);
                            continue;
                        }
                        if (!((String)object8).equals("description")) continue;
                        if (((String)object7).equals(string3)) {
                            this.description = XMLTools.getNodeText(element);
                            continue;
                        }
                        if (((String)object7).equals(object2)) {
                            string = XMLTools.getNodeText(element);
                            continue;
                        }
                        if (!this.description.equals("") || !string.equals("")) continue;
                        string = XMLTools.getNodeText(element);
                    }
                    if (this.name.equals("")) {
                        this.name = string2;
                    }
                    if (this.description.equals("")) {
                        this.description = string;
                    }
                }
            }
        }
        catch (Exception exception) {
            DebugStream.println("Error in CollectionConfiguration.<init>(): " + exception);
            DebugStream.printStackTrace(exception);
        }
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        return this.toString().compareTo(object.toString());
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getDescription() {
        return this.description;
    }

    public File getFile() {
        return this.file;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getName() {
        return this.name;
    }

    public String getIsPublic() {
        return this.is_public;
    }

    public String getCollectGroup() {
        return this.collectgroup;
    }

    public String getShortName() {
        if (this.short_name.equals("")) {
            String string = Gatherer.getCollectDirectoryPath();
            String string2 = this.file.getParentFile().getParentFile().getAbsolutePath();
            if (string2.startsWith(string)) {
                this.short_name = string2.substring(string.length());
                this.short_name = this.short_name.replace('\\', '/');
            } else {
                this.short_name = this.file.getParentFile().getParentFile().getName();
            }
        }
        return this.short_name;
    }

    public void setSite(String string) {
        this.site = string;
    }

    public String toString() {
        if (this.site == null) {
            return this.getName() + " " + "[" + this.getShortName() + "]";
        }
        return this.getName() + " " + "[" + this.getShortName() + ", " + this.site + "]";
    }
}

