/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.SearchMeta;
import org.greenstone.gatherer.cdm.Subcollection;
import org.greenstone.gatherer.cdm.SubcollectionIndex;
import org.greenstone.gatherer.cdm.SubcollectionManager;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.util.CheckList;
import org.greenstone.gatherer.util.JarTools;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubcollectionIndexManager
extends DOMProxyListModel {
    private static final Dimension FIELD_SIZE = new Dimension(200, 30);
    private Control controls;
    private DOMProxyListModel model;
    private SubcollectionIndex default_index;

    public SubcollectionIndexManager(Element element) {
        super(element, "Index", new SubcollectionIndex());
        DebugStream.println("SubcollectionIndexManager: " + this.getSize() + " subcollection indexes parsed.");
        this.model = this;
        NodeList nodeList = CollectionConfiguration.getElementsByTagName("DefaultSubcollection");
        if (nodeList.getLength() > 0) {
            this.default_index = new SubcollectionIndex((Element)nodeList.item(0));
        }
    }

    private void addSubcollectionIndex(SubcollectionIndex subcollectionIndex) {
        if (!this.contains(subcollectionIndex)) {
            SearchMeta searchMeta = new SearchMeta(subcollectionIndex.getID(), "partition");
            searchMeta.setValue(subcollectionIndex.getID());
            CollectionDesignManager.searchmeta_manager.addMetadatum(searchMeta);
            this.add(this.getSize(), subcollectionIndex);
        }
    }

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
        this.default_index = null;
        this.model = null;
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new SubcollectionIndexControls();
        }
        return this.controls;
    }

    public ArrayList getSubcollectionIndexes() {
        return this.children();
    }

    public void modeChanged(int n) {
    }

    private int moveSubcollectionIndex(SubcollectionIndex subcollectionIndex, boolean bl) {
        int n;
        int n2 = this.indexOf(subcollectionIndex);
        if (bl) {
            if (n2 == 0) {
                return n2;
            }
            n = n2 - 1;
            this.addBefore(subcollectionIndex, (SubcollectionIndex)this.getElementAt(n));
        } else {
            if (n2 == this.getSize() - 1) {
                return n2;
            }
            n = n2 + 1;
            this.addAfter(subcollectionIndex, (SubcollectionIndex)this.getElementAt(n));
        }
        return n;
    }

    private void removeSubcollectionIndex(SubcollectionIndex subcollectionIndex) {
        if (subcollectionIndex != null) {
            CollectionDesignManager.searchmeta_manager.removeMetadata(subcollectionIndex.getID(), "partition");
            if (this.default_index != null && this.default_index.equals(subcollectionIndex)) {
                this.setDefault(null);
            }
            this.remove(subcollectionIndex);
        }
    }

    public void removeSubcollectionIndexes(Subcollection subcollection) {
        String string = subcollection.getName();
        int n = this.getSize();
        for (int i = n - 1; i >= 0; --i) {
            SubcollectionIndex subcollectionIndex = (SubcollectionIndex)this.getElementAt(i);
            if (!subcollectionIndex.getSources().contains(string)) continue;
            this.removeSubcollectionIndex(subcollectionIndex);
        }
    }

    private void replaceSubcollectionIndex(SubcollectionIndex subcollectionIndex, SubcollectionIndex subcollectionIndex2) {
        CollectionDesignManager.searchmeta_manager.removeMetadata(subcollectionIndex.getID(), "partition");
        SearchMeta searchMeta = new SearchMeta(subcollectionIndex2.getID());
        searchMeta.setValue(subcollectionIndex2.getID());
        CollectionDesignManager.searchmeta_manager.addMetadatum(searchMeta);
        if (this.default_index != null && this.default_index.equals(subcollectionIndex)) {
            this.setDefault(subcollectionIndex2);
        }
        int n = this.indexOf(subcollectionIndex);
        this.remove(subcollectionIndex);
        this.add(n, subcollectionIndex2);
    }

    private void setDefault(SubcollectionIndex subcollectionIndex) {
        if (subcollectionIndex != null) {
            if (this.default_index == null) {
                Element element = this.root.getOwnerDocument().createElement("DefaultSubcollection");
                this.default_index = new SubcollectionIndex(element);
                Node node = CollectionConfiguration.findInsertionPoint(element);
                if (node != null) {
                    this.root.getOwnerDocument().getDocumentElement().insertBefore(element, node);
                } else {
                    this.root.getOwnerDocument().getDocumentElement().appendChild(element);
                }
            }
            this.default_index.setAssigned(true);
            this.default_index.setSources(subcollectionIndex.getSources());
        } else if (this.default_index != null) {
            this.default_index.setAssigned(false);
        }
    }

    private class SubcollectionIndexControls
    extends JPanel
    implements Control {
        private CheckList source_list;
        private JButton add_button;
        private JButton move_down_button;
        private JButton move_up_button;
        private JButton remove_button;
        private JButton replace_button;
        private JButton select_all_button;
        private JButton select_none_button;
        private JButton set_default_button;
        private JList subcollection_index_list;
        private JTextField subcollection_index_name_textfield;

        public SubcollectionIndexControls() {
            this.setComponentOrientation(Dictionary.getOrientation());
            ArrayList arrayList = new ArrayList();
            SubcollectionManager subcollectionManager = CollectionDesignManager.subcollection_manager;
            for (int i = 0; i < subcollectionManager.getSize(); ++i) {
                arrayList.add(subcollectionManager.getElementAt(i));
            }
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get("CDM.SubcollectionIndexManager.Subindexes"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            this.subcollection_index_list = new JList(SubcollectionIndexManager.this.model);
            this.subcollection_index_list.setCellRenderer(new SubcollectionIndexListCellRenderer());
            this.subcollection_index_list.setSelectionMode(0);
            this.subcollection_index_list.setVisibleRowCount(2);
            this.subcollection_index_list.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            this.move_up_button = new GLIButton(Dictionary.get("CDM.Move.Move_Up"), JarTools.getImage("arrow-up.gif"), Dictionary.get("CDM.Move.Move_Up_Tooltip"));
            this.move_up_button.setEnabled(false);
            this.move_down_button = new GLIButton(Dictionary.get("CDM.Move.Move_Down"), JarTools.getImage("arrow-down.gif"), Dictionary.get("CDM.Move.Move_Down_Tooltip"));
            this.move_down_button.setEnabled(false);
            this.set_default_button = new GLIButton(Dictionary.get("CDM.SubcollectionIndexManager.Set_Default_Subindex"), Dictionary.get("CDM.SubcollectionIndexManager.Set_Default_Subindex_Tooltip"));
            this.set_default_button.setEnabled(false);
            JPanel jPanel3 = new JPanel();
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel4 = new JPanel();
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel5 = new JPanel();
            jPanel5.setComponentOrientation(Dictionary.getOrientation());
            this.select_all_button = new GLIButton(Dictionary.get("CDM.IndexManager.Select_All"), Dictionary.get("CDM.IndexManager.Select_All_Tooltip"));
            this.select_none_button = new GLIButton(Dictionary.get("CDM.IndexManager.Select_None"), Dictionary.get("CDM.IndexManager.Select_None_Tooltip"));
            JPanel jPanel6 = new JPanel();
            jPanel6.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel7 = new JPanel();
            jPanel7.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel2 = new JLabel(Dictionary.get("CDM.SubcollectionIndexManager.Source"));
            jLabel2.setComponentOrientation(Dictionary.getOrientation());
            this.source_list = new CheckList(false);
            this.source_list.setListData(arrayList);
            this.source_list.setToolTipText(Dictionary.get("CDM.SubcollectionIndexManager.Source_Tooltip"));
            this.select_all_button.setEnabled(this.isSelectAllEnabled());
            this.select_none_button.setEnabled(this.isSelectAllEnabled());
            JPanel jPanel8 = new JPanel();
            jPanel8.setComponentOrientation(Dictionary.getOrientation());
            this.add_button = new GLIButton(Dictionary.get("CDM.SubcollectionIndexManager.Add_Subindex"), Dictionary.get("CDM.SubcollectionIndexManager.Add_Subindex_Tooltip"));
            this.add_button.setEnabled(false);
            this.remove_button = new GLIButton(Dictionary.get("CDM.SubcollectionIndexManager.Remove_Subindex"), Dictionary.get("CDM.SubcollectionIndexManager.Remove_Subindex_Tooltip"));
            this.remove_button.setEnabled(false);
            this.replace_button = new GLIButton(Dictionary.get("CDM.SubcollectionIndexManager.Replace_Subindex"), Dictionary.get("CDM.SubcollectionIndexManager.Replace_Subindex_Tooltip"));
            this.replace_button.setEnabled(false);
            this.add_button.addActionListener(new AddListener());
            this.add_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.move_down_button.addActionListener(new MoveListener(false));
            this.move_down_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.move_up_button.addActionListener(new MoveListener(true));
            this.move_up_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.remove_button.addActionListener(new RemoveListener());
            this.remove_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.replace_button.addActionListener(new ReplaceListener());
            this.replace_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.select_all_button.addActionListener(new SelectAllListener());
            this.select_all_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.select_none_button.addActionListener(new SelectNoneListener());
            this.select_none_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.set_default_button.addActionListener(new SetDefaultListener());
            this.set_default_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.subcollection_index_list.addListSelectionListener(new AssignedListListener());
            this.source_list.addListSelectionListener(new SourceListListener());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            jPanel2.setLayout(new GridLayout(3, 1));
            jPanel2.add(this.move_up_button);
            jPanel2.add(this.move_down_button);
            jPanel2.add(this.set_default_button);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)new JScrollPane(this.subcollection_index_list), "Center");
            jPanel.add((Component)jPanel2, "After");
            jPanel5.setLayout(new BorderLayout());
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel5.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jPanel5.add(jLabel2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.select_all_button, gridBagConstraints);
            jPanel5.add(this.select_all_button);
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.select_none_button, gridBagConstraints);
            jPanel5.add(this.select_none_button);
            jPanel6.setLayout(new BorderLayout());
            jPanel6.add((Component)new JScrollPane(this.source_list), "Center");
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel5, "Before");
            jPanel4.add((Component)jPanel6, "Center");
            jPanel8.setLayout(new GridLayout(1, 3));
            jPanel8.add(this.add_button);
            jPanel8.add(this.replace_button);
            jPanel8.add(this.remove_button);
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jPanel4, "Center");
            jPanel3.add((Component)jPanel8, "South");
            jPanel7.setLayout(new BorderLayout());
            jPanel7.add((Component)jPanel, "North");
            jPanel7.add((Component)jPanel3, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel7, "Center");
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
            ArrayList arrayList = new ArrayList();
            SubcollectionManager subcollectionManager = CollectionDesignManager.subcollection_manager;
            for (int i = 0; i < subcollectionManager.getSize(); ++i) {
                arrayList.add(subcollectionManager.getElementAt(i));
            }
            this.source_list.setListData(arrayList);
            this.subcollection_index_list.updateUI();
            this.clearControls();
        }

        @Override
        public void loseFocus() {
        }

        private void clearControls() {
            this.subcollection_index_list.clearSelection();
            this.source_list.clearTicked();
            this.add_button.setEnabled(false);
            this.remove_button.setEnabled(false);
            this.replace_button.setEnabled(false);
            this.set_default_button.setEnabled(false);
            this.move_down_button.setEnabled(false);
            this.move_up_button.setEnabled(false);
            this.select_all_button.setEnabled(this.isSelectAllEnabled());
            this.select_none_button.setEnabled(this.isSelectAllEnabled());
        }

        private boolean isSelectAllEnabled() {
            return this.source_list.getModel().getSize() > 0;
        }

        private void updateControlsWithSelectedIndex() {
            SubcollectionIndex subcollectionIndex = (SubcollectionIndex)this.subcollection_index_list.getSelectedValue();
            if (subcollectionIndex == null) {
                this.source_list.clearTicked();
                return;
            }
            this.source_list.clearTicked();
            this.source_list.setTickedObjects(subcollectionIndex.getSources().toArray());
        }

        private void validateButtons() {
            boolean bl = false;
            boolean bl2 = false;
            if (!this.source_list.isNothingTicked()) {
                ArrayList arrayList = this.source_list.getTicked();
                SubcollectionIndex subcollectionIndex = new SubcollectionIndex(arrayList.toArray());
                if (!SubcollectionIndexManager.this.model.contains(subcollectionIndex)) {
                    bl = true;
                    if (!this.subcollection_index_list.isSelectionEmpty()) {
                        bl2 = true;
                    }
                }
            }
            this.select_all_button.setEnabled(this.isSelectAllEnabled());
            this.select_none_button.setEnabled(this.isSelectAllEnabled());
            this.add_button.setEnabled(bl);
            this.replace_button.setEnabled(bl2);
        }

        private class SubcollectionIndexListCellRenderer
        extends DefaultListCellRenderer {
            private SubcollectionIndexListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (SubcollectionIndexManager.this.default_index != null && SubcollectionIndexManager.this.default_index.equals(object)) {
                    jLabel.setText(jLabel.getText() + " " + Dictionary.get("CDM.SubcollectionIndexManager.Default_Partition_Indicator"));
                }
                return jLabel;
            }
        }

        private class AssignedListListener
        implements ListSelectionListener {
            private AssignedListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (SubcollectionIndexControls.this.subcollection_index_list.isSelectionEmpty()) {
                    SubcollectionIndexControls.this.clearControls();
                    return;
                }
                int n = SubcollectionIndexControls.this.subcollection_index_list.getSelectedIndex();
                int n2 = SubcollectionIndexControls.this.subcollection_index_list.getModel().getSize();
                SubcollectionIndexControls.this.select_all_button.setEnabled(SubcollectionIndexControls.this.isSelectAllEnabled());
                SubcollectionIndexControls.this.select_none_button.setEnabled(SubcollectionIndexControls.this.isSelectAllEnabled());
                SubcollectionIndexControls.this.remove_button.setEnabled(true);
                SubcollectionIndexControls.this.replace_button.setEnabled(false);
                SubcollectionIndexControls.this.add_button.setEnabled(false);
                SubcollectionIndex subcollectionIndex = (SubcollectionIndex)SubcollectionIndexControls.this.subcollection_index_list.getSelectedValue();
                SubcollectionIndexControls.this.set_default_button.setEnabled(SubcollectionIndexManager.this.default_index == null || !SubcollectionIndexManager.this.default_index.equals(subcollectionIndex));
                if (n > 0) {
                    SubcollectionIndexControls.this.move_up_button.setEnabled(true);
                } else {
                    SubcollectionIndexControls.this.move_up_button.setEnabled(false);
                }
                if (n < n2 - 1) {
                    SubcollectionIndexControls.this.move_down_button.setEnabled(true);
                } else {
                    SubcollectionIndexControls.this.move_down_button.setEnabled(false);
                }
                SubcollectionIndexControls.this.updateControlsWithSelectedIndex();
            }
        }

        private class SelectNoneListener
        implements ActionListener {
            private SelectNoneListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SubcollectionIndexControls.this.select_none_button.isEnabled()) {
                    SubcollectionIndexControls.this.source_list.clearTicked();
                    SubcollectionIndexControls.this.validateButtons();
                }
            }
        }

        private class SelectAllListener
        implements ActionListener {
            private SelectAllListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SubcollectionIndexControls.this.select_all_button.isEnabled()) {
                    SubcollectionIndexControls.this.source_list.setAllTicked();
                    SubcollectionIndexControls.this.validateButtons();
                }
            }
        }

        private class SourceListListener
        implements ListSelectionListener {
            private SourceListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                SubcollectionIndexControls.this.validateButtons();
            }
        }

        private class SetDefaultListener
        implements ActionListener {
            private SetDefaultListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SubcollectionIndex subcollectionIndex = (SubcollectionIndex)SubcollectionIndexControls.this.subcollection_index_list.getSelectedValue();
                if (subcollectionIndex != null) {
                    SubcollectionIndexManager.this.setDefault(subcollectionIndex);
                    SubcollectionIndexControls.this.subcollection_index_list.setSelectedValue(subcollectionIndex, true);
                }
                SubcollectionIndexControls.this.set_default_button.setEnabled(false);
            }
        }

        private class ReplaceListener
        implements ActionListener {
            private ReplaceListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SubcollectionIndexControls.this.subcollection_index_list.isSelectionEmpty() || SubcollectionIndexControls.this.source_list.isNothingTicked()) {
                    SubcollectionIndexControls.this.replace_button.setEnabled(false);
                    return;
                }
                SubcollectionIndex subcollectionIndex = (SubcollectionIndex)SubcollectionIndexControls.this.subcollection_index_list.getSelectedValue();
                ArrayList arrayList = SubcollectionIndexControls.this.source_list.getTicked();
                SubcollectionIndex subcollectionIndex2 = new SubcollectionIndex(arrayList.toArray());
                SubcollectionIndexManager.this.replaceSubcollectionIndex(subcollectionIndex, subcollectionIndex2);
            }
        }

        private class RemoveListener
        implements ActionListener {
            private RemoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SubcollectionIndex subcollectionIndex = (SubcollectionIndex)SubcollectionIndexControls.this.subcollection_index_list.getSelectedValue();
                if (subcollectionIndex != null) {
                    SubcollectionIndexManager.this.removeSubcollectionIndex(subcollectionIndex);
                }
            }
        }

        private class MoveListener
        implements ActionListener {
            private boolean move_up;

            public MoveListener(boolean bl) {
                this.move_up = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SubcollectionIndex subcollectionIndex = (SubcollectionIndex)SubcollectionIndexControls.this.subcollection_index_list.getSelectedValue();
                if (subcollectionIndex != null) {
                    int n = SubcollectionIndexManager.this.moveSubcollectionIndex(subcollectionIndex, this.move_up);
                    SubcollectionIndexControls.this.subcollection_index_list.setSelectedIndex(n);
                }
            }
        }

        private class AddListener
        implements ActionListener {
            private AddListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SubcollectionIndexControls.this.source_list.isNothingTicked()) {
                    ArrayList arrayList = SubcollectionIndexControls.this.source_list.getTicked();
                    SubcollectionIndex subcollectionIndex = new SubcollectionIndex(arrayList.toArray());
                    SubcollectionIndexManager.this.addSubcollectionIndex(subcollectionIndex);
                    SubcollectionIndexControls.this.clearControls();
                }
            }
        }
    }
}

