/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;

public class Subcollection
implements Comparable,
DOMProxyListEntry {
    private boolean include = true;
    private Element element = null;
    private String pattern = null;
    private String flags = null;
    private String name = null;
    private String source = null;
    private String text = null;

    public Subcollection() {
    }

    public Subcollection(Element element) {
        this.element = element;
    }

    public Subcollection(String string, boolean bl, String string2, String string3, String string4) {
        this.flags = string4;
        this.include = bl;
        this.name = string;
        this.pattern = string3;
        this.source = string2 != null ? string2 : "Filename";
        this.element = CollectionConfiguration.createElement("Subcollection");
        this.element.setAttribute("content", string2);
        this.element.setAttribute("name", string);
        this.element.setAttribute("options", string4);
        this.element.setAttribute("type", bl ? "include" : "exclude");
        XMLTools.setValue(this.element, string3);
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof String) {
            return this.getName().compareTo((String)object);
        }
        return this.getName().compareTo(((Subcollection)object).getName());
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new Subcollection(element);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public String getFlags() {
        if (this.flags == null && this.element != null) {
            this.flags = this.element.getAttribute("options");
        }
        return this.flags;
    }

    public String getName() {
        if (this.name == null && this.element != null) {
            this.name = this.element.getAttribute("name");
        }
        return this.name;
    }

    public String getPattern() {
        if (this.pattern == null && this.element != null) {
            this.pattern = XMLTools.getValue(this.element);
        }
        return this.pattern;
    }

    public String getSource() {
        if (this.source == null && this.element != null) {
            this.source = this.element.getAttribute("content");
        }
        return this.source;
    }

    @Override
    public boolean isAssigned() {
        return this.element != null && !this.element.getAttribute("assigned").equals("false");
    }

    public boolean isInclusive() {
        if (this.element != null) {
            this.include = this.element.getAttribute("type").equals("include");
        }
        return this.include;
    }

    @Override
    public void setAssigned(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("assigned", bl ? "true" : "false");
        }
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
        this.include = true;
        this.flags = null;
        this.name = null;
        this.pattern = null;
        this.source = null;
        this.text = null;
    }

    public void setFlags(String string) {
        if (this.element != null) {
            this.element.setAttribute("options", string);
            this.flags = string;
            this.text = null;
        }
    }

    public void setInclusive(boolean bl) {
        if (this.element != null) {
            this.include = bl;
            this.element.setAttribute("type", this.include ? "include" : "exclude");
            this.text = null;
        }
    }

    public void setName(String string) {
        if (this.element != null) {
            this.element.setAttribute("name", string);
            this.name = string;
            this.text = null;
        }
    }

    public void setPattern(String string) {
        if (this.element != null) {
            XMLTools.setValue(this.element, string);
            this.pattern = string;
            this.text = null;
        }
    }

    public void setSource(String string) {
        if (this.element != null) {
            this.element.setAttribute("content", string);
            this.source = string;
            this.text = null;
        }
    }

    public String toString() {
        if (this.text == null) {
            StringBuffer stringBuffer = new StringBuffer(this.getName());
            stringBuffer.append(" ");
            stringBuffer.append("\"");
            if (!this.isInclusive()) {
                stringBuffer.append("!");
            }
            stringBuffer.append(this.getSource());
            stringBuffer.append("/");
            stringBuffer.append(this.getPattern());
            stringBuffer.append("/");
            stringBuffer.append(this.getFlags());
            stringBuffer.append("\"");
            this.text = stringBuffer.toString();
        }
        return this.text;
    }
}

