/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMetaManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.Index;
import org.greenstone.gatherer.cdm.IndexOption;
import org.greenstone.gatherer.cdm.Language;
import org.greenstone.gatherer.cdm.SearchMeta;
import org.greenstone.gatherer.cdm.SubcollectionIndex;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.TestingPreparation;

public class SearchMetadataManager
extends CollectionMetaManager {
    private Control controls;
    public static final String METADATA_INDEX = "ex.metadata";

    public SearchMetadataManager() {
        super(CollectionDesignManager.collect_config.getDocumentElement(), "SearchMetadata", new SearchMeta("", ""));
        DebugStream.println("SearchMetaManager: " + this.getSize() + " metadata parsed.");
    }

    @Override
    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    public void loseFocus() {
    }

    public void gainFocus() {
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new DisplayControl();
        }
        return this.controls;
    }

    public SearchMeta getMetadatum(String string, String string2) {
        return this.getMetadatum(string, string2, true);
    }

    public SearchMeta getMetadatum(String string, String string2, boolean bl) {
        int n = this.getSize();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            SearchMeta searchMeta = (SearchMeta)this.getElementAt(i);
            if (searchMeta.getName().equals(string) && searchMeta.getType().equals(string2) && searchMeta.getLanguage().equals(Configuration.getLanguage())) {
                return searchMeta;
            }
            searchMeta = null;
        }
        if (bl) {
            SearchMeta searchMeta = new SearchMeta(string, string2);
            this.addMetadatum(searchMeta);
            return searchMeta;
        }
        return null;
    }

    public ArrayList getMetadata(String string, String string2) {
        ArrayList<SearchMeta> arrayList = new ArrayList<SearchMeta>();
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            SearchMeta searchMeta = (SearchMeta)this.getElementAt(i);
            if (!searchMeta.getName().equals(string) || !searchMeta.getType().equals(string2)) continue;
            arrayList.add(searchMeta);
        }
        return arrayList;
    }

    public void removeMetadata(String string, String string2) {
        for (int i = this.getSize(); i != 0; --i) {
            SearchMeta searchMeta = (SearchMeta)this.getElementAt(i - 1);
            if (string.equals(searchMeta.getName()) && string2.equals(searchMeta.getType())) {
                this.remove(i - 1);
            }
            searchMeta = null;
        }
    }

    private ArrayList getEntries() {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        SearchMetadataEntry searchMetadataEntry;
        ArrayList arrayList4;
        Object object;
        ArrayList arrayList5;
        Object object2;
        int n;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        ArrayList arrayList6 = CollectionDesignManager.index_manager.getIndexes();
        if (arrayList6 != null) {
            int n2 = arrayList6.size();
            for (n = 0; n < n2; ++n) {
                String string = ((Index)arrayList6.get(n)).getID();
                if (string.equals(METADATA_INDEX)) continue;
                object2 = new SearchMetadataEntry(string, "index");
                linkedHashSet.add(object2);
            }
        }
        if ((arrayList5 = CollectionDesignManager.index_manager.getSortFields()) != null) {
            n = arrayList5.size();
            for (int i = 0; i < n; ++i) {
                object2 = ((Index)arrayList5.get(i)).getID();
                object = new SearchMetadataEntry((String)object2, "sort");
                linkedHashSet.add(object);
            }
        }
        if ((arrayList4 = CollectionDesignManager.index_manager.getFacets()) != null) {
            int n3 = arrayList4.size();
            for (int i = 0; i < n3; ++i) {
                object = ((Index)arrayList4.get(i)).getID();
                searchMetadataEntry = new SearchMetadataEntry((String)object, "facet");
                linkedHashSet.add(searchMetadataEntry);
            }
        }
        if ((arrayList3 = CollectionDesignManager.index_manager.getLevels()) != null) {
            int n4 = arrayList3.size();
            for (int i = 0; i < n4; ++i) {
                searchMetadataEntry = new SearchMetadataEntry(((IndexOption)arrayList3.get(i)).getName(), "level");
                linkedHashSet.add(searchMetadataEntry);
            }
        }
        if ((arrayList2 = CollectionDesignManager.subcollectionindex_manager.getSubcollectionIndexes()) != null) {
            int n5 = arrayList2.size();
            for (int i = 0; i < n5; ++i) {
                SearchMetadataEntry searchMetadataEntry2 = new SearchMetadataEntry(((SubcollectionIndex)arrayList2.get(i)).getID(), "partition");
                linkedHashSet.add(searchMetadataEntry2);
            }
        }
        if ((arrayList = CollectionDesignManager.language_manager.getLanguages()) != null) {
            int n6 = arrayList.size();
            for (int i = 0; i < n6; ++i) {
                SearchMetadataEntry searchMetadataEntry3 = new SearchMetadataEntry(((Language)arrayList.get(i)).getCode(), "language");
                linkedHashSet.add(searchMetadataEntry3);
            }
        }
        ArrayList<Object> arrayList7 = new ArrayList<Object>();
        arrayList7.addAll(linkedHashSet);
        return arrayList7;
    }

    private static class SearchMetadataTableCellRenderer
    extends DefaultTableCellRenderer {
        private SearchMetadataTableCellRenderer() {
        }

        @Override
        public void setValue(Object object) {
            this.setText((String)object);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 1 && bl) {
                jTable.editCellAt(n, n2);
                if (jTable.isEditing()) {
                    jTable.getEditorComponent().requestFocus();
                }
            }
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(Configuration.getColor("coloring.workspace_heading_background", true));
            } else if (n3 == 0) {
                jLabel.setBackground(Configuration.getColor("coloring.collection_heading_background", true));
            } else {
                jLabel.setBackground(Configuration.getColor("coloring.collection_tree_background", true));
            }
            if (n3 == 1) {
                jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            }
            return jLabel;
        }
    }

    private class SearchMetadataTableModel
    extends AbstractTableModel {
        private ArrayList search_metadata_entries = null;
        private final String[] COLUMN_NAMES = new String[]{Dictionary.get("CDM.SearchMetadataManager.Component"), Dictionary.get("CDM.SearchMetadataManager.Component_Name")};

        public SearchMetadataTableModel() {
            this.refresh();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public int getRowCount() {
            return this.search_metadata_entries.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n >= this.search_metadata_entries.size() || n2 < 0 || n2 >= this.COLUMN_NAMES.length) {
                return null;
            }
            SearchMetadataEntry searchMetadataEntry = (SearchMetadataEntry)this.search_metadata_entries.get(n);
            if (n2 == 0) {
                return searchMetadataEntry.toString();
            }
            if (n2 == 1) {
                return searchMetadataEntry.getValue();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void refresh() {
            this.search_metadata_entries = SearchMetadataManager.this.getEntries();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SearchMetadataEntry searchMetadataEntry = (SearchMetadataEntry)this.search_metadata_entries.get(n);
            String string = searchMetadataEntry.getValue();
            if (!object.equals(string)) {
                searchMetadataEntry.setValue((String)object);
            }
        }
    }

    private class SearchMetadataTable
    extends JTable {
        private SearchMetadataTableModel model = null;

        public SearchMetadataTable() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.model = new SearchMetadataTableModel();
            this.setModel(this.model);
            this.setSelectionMode(0);
            TableColumnModel tableColumnModel = this.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            TableColumn tableColumn2 = tableColumnModel.getColumn(1);
            SearchMetadataTableCellRenderer searchMetadataTableCellRenderer = new SearchMetadataTableCellRenderer();
            tableColumn.setCellRenderer(searchMetadataTableCellRenderer);
            tableColumn2.setCellRenderer(searchMetadataTableCellRenderer);
        }

        public void refreshModel() {
            this.model.refresh();
        }

        public void stopEditing() {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
        }
    }

    private class SearchMetadataEntry {
        String id;
        String type;
        SearchMeta coll_meta = null;
        String value;

        public SearchMetadataEntry(String string, String string2) {
            if (!Gatherer.GS3) {
                string2 = "search";
            }
            this.id = string;
            this.type = string2;
            this.coll_meta = SearchMetadataManager.this.getMetadatum(string, string2);
            if (this.coll_meta != null) {
                this.value = this.coll_meta.getValue(false);
            }
        }

        public String toString() {
            return Dictionary.get("CDM.SearchMetadataManager.Type_" + this.type) + ": " + this.id;
        }

        public boolean equals(Object object) {
            if (object instanceof SearchMetadataEntry) {
                return this.id.equals(((SearchMetadataEntry)object).id) && this.type.equals(((SearchMetadataEntry)object).type);
            }
            return this.toString().equals(object.toString());
        }

        public String getMetaID() {
            if (Gatherer.GS3) {
                return this.id;
            }
            return "." + this.id;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.coll_meta.setValue(string);
            this.value = string;
        }
    }

    private class DisplayControl
    extends JPanel
    implements Control {
        private SearchMetadataTable metadata_table = null;

        public DisplayControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.SearchMetadata", "searchmetadatasettings");
            this.metadata_table = new SearchMetadataTable();
            JScrollPane jScrollPane = new JScrollPane(this.metadata_table);
            jScrollPane.getViewport().setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            jScrollPane.setOpaque(true);
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jScrollPane, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jPanel, "Center");
            TestingPreparation.setNamesRecursively(this);
        }

        @Override
        public void loseFocus() {
            this.metadata_table.stopEditing();
        }

        @Override
        public void gainFocus() {
            this.metadata_table.refreshModel();
        }

        @Override
        public void destroy() {
        }
    }
}

