/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.w3c.dom.Element;

public class SearchMeta
extends CollectionMeta {
    public static final String TYPE_INDEX = "index";
    public static final String TYPE_LEVEL = "level";
    public static final String TYPE_PARTITION = "partition";
    public static final String TYPE_LANGUAGE = "language";
    public static final String TYPE_SORT = "sort";
    public static final String TYPE_FACET = "facet";
    public static final String TYPE_SEARCH = "search";

    public SearchMeta(Element element) {
        this.element = element;
    }

    public SearchMeta(String string) {
        System.err.println("error calling new search meta with only a name");
    }

    public SearchMeta(String string, String string2) {
        this(string, string2, Configuration.getLanguage());
    }

    public SearchMeta(String string, String string2, String string3) {
        this.element = CollectionConfiguration.createElement("SearchMetadata");
        this.element.setAttribute("name", string);
        this.element.setAttribute(TYPE_LANGUAGE, string3);
        this.element.setAttribute("assigned", "false");
        if (Gatherer.GS3) {
            this.element.setAttribute("type", string2);
        } else {
            this.element.setAttribute("type", TYPE_SEARCH);
        }
    }

    public SearchMeta(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3);
        this.dummy = bl;
    }

    @Override
    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new SearchMeta(element);
    }

    @Override
    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public void setType(String string) {
        if (this.element != null) {
            if (Gatherer.GS3) {
                this.element.setAttribute("type", string);
            } else {
                this.element.setAttribute("type", TYPE_SEARCH);
            }
        }
    }

    public String getType() {
        if (this.element != null) {
            return this.element.getAttribute("type");
        }
        return null;
    }

    public boolean hasType() {
        return this.element.hasAttribute("type");
    }

    @Override
    public String toString() {
        if (this.text == null) {
            this.text = "searchmeta [" + this.getType() + "] [l=" + this.getLanguage() + "] \"" + this.getName() + "\"";
        }
        return this.text;
    }
}

