/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.util.ArrayList;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.cdm.Index;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.w3c.dom.Element;

public class MGIndex
extends Index {
    protected static final String[] LEVEL = new String[]{"document", "section", "paragraph"};
    private int level = -1;

    public MGIndex() {
    }

    public MGIndex(Element element) {
        this.element = element;
    }

    public MGIndex(int n, ArrayList arrayList) {
        super(arrayList);
        this.level = n;
        this.element.setAttribute("level", LEVEL[n]);
    }

    public MGIndex(String string, ArrayList arrayList) {
        super(arrayList);
        for (int i = 0; i < LEVEL.length; ++i) {
            if (!LEVEL[i].equalsIgnoreCase(string)) continue;
            this.level = i;
        }
        this.element.setAttribute("level", LEVEL[this.level]);
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new MGIndex(element);
    }

    public int getLevel() {
        if (this.level == -1 && this.element != null) {
            String string = this.element.getAttribute("level");
            for (int i = 0; this.level == -1 && i < LEVEL.length; ++i) {
                if (!string.equals(LEVEL[i])) continue;
                this.level = i;
            }
            string = null;
        }
        return this.level;
    }

    @Override
    public String getID() {
        if (this.element == null) {
            this.id = "";
        } else if (this.id == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getLevel();
            if (0 <= n && n < 3) {
                stringBuffer.append(LEVEL[n]);
                stringBuffer.append(":");
            }
            ArrayList arrayList = this.getSources();
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList.get(i);
                if (e instanceof MetadataElement) {
                    String string = ((MetadataElement)e).getFullName();
                    if (string.startsWith("ex.") && string.indexOf(46, "ex.".length()) == -1) {
                        stringBuffer.append(string.substring("ex.".length()));
                    } else {
                        stringBuffer.append(string);
                    }
                } else {
                    stringBuffer.append(e.toString());
                }
                stringBuffer.append(",");
            }
            arrayList = null;
            this.id = stringBuffer.length() == 0 ? "" : stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return this.id;
    }

    @Override
    public void setElement(Element element) {
        this.level = -1;
        super.setElement(element);
    }

    public void setLevel(int n) {
        if (this.element != null && this.element.getNodeName().equals("DefaultIndex")) {
            if (0 <= n && n < 3) {
                this.element.setAttribute("level", LEVEL[n]);
            } else {
                this.element.setAttribute("level", "");
            }
            this.id = null;
            this.level = n;
        } else {
            DebugStream.println("Error! Called setLevel() of index other than the default.");
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.getLevel();
        if (0 <= n && n < 3) {
            stringBuffer.append(LEVEL[n]);
            stringBuffer.append(":");
        }
        ArrayList arrayList = this.getSources();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string = arrayList.get(i).toString();
            stringBuffer.append(string);
            if (i >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        arrayList = null;
        return stringBuffer.toString();
    }
}

