/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.BuildTypeManager;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.IndexOption;
import org.greenstone.gatherer.cdm.IndexOptionList;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.JarTools;
import org.w3c.dom.Element;

public class IndexOptionManager
implements BuildTypeManager.BuildTypeListener {
    private IndexOptionList level_model = new IndexOptionList(CollectionDesignManager.collect_config.getLevels());
    private IndexOptionList options_model = new IndexOptionList(CollectionDesignManager.collect_config.getIndexOptions());
    private IndexOption default_level = null;
    private String build_type = null;
    private Control controls = null;

    public IndexOptionManager(String string) {
        DebugStream.println("IndexOptionManager: " + this.level_model.getSize() + " levels parsed.");
        DebugStream.println("IndexOptionManager: " + this.options_model.getSize() + " index options parsed.");
        this.build_type = string;
        if (this.build_type.equals("mg")) {
            this.level_model.setAssigned(false);
        }
        Element element = CollectionDesignManager.collect_config.getLevelDefault();
        this.default_level = new IndexOption(element);
        if (this.build_type.equals("mg")) {
            this.default_level.setAssigned(false);
        }
    }

    @Override
    public void buildTypeChanged(String string) {
        boolean bl = true;
        if (string.equals("mg")) {
            bl = false;
        }
        this.level_model.setAssigned(bl);
        this.default_level.setAssigned(bl);
        ((IndexOptionControl)this.controls).buildTypeChanged(string);
        this.build_type = string;
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new IndexOptionControl();
        }
        return this.controls;
    }

    public int getNumLevels() {
        return this.level_model.getSize();
    }

    public ArrayList getLevels() {
        return this.level_model.children();
    }

    private void addLevel(String string) {
        if (this.level_model.getOption(string) == null) {
            int n = 0;
            if (string.equals("section") && this.level_model.getSize() == 1) {
                n = 1;
            }
            this.level_model.add(n, new IndexOption(string));
            CollectionMeta collectionMeta = new CollectionMeta("." + string);
            collectionMeta.setAssigned(true);
            if (string.equals("document") || string.equals("section")) {
                collectionMeta.setValue("_text" + string + "_");
            } else {
                collectionMeta.setValue(string);
            }
            CollectionDesignManager.collectionmeta_manager.addMetadatum(collectionMeta);
        }
    }

    private IndexOption getLevel(String string) {
        return this.level_model.getOption(string);
    }

    private void removeLevel(String string) {
        CollectionDesignManager.collectionmeta_manager.removeMetadata("." + string);
        this.level_model.removeOption(string);
    }

    private void setDefaultLevel(String string) {
        if (string != null) {
            this.default_level.setValue(string);
            if (!this.build_type.equals("mg")) {
                this.default_level.setAssigned(true);
            }
        } else {
            this.default_level.setAssigned(false);
        }
    }

    private class LevelControl
    extends JPanel
    implements BuildTypeManager.BuildTypeListener {
        JCheckBox document_checkbox = null;
        JCheckBox section_checkbox = null;
        JRadioButton document_default_radio = null;
        JRadioButton section_default_radio = null;

        public LevelControl() {
            Object object;
            this.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            this.document_checkbox = new JCheckBox();
            this.document_checkbox.setComponentOrientation(Dictionary.getOrientation());
            this.document_checkbox.setText(Dictionary.get("CDM.LevelManager.Document"));
            this.document_checkbox.setActionCommand("document");
            this.document_default_radio = new JRadioButton();
            this.document_default_radio.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            this.document_default_radio.setOpaque(false);
            this.document_default_radio.setActionCommand("document");
            this.document_default_radio.setIcon(JarTools.getImage("radio_unselected.gif"));
            this.document_default_radio.setSelectedIcon(JarTools.getImage("radio_selected.gif"));
            this.document_default_radio.setComponentOrientation(Dictionary.getOrientation());
            this.section_checkbox = new JCheckBox();
            this.section_checkbox.setText(Dictionary.get("CDM.LevelManager.Section"));
            this.section_checkbox.setActionCommand("section");
            this.section_checkbox.setComponentOrientation(Dictionary.getOrientation());
            this.section_default_radio = new JRadioButton();
            this.section_default_radio.setOpaque(true);
            this.section_default_radio.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            this.section_default_radio.setOpaque(false);
            this.section_default_radio.setIcon(JarTools.getImage("radio_unselected.gif"));
            this.section_default_radio.setSelectedIcon(JarTools.getImage("radio_selected.gif"));
            this.section_default_radio.setComponentOrientation(Dictionary.getOrientation());
            this.section_default_radio.setActionCommand("section");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.document_default_radio);
            buttonGroup.add(this.section_default_radio);
            if (IndexOptionManager.this.level_model.getSize() == 0) {
                this.document_checkbox.setSelected(true);
                IndexOptionManager.this.addLevel("document");
            } else {
                if (IndexOptionManager.this.getLevel("document") != null) {
                    this.document_checkbox.setSelected(true);
                }
                if (IndexOptionManager.this.getLevel("section") != null) {
                    this.section_checkbox.setSelected(true);
                }
            }
            if (IndexOptionManager.this.default_level.isAssigned()) {
                if (IndexOptionManager.this.default_level.getValue().equals("document") && this.document_checkbox.isSelected()) {
                    this.document_default_radio.setSelected(true);
                } else if (IndexOptionManager.this.default_level.getValue().equals("section") && this.section_checkbox.isSelected()) {
                    this.section_default_radio.setSelected(true);
                } else {
                    IndexOptionManager.this.default_level.setAssigned(false);
                }
            }
            if (!IndexOptionManager.this.default_level.isAssigned()) {
                object = "document";
                if (this.document_checkbox.isSelected()) {
                    this.document_default_radio.setSelected(true);
                    object = "document";
                } else if (this.section_checkbox.isSelected()) {
                    this.section_default_radio.setSelected(true);
                    object = "section";
                }
                IndexOptionManager.this.setDefaultLevel((String)object);
            }
            this.validateControls();
            object = new JLabel(Dictionary.get("CDM.LevelManager.Level_Title"));
            jPanel.setLayout(new GridLayout(3, 1));
            jPanel.setToolTipText(Dictionary.get("CDM.IndexManager.Level_Tooltip"));
            jPanel.add((Component)object);
            jPanel.add(this.document_checkbox);
            jPanel.add(this.section_checkbox);
            ((Component)object).setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get("CDM.LevelManager.Default"));
            jPanel2.setLayout(new GridLayout(3, 1));
            jPanel2.setToolTipText(Dictionary.get("CDM.LevelManager.Default_Tooltip"));
            jPanel2.add(jLabel);
            jPanel2.add(this.document_default_radio);
            jPanel2.add(this.section_default_radio);
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            CheckBoxListener checkBoxListener = new CheckBoxListener();
            this.document_checkbox.addActionListener(checkBoxListener);
            this.section_checkbox.addActionListener(checkBoxListener);
            this.document_checkbox.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.section_checkbox.addActionListener(CollectionDesignManager.buildcol_change_listener);
            RadioListener radioListener = new RadioListener();
            this.document_default_radio.addActionListener(radioListener);
            this.section_default_radio.addActionListener(radioListener);
            this.setLayout(new BorderLayout(10, 10));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)jPanel, "Before");
            this.add((Component)jPanel2, "Center");
        }

        @Override
        public void buildTypeChanged(String string) {
        }

        public void gainFocus() {
        }

        public void loseFocus() {
        }

        public void destroy() {
        }

        private boolean noLevelsSelected() {
            return !this.document_checkbox.isSelected() && !this.section_checkbox.isSelected();
        }

        private void validateControls() {
            boolean bl = this.document_checkbox.isSelected();
            this.document_default_radio.setEnabled(bl);
            boolean bl2 = this.section_checkbox.isSelected();
            this.section_default_radio.setEnabled(bl2);
            if (!bl && this.document_default_radio.isSelected()) {
                this.section_default_radio.setSelected(true);
                IndexOptionManager.this.setDefaultLevel("section");
            } else if (!bl2 && this.section_default_radio.isSelected()) {
                this.document_default_radio.setSelected(true);
                IndexOptionManager.this.setDefaultLevel("document");
            }
        }

        private class CheckBoxListener
        implements ActionListener {
            private CheckBoxListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!((JCheckBox)actionEvent.getSource()).isSelected()) {
                    if (LevelControl.this.noLevelsSelected()) {
                        ((JCheckBox)actionEvent.getSource()).setSelected(true);
                    } else {
                        IndexOptionManager.this.removeLevel(actionEvent.getActionCommand());
                    }
                } else {
                    IndexOptionManager.this.addLevel(actionEvent.getActionCommand());
                }
                LevelControl.this.validateControls();
            }
        }

        private class RadioListener
        implements ActionListener {
            private RadioListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                IndexOptionManager.this.setDefaultLevel(string);
            }
        }
    }

    private class StemmingControl
    extends JPanel
    implements BuildTypeManager.BuildTypeListener {
        private JCheckBox stem_checkbox = new JCheckBox();
        private JCheckBox casefold_checkbox = new JCheckBox();
        private JCheckBox accentfold_checkbox = new JCheckBox();
        private JCheckBox separate_cjk_checkbox = new JCheckBox();

        public StemmingControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.setLayout(new BorderLayout(10, 10));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.stem_checkbox.setText(Dictionary.get("CDM.IndexingManager.Stem"));
            this.stem_checkbox.setToolTipText(Dictionary.get("CDM.IndexingManager.Stem_Tooltip"));
            this.stem_checkbox.setActionCommand("stem");
            this.stem_checkbox.setComponentOrientation(Dictionary.getOrientation());
            this.casefold_checkbox.setText(Dictionary.get("CDM.IndexingManager.Casefold"));
            this.casefold_checkbox.setToolTipText(Dictionary.get("CDM.IndexingManager.Casefold_Tooltip"));
            this.casefold_checkbox.setActionCommand("casefold");
            this.casefold_checkbox.setComponentOrientation(Dictionary.getOrientation());
            this.accentfold_checkbox.setText(Dictionary.get("CDM.IndexingManager.Accent_fold"));
            this.accentfold_checkbox.setToolTipText(Dictionary.get("CDM.IndexingManager.Accent_fold_Tooltip"));
            this.accentfold_checkbox.setActionCommand("accentfold");
            this.accentfold_checkbox.setComponentOrientation(Dictionary.getOrientation());
            this.separate_cjk_checkbox.setText(Dictionary.get("CDM.IndexingManager.Separate_cjk"));
            this.separate_cjk_checkbox.setToolTipText(Dictionary.get("CDM.IndexingManager.Separate_cjk_Tooltip"));
            this.separate_cjk_checkbox.setActionCommand("separate_cjk");
            this.separate_cjk_checkbox.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 1));
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(2, 2));
            jPanel2.add(this.stem_checkbox);
            jPanel2.add(this.casefold_checkbox);
            jPanel2.add(this.accentfold_checkbox);
            jPanel2.add(this.separate_cjk_checkbox);
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            jPanel.add(jPanel2);
            JLabel jLabel = new JLabel(Dictionary.get("CDM.IndexingManager.Options"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            this.add((Component)jLabel, "North");
            this.add((Component)jPanel, "Center");
            if (IndexOptionManager.this.build_type.equals("lucene") || IndexOptionManager.this.build_type.equals("solr")) {
                this.stem_checkbox.setSelected(false);
                this.stem_checkbox.setEnabled(false);
                this.casefold_checkbox.setSelected(true);
                this.casefold_checkbox.setEnabled(false);
                this.accentfold_checkbox.setSelected(true);
                this.accentfold_checkbox.setEnabled(false);
                if (IndexOptionManager.this.options_model.getOption("separate_cjk") != null) {
                    this.separate_cjk_checkbox.setSelected(true);
                }
            } else {
                if (IndexOptionManager.this.build_type.equals("mg")) {
                    this.accentfold_checkbox.setEnabled(false);
                }
                if (IndexOptionManager.this.options_model.getSize() != 0) {
                    if (IndexOptionManager.this.options_model.getOption("stem") != null) {
                        this.stem_checkbox.setSelected(true);
                    }
                    if (IndexOptionManager.this.options_model.getOption("casefold") != null) {
                        this.casefold_checkbox.setSelected(true);
                    }
                    if (IndexOptionManager.this.options_model.getOption("accentfold") != null) {
                        this.accentfold_checkbox.setSelected(true);
                    }
                    if (IndexOptionManager.this.options_model.getOption("separate_cjk") != null) {
                        this.separate_cjk_checkbox.setSelected(true);
                    }
                }
            }
            CheckBoxListener checkBoxListener = new CheckBoxListener();
            this.stem_checkbox.addActionListener(checkBoxListener);
            this.casefold_checkbox.addActionListener(checkBoxListener);
            this.accentfold_checkbox.addActionListener(checkBoxListener);
            this.separate_cjk_checkbox.addActionListener(checkBoxListener);
            this.stem_checkbox.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.casefold_checkbox.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.accentfold_checkbox.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.separate_cjk_checkbox.addActionListener(CollectionDesignManager.buildcol_change_listener);
        }

        @Override
        public void buildTypeChanged(String string) {
            if (string.equals("mgpp")) {
                this.accentfold_checkbox.setEnabled(true);
                this.accentfold_checkbox.setSelected(true);
                IndexOptionManager.this.options_model.addOption("accentfold");
                if (IndexOptionManager.this.build_type.equals("lucene") || IndexOptionManager.this.build_type.equals("solr")) {
                    this.stem_checkbox.setEnabled(true);
                    this.stem_checkbox.setSelected(true);
                    IndexOptionManager.this.options_model.addOption("stem");
                    this.casefold_checkbox.setEnabled(true);
                    this.casefold_checkbox.setSelected(true);
                    IndexOptionManager.this.options_model.addOption("casefold");
                }
            }
            if (string.equals("mg")) {
                this.accentfold_checkbox.setSelected(false);
                this.accentfold_checkbox.setEnabled(false);
                IndexOptionManager.this.options_model.removeOption("accentfold");
                if (IndexOptionManager.this.build_type.equals("lucene") || IndexOptionManager.this.build_type.equals("solr")) {
                    this.stem_checkbox.setEnabled(true);
                    this.stem_checkbox.setSelected(true);
                    IndexOptionManager.this.options_model.addOption("stem");
                    this.casefold_checkbox.setEnabled(true);
                    this.casefold_checkbox.setSelected(true);
                    IndexOptionManager.this.options_model.addOption("casefold");
                }
            }
            if (string.equals("lucene") || string.equals("solr")) {
                this.accentfold_checkbox.setSelected(true);
                this.accentfold_checkbox.setEnabled(false);
                IndexOptionManager.this.options_model.removeOption("accentfold");
                this.stem_checkbox.setSelected(false);
                this.stem_checkbox.setEnabled(false);
                IndexOptionManager.this.options_model.removeOption("stem");
                this.casefold_checkbox.setSelected(true);
                this.casefold_checkbox.setEnabled(false);
                IndexOptionManager.this.options_model.removeOption("casefold");
            }
        }

        private class CheckBoxListener
        implements ActionListener {
            private CheckBoxListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!((JCheckBox)actionEvent.getSource()).isSelected()) {
                    IndexOptionManager.this.options_model.removeOption(actionEvent.getActionCommand());
                } else {
                    IndexOptionManager.this.options_model.addOption(actionEvent.getActionCommand());
                }
            }
        }
    }

    private class IndexOptionControl
    extends JPanel
    implements Control {
        public StemmingControl stem_control = null;
        public LevelControl level_control = null;

        public IndexOptionControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.stem_control = new StemmingControl();
            this.level_control = new LevelControl();
            this.setLayout(new BorderLayout());
            this.add((Component)this.stem_control, "East");
            if (!IndexOptionManager.this.build_type.equals("mg")) {
                this.add((Component)this.level_control, "West");
            }
            TestingPreparation.setNamesRecursivelyForControl(this);
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void loseFocus() {
        }

        public void buildTypeChanged(String string) {
            if (IndexOptionManager.this.build_type.equals(string)) {
                return;
            }
            this.stem_control.buildTypeChanged(string);
            this.level_control.buildTypeChanged(string);
            if (IndexOptionManager.this.build_type.equals("mg")) {
                this.add((Component)this.level_control, "West");
            } else if (string.equals("mg")) {
                this.remove(this.level_control);
            }
        }
    }
}

