/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.CollectionMetaManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.gems.MetadataSetManager;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.GComboBox;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.util.Utility;

public class DepositorMetadataManager {
    private static Dimension LABEL_SIZE = new Dimension(150, 15);
    private static Dimension ROW_SIZE = new Dimension(400, 20);
    private static Dimension MAX_ROW_SIZE = new Dimension(1000, 30);
    private static String[] TYPEOPTIONS = new String[]{"text", "textarea"};
    private static String DEFAULT_METADATA_ELEMENTS = "dc.Title, dc.Creator, dc.Description";
    private static String DEFINITION = "definition";
    private Control controls;
    private ArrayList metadata_checklist_model = null;
    private CollectionMetaManager collmeta_manager = CollectionDesignManager.collectionmeta_manager;

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
        if (this.metadata_checklist_model != null) {
            this.metadata_checklist_model.clear();
            this.metadata_checklist_model = null;
        }
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new DepositorControl();
        }
        return this.controls;
    }

    public void modeChanged(int n) {
    }

    private class MetadataElementEntry
    implements Comparable {
        String namespace = null;
        String name = null;
        String label = null;
        String type = null;
        String tooltip = null;
        boolean selected;
        MetadataElementControl gui_object = null;

        public MetadataElementEntry(String string, String string2, boolean bl) {
            this.name = string;
            this.label = string2;
            this.selected = bl;
            if (string.indexOf(".") != -1) {
                this.namespace = string.substring(0, string.indexOf("."));
            }
        }

        public MetadataElementControl initGUIControl(String string) {
            this.gui_object = new MetadataElementControl(this, string);
            return this.gui_object;
        }

        public MetadataElementControl getGUIControl() {
            return this.gui_object;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.gui_object.enabled.isSelected();
        }

        public String getType() {
            return ((JComboBox)this.gui_object.value_control).getSelectedItem().toString();
        }

        public void setToolTip(String string) {
            if (string == null) {
                this.tooltip = "";
                return;
            }
            this.tooltip = string;
        }

        public int compareTo(Object object) {
            return this.compareTo((MetadataElementEntry)object);
        }

        public int compareTo(MetadataElementEntry metadataElementEntry) {
            return this.name.compareTo(metadataElementEntry.name);
        }
    }

    private class MetadataElementControl
    extends JPanel {
        private JCheckBox enabled = null;
        private JComponent value_control = null;

        public MetadataElementControl(MetadataElementEntry metadataElementEntry, String string) {
            this.setComponentOrientation(Dictionary.getOrientation());
            String string2 = "<html>" + metadataElementEntry.tooltip + "</html>";
            string2 = Utility.formatHTMLWidth(string2, 80);
            this.setBackground(Configuration.getColor(string, false));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setLayout(new BorderLayout());
            this.setPreferredSize(ROW_SIZE);
            this.setMaximumSize(MAX_ROW_SIZE);
            this.enabled = new JCheckBox(metadataElementEntry.name);
            this.enabled.setComponentOrientation(Dictionary.getOrientation());
            this.enabled.setSelected(metadataElementEntry.selected);
            this.enabled.setOpaque(false);
            this.enabled.setPreferredSize(LABEL_SIZE);
            this.enabled.setToolTipText(metadataElementEntry.tooltip);
            this.add((Component)this.enabled, "Before");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < TYPEOPTIONS.length; ++i) {
                arrayList.add(TYPEOPTIONS[i]);
            }
            this.value_control = new GComboBox(arrayList.toArray(), false, false);
            this.value_control.setComponentOrientation(Dictionary.getOrientation());
            this.selectValue((JComboBox)this.value_control, metadataElementEntry.type);
            this.value_control.setOpaque(true);
            if (metadataElementEntry.selected) {
                this.value_control.setBackground(Color.white);
                this.value_control.setEnabled(true);
            } else {
                this.value_control.setBackground(Color.lightGray);
                this.value_control.setEnabled(false);
                this.value_control.setVisible(false);
            }
            this.add((Component)this.value_control, "Center");
            this.enabled.addActionListener(new EnabledListener(this.value_control));
        }

        private boolean selectValue(JComboBox jComboBox, String string) {
            if (string == null) {
                jComboBox.setSelectedIndex(0);
                return false;
            }
            for (int i = 0; i < jComboBox.getItemCount(); ++i) {
                if (!jComboBox.getItemAt(i).toString().equals(string)) continue;
                jComboBox.setSelectedIndex(i);
                return true;
            }
            return false;
        }

        private class EnabledListener
        implements ActionListener {
            private JComponent target = null;

            public EnabledListener(JComponent jComponent) {
                this.target = jComponent;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                this.checkTickedElements(jCheckBox);
                if (this.target == null) {
                    return;
                }
                if (jCheckBox.isSelected()) {
                    this.target.setBackground(Color.white);
                    this.target.setEnabled(true);
                    this.target.setVisible(true);
                } else {
                    this.target.setBackground(Color.lightGray);
                    this.target.setEnabled(false);
                    this.target.setVisible(false);
                }
            }

            private void checkTickedElements(JCheckBox jCheckBox) {
                if (jCheckBox.isSelected()) {
                    return;
                }
                boolean bl = false;
                int n = DepositorMetadataManager.this.metadata_checklist_model.size();
                for (int i = 0; i < n; ++i) {
                    if (!((MetadataElementEntry)((DepositorMetadataManager)DepositorMetadataManager.this).metadata_checklist_model.get((int)i)).gui_object.enabled.isSelected()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    Object[] objectArray = new Object[]{Dictionary.get("General.OK")};
                    JOptionPane.showOptionDialog(Gatherer.g_man, Dictionary.get("CDM.DepositorMetadataManager.Warning"), Dictionary.get("General.Warning"), -1, 2, null, objectArray, objectArray[0]);
                    jCheckBox.setSelected(true);
                }
            }
        }
    }

    private class DepositorControl
    extends JPanel
    implements Control {
        private JPanel central_pane = null;

        public DepositorControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.DepositorMetadata", "depositormetadatasettings");
            this.buildModel();
            this.central_pane = new JPanel();
            this.central_pane.setComponentOrientation(Dictionary.getOrientation());
            this.central_pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.central_pane.setLayout(new BoxLayout(this.central_pane, 1));
            this.buildPane();
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JScrollPane(this.central_pane), "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jPanel, "Center");
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void loseFocus() {
            StringBuffer stringBuffer = new StringBuffer();
            if (DepositorMetadataManager.this.metadata_checklist_model != null) {
                int n = DepositorMetadataManager.this.metadata_checklist_model.size();
                for (int i = 0; i < n; ++i) {
                    MetadataElementEntry metadataElementEntry = (MetadataElementEntry)DepositorMetadataManager.this.metadata_checklist_model.get(i);
                    if (!metadataElementEntry.isSelected()) continue;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append("{\"name\":\"").append(metadataElementEntry.name).append("\",");
                    stringBuffer2.append("\"label\":\"").append(metadataElementEntry.label).append("\",");
                    stringBuffer2.append("\"tooltip\":\"").append(metadataElementEntry.name).append(": ").append(metadataElementEntry.tooltip).append("\",");
                    stringBuffer2.append("\"type\":\"").append(metadataElementEntry.getType()).append("\"}");
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(stringBuffer2);
                    stringBuffer2 = null;
                }
                if (stringBuffer.length() == 0) {
                    System.err.println("Error: DepositorMetadataMananger should have at least one selected metadata element.");
                }
                CollectionMeta collectionMeta = DepositorMetadataManager.this.collmeta_manager.getMetadatum("depositormetadata", true);
                collectionMeta.setValue(stringBuffer.toString());
            }
        }

        private void buildModel() {
            Object object;
            Object object2;
            int n;
            int n2;
            DepositorMetadataManager.this.metadata_checklist_model = new ArrayList();
            String string = CollectionManager.getLoadedCollectionName();
            CollectionMeta collectionMeta = DepositorMetadataManager.this.collmeta_manager.getMetadatum("depositormetadata", true);
            String string2 = collectionMeta.getValue(true);
            String string3 = Gatherer.getCollectDirectoryPath() + File.separator + string + File.separator + "metadata";
            ArrayList<MetadataSet> arrayList = org.greenstone.gatherer.metadata.MetadataSetManager.listMetadataSets(new File(string3));
            if (arrayList != null) {
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    if (!((MetadataSet)arrayList.get(n)).getNamespace().equals("ex")) continue;
                    arrayList.remove(n);
                    break;
                }
            }
            if (arrayList == null) {
                arrayList = new ArrayList<MetadataSet>();
            }
            if (arrayList.size() == 0) {
                string3 = MetadataSetManager.getGLIMetadataDirectoryPath();
                File file = new File(string3 = string3 + "dublin.mds");
                if (file.exists()) {
                    org.greenstone.gatherer.metadata.MetadataSetManager.loadMetadataSet(file);
                    MetadataSet metadataSet = org.greenstone.gatherer.metadata.MetadataSetManager.getMetadataSet("dc");
                    arrayList.add(metadataSet);
                }
            }
            if (arrayList.size() == 0) {
                System.err.println("Error: DepositorMetadataMananger can't find any valid metadata set files.");
                return;
            }
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                object2 = (MetadataSet)arrayList.get(n);
                object = ((MetadataSet)object2).getMetadataSetElements();
                for (int i = 0; object != null && i < ((ArrayList)object).size(); ++i) {
                    MetadataElement metadataElement = (MetadataElement)((ArrayList)object).get(i);
                    MetadataElementEntry metadataElementEntry = new MetadataElementEntry(metadataElement.getFullName(), metadataElement.getName(), false);
                    metadataElementEntry.setToolTip(metadataElement.getAttribute(DEFINITION, "en"));
                    DepositorMetadataManager.this.metadata_checklist_model.add(metadataElementEntry);
                }
            }
            if (!string2.equals("")) {
                n2 = DepositorMetadataManager.this.metadata_checklist_model.size();
                for (n = 0; n < n2; ++n) {
                    object2 = (MetadataElementEntry)DepositorMetadataManager.this.metadata_checklist_model.get(n);
                    object = "\"name\":\"" + ((MetadataElementEntry)object2).name + "\"";
                    if (string2.indexOf((String)object) != -1) {
                        ((MetadataElementEntry)object2).setSelected(true);
                        ((MetadataElementEntry)object2).type = this.getValueFromJSAssociatedArray(string2, ((MetadataElementEntry)object2).name, "type");
                    }
                    object = null;
                }
            } else {
                n2 = DepositorMetadataManager.this.metadata_checklist_model.size();
                for (n = 0; n < n2; ++n) {
                    object2 = (MetadataElementEntry)DepositorMetadataManager.this.metadata_checklist_model.get(n);
                    if (DEFAULT_METADATA_ELEMENTS.indexOf(((MetadataElementEntry)object2).name) == -1) continue;
                    ((MetadataElementEntry)object2).setSelected(true);
                    ((MetadataElementEntry)object2).type = TYPEOPTIONS[0];
                }
            }
        }

        private void buildPane() {
            String string = null;
            String string2 = null;
            int n = DepositorMetadataManager.this.metadata_checklist_model.size();
            for (int i = 0; i < n; ++i) {
                MetadataElementEntry metadataElementEntry = (MetadataElementEntry)DepositorMetadataManager.this.metadata_checklist_model.get(i);
                if (string == null) {
                    string = metadataElementEntry.namespace;
                    string2 = "coloring.collection_tree_background";
                } else if (!metadataElementEntry.namespace.equals(string)) {
                    string = metadataElementEntry.namespace;
                    String string3 = string2 = string2 == "coloring.collection_tree_background" ? "coloring.collection_heading_background" : "coloring.collection_tree_background";
                }
                if (metadataElementEntry.getGUIControl() != null) continue;
                MetadataElementControl metadataElementControl = metadataElementEntry.initGUIControl(string2);
                this.central_pane.add((Component)metadataElementControl, "North");
            }
        }

        private String getValueFromJSAssociatedArray(String string, String string2, String string3) {
            int n = string.indexOf(string3, string.indexOf(string2));
            if (n == -1) {
                return null;
            }
            if ((n = string.indexOf("\":\"", n)) == -1) {
                return null;
            }
            return string.substring(n += 3, string.indexOf("\"", n));
        }
    }
}

