/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.TestingPreparation;

public class DatabaseTypeManager {
    private static Dimension DIALOG_SIZE = new Dimension(600, 280);
    public static final String DATABASE_TYPE_GDBM = "gdbm";
    public static final String DATABASE_TYPE_JDBM = "jdbm";
    public static final String DATABASE_TYPE_SQLITE = "sqlite";
    public static final String DATABASE_TYPE_GDBM_STR = "GDBM";
    public static final String DATABASE_TYPE_JDBM_STR = "JDBM";
    public static final String DATABASE_TYPE_SQLITE_STR = "SQLITE";
    public static final String[] DATABASE_TYPES = new String[]{"gdbm", "jdbm", "sqlite"};
    private EventListenerList listeners = null;
    public CollectionMeta database_type_meta = new CollectionMeta(CollectionDesignManager.collect_config.getDatabaseType());
    private Control controls = null;
    protected DatabaseTypeManager manager = null;

    public DatabaseTypeManager() {
        if (this.getDatabaseType().equals("")) {
            this.database_type_meta.setValue(DATABASE_TYPE_GDBM);
        }
        this.listeners = new EventListenerList();
        this.manager = this;
    }

    public void addDatabaseTypeListener(DatabaseTypeListener databaseTypeListener) {
        this.listeners.add(DatabaseTypeListener.class, databaseTypeListener);
    }

    protected void notifyListeners(String string) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != DatabaseTypeListener.class) continue;
            ((DatabaseTypeListener)objectArray[i + 1]).databaseTypeChanged(string);
        }
        objectArray = null;
    }

    public void promptForNewDatabaseType() {
        DatabaseTypePrompt databaseTypePrompt = new DatabaseTypePrompt(this.database_type_meta.getValue(true));
    }

    public boolean isGDBM() {
        return this.getDatabaseType().equals(DATABASE_TYPE_GDBM);
    }

    public boolean isJDBM() {
        return this.getDatabaseType().equals(DATABASE_TYPE_JDBM);
    }

    public boolean isSQLITE() {
        return this.getDatabaseType().equals(DATABASE_TYPE_SQLITE);
    }

    public String getDatabaseType() {
        return this.database_type_meta.getValue(true);
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new DatabaseTypeControl();
        }
        return this.controls;
    }

    private class DatabaseTypePrompt
    extends ModalDialog {
        private JDialog self;
        private JRadioButton gdbm_button;
        private JRadioButton jdbm_button;
        private JRadioButton sqlite_button;
        private JTextArea description_textarea;
        JButton ok_button;
        JButton cancel_button;

        public DatabaseTypePrompt(String string) {
            super((Frame)Gatherer.g_man, true);
            this.gdbm_button = null;
            this.jdbm_button = null;
            this.sqlite_button = null;
            this.description_textarea = null;
            this.ok_button = null;
            this.cancel_button = null;
            this.self = this;
            this.setSize(DIALOG_SIZE);
            this.setTitle(Dictionary.get("CDM.DatabaseTypeManager.Title"));
            this.setComponentOrientation(Dictionary.getOrientation());
            this.gdbm_button = new JRadioButton(DatabaseTypeManager.DATABASE_TYPE_GDBM_STR);
            this.gdbm_button.setComponentOrientation(Dictionary.getOrientation());
            this.gdbm_button.setActionCommand(DatabaseTypeManager.DATABASE_TYPE_GDBM);
            this.jdbm_button = new JRadioButton(DatabaseTypeManager.DATABASE_TYPE_JDBM_STR);
            this.jdbm_button.setComponentOrientation(Dictionary.getOrientation());
            this.jdbm_button.setActionCommand(DatabaseTypeManager.DATABASE_TYPE_JDBM);
            this.sqlite_button = new JRadioButton(DatabaseTypeManager.DATABASE_TYPE_SQLITE_STR);
            this.sqlite_button.setComponentOrientation(Dictionary.getOrientation());
            this.sqlite_button.setActionCommand(DatabaseTypeManager.DATABASE_TYPE_SQLITE);
            DatabaseTypeButtonListener databaseTypeButtonListener = new DatabaseTypeButtonListener();
            this.gdbm_button.addActionListener(databaseTypeButtonListener);
            this.jdbm_button.addActionListener(databaseTypeButtonListener);
            this.sqlite_button.addActionListener(databaseTypeButtonListener);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.gdbm_button);
            buttonGroup.add(this.jdbm_button);
            if (!Gatherer.GS3) {
                buttonGroup.add(this.sqlite_button);
            }
            if (string != null) {
                if (string.equals(DatabaseTypeManager.DATABASE_TYPE_GDBM)) {
                    this.gdbm_button.setSelected(true);
                } else if (string.equals(DatabaseTypeManager.DATABASE_TYPE_JDBM)) {
                    this.jdbm_button.setSelected(true);
                } else if (string.equals(DatabaseTypeManager.DATABASE_TYPE_SQLITE) && !Gatherer.GS3) {
                    this.sqlite_button.setSelected(true);
                }
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(3, 1));
            jPanel.add(this.gdbm_button);
            jPanel.add(this.jdbm_button);
            if (!Gatherer.GS3) {
                jPanel.add(this.sqlite_button);
            }
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            this.description_textarea = new JTextArea();
            this.description_textarea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.description_textarea.setText(Dictionary.get("CDM.DatabaseTypeManager." + string + "_Description"));
            this.description_textarea.setLineWrap(true);
            this.description_textarea.setWrapStyleWord(true);
            this.description_textarea.setComponentOrientation(Dictionary.getOrientation());
            this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
            this.cancel_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DatabaseTypePrompt.this.self.dispose();
                }
            });
            this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
            this.ok_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = DatabaseTypeManager.DATABASE_TYPE_GDBM;
                    if (DatabaseTypePrompt.this.gdbm_button.isSelected()) {
                        string = DatabaseTypeManager.DATABASE_TYPE_GDBM;
                    } else if (DatabaseTypePrompt.this.jdbm_button.isSelected()) {
                        string = DatabaseTypeManager.DATABASE_TYPE_JDBM;
                    } else if (DatabaseTypePrompt.this.sqlite_button.isSelected()) {
                        string = DatabaseTypeManager.DATABASE_TYPE_SQLITE;
                    }
                    if (!DatabaseTypeManager.this.database_type_meta.getValue(true).equals(string)) {
                        DatabaseTypeManager.this.manager.notifyListeners(string);
                        DatabaseTypeManager.this.database_type_meta.setValue(string);
                    }
                    DatabaseTypePrompt.this.self.dispose();
                }
            });
            this.ok_button.addActionListener(CollectionDesignManager.databasecol_change_listener);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(1, 2));
            jPanel2.add(this.ok_button);
            jPanel2.add(this.cancel_button);
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel3 = (JPanel)this.getContentPane();
            jPanel3.setOpaque(true);
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jPanel, "North");
            jPanel3.add((Component)new JScrollPane(this.description_textarea), "Center");
            jPanel3.add((Component)jPanel2, "South");
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            TestingPreparation.setIndividualSubcomponentNames(this, this.gdbm_button, this.jdbm_button, this.sqlite_button);
            Dimension dimension = Configuration.screen_size;
            this.setLocation((dimension.width - DIALOG_SIZE.width) / 2, (dimension.height - DIALOG_SIZE.height) / 2);
            this.setVisible(true);
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }

        public void destroy() {
        }

        private class DatabaseTypeButtonListener
        implements ActionListener {
            private DatabaseTypeButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseTypePrompt.this.description_textarea.setText(Dictionary.get("CDM.DatabaseTypeManager." + actionEvent.getActionCommand() + "_Description"));
            }
        }
    }

    private class DatabaseTypeControl
    extends JPanel
    implements Control,
    DatabaseTypeListener {
        JLabel label = null;
        JButton change_button = null;

        public DatabaseTypeControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            this.label = new JLabel(Dictionary.get("CDM.DatabaseTypeManager.Current_Type", this.getDatabaseTypeString(DatabaseTypeManager.this.getDatabaseType())));
            this.label.setComponentOrientation(Dictionary.getOrientation());
            this.change_button = new GLIButton(Dictionary.get("CDM.DatabaseTypeManager.Change"), Dictionary.get("CDM.DatabaseTypeManager.Change_Tooltip"));
            this.change_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DatabaseTypeManager.this.promptForNewDatabaseType();
                }
            });
            jPanel2.setLayout(new BorderLayout(10, 10));
            jPanel2.add((Component)this.label, "Center");
            jPanel2.add((Component)this.change_button, "After");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel2, "After");
            DatabaseTypeManager.this.manager.addDatabaseTypeListener(this);
            TestingPreparation.setNamesRecursivelyForControl(this);
        }

        @Override
        public void loseFocus() {
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void destroy() {
        }

        private String getDatabaseTypeString(String string) {
            if (string.equals(DatabaseTypeManager.DATABASE_TYPE_GDBM)) {
                return DatabaseTypeManager.DATABASE_TYPE_GDBM_STR;
            }
            if (string.equals(DatabaseTypeManager.DATABASE_TYPE_JDBM)) {
                return DatabaseTypeManager.DATABASE_TYPE_JDBM_STR;
            }
            if (string.equals(DatabaseTypeManager.DATABASE_TYPE_SQLITE)) {
                return DatabaseTypeManager.DATABASE_TYPE_SQLITE_STR;
            }
            return "";
        }

        @Override
        public void databaseTypeChanged(String string) {
            this.label.setText(Dictionary.get("CDM.DatabaseTypeManager.Current_Type", this.getDatabaseTypeString(string)));
        }
    }

    public static interface DatabaseTypeListener
    extends EventListener {
        public void databaseTypeChanged(String var1);
    }
}

