/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectCfgReadWrite;
import org.greenstone.gatherer.cdm.CollectionConfigXMLReadWrite;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.greenstone.LocalLibraryServer;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.util.DOMTree;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectionConfiguration {
    public static final String ENCODING = "UTF-8";
    public static final String NEWLINE_ELEMENT = "NewLine";
    private static Document document;
    private static String saved_config_file_string;
    private File collect_config_file;
    private String collect_config_filename;
    public static final String[] COMMAND_ORDER;

    public CollectionConfiguration(File file) {
        this.load(file);
    }

    private void load(File file) {
        this.collect_config_file = file;
        this.collect_config_filename = file.getName();
        document = XMLTools.parseXMLFile("xml/CollectionConfig.xml", true);
        String string = this.collect_config_filename.toLowerCase();
        if (string.endsWith(".cfg")) {
            saved_config_file_string = CollectCfgReadWrite.parse(file, document);
        } else if (string.endsWith(".xml")) {
            CollectionConfigXMLReadWrite.parse(file, document);
        }
    }

    public void reload() {
        this.load(this.collect_config_file);
    }

    public static Element createElement(String string) {
        return document.createElement(string);
    }

    public static Node findInsertionPoint(Element element) {
        int n;
        String string = element.getNodeName();
        Element element2 = document.getDocumentElement();
        NodeList nodeList = element2.getElementsByTagName(string);
        if (nodeList.getLength() != 0) {
            if (string.equals("CollectionMetadata")) {
                if (element.getAttribute("special").equals("true")) {
                    int n2 = 0;
                    Element element3 = (Element)nodeList.item(n2);
                    Element element4 = (Element)element3.getNextSibling();
                    while (element4.getAttribute("special").equals("true")) {
                        element3 = (Element)nodeList.item(++n2);
                        element4 = (Element)element3.getNextSibling();
                    }
                    if (element4.getNodeName().equals(NEWLINE_ELEMENT)) {
                        Element element5 = document.createElement(NEWLINE_ELEMENT);
                        element2.insertBefore(element5, element4);
                    }
                    return element4;
                }
                int n3 = 0;
                string = element.getAttribute("name");
                boolean bl = false;
                Element element6 = (Element)nodeList.item(n3);
                while (element6.getAttribute("special").equals("true")) {
                    element6 = (Element)nodeList.item(++n3);
                }
                while (!bl && element6 != null) {
                    if (element6.getAttribute("name").equals(string)) {
                        bl = true;
                        continue;
                    }
                    element6 = (Element)nodeList.item(++n3);
                }
                if (bl) {
                    Element element7 = element6;
                    Element element8 = (Element)nodeList.item(++n3);
                    while (element8 != null && element8.getAttribute("name").equals(string)) {
                        element7 = element8;
                        element8 = (Element)nodeList.item(++n3);
                    }
                    return element7.getNextSibling();
                }
                Element element9 = (Element)nodeList.item(nodeList.getLength() - 1);
                return element9.getNextSibling();
            }
            Element element10 = (Element)nodeList.item(nodeList.getLength() - 1);
            Node node = element10.getNextSibling();
            if (node != null && node.getNodeName().equals(NEWLINE_ELEMENT)) {
                Element element11 = document.createElement(NEWLINE_ELEMENT);
                element2.insertBefore(element11, node);
            }
            return node;
        }
        int n4 = -1;
        for (n = 0; n4 == -1 && n < COMMAND_ORDER.length; ++n) {
            if (!COMMAND_ORDER[n].equals(string)) continue;
            n4 = n;
        }
        for (n = n4 - 1; n >= 0; --n) {
            nodeList = element2.getElementsByTagName(COMMAND_ORDER[n]);
            if (nodeList.getLength() <= 0) continue;
            Element element12 = (Element)nodeList.item(nodeList.getLength() - 1);
            Node node = element12.getNextSibling();
            if (node != null && node.getNodeName().equals(NEWLINE_ELEMENT)) {
                Element element13 = document.createElement(NEWLINE_ELEMENT);
                element2.insertBefore(element13, node);
            }
            return node;
        }
        for (int i = n4 + 1; i < COMMAND_ORDER.length; ++i) {
            nodeList = element2.getElementsByTagName(COMMAND_ORDER[i]);
            if (nodeList.getLength() <= 0) continue;
            Element element14 = (Element)nodeList.item(0);
            Node node = element14.getPreviousSibling();
            if (node != null && node.getNodeName().equals(NEWLINE_ELEMENT)) {
                Element element15 = document.createElement(NEWLINE_ELEMENT);
                element2.insertBefore(element15, node);
            }
            return node;
        }
        return null;
    }

    public static NodeList getElementsByTagName(String string) {
        return document.getDocumentElement().getElementsByTagName(string);
    }

    public Element getDocumentElement() {
        return document.getDocumentElement();
    }

    public void display() {
        JDialog jDialog = new JDialog(Gatherer.g_man, "Collection Configuration", false);
        jDialog.setSize(400, 400);
        JPanel jPanel = (JPanel)jDialog.getContentPane();
        final DOMTree dOMTree = new DOMTree(document);
        GLIButton gLIButton = new GLIButton("Refresh Tree");
        gLIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dOMTree.setDocument(document);
            }
        });
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(dOMTree), "Center");
        jPanel.add((Component)gLIButton, "South");
        jDialog.setVisible(true);
    }

    public File getFile() {
        return this.collect_config_file;
    }

    public Element getCreator() {
        Element element = CollectionConfiguration.getOrCreateElementByTagName("Creator", null, null);
        element.setAttribute("name", "creator");
        element.setAttribute("special", "true");
        return element;
    }

    public Element getMaintainer() {
        Element element = CollectionConfiguration.getOrCreateElementByTagName("Maintainer", null, null);
        element.setAttribute("name", "maintainer");
        element.setAttribute("special", "true");
        return element;
    }

    public Element getLanguages() {
        return CollectionConfiguration.getOrCreateElementByTagName("Languages", null, null);
    }

    public Element getLanguageMetadata() {
        return CollectionConfiguration.getOrCreateElementByTagName("LanguageMetadata", null, null);
    }

    public Element getLevels() {
        return CollectionConfiguration.getOrCreateElementByTagName("IndexOption", "name", "levels");
    }

    public Element getLevelDefault() {
        return CollectionConfiguration.getOrCreateElementByTagName("DefaultIndexOption", "name", "defaultlevel");
    }

    public Element getIndexOptions() {
        return CollectionConfiguration.getOrCreateElementByTagName("IndexOption", "name", "indexoptions");
    }

    public Element getMGIndexes() {
        return CollectionConfiguration.getOrCreateElementByTagName("Indexes", "mgpp_enabled", "false");
    }

    public Element getMGPPIndexes() {
        return CollectionConfiguration.getOrCreateElementByTagName("Indexes", "mgpp_enabled", "true");
    }

    public Element getSorts() {
        return CollectionConfiguration.getOrCreateElementByTagName("Sorts", null, null);
    }

    public Element getFacets() {
        return CollectionConfiguration.getOrCreateElementByTagName("Facets", null, null);
    }

    public Element getPublic() {
        Element element = CollectionConfiguration.getOrCreateElementByTagName("Public", null, null);
        element.setAttribute("name", "public");
        element.setAttribute("special", "true");
        return element;
    }

    public Element getBuildType() {
        Element element = CollectionConfiguration.getOrCreateElementByTagName("BuildType", null, null);
        element.setAttribute("name", "buildtype");
        element.setAttribute("special", "true");
        return element;
    }

    public Element getDatabaseType() {
        Element element = CollectionConfiguration.getOrCreateElementByTagName("infodbtype", null, null);
        element.setAttribute("name", "infodbtype");
        element.setAttribute("special", "true");
        return element;
    }

    public Element getSubIndexes() {
        return CollectionConfiguration.getOrCreateElementByTagName("SubcollectionIndexes", null, null);
    }

    public Element getSuperCollection() {
        return CollectionConfiguration.getOrCreateElementByTagName("Supercollection", null, null);
    }

    public boolean ready() {
        return document != null;
    }

    private static Element getOrCreateElementByTagName(String string, String string2, String string3) {
        Node node;
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n > 0) {
            if (string2 == null) {
                element = null;
                return (Element)nodeList.item(0);
            }
            for (int i = 0; i < n; ++i) {
                node = (Element)nodeList.item(i);
                if (node.getAttribute(string2).equals(string3)) {
                    element = null;
                    return node;
                }
                node = null;
            }
        }
        Element element2 = document.createElement(string);
        if (string2 != null) {
            element2.setAttribute(string2, string3);
        }
        if ((node = CollectionConfiguration.findInsertionPoint(element2)) != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
        element = null;
        return element2;
    }

    private void write(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string, 0, string.length());
    }

    public void saveIfNecessary() {
        Object object;
        Object object2;
        Object object3;
        String string = null;
        string = Gatherer.GS3 ? CollectionConfigXMLReadWrite.generateStringVersion(document) : CollectCfgReadWrite.generateStringVersion(document);
        if (saved_config_file_string != null && saved_config_file_string.equals(string)) {
            DebugStream.println(this.collect_config_filename + " file hasn't changed so no save necessary...");
            return;
        }
        DebugStream.println(this.collect_config_filename + " file has changed, saving now...");
        String string2 = CollectionManager.getLoadedCollectionName(true);
        boolean bl = false;
        if (Gatherer.c_man.built() && LocalLibraryServer.isRunning()) {
            LocalLibraryServer.releaseCollection(string2);
            bl = true;
        }
        if (this.collect_config_file.exists()) {
            if (Gatherer.GS3) {
                object3 = "collectionConfig.xml";
                object2 = "collectionConfig.bak";
            } else {
                object3 = "collect.cfg";
                object2 = "collect.bak";
            }
            object = new File(this.collect_config_file.getParentFile(), (String)object3);
            File file = new File(this.collect_config_file.getParentFile(), (String)object2);
            if (file.exists()) {
                file.delete();
            }
            if (!((File)object).renameTo(file)) {
                System.err.println("Warning: can't rename " + (String)object3 + " to " + (String)object2);
            }
        }
        if (Gatherer.GS3) {
            CollectionConfigXMLReadWrite.save(this.collect_config_file, document);
        } else {
            try {
                object3 = new FileOutputStream(this.collect_config_file);
                object2 = new OutputStreamWriter((OutputStream)object3, ENCODING);
                object = new BufferedWriter((Writer)object2);
                ((Writer)object).write(string);
                ((BufferedWriter)object).close();
            }
            catch (Exception exception) {
                DebugStream.println("Error in CollectionConfiguration.save(): " + exception);
                DebugStream.printStackTrace(exception);
            }
        }
        saved_config_file_string = string;
        if (Gatherer.isGsdlRemote) {
            Gatherer.remoteGreenstoneServer.uploadCollectionFile(string2, this.collect_config_file);
        }
        if (bl) {
            LocalLibraryServer.addCollection(string2);
        }
    }

    static {
        saved_config_file_string = null;
        COMMAND_ORDER = new String[]{"Creator", "Maintainer", "Public", "BuildType", "Plugin", "Indexes", "DefaultIndex", "Sorts", "defaultSort", "Facets", "IndexOption", "DefaultIndexOption", "Languages", "DefaultLanguage", "LanguageMetadata", "Subcollection", "SubcollectionIndexes", "DefaultSubcollection", "Supercollection", "Classify", "Format", "SearchMetadata", "CollectionMetadata"};
    }
}

