/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CommandTokenizer;
import org.greenstone.gatherer.util.Codec;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectCfgReadWrite {
    public static String toString(Element element) {
        String string = element.getNodeName();
        if (string.equals("Classify")) {
            return CollectCfgReadWrite.classifyToString(element);
        }
        if (string.equals("Format")) {
            return CollectCfgReadWrite.formatToString(element);
        }
        if (string.equals("Indexes")) {
            return CollectCfgReadWrite.indexesToString(element);
        }
        if (string.equals("DefaultIndex")) {
            return CollectCfgReadWrite.indexDefaultToString(element);
        }
        if (string.equals("Sorts")) {
            return CollectCfgReadWrite.sortsToString(element);
        }
        if (string.equals("defaultSort")) {
            return CollectCfgReadWrite.sortDefaultToString(element);
        }
        if (string.equals("Languages")) {
            return CollectCfgReadWrite.languagesToString(element);
        }
        if (string.equals("DefaultLanguage")) {
            return CollectCfgReadWrite.languageDefaultToString(element);
        }
        if (string.equals("LanguageMetadata")) {
            return CollectCfgReadWrite.languageMetadataToString(element);
        }
        if (string.equals("IndexOption")) {
            return CollectCfgReadWrite.indexOptionsToString(element);
        }
        if (string.equals("DefaultIndexOption")) {
            return CollectCfgReadWrite.indexOptionDefaultToString(element);
        }
        if (string.equals("CollectionMetadata")) {
            return CollectCfgReadWrite.metadataToString(element);
        }
        if (string.equals("Creator")) {
            return CollectCfgReadWrite.metadataToString(element);
        }
        if (string.equals("Maintainer")) {
            return CollectCfgReadWrite.metadataToString(element);
        }
        if (string.equals("Public")) {
            return CollectCfgReadWrite.metadataToString(element);
        }
        if (string.equals("SearchMetadata")) {
            return CollectCfgReadWrite.metadataToString(element, true);
        }
        if (string.equals("BuildType")) {
            return CollectCfgReadWrite.metadataToString(element);
        }
        if (string.equals("infodbtype")) {
            return CollectCfgReadWrite.metadataToString(element);
        }
        if (string.equals("Plugin")) {
            return CollectCfgReadWrite.pluginToString(element);
        }
        if (string.equals("Subcollection")) {
            return CollectCfgReadWrite.subcollectionToString(element);
        }
        if (string.equals("DefaultSubcollection")) {
            return CollectCfgReadWrite.subcollectionDefaultIndexToString(element);
        }
        if (string.equals("SubcollectionIndexes")) {
            return CollectCfgReadWrite.subcollectionIndexesToString(element);
        }
        if (string.equals("Supercollection")) {
            return CollectCfgReadWrite.supercollectionToString(element);
        }
        if (string.equals("Unknown")) {
            return CollectCfgReadWrite.unknownToString(element);
        }
        return "";
    }

    private static String classifyToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("classify");
        stringBuffer.append("\t");
        stringBuffer.append(element.getAttribute("type"));
        NodeList nodeList = element.getElementsByTagName("Option");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.getAttribute("assigned").equals("true")) {
                stringBuffer.append(" ");
                stringBuffer.append("-");
                stringBuffer.append(element2.getAttribute("name"));
                String string = XMLTools.getValue(element2);
                if (string.length() > 0) {
                    stringBuffer.append(" ");
                    if (string.indexOf(" ") != -1) {
                        stringBuffer.append("\"");
                        stringBuffer.append(string);
                        stringBuffer.append("\"");
                    } else {
                        stringBuffer.append(string);
                    }
                }
                string = null;
            }
            element2 = null;
        }
        nodeList = null;
        return stringBuffer.toString();
    }

    private static String formatToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("format");
        stringBuffer.append(" ");
        stringBuffer.append(element.getAttribute("name"));
        stringBuffer.append(" ");
        String string = element.getAttribute("value");
        if (string.length() != 0) {
            stringBuffer.append(string);
        } else {
            string = Codec.transform(XMLTools.getValue(element), "DOM_TO_GREENSTONE");
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        string = null;
        return stringBuffer.toString();
    }

    private static String indexesToString(Element element) {
        NodeList nodeList;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        if (element.getAttribute("assigned").equals("false")) {
            stringBuffer.append("#");
            bl = true;
        }
        stringBuffer.append("indexes");
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("\t");
        }
        if ((nodeList = element.getElementsByTagName("Index")).getLength() == 0) {
            return "";
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2;
            int n2;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("level");
            if (string.length() > 0) {
                stringBuffer.append(string);
                stringBuffer.append(":");
            }
            if ((n2 = (nodeList2 = element2.getElementsByTagName("content")).getLength()) == 0) {
                return null;
            }
            for (int j = 0; j < n2; ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string2 = element3.getAttribute("name");
                stringBuffer.append(string2);
                string2 = null;
                if (j < n2 - 1) {
                    stringBuffer.append(",");
                }
                element3 = null;
            }
            if (i < n - 1) {
                stringBuffer.append(" ");
            }
            nodeList2 = null;
            element2 = null;
        }
        nodeList = null;
        return stringBuffer.toString();
    }

    private static String indexDefaultToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (element.getAttribute("assigned").equals("false")) {
            stringBuffer.append("#");
        }
        stringBuffer.append("defaultindex");
        stringBuffer.append("\t");
        if (!element.getAttribute("level").equals("")) {
            stringBuffer.append(element.getAttribute("level"));
            stringBuffer.append(":");
        }
        NodeList nodeList = element.getElementsByTagName("content");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("name");
            stringBuffer.append(string);
            string = null;
            if (i < n - 1) {
                stringBuffer.append(",");
            }
            element2 = null;
        }
        nodeList = null;
        return stringBuffer.toString();
    }

    private static String sortsToString(Element element) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        if (element.getAttribute("assigned").equals("false")) {
            System.err.println("sorts not assigned, returning false");
            return "";
        }
        stringBuffer.append("sortfields");
        stringBuffer.append("\t");
        NodeList nodeList = element.getElementsByTagName("Sort");
        if (nodeList.getLength() == 0) {
            return "";
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagName("content");
            int n2 = nodeList2.getLength();
            if (n2 == 0) {
                return null;
            }
            for (int j = 0; j < n2; ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string = element3.getAttribute("name");
                stringBuffer.append(string);
                string = null;
                if (j < n2 - 1) {
                    stringBuffer.append(",");
                }
                element3 = null;
            }
            if (i < n - 1) {
                stringBuffer.append(" ");
            }
            nodeList2 = null;
            element2 = null;
        }
        nodeList = null;
        return stringBuffer.toString();
    }

    private static String sortDefaultToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (element.getAttribute("assigned").equals("false")) {
            return "";
        }
        stringBuffer.append("defaultsort");
        stringBuffer.append("\t");
        NodeList nodeList = element.getElementsByTagName("content");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("name");
            stringBuffer.append(string);
            string = null;
            if (i < n - 1) {
                stringBuffer.append(",");
            }
            element2 = null;
        }
        nodeList = null;
        return stringBuffer.toString();
    }

    private static String languagesToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("languages");
        stringBuffer.append("\t");
        NodeList nodeList = element.getElementsByTagName("Language");
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            stringBuffer.append(element2.getAttribute("name"));
            if (i >= n - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String languageDefaultToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("defaultlanguage");
        stringBuffer.append("\t");
        stringBuffer.append(element.getAttribute("name"));
        return stringBuffer.toString();
    }

    private static String languageMetadataToString(Element element) {
        if (!element.getAttribute("assigned").equals("true")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("languagemetadata");
        stringBuffer.append("\t");
        String string = element.getAttribute("name");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String indexOptionsToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (element.getAttribute("assigned").equals("false")) {
            stringBuffer.append("#");
        }
        stringBuffer.append(element.getAttribute("name"));
        stringBuffer.append("\t");
        NodeList nodeList = element.getElementsByTagName("Option");
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            stringBuffer.append(element2.getAttribute("name"));
            stringBuffer.append(" ");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private static String indexOptionDefaultToString(Element element) {
        if (element.getAttribute("value").equals("")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (element.getAttribute("assigned").equals("false")) {
            stringBuffer.append("#");
        }
        stringBuffer.append(element.getAttribute("name"));
        stringBuffer.append("\t");
        stringBuffer.append(element.getAttribute("value"));
        return stringBuffer.toString();
    }

    private static String metadataToString(Element element) {
        return CollectCfgReadWrite.metadataToString(element, false);
    }

    private static String metadataToString(Element element, boolean bl) {
        String string = XMLTools.getValue(element);
        if (string.equals("")) {
            return "";
        }
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = element.getAttribute("name");
        if (string2.equals("maintainer") || string2.equals("buildtype") || string2.equals("infodbtype")) {
            stringBuffer.append(string2);
            stringBuffer.append("\t");
            bl2 = true;
        } else if (string2.equals("creator") || string2.equals("public")) {
            stringBuffer.append(string2);
            stringBuffer.append("\t");
            stringBuffer.append("\t");
            bl2 = true;
        } else {
            stringBuffer.append("collectionmeta");
            stringBuffer.append("\t");
            if (bl) {
                stringBuffer.append(".");
            }
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            String string3 = element.getAttribute("language");
            stringBuffer.append("[");
            stringBuffer.append("l=");
            stringBuffer.append(string3);
            stringBuffer.append("]");
            stringBuffer.append(" ");
        }
        string2 = null;
        string = Codec.transform(string, "DOM_TO_GREENSTONE");
        if (bl2) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        string = null;
        return stringBuffer.toString();
    }

    private static String searchtypeToString(Element element) {
        if (element.getAttribute("assigned").equals("true")) {
            StringBuffer stringBuffer = new StringBuffer("searchtype");
            stringBuffer.append("\t");
            NodeList nodeList = element.getElementsByTagName("content");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                stringBuffer.append(element2.getAttribute("name"));
                stringBuffer.append(" ");
            }
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return null;
    }

    private static String subcollectionToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("subcollection");
        stringBuffer.append(" ");
        stringBuffer.append(element.getAttribute("name"));
        stringBuffer.append(" ");
        stringBuffer.append("\t");
        stringBuffer.append("\"");
        if (element.getAttribute("type").equals("exclude")) {
            stringBuffer.append("!");
        }
        stringBuffer.append(element.getAttribute("content"));
        stringBuffer.append("/");
        stringBuffer.append(XMLTools.getValue(element));
        stringBuffer.append("/");
        String string = element.getAttribute("options");
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        string = null;
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private static String subcollectionDefaultIndexToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("defaultsubcollection");
        stringBuffer.append("\t");
        NodeList nodeList = element.getElementsByTagName("content");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            stringBuffer.append(element2.getAttribute("name"));
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private static String subcollectionIndexesToString(Element element) {
        StringBuffer stringBuffer = new StringBuffer("indexsubcollections");
        stringBuffer.append("\t");
        NodeList nodeList = element.getElementsByTagName("Index");
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            NodeList nodeList2 = element2.getElementsByTagName("content");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Element element3 = (Element)nodeList2.item(j);
                stringBuffer.append(element3.getAttribute("name"));
                if (j >= n2 - 1) continue;
                stringBuffer.append(",");
            }
            if (i >= n - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String supercollectionToString(Element element) {
        NodeList nodeList = element.getElementsByTagName("Collection");
        int n = nodeList.getLength();
        if (n > 1) {
            StringBuffer stringBuffer = new StringBuffer("supercollection");
            stringBuffer.append("\t");
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                stringBuffer.append(element2.getAttribute("name"));
                if (i >= n - 1) continue;
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private static String unknownToString(Element element) {
        return XMLTools.getValue(element);
    }

    public static String parse(File file, Document document) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            Element element;
            StringBuffer stringBuffer = new StringBuffer();
            Element element2 = document.getDocumentElement();
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                stringBuffer.append(string + "\n");
                boolean bl3 = true;
                element = null;
                string = string.trim();
                boolean bl4 = false;
                while (!bl4 && string.endsWith("\\")) {
                    object = bufferedReader.readLine();
                    if (object != null) {
                        if (((String)(object = ((String)object).trim())).length() > 0) {
                            string = string.substring(0, string.lastIndexOf("\\"));
                            string = string + (String)object;
                        }
                        object = null;
                        continue;
                    }
                    bl4 = true;
                }
                if (string.endsWith("\\")) {
                    string = string.substring(0, string.lastIndexOf("\\"));
                }
                if (string.length() != 0) {
                    object = new CommandTokenizer(string, bufferedReader);
                    String string2 = ((CommandTokenizer)object).nextToken().toLowerCase();
                    if (element == null && string2.equals("classify")) {
                        element = CollectCfgReadWrite.parseClassify(string, document);
                    }
                    if (element == null && string2.equals("format")) {
                        element = CollectCfgReadWrite.parseFormat((CommandTokenizer)object, document);
                    }
                    if (element == null && (string2.equals("indexes") || string2.equals("#indexes"))) {
                        element = CollectCfgReadWrite.parseIndex(string, document);
                    }
                    if (element == null && (string2.equals("defaultindex") || string2.equals("#defaultindex"))) {
                        element = CollectCfgReadWrite.parseIndexDefault(string, document);
                    }
                    if (element == null && string2.equals("sortfields")) {
                        element = CollectCfgReadWrite.parseSortfields(string, document);
                    }
                    if (element == null && string2.equals("defaultsort")) {
                        element = CollectCfgReadWrite.parseSortfieldDefault(string, document);
                    }
                    if (element == null && string2.equals("languages")) {
                        element = CollectCfgReadWrite.parseLanguage(string, document);
                    }
                    if (element == null && string2.equals("defaultlanguage")) {
                        element = CollectCfgReadWrite.parseLanguageDefault(string, document);
                    }
                    if (element == null && string2.equals("languagemetadata")) {
                        element = CollectCfgReadWrite.parseLanguageMetadata(string, document);
                    }
                    if (element == null && string2.equals("levels")) {
                        element = CollectCfgReadWrite.parseIndexOptions(string, document, "levels", true);
                    }
                    if (element == null && string2.equals("#levels")) {
                        element = CollectCfgReadWrite.parseIndexOptions(string, document, "levels", false);
                    }
                    if (element == null && string2.equals("defaultlevel")) {
                        element = CollectCfgReadWrite.parseIndexOptionDefault(string, document, "defaultlevel", true);
                    }
                    if (element == null && string2.equals("#defaultlevel")) {
                        element = CollectCfgReadWrite.parseIndexOptionDefault(string, document, "defaultlevel", false);
                    }
                    if (element == null && string2.equals("indexoptions")) {
                        element = CollectCfgReadWrite.parseIndexOptions(string, document, "indexoptions", true);
                    }
                    if (element == null && string2.equals("#indexoptions")) {
                        element = CollectCfgReadWrite.parseIndexOptions(string, document, "indexoptions", false);
                    }
                    if (element == null && string2.equals("collectionmeta")) {
                        element = CollectCfgReadWrite.parseMetadata((CommandTokenizer)object, document);
                    }
                    if (element == null && (string2.equals("public") || string2.equals("creator") || string2.equals("maintainer") || string2.equals("buildtype") || string2.equals("infodbtype"))) {
                        element = CollectCfgReadWrite.parseMetadataSpecial(string, document);
                        if (string2.equals("buildtype")) {
                            bl2 = true;
                        }
                    }
                    if (element == null && string2.equals("plugin")) {
                        element = CollectCfgReadWrite.parsePlugin(string, document);
                    }
                    if (element == null && string2.equals("searchtype")) {
                        element = CollectCfgReadWrite.parseSearchType(string, document);
                        bl = true;
                    }
                    if (element == null && string2.equals("subcollection")) {
                        element = CollectCfgReadWrite.parseSubCollection(string, document);
                    }
                    if (element == null && string2.equals("defaultsubcollection")) {
                        element = CollectCfgReadWrite.parseSubCollectionDefaultIndex(string, document);
                    }
                    if (element == null && string2.equals("indexsubcollections")) {
                        element = CollectCfgReadWrite.parseSubCollectionIndex(string, document);
                    }
                    if (element == null && (string2.equals("supercollection") || string2.equals("ccs"))) {
                        element = CollectCfgReadWrite.parseSuperCollection(string, document);
                    }
                    string2 = null;
                    if (element == null) {
                        element = document.createElement("Unknown");
                        XMLTools.setValue(element, string);
                    }
                } else {
                    element = document.createElement("NewLine");
                }
                element2.appendChild(element);
            }
            if (!bl2) {
                Node node;
                String string3 = "mg";
                if (bl) {
                    string3 = "mgpp";
                }
                if ((node = CollectionConfiguration.findInsertionPoint(element = CollectCfgReadWrite.parseMetadataSpecial("buildtype  " + string3, document))) != null) {
                    element2.insertBefore(element, node);
                } else {
                    element2.appendChild(element);
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            DebugStream.println("Error in CollectionConfiguration.parse(java.io.File): " + exception);
            DebugStream.printStackTrace(exception);
            return null;
        }
    }

    public static HashMap parseArguments(CommandTokenizer commandTokenizer) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        String string2 = null;
        while (commandTokenizer.hasMoreTokens() || string != null) {
            if (string == null) {
                string = commandTokenizer.nextToken();
            }
            if (commandTokenizer.hasMoreTokens()) {
                string2 = commandTokenizer.nextToken();
                if (string2.startsWith("-") && string2.indexOf(" ") == -1) {
                    hashMap.put(string, null);
                    string = string2;
                    continue;
                }
                hashMap.put(string, string2);
                string = null;
                continue;
            }
            hashMap.put(string, null);
            string = null;
        }
        return hashMap;
    }

    private static Element parseClassify(String string, Document document) {
        Element element = null;
        try {
            CommandTokenizer commandTokenizer = new CommandTokenizer(string);
            if (commandTokenizer.countTokens() >= 2) {
                element = document.createElement("Classify");
                commandTokenizer.nextToken();
                element.setAttribute("type", commandTokenizer.nextToken());
                HashMap hashMap = CollectCfgReadWrite.parseArguments(commandTokenizer);
                for (String string2 : hashMap.keySet()) {
                    String string3 = (String)hashMap.get(string2);
                    Element element2 = document.createElement("Option");
                    element2.setAttribute("name", string2.substring(1));
                    if (string3 != null) {
                        if (string3.startsWith("\"") && string3.endsWith("\"")) {
                            string3 = string3.substring(1, string3.length() - 1);
                        }
                        XMLTools.setValue(element2, string3);
                    }
                    element2.setAttribute("assigned", "true");
                    element.appendChild(element2);
                    element2 = null;
                    string2 = null;
                    string3 = null;
                }
                Iterator iterator = null;
                hashMap = null;
            }
            commandTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseFormat(CommandTokenizer commandTokenizer, Document document) {
        Element element = null;
        try {
            element = document.createElement("Format");
            String string = commandTokenizer.nextToken();
            String string2 = commandTokenizer.nextToken();
            if (string != null && string2 != null) {
                element.setAttribute("name", string);
                if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false")) {
                    element.setAttribute("value", string2.toLowerCase());
                } else {
                    string2 = Codec.transform(string2, "GREENSTONE_TO_DOM");
                    XMLTools.setValue(element, string2);
                }
            } else {
                element = null;
            }
            string = null;
            string2 = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
            element = null;
        }
        return element;
    }

    private static Element parseIndex(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            element = document.createElement("Indexes");
            element.setAttribute("assigned", string2.equals("indexes") ? "true" : "false");
            string2 = null;
            if (!stringTokenizer.hasMoreTokens()) {
                element.setAttribute("assigned", "false");
                element.setAttribute("mgpp_enabled", "false");
                stringTokenizer = null;
                return element;
            }
            while (stringTokenizer.hasMoreTokens()) {
                Element element2 = document.createElement("Index");
                String string3 = stringTokenizer.nextToken();
                if (string3.indexOf(":") != -1) {
                    element2.setAttribute("level", string3.substring(0, string3.indexOf(":")));
                    string3 = string3.substring(string3.indexOf(":") + 1);
                    element.setAttribute("mgpp_enabled", "false");
                } else {
                    element.setAttribute("mgpp_enabled", "true");
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    Element element3 = document.createElement("content");
                    String string4 = stringTokenizer2.nextToken();
                    if (!(string4.indexOf(46) != -1 || string4.equals("text") || string4.equals("allfields") || string4.equals("metadata"))) {
                        string4 = "ex." + string4;
                    }
                    element3.setAttribute("name", string4);
                    element2.appendChild(element3);
                    element3 = null;
                }
                stringTokenizer2 = null;
                string3 = null;
                element.appendChild(element2);
                element2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return element;
    }

    private static Element parseIndexDefault(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 2) {
                element = document.createElement("DefaultIndex");
                element.setAttribute("assigned", stringTokenizer.nextToken().equals("defaultindex") ? "true" : "false");
                String string2 = stringTokenizer.nextToken();
                String string3 = "";
                if (string2.indexOf(":") != -1) {
                    string3 = string2.substring(0, string2.indexOf(":"));
                }
                element.setAttribute("level", string3);
                String string4 = string2;
                if (string2.indexOf(":") != -1) {
                    string4 = string2.substring(string2.indexOf(":") + 1);
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    Element element2 = document.createElement("content");
                    element2.setAttribute("name", stringTokenizer2.nextToken());
                    element.appendChild(element2);
                    element2 = null;
                }
                stringTokenizer2 = null;
                string4 = null;
                string4 = null;
                string2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseSortfields(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            element = document.createElement("Sorts");
            element.setAttribute("assigned", "true");
            string2 = null;
            if (!stringTokenizer.hasMoreTokens()) {
                element.setAttribute("assigned", "false");
                stringTokenizer = null;
                return element;
            }
            while (stringTokenizer.hasMoreTokens()) {
                Element element2 = document.createElement("Sort");
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    Element element3 = document.createElement("content");
                    String string4 = stringTokenizer2.nextToken();
                    if (string4.indexOf(46) == -1 && !string4.equals("rank") && !string4.equals("none")) {
                        string4 = "ex." + string4;
                    }
                    element3.setAttribute("name", string4);
                    element2.appendChild(element3);
                    element3 = null;
                }
                stringTokenizer2 = null;
                string3 = null;
                element.appendChild(element2);
                element2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return element;
    }

    private static Element parseSortfieldDefault(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 2) {
                String string2;
                element = document.createElement("defaultSort");
                element.setAttribute("assigned", stringTokenizer.nextToken().equals("defaultsort") ? "true" : "false");
                String string3 = string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    Element element2 = document.createElement("content");
                    element2.setAttribute("name", stringTokenizer2.nextToken());
                    element.appendChild(element2);
                    element2 = null;
                }
                stringTokenizer2 = null;
                string3 = null;
                string3 = null;
                string2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseLanguage(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                element = document.createElement("Languages");
                while (stringTokenizer.hasMoreTokens()) {
                    Element element2 = document.createElement("Language");
                    element2.setAttribute("name", stringTokenizer.nextToken());
                    element.appendChild(element2);
                    element2 = null;
                }
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseLanguageDefault(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 2) {
                element = document.createElement("DefaultLanguage");
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                element.setAttribute("name", string2);
                element.setAttribute("assigned", "true");
                string2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseLanguageMetadata(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 2) {
                element = document.createElement("LanguageMetadata");
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                if (string2.indexOf(46) == -1) {
                    string2 = "ex." + string2;
                }
                element.setAttribute("name", string2);
                element.setAttribute("assigned", "true");
                string2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseIndexOptions(String string, Document document, String string2, boolean bl) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                element = document.createElement("IndexOption");
                element.setAttribute("name", string2);
                element.setAttribute("assigned", bl ? "true" : "false");
                while (stringTokenizer.hasMoreTokens()) {
                    Element element2 = document.createElement("Option");
                    element2.setAttribute("name", stringTokenizer.nextToken());
                    element.appendChild(element2);
                    element2 = null;
                }
            }
            string3 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseIndexOptionDefault(String string, Document document, String string2, boolean bl) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                element = document.createElement("DefaultIndexOption");
                element.setAttribute("assigned", bl ? "true" : "false");
                element.setAttribute("name", string2);
                element.setAttribute("value", stringTokenizer.nextToken());
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseMetadata(CommandTokenizer commandTokenizer, Document document) {
        Element element = null;
        boolean bl = false;
        try {
            String string = commandTokenizer.nextToken();
            if (string.startsWith(".")) {
                bl = true;
                string = string.substring(1);
            }
            String string2 = commandTokenizer.nextToken();
            if (string != null && string2 != null) {
                String string3 = Configuration.getLanguage();
                if (string2.startsWith("[") && string2.endsWith("]")) {
                    string3 = string2.substring(string2.indexOf("l=") + 2, string2.length() - 1);
                    string2 = commandTokenizer.nextToken();
                }
                if (string2 != null) {
                    if (bl) {
                        element = document.createElement("SearchMetadata");
                        element.setAttribute("type", "search");
                    } else {
                        element = document.createElement("CollectionMetadata");
                    }
                    string2 = Codec.transform(string2, "GREENSTONE_TO_DOM");
                    element.setAttribute("name", string);
                    element.setAttribute("language", string3);
                    element.setAttribute("assigned", "true");
                    XMLTools.setValue(element, string2);
                } else {
                    element = null;
                }
                string3 = null;
            } else {
                element = null;
            }
            string = null;
            string2 = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
            element = null;
        }
        return element;
    }

    private static Element parseMetadataSpecial(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 2) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string2.equals("creator")) {
                    element = document.createElement("Creator");
                } else if (string2.equals("maintainer")) {
                    element = document.createElement("Maintainer");
                } else if (string2.equals("public")) {
                    element = document.createElement("Public");
                } else if (string2.equals("buildtype")) {
                    element = document.createElement("BuildType");
                } else if (string2.equals("infodbtype")) {
                    element = document.createElement("infodbtype");
                }
                if (element != null) {
                    element.setAttribute("name", string2);
                    element.setAttribute("language", "en");
                    element.setAttribute("special", "true");
                    element.setAttribute("assigned", "true");
                    if (string3.startsWith("\"") && string3.endsWith("\"")) {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    XMLTools.setValue(element, string3);
                }
                string3 = null;
                string2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parsePlugin(String string, Document document) {
        Element element = null;
        try {
            CommandTokenizer commandTokenizer = new CommandTokenizer(string);
            if (commandTokenizer.countTokens() >= 2) {
                element = document.createElement("Plugin");
                commandTokenizer.nextToken();
                String string2 = commandTokenizer.nextToken();
                string2 = Utility.ensureNewPluginName(string2);
                element.setAttribute("type", string2);
                HashMap hashMap = CollectCfgReadWrite.parseArguments(commandTokenizer);
                for (String string3 : hashMap.keySet()) {
                    String string4 = (String)hashMap.get(string3);
                    if (string2.equals("DirectoryPlugin") && string3.substring(1).equals("use_metadata_files")) continue;
                    Element element2 = document.createElement("Option");
                    element2.setAttribute("name", string3.substring(1));
                    element2.setAttribute("assigned", "true");
                    if (string4 != null) {
                        if (string4.startsWith("\"") && string4.endsWith("\"")) {
                            string4 = string4.substring(1, string4.length() - 1);
                        }
                        XMLTools.setValue(element2, string4);
                    }
                    element.appendChild(element2);
                    element2 = null;
                    string3 = null;
                    string4 = null;
                }
                string2 = null;
                Iterator iterator = null;
                hashMap = null;
            }
            commandTokenizer = null;
        }
        catch (Exception exception) {
            System.err.println("Malformed plugin statement");
            exception.printStackTrace();
        }
        return element;
    }

    private static Element parseSearchType(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                element = document.createElement("Format");
                element.setAttribute("name", "SearchTypes");
                String string2 = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = string2 + "," + stringTokenizer.nextToken();
                }
                string2 = Codec.transform(string2, "GREENSTONE_TO_DOM");
                XMLTools.setValue(element, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseSubCollection(String string, Document document) {
        Element element = null;
        try {
            CommandTokenizer commandTokenizer = new CommandTokenizer(string);
            if (commandTokenizer.countTokens() >= 3) {
                element = document.createElement("Subcollection");
                commandTokenizer.nextToken();
                element.setAttribute("name", commandTokenizer.nextToken());
                String string2 = commandTokenizer.nextToken();
                boolean bl = string2.startsWith("!");
                if (bl) {
                    string2 = string2.substring(1, string2.length());
                    element.setAttribute("type", "exclude");
                } else {
                    element.setAttribute("type", "include");
                }
                String[] stringArray = string2.split("\\/", 3);
                if (stringArray.length >= 2) {
                    String string3 = stringArray[0];
                    if (!string3.equals("Filename") && string3.indexOf(46) == -1) {
                        string3 = "ex." + string3;
                    }
                    element.setAttribute("content", string3);
                    XMLTools.setValue(element, stringArray[1]);
                    if (stringArray.length >= 3) {
                        element.setAttribute("options", stringArray[2]);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return element;
    }

    private static Element parseSubCollectionDefaultIndex(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() == 2) {
                element = document.createElement("DefaultSubcollection");
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    Element element2 = document.createElement("content");
                    element2.setAttribute("name", stringTokenizer2.nextToken());
                    element.appendChild(element2);
                    element2 = null;
                }
                stringTokenizer2 = null;
                string2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseSubCollectionIndex(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                element = document.createElement("SubcollectionIndexes");
            }
            while (stringTokenizer.hasMoreTokens()) {
                Element element2 = document.createElement("Index");
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    Element element3 = document.createElement("content");
                    element3.setAttribute("name", stringTokenizer2.nextToken());
                    element2.appendChild(element3);
                    element3 = null;
                }
                stringTokenizer2 = null;
                string2 = null;
                element.appendChild(element2);
                element2 = null;
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static Element parseSuperCollection(String string, Document document) {
        Element element = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() >= 3) {
                element = document.createElement("Supercollection");
                stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    Element element2 = document.createElement("Collection");
                    element2.setAttribute("name", stringTokenizer.nextToken());
                    element.appendChild(element2);
                    element2 = null;
                }
            }
            stringTokenizer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private static String pluginToString(Element element) {
        if (element.getAttribute("separator").equals("true")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("plugin");
        stringBuffer.append("\t");
        stringBuffer.append(element.getAttribute("type"));
        NodeList nodeList = element.getElementsByTagName("Option");
        int n = nodeList.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (element2.getAttribute("assigned").equals("true")) {
                    stringBuffer.append(" ");
                    stringBuffer.append("-");
                    stringBuffer.append(element2.getAttribute("name"));
                    String string = XMLTools.getValue(element2);
                    if (string.length() > 0) {
                        stringBuffer.append(" ");
                        if (string.indexOf(" ") != -1) {
                            stringBuffer.append("\"");
                            stringBuffer.append(string);
                            stringBuffer.append("\"");
                        } else {
                            stringBuffer.append(string);
                        }
                    }
                    string = null;
                }
                element2 = null;
            }
        }
        nodeList = null;
        return stringBuffer.toString();
    }

    public static String generateStringVersion(Document document) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getNodeName().equals("NewLine") && !bl) {
                stringBuffer.append("\n");
                bl = true;
                continue;
            }
            if (element.getAttribute("assigned").equals("false") && !element.getNodeName().equals("Indexes") && !element.getNodeName().equals("DefaultIndex") && !element.getNodeName().equals("IndexOption") && !element.getNodeName().equals("DefaultIndexOption") || (string = CollectCfgReadWrite.toString(element)) == null || string.length() <= 0) continue;
            stringBuffer.append(string + "\n");
            bl = false;
        }
        return stringBuffer.toString();
    }
}

