/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.TestingPreparation;

public class BuildTypeManager {
    private static Dimension DIALOG_SIZE = new Dimension(600, 280);
    public static final String BUILD_TYPE_MG = "mg";
    public static final String BUILD_TYPE_MGPP = "mgpp";
    public static final String BUILD_TYPE_LUCENE = "lucene";
    public static final String BUILD_TYPE_SOLR = "solr";
    public static final String BUILD_TYPE_MG_STR = "MG";
    public static final String BUILD_TYPE_MGPP_STR = "MGPP";
    public static final String BUILD_TYPE_LUCENE_STR = "Lucene";
    public static final String BUILD_TYPE_SOLR_STR = "SOLR";
    public static final String[] BUILD_TYPES = new String[]{"solr", "lucene", "mgpp", "mg"};
    private EventListenerList listeners = null;
    public CollectionMeta build_type_meta = new CollectionMeta(CollectionDesignManager.collect_config.getBuildType());
    private Control controls = null;
    protected BuildTypeManager manager = null;

    public BuildTypeManager() {
        if (this.getBuildType().equals("")) {
            this.build_type_meta.setValue(BUILD_TYPE_MG);
        }
        this.listeners = new EventListenerList();
        this.manager = this;
    }

    public void addBuildTypeListener(BuildTypeListener buildTypeListener) {
        this.listeners.add(BuildTypeListener.class, buildTypeListener);
    }

    protected void notifyListeners(String string) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != BuildTypeListener.class) continue;
            ((BuildTypeListener)objectArray[i + 1]).buildTypeChanged(string);
        }
        objectArray = null;
    }

    public void promptForNewBuildType() {
        BuildTypePrompt buildTypePrompt = new BuildTypePrompt(this.build_type_meta.getValue(true));
    }

    public boolean isMGPP() {
        return this.getBuildType().equals(BUILD_TYPE_MGPP);
    }

    public boolean isMG() {
        return this.getBuildType().equals(BUILD_TYPE_MG);
    }

    public boolean isLucene() {
        return this.getBuildType().equals(BUILD_TYPE_LUCENE);
    }

    public boolean isSOLR() {
        return this.getBuildType().equals(BUILD_TYPE_SOLR);
    }

    public String getBuildType() {
        return this.build_type_meta.getValue(true);
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new BuildTypeControl();
        }
        return this.controls;
    }

    private class BuildTypePrompt
    extends ModalDialog {
        private JDialog self;
        private JRadioButton mg_button;
        private JRadioButton mgpp_button;
        private JRadioButton lucene_button;
        private JRadioButton solr_button;
        private JTextArea description_textarea;
        JButton ok_button;
        JButton cancel_button;

        public BuildTypePrompt(String string) {
            super((Frame)Gatherer.g_man, true);
            this.mg_button = null;
            this.mgpp_button = null;
            this.lucene_button = null;
            this.solr_button = null;
            this.description_textarea = null;
            this.ok_button = null;
            this.cancel_button = null;
            this.self = this;
            this.setSize(DIALOG_SIZE);
            this.setTitle(Dictionary.get("CDM.BuildTypeManager.Title"));
            this.setComponentOrientation(Dictionary.getOrientation());
            BuildTypeButtonListener buildTypeButtonListener = new BuildTypeButtonListener();
            this.mg_button = new JRadioButton(BuildTypeManager.BUILD_TYPE_MG_STR);
            this.mg_button.setComponentOrientation(Dictionary.getOrientation());
            this.mg_button.setActionCommand(BuildTypeManager.BUILD_TYPE_MG);
            this.mg_button.addActionListener(buildTypeButtonListener);
            this.mgpp_button = new JRadioButton(BuildTypeManager.BUILD_TYPE_MGPP_STR);
            this.mgpp_button.setComponentOrientation(Dictionary.getOrientation());
            this.mgpp_button.setActionCommand(BuildTypeManager.BUILD_TYPE_MGPP);
            this.mgpp_button.addActionListener(buildTypeButtonListener);
            this.lucene_button = new JRadioButton(BuildTypeManager.BUILD_TYPE_LUCENE_STR);
            this.lucene_button.setComponentOrientation(Dictionary.getOrientation());
            this.lucene_button.setActionCommand(BuildTypeManager.BUILD_TYPE_LUCENE);
            this.lucene_button.addActionListener(buildTypeButtonListener);
            if (Gatherer.GS3) {
                this.solr_button = new JRadioButton(BuildTypeManager.BUILD_TYPE_SOLR_STR);
                this.solr_button.setComponentOrientation(Dictionary.getOrientation());
                this.solr_button.setActionCommand(BuildTypeManager.BUILD_TYPE_SOLR);
                this.solr_button.addActionListener(buildTypeButtonListener);
            }
            ButtonGroup buttonGroup = new ButtonGroup();
            if (Gatherer.GS3) {
                buttonGroup.add(this.solr_button);
            }
            buttonGroup.add(this.lucene_button);
            buttonGroup.add(this.mgpp_button);
            buttonGroup.add(this.mg_button);
            if (string != null) {
                if (string.equals(BuildTypeManager.BUILD_TYPE_MGPP)) {
                    this.mgpp_button.setSelected(true);
                } else if (string.equals(BuildTypeManager.BUILD_TYPE_MG)) {
                    this.mg_button.setSelected(true);
                } else if (string.equals(BuildTypeManager.BUILD_TYPE_LUCENE)) {
                    this.lucene_button.setSelected(true);
                } else if (string.equals(BuildTypeManager.BUILD_TYPE_SOLR)) {
                    this.solr_button.setSelected(true);
                }
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(4, 1));
            if (Gatherer.GS3) {
                jPanel.add(this.solr_button);
            }
            jPanel.add(this.lucene_button);
            jPanel.add(this.mgpp_button);
            jPanel.add(this.mg_button);
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            this.description_textarea = new JTextArea();
            this.description_textarea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.description_textarea.setText(Dictionary.get("CDM.BuildTypeManager." + string + "_Description"));
            this.description_textarea.setCaretPosition(0);
            this.description_textarea.setLineWrap(true);
            this.description_textarea.setWrapStyleWord(true);
            this.description_textarea.setComponentOrientation(Dictionary.getOrientation());
            this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
            this.cancel_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BuildTypePrompt.this.self.dispose();
                }
            });
            this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
            this.ok_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = BuildTypeManager.BUILD_TYPE_MGPP;
                    if (BuildTypePrompt.this.mgpp_button.isSelected()) {
                        string = BuildTypeManager.BUILD_TYPE_MGPP;
                    } else if (BuildTypePrompt.this.mg_button.isSelected()) {
                        string = BuildTypeManager.BUILD_TYPE_MG;
                    } else if (BuildTypePrompt.this.lucene_button.isSelected()) {
                        string = BuildTypeManager.BUILD_TYPE_LUCENE;
                    } else if (BuildTypePrompt.this.solr_button.isSelected()) {
                        string = BuildTypeManager.BUILD_TYPE_SOLR;
                    }
                    if (!BuildTypeManager.this.build_type_meta.getValue(true).equals(string)) {
                        BuildTypeManager.this.manager.notifyListeners(string);
                        BuildTypeManager.this.build_type_meta.setValue(string);
                    }
                    BuildTypePrompt.this.self.dispose();
                }
            });
            this.ok_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(1, 2));
            jPanel2.add(this.ok_button);
            jPanel2.add(this.cancel_button);
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel3 = (JPanel)this.getContentPane();
            jPanel3.setOpaque(true);
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jPanel, "North");
            jPanel3.add((Component)new JScrollPane(this.description_textarea), "Center");
            jPanel3.add((Component)jPanel2, "South");
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            TestingPreparation.setIndividualSubcomponentNames(this, this.mg_button, this.mgpp_button, this.lucene_button, this.solr_button);
            Dimension dimension = Configuration.screen_size;
            this.setLocation((dimension.width - DIALOG_SIZE.width) / 2, (dimension.height - DIALOG_SIZE.height) / 2);
            this.setVisible(true);
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }

        public void destroy() {
        }

        private class BuildTypeButtonListener
        implements ActionListener {
            private BuildTypeButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTypePrompt.this.description_textarea.setText(Dictionary.get("CDM.BuildTypeManager." + actionEvent.getActionCommand() + "_Description"));
                BuildTypePrompt.this.description_textarea.setCaretPosition(0);
            }
        }
    }

    private class BuildTypeControl
    extends JPanel
    implements Control,
    BuildTypeListener {
        JLabel label = null;
        JButton change_button = null;

        public BuildTypeControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            this.label = new JLabel(Dictionary.get("CDM.BuildTypeManager.Current_Type", this.getBuildTypeString(BuildTypeManager.this.getBuildType())));
            this.label.setComponentOrientation(Dictionary.getOrientation());
            this.change_button = new GLIButton(Dictionary.get("CDM.BuildTypeManager.Change"), Dictionary.get("CDM.BuildTypeManager.Change_Tooltip"));
            this.change_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BuildTypeManager.this.promptForNewBuildType();
                }
            });
            jPanel2.setLayout(new BorderLayout(10, 10));
            jPanel2.add((Component)this.label, "Center");
            jPanel2.add((Component)this.change_button, "After");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel2, "After");
            BuildTypeManager.this.manager.addBuildTypeListener(this);
            TestingPreparation.setNamesRecursivelyForControl(this);
        }

        @Override
        public void loseFocus() {
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void destroy() {
        }

        private String getBuildTypeString(String string) {
            if (string.equals(BuildTypeManager.BUILD_TYPE_MG)) {
                return BuildTypeManager.BUILD_TYPE_MG_STR;
            }
            if (string.equals(BuildTypeManager.BUILD_TYPE_MGPP)) {
                return BuildTypeManager.BUILD_TYPE_MGPP_STR;
            }
            if (string.equals(BuildTypeManager.BUILD_TYPE_LUCENE)) {
                return BuildTypeManager.BUILD_TYPE_LUCENE_STR;
            }
            if (string.equals(BuildTypeManager.BUILD_TYPE_SOLR)) {
                return BuildTypeManager.BUILD_TYPE_SOLR_STR;
            }
            return "";
        }

        @Override
        public void buildTypeChanged(String string) {
            this.label.setText(Dictionary.get("CDM.BuildTypeManager.Current_Type", this.getBuildTypeString(string)));
        }
    }

    public static interface BuildTypeListener
    extends EventListener {
        public void buildTypeChanged(String var1);
    }
}

