/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ArgumentContainer
extends ArrayList
implements Comparable,
DOMProxyListEntry,
Serializable {
    protected Element element;
    protected boolean is_abstract = false;
    protected ArgumentContainer super_container;
    protected String description;
    protected String name;

    public ArgumentContainer() {
    }

    public ArgumentContainer(Element element, ArgumentContainer argumentContainer) {
        Object object;
        this.element = element;
        this.name = element.getAttribute("type");
        HashMap<String, Argument> hashMap = new HashMap<String, Argument>();
        NodeList nodeList = element.getElementsByTagName("Option");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            Argument argument = new Argument(element2);
            hashMap.put(argument.getName(), argument);
        }
        if (argumentContainer != null) {
            this.description = argumentContainer.getDescription();
            ArrayList arrayList = argumentContainer.getArguments();
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                object = (Argument)arrayList.get(i);
                String string = ((Argument)object).getName();
                Argument argument = (Argument)hashMap.get(string);
                if (argument != null) {
                    hashMap.remove(string);
                    argument.setDisplayName(((Argument)object).getDisplayName());
                    argument.setDefaultValue(((Argument)object).getDefaultValue());
                    argument.setDescription(((Argument)object).getDescription());
                    argument.setOptions(((Argument)object).getOptions());
                    argument.setRequired(((Argument)object).isRequired());
                    argument.setType(((Argument)object).getType());
                    argument.setMinimum(((Argument)object).getMinimum());
                    argument.setMaximum(((Argument)object).getMaximum());
                    argument.setOwner(((Argument)object).getOwner());
                    argument.setHiddenGLI(((Argument)object).isHiddenGLI());
                    this.add(argument);
                    continue;
                }
                Argument argument2 = ((Argument)object).copy();
                Element element3 = CollectionConfiguration.createElement("Option");
                element3.setAttribute("name", string);
                element3.setAttribute("assigned", "false");
                argument2.setElement(element3);
                element.appendChild(element3);
                this.add(argument2);
            }
        }
        if (!hashMap.isEmpty()) {
            Set set = hashMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Argument argument = (Argument)iterator.next().getValue();
                object = argument.getElement();
                element.removeChild((Node)object);
            }
        }
    }

    public void addArgument(Argument argument) {
        if (this.element == null && !this.contains(argument)) {
            this.add(argument);
            argument.setOwner(this.name);
        }
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        return this.toString().compareTo(object.toString());
    }

    @Override
    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public abstract DOMProxyListEntry create(Element var1);

    public Argument getArgument(String string) {
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        ArrayList arrayList = this.getArguments();
        for (int i = 0; i < arrayList.size(); ++i) {
            Argument argument = (Argument)arrayList.get(i);
            if (!argument.getName().equals(string)) continue;
            return argument;
        }
        return null;
    }

    public ArrayList getArguments() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this);
        if (this.super_container != null) {
            ArrayList arrayList2 = this.super_container.getArguments();
            arrayList2.removeAll(arrayList);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public String getName() {
        if (this.name == null && this.element != null) {
            this.name = this.element.getAttribute("type");
        }
        return this.name;
    }

    public boolean isAbstract() {
        return this.is_abstract;
    }

    @Override
    public boolean isAssigned() {
        return this.element != null && !this.element.getAttribute("assigned").equals("false");
    }

    @Override
    public void setAssigned(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("assigned", bl ? "true" : "false");
        }
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
    }

    public void setIsAbstract(boolean bl) {
        this.is_abstract = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSuper(ArgumentContainer argumentContainer) {
        this.super_container = argumentContainer;
    }

    @Override
    public String toString() {
        if (this.element == null) {
            return this.name;
        }
        if (this.name == null) {
            this.name = this.element.getAttribute("type");
        }
        StringBuffer stringBuffer = new StringBuffer(" ");
        if (!this.isAssigned()) {
            stringBuffer.append("#");
        }
        stringBuffer.append(this.name);
        ArrayList arrayList = this.getArguments();
        for (int i = 0; i < arrayList.size(); ++i) {
            Argument argument = (Argument)arrayList.get(i);
            if (!argument.isAssigned()) continue;
            stringBuffer.append(" ");
            stringBuffer.append(argument.toString());
        }
        return stringBuffer.toString();
    }

    public ArrayList getArguments(boolean bl, boolean bl2) {
        return this;
    }
}

