/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.io.Serializable;
import java.util.ArrayList;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Argument
implements Comparable,
Serializable {
    public static final byte ENUM = 0;
    public static final byte FLAG = 1;
    public static final byte HIERARCHY = 2;
    public static final byte INTEGER = 3;
    public static final byte LANGUAGE = 4;
    public static final byte METADATA = 5;
    public static final byte STRING = 6;
    public static final byte REGEXP = 7;
    public static final byte METADATA_SET_NAMESPACE = 8;
    public static final byte URL = 9;
    public static final byte ENUM_STRING = 10;
    private boolean hidden_gli = false;
    private boolean required = false;
    private byte type = (byte)6;
    private int maximum = Integer.MAX_VALUE;
    private int minimum = Integer.MIN_VALUE;
    private int mode_level = 2;
    private Element element;
    private ArrayList option_list = null;
    private String default_value = null;
    private String description = null;
    private String name = null;
    private String stored_value = null;
    private String owner = null;
    private String display_name = null;

    public Argument() {
    }

    public Argument(Element element) {
        this.element = element;
    }

    public void addOption(String string, String string2) {
        if ((this.type == 0 || this.type == 10) && string != null) {
            if (string2 == null) {
                string2 = "";
            }
            if (this.option_list == null) {
                this.option_list = new ArrayList();
            }
            this.option_list.add(new ArgumentOption(string, string2));
        }
    }

    public int compareTo(Object object) {
        if (object instanceof Argument) {
            return this.getName().compareTo(((Argument)object).getName());
        }
        return this.toString().compareTo(object.toString());
    }

    public Argument copy() {
        Argument argument = new Argument();
        argument.setDefaultValue(this.default_value);
        argument.setDescription(this.description);
        argument.setOptions(this.option_list);
        argument.setOwner(this.owner);
        argument.setName(this.name);
        argument.setDisplayName(this.display_name);
        argument.setRequired(this.required);
        argument.setType(this.type);
        argument.setMinimum(this.minimum);
        argument.setMaximum(this.maximum);
        argument.setModeLevel(this.mode_level);
        argument.setHiddenGLI(this.hidden_gli);
        return argument;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public String getDefaultValue() {
        return this.default_value;
    }

    public String getDescription() {
        return this.description;
    }

    public Element getElement() {
        return this.element;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getModeLevel() {
        return this.mode_level;
    }

    public String getName() {
        if (this.name == null && this.element != null) {
            this.name = this.element.getAttribute("name");
        }
        return this.name;
    }

    public String getDisplayName() {
        if (this.display_name == null) {
            return "";
        }
        return this.display_name;
    }

    public ArrayList getOptions() {
        return this.option_list;
    }

    public String getOwner() {
        return this.owner;
    }

    public byte getType() {
        return this.type;
    }

    public String getValue() {
        if (this.element == null) {
            return null;
        }
        if (this.stored_value != null) {
            return this.stored_value;
        }
        String string = XMLTools.getValue(this.element);
        if (this.type == 5) {
            this.stored_value = MetadataTools.convertMetadataElementListNames(string, MetadataTools.TO_DISPLAY_NAMES);
            return this.stored_value;
        }
        return string;
    }

    public boolean isAssigned() {
        return this.element != null && this.element.getAttribute("assigned").equals("true");
    }

    public boolean isCustomArgument() {
        return this.element != null && this.element.getAttribute("custom").equals("true");
    }

    public boolean isHiddenGLI() {
        return this.hidden_gli;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setAssigned(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("assigned", bl ? "true" : "false");
        }
    }

    public void setDefaultValue(String string) {
        this.default_value = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setHiddenGLI(boolean bl) {
        this.hidden_gli = bl;
    }

    public void setMaximum(int n) {
        this.maximum = n;
    }

    public void setMinimum(int n) {
        this.minimum = n;
    }

    public void setModeLevel(int n) {
        this.mode_level = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDisplayName(String string) {
        this.display_name = string;
    }

    public void setOptions(ArrayList arrayList) {
        this.option_list = arrayList;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public void setType(String string) {
        if (string.equalsIgnoreCase("enum")) {
            this.type = 0;
            this.option_list = new ArrayList();
        } else if (string.equalsIgnoreCase("enumstring")) {
            this.type = (byte)10;
            this.option_list = new ArrayList();
        } else {
            this.type = string.equalsIgnoreCase("flag") ? (byte)1 : (string.equalsIgnoreCase("hierarchy") ? (byte)2 : (string.equalsIgnoreCase("int") ? (byte)3 : (string.equalsIgnoreCase("language") ? (byte)4 : (string.equalsIgnoreCase("metadata") ? (byte)5 : (string.equalsIgnoreCase("regexp") ? (byte)7 : (byte)6)))));
        }
    }

    public void setValue(String string) {
        if (this.element != null) {
            if (this.type == 5) {
                this.stored_value = string = MetadataTools.convertMetadataElementListNames(string, MetadataTools.FROM_DISPLAY_NAMES);
            }
            XMLTools.setValue(this.element, string);
        } else {
            DebugStream.println("Argument.setValue(" + string + ") called on a base Argument.");
        }
    }

    public void setValues(ArrayList arrayList) {
        if (this.element != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(arrayList.get(i));
                stringBuffer.append(",");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            XMLTools.setValue(this.element, stringBuffer.toString());
        } else {
            DebugStream.println("Argument.setValues([" + arrayList.size() + " items]) called on a base Argument.");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("-");
        if (this.element == null) {
            return stringBuffer.toString();
        }
        if (this.name == null) {
            this.name = this.element.getAttribute("name");
        }
        stringBuffer.append(this.name);
        String string = this.getValue();
        if (string.length() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append(" ");
        if (string.indexOf(" ") != -1 && this.type != 5) {
            string = "\"" + string + "\"";
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void parseXML(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            Object object;
            String string2 = node.getNodeName();
            if (string2.equals("Name")) {
                this.setName(XMLTools.getValue(node));
                continue;
            }
            if (string2.equals("DisplayName")) {
                this.setDisplayName(XMLTools.getValue(node));
                continue;
            }
            if (string2.equals("Desc")) {
                this.setDescription(XMLTools.getValue(node));
                continue;
            }
            if (string2.equals("Type")) {
                this.setType(XMLTools.getValue(node));
                continue;
            }
            if (string2.equals("Default")) {
                this.setDefaultValue(XMLTools.getValue(node));
                continue;
            }
            if (string2.equals("Required")) {
                object = XMLTools.getValue(node);
                if (object == null || !((String)object).equals("yes")) continue;
                this.setRequired(true);
                continue;
            }
            if (string2.equals("List")) {
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (!object.getNodeName().equals("Value")) continue;
                    String string3 = null;
                    string = "";
                    for (Node node2 = object.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        string2 = node2.getNodeName();
                        if (string2.equals("Name")) {
                            string3 = XMLTools.getValue(node2);
                            continue;
                        }
                        if (!string2.equals("Desc")) continue;
                        string = XMLTools.getValue(node2);
                    }
                    if (string3 == null) continue;
                    this.addOption(string3, string);
                }
                continue;
            }
            if (string2.equals("Range")) {
                object = XMLTools.getValue(node);
                int n = -1;
                n = ((String)object).indexOf(",");
                if (n == -1) continue;
                if (n > 0) {
                    try {
                        string = ((String)object).substring(0, n);
                        this.setMinimum(Integer.parseInt(string));
                        string = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n + 1 >= ((String)object).length()) continue;
                try {
                    string = ((String)object).substring(n + 1);
                    this.setMaximum(Integer.parseInt(string));
                    string = null;
                }
                catch (Exception exception) {}
                continue;
            }
            if (string2.equals("HiddenGLI")) {
                this.setHiddenGLI(true);
                continue;
            }
            if (!string2.equals("ModeGLI")) continue;
            object = XMLTools.getValue(node);
            try {
                int n = Integer.parseInt((String)object);
                this.setModeLevel(n);
                continue;
            }
            catch (Exception exception) {
                DebugStream.println("Exception in Argument.parseXML() - Unexpected but non-fatal");
                DebugStream.printStackTrace(exception);
            }
        }
    }

    public class ArgumentOption
    implements Comparable {
        public String name;
        public String description;
        private String text;

        public ArgumentOption(String string, String string2) {
            this.name = string;
            this.description = string2;
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }

        public boolean equals(Object object) {
            return object != null && this.compareTo(object) == 0;
        }

        public String toString() {
            return this.name + " " + "-" + " " + this.description;
        }

        public String getToolTip() {
            return Utility.formatHTMLWidth(this.name + ": " + this.description, 80);
        }
    }
}

