/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.FedoraInfo;
import org.greenstone.gatherer.GAuthenticator;
import org.greenstone.gatherer.GetOpt;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.feedback.ActionRecorderDialog;
import org.greenstone.gatherer.feedback.Base64;
import org.greenstone.gatherer.file.FileAssociationManager;
import org.greenstone.gatherer.file.FileManager;
import org.greenstone.gatherer.file.RecycleBin;
import org.greenstone.gatherer.greenstone.Classifiers;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.greenstone.LocalLibraryServer;
import org.greenstone.gatherer.greenstone.Plugins;
import org.greenstone.gatherer.greenstone3.LibraryAddressProperties;
import org.greenstone.gatherer.greenstone3.ServletConfiguration;
import org.greenstone.gatherer.gui.FedoraLogin;
import org.greenstone.gatherer.gui.GUIManager;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.gui.URLField;
import org.greenstone.gatherer.gui.WarningDialog;
import org.greenstone.gatherer.metadata.FilenameEncoding;
import org.greenstone.gatherer.remote.RemoteGreenstoneServer;
import org.greenstone.gatherer.util.GS3ServerThread;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.Utility;
import org.webswing.toolkit.api.WebswingUtil;

public class Gatherer {
    public static final String PROGRAM_NAME = "Greenstone Librarian Interface";
    public static final String PROGRAM_VERSION = "2.88";
    private static Dimension size = new Dimension(800, 540);
    public static RemoteGreenstoneServer remoteGreenstoneServer = null;
    public static WebswingAuthenticator webswingAuthenticator = null;
    public static final int EXIT_THEN_RESTART = 2;
    public static boolean exit = false;
    public static int exit_status = 0;
    private static String gli_directory_path = null;
    private static String gli_user_directory_path = null;
    public static String client_operating_system = null;
    private static Vector apps = new Vector();
    private static String non_standard_collect_directory_path = null;
    public static String open_collection_file_path = null;
    public static String gsdlsite_collecthome = "";
    public static FileAssociationManager assoc_man;
    public static CollectionManager c_man;
    public static RecycleBin recycle_bin;
    public static ServletConfiguration servlet_config;
    public static FileManager f_man;
    public static GUIManager g_man;
    private static boolean g_man_built;
    public static boolean GS3;
    public static boolean isApplet;
    public static boolean isGsdlRemote;
    public static boolean isLocalLibrary;
    public static boolean isWebswing;
    private static Properties startup_proxy_settings;
    public static boolean isDownloadEnabled;
    public static boolean feedback_enabled;
    public static ActionRecorderDialog feedback_dialog;
    public static final int COLLECTION_OPENED = 0;
    public static final int COLLECTION_CLOSED = 1;
    public static final int COLLECTION_REBUILT = 2;
    public static final int PREFERENCES_CHANGED = 3;
    public static String cgiBase;
    private static URL default_gliserver_url;
    public static String local_tomcat_context_url_string;
    public static final boolean TURN_OFF_EVENTDISPATCH_CHANGES = false;
    public static boolean PRINT_THREAD_NAMES;
    public static final boolean SYNC = true;
    public static final boolean ASYNC = false;
    public static final boolean BYPASS_WHEN_NOT_TESTING = true;
    public static final boolean DO_NOT_BYPASS_WHEN_NOT_TESTING = false;
    private static final int RUN_IN_THREAD_PARAM_WITH_START = 1;
    private static final int PROCEED_IN_CURRENT_THREAD = 2;

    public static void invokeInEDT_replacesThreadStart(String string, boolean bl, boolean bl2, Thread thread) {
        Gatherer.invokeInDispatchThread(string, bl, bl2, 1, thread);
    }

    public static void invokeInEDT_replacesThreadStart(String string, boolean bl, Thread thread) {
        Gatherer.invokeInDispatchThread(string, bl, false, 1, thread);
    }

    public static void invokeInEDT_replacesProceedInCurrThread(String string, boolean bl, boolean bl2, Runnable runnable) {
        Gatherer.invokeInDispatchThread(string, bl, bl2, 2, runnable);
    }

    public static void invokeInEDT_replacesProceedInCurrThread(String string, boolean bl, Runnable runnable) {
        Gatherer.invokeInDispatchThread(string, bl, false, 2, runnable);
    }

    private static void invokeInDispatchThread(String string, boolean bl, boolean bl2, int n, Runnable runnable) {
        Object object;
        Object object2;
        if (PRINT_THREAD_NAMES) {
            object2 = Thread.getAllStackTraces();
            object = object2.keySet();
            Iterator<Thread> iterator = object.iterator();
            while (iterator.hasNext()) {
                Thread thread = iterator.next();
                System.err.println("thread name: " + thread.getName() + " - class " + thread.getClass().getName());
            }
        }
        if (bl2) {
            System.err.println("Calling thread name: " + Thread.currentThread().getName() + " - class " + Thread.currentThread().getClass().getName());
            if (runnable instanceof Thread) {
                object2 = (Thread)runnable;
                System.err.println("\tRunnable thread name: " + ((Thread)object2).getName() + " - class " + object2.getClass().getName());
            }
        }
        if (bl2 && !TestingPreparation.TEST_MODE) {
            if (bl2 && !TestingPreparation.TEST_MODE) {
                System.err.println("@@@@" + string + " - Bypassing EDT change");
            }
            if (!EventQueue.isDispatchThread()) {
                System.err.println("@@@@" + string + "\n\tExpected to be on the Event Dispatch Thread but not so.\n\tThis is potentially dangerous!!!");
            }
            if (n == 1) {
                object2 = (Thread)runnable;
                ((Thread)object2).start();
            } else if (n == 2) {
                runnable.run();
            }
        } else if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else if (!bl) {
            SwingUtilities.invokeLater(runnable);
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                object = "@@@ Exception during ";
                if (string != null && !string.equals("")) {
                    object = (String)object + string + " - ";
                }
                object = (String)object + "invokeAndWait on EDT: ";
                System.err.println((String)object + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public Gatherer(GetOpt getOpt) {
        System.err.println("Version: 2.88\n");
        if (getOpt.webswing) {
            WebswingUtil.getWebswingApi().sendActionEvent("setCursor", "wait", null);
        }
        JarTools.initialise(this);
        client_operating_system = getOpt.client_operating_system;
        if (getOpt.feedback_enabled) {
            feedback_enabled = true;
            feedback_dialog = new ActionRecorderDialog(Locale.getDefault());
        }
        if (getOpt.gsdl3_web_path != null && !getOpt.gsdl3_web_path.equals("")) {
            GS3 = true;
            Configuration.config_xml = "config3.xml";
        } else {
            getOpt.gsdl3_web_path = null;
            getOpt.gsdl3_writableweb_path = null;
            getOpt.gsdl3_src_path = null;
        }
        if (getOpt.use_remote_greenstone) {
            isGsdlRemote = true;
            getOpt.gsdl3_web_path = null;
            getOpt.gsdl3_writableweb_path = null;
            getOpt.gsdl3_src_path = null;
            if (getOpt.gsdl_path == null) {
                isDownloadEnabled = false;
            }
            Gatherer.setCollectDirectoryPath(Gatherer.getGLIUserDirectoryPath() + "collect" + File.separator);
        }
        if (getOpt.webswing) {
            isWebswing = true;
        }
        if (isDownloadEnabled) {
            LocalGreenstone.setDirectoryPath(getOpt.gsdl_path);
        }
        if (isGsdlRemote) {
            Configuration.template_config_xml = getOpt.fedora_info.isActive() ? "xml/fedora-configRemote.xml" : "xml/configRemote.xml";
            Configuration.config_xml = "configRemote.xml";
            File file = new File(Gatherer.getCollectDirectoryPath());
            if (!file.exists() && !file.mkdir()) {
                System.err.println("Warning: Unable to make directory: " + file);
            }
        } else if (isWebswing) {
            Configuration.template_config_xml = "xml/configWebswing.xml";
            Configuration.config_xml = "configWebswing.xml";
            if (getOpt.username != null && !getOpt.username.equals("") && getOpt.userJSessionID != null && !getOpt.userJSessionID.equals("")) {
                webswingAuthenticator = new WebswingAuthenticator(getOpt.username, getOpt.usergroups, getOpt.userJSessionID);
            }
        } else if (getOpt.fedora_info.isActive()) {
            Configuration.template_config_xml = "xml/fedora-" + Configuration.config_xml;
        }
        if (getOpt.testing_mode) {
            TestingPreparation.TEST_MODE = true;
        }
        this.init(getOpt.gsdl_path, getOpt.gsdl3_web_path, getOpt.gsdl3_writableweb_path, getOpt.gsdl3_src_path, getOpt.fedora_info, getOpt.local_library_path, getOpt.library_url_string, getOpt.gliserver_url_string, getOpt.debug, getOpt.perl_path, getOpt.no_load, getOpt.filename, getOpt.site_name, getOpt.servlet_path, getOpt.collect_directory_path, getOpt.language);
    }

    public Gatherer(String[] stringArray) {
        this(new GetOpt(stringArray));
    }

    public void init(String string, String string2, String string3, String string4, FedoraInfo fedoraInfo, String string5, String string6, String string7, boolean bl, String string8, boolean bl2, String string9, String string10, String string11, String string12, String string13) {
        Object object;
        String string14;
        Object object2;
        Object object3;
        Properties properties = null;
        LibraryAddressProperties libraryAddressProperties = null;
        if (isWebswing) {
            if (string6 == null) {
                System.err.println("Please set the library_url gli option in the webswing config");
                System.exit(0);
            }
            if (string11 == null) {
                System.err.println("The servlet path option was not set for GLI options in webswing config, defaulting to /library");
                string11 = "/library";
            }
            if ((properties = Gatherer.loadBuildProperties(string4)) != null) {
                libraryAddressProperties = new LibraryAddressProperties(properties);
                local_tomcat_context_url_string = libraryAddressProperties.getLocalHttpAddress();
                System.err.println("local url = " + local_tomcat_context_url_string);
            }
            if (local_tomcat_context_url_string == null) {
                System.err.println("Setting base configuration URL to Greenstone3 default:");
                local_tomcat_context_url_string = "http://127.0.0.1:8383/greenstone3";
                System.err.println("    " + local_tomcat_context_url_string);
            }
            if (webswingAuthenticator == null) {
                webswingAuthenticator = new WebswingAuthenticator();
            }
            if (!webswingAuthenticator.authenticate(local_tomcat_context_url_string + string11)) {
                System.err.println("Authentication error (" + local_tomcat_context_url_string + "), quitting GLI");
                System.exit(0);
            }
            object3 = webswingAuthenticator.getUsername();
            object2 = Gatherer.getGLIUserDirectoryPath();
            string14 = (String)object2 + (String)object3 + File.separator;
            object = new File(string14);
            if (!((File)object).exists() && !((File)object).mkdir()) {
                System.err.println("Warning: Unable to make directory: " + string14);
            } else {
                Gatherer.setGLIUserDirectoryPath(string14);
            }
        }
        if (bl) {
            DebugStream.enableDebugging();
            object3 = Calendar.getInstance();
            object2 = "debug" + ((Calendar)object3).get(5) + "-" + ((Calendar)object3).get(2) + "-" + ((Calendar)object3).get(1) + ".txt";
            object2 = Gatherer.getGLIUserDirectoryPath() + (String)object2;
            DebugStream.println("Debug file path: " + (String)object2);
            DebugStream.setDebugFile((String)object2);
            DebugStream.print(System.getProperties());
        }
        if (((File)(object3 = new File(Gatherer.getGLIUserDirectoryPath() + "plugins.dat"))).exists()) {
            System.err.println("Deleting plugins.dat file...");
            Utility.delete(object3);
        }
        if (((File)(object2 = new File(Gatherer.getGLIUserDirectoryPath() + "classifiers.dat"))).exists()) {
            System.err.println("Deleting classifiers.dat file...");
            Utility.delete((File)object2);
        }
        try {
            Object object4;
            Object object5;
            String string15;
            String string16;
            Object object6;
            new Configuration(Gatherer.getGLIUserDirectoryPath(), string, string2, string3, string4, string10, string11, fedoraInfo, string13);
            Configuration.perl_path = string8;
            if (isGsdlRemote && !isDownloadEnabled && Utility.isWindows() && Configuration.perl_path != null) {
                if (Configuration.perl_path.toLowerCase().endsWith("perl.exe")) {
                    Configuration.perl_path = Configuration.perl_path.substring(0, Configuration.perl_path.length() - "perl.exe".length());
                }
                if (Configuration.perl_path.endsWith(File.separator)) {
                    Configuration.perl_path = Configuration.perl_path.substring(0, Configuration.perl_path.length() - File.separator.length());
                }
            }
            if (feedback_enabled && feedback_dialog != null) {
                feedback_dialog.setLocale(Configuration.getLocale("general.locale", true));
            }
            new Dictionary(Configuration.getLocale("general.locale", true), Configuration.getFont("general.font", true));
            string14 = System.getProperty("java.vendor");
            object = System.getProperty("java.runtime.name");
            if (!(string14.equals("Sun Microsystems Inc.") || string14.equals("Oracle Corporation") || ((String)object).equals("OpenJDK Runtime Environment"))) {
                System.err.println(Dictionary.get("General.NotSunJava", string14));
            }
            if (!isGsdlRemote && string == null) {
                Gatherer.missingGSDL();
            }
            if (fedoraInfo.isActive()) {
                object6 = new File(string4 + File.separator + "packages" + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "fedora");
                if (isGsdlRemote || !GS3 || !((File)object6).exists()) {
                    Gatherer.popupFedoraInfo();
                }
            }
            if (System.getenv("http_proxy") != null) {
                System.err.println("http_proxy already set");
            }
            if (System.getenv("https_proxy") != null) {
                System.err.println("https_proxy already set");
            }
            if (System.getenv("ftp_proxy") != null) {
                System.err.println("ftp_proxy already set");
            }
            if (isGsdlRemote) {
                remoteGreenstoneServer = new RemoteGreenstoneServer();
                Gatherer.setProxy();
                Authenticator.setDefault(new GAuthenticator());
                int n = 2;
                string16 = Configuration.getString("general.gliserver_url", true);
                Gatherer.requestGLIServerURL();
                string7 = Configuration.gliserver_url.toString();
                n = remoteGreenstoneServer.getGreenstoneVersion();
                System.err.println("Remote Greenstone server version: " + n);
                if (n == -1) {
                    Gatherer.exit();
                }
                if (n >= 3) {
                    GS3 = true;
                    if (!string16.equals(string7)) {
                        System.err.println("Using a new GLI server url, clear site and servlet info");
                        Configuration.setSiteAndServlet("", "");
                    } else {
                        Configuration.prepareForGS3();
                    }
                }
                string6 = fedoraInfo.isActive() ? fedoraInfo.getLibraryURL() : remoteGreenstoneServer.getLibraryURL(Configuration.gliserver_url.toString());
                Configuration.setString("general.library_url", true, string6);
            } else if (!isWebswing) {
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!exit) {
                            System.err.println("ShutDownHook called...");
                            if (GS3) {
                                if (!GS3ServerThread.wasServerLaunchedOutsideGLI()) {
                                    System.err.println("Attempting to forcibly terminate the GS server...");
                                    GS3ServerThread.stopServer();
                                } else {
                                    System.err.println("Tomcat was launched outside GLI. Leaving it running...");
                                }
                            } else if (LocalLibraryServer.isRunning()) {
                                System.err.println("Attempting to forcibly terminate the GS server...");
                                LocalLibraryServer.forceStopServer();
                            }
                        }
                    }
                }));
                if (!GS3) {
                    isLocalLibrary = LocalLibraryServer.start(string, string5);
                } else {
                    if (!GS3ServerThread.wasServerLaunchedOutsideGLI()) {
                        GS3ServerThread.prepareXML();
                        object6 = new GS3ServerThread(string4, "restart");
                        ((Thread)object6).start();
                    }
                    if (fedoraInfo.isActive() && ((File)(object6 = new File(string4 + File.separator + "packages" + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "fedora"))).exists()) {
                        System.err.println("**** Waiting for the local Greenstone server to start up fedora...");
                        Gatherer.popupFedoraInfo();
                    }
                }
            }
            if (string6 != null && string6.length() > 0) {
                try {
                    System.err.println("Setting library_url to " + string6 + "...");
                    Configuration.library_url = new URL(string6);
                }
                catch (MalformedURLException malformedURLException) {
                    DebugStream.printStackTrace(malformedURLException);
                }
            }
            DebugStream.println("Configuration.library_url = " + Configuration.library_url);
            if (Configuration.library_url == null) {
                if (isLocalLibrary) {
                    if (!LocalLibraryServer.isURLPending()) {
                        Gatherer.missingEXEC(null);
                    }
                } else {
                    String string17 = null;
                    if (GS3) {
                        string17 = "http://127.0.0.1:8383/greenstone3";
                        if (properties == null) {
                            properties = Gatherer.loadBuildProperties(string4);
                        }
                        if (properties != null) {
                            libraryAddressProperties = new LibraryAddressProperties(properties);
                        }
                        if (libraryAddressProperties != null) {
                            string17 = libraryAddressProperties.getExternalAddress();
                        }
                    }
                    Gatherer.missingEXEC(string17);
                }
            }
            if (string7 != null && string7.length() > 0) {
                try {
                    System.err.println("Setting gliserver_url to " + string7 + "...");
                    Configuration.gliserver_url = new URL(string7);
                }
                catch (MalformedURLException malformedURLException) {
                    DebugStream.printStackTrace(malformedURLException);
                }
            }
            DebugStream.println("Configuration.gliserver_url = " + Configuration.gliserver_url);
            if (GS3) {
                servlet_config = isGsdlRemote ? new ServletConfiguration(Configuration.gli_user_directory_path, Configuration.gli_user_directory_path) : new ServletConfiguration(string2, string3);
                if (Configuration.servlet_path == null || Configuration.servlet_path.equals("")) {
                    String string18 = null;
                    if (isGsdlRemote) {
                        System.err.println("servlet path is null, get new one from remote server");
                        string18 = remoteGreenstoneServer.getDefaultServletPath().trim();
                    } else {
                        System.err.println("servlet path is null, get one from build.properties");
                        if (properties == null) {
                            properties = Gatherer.loadBuildProperties(string4);
                        }
                        string18 = properties.getProperty("greenstone.default.servlet", "/library");
                    }
                    string16 = servlet_config.getSiteForServlet(string18);
                    System.err.println("setting site and servlet to " + string16 + ", " + string18);
                    Configuration.setSiteAndServlet(string16, string18);
                }
            }
            if (isWebswing) {
                Configuration.local_url = new URL(local_tomcat_context_url_string);
            }
            if ((open_collection_file_path = string9) == null) {
                open_collection_file_path = Configuration.getString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true);
            } else {
                File file = new File(open_collection_file_path);
                if (!file.isAbsolute()) {
                    string16 = string12 != null ? string12 : Gatherer.getDefaultGSCollectDirectoryPath(false);
                    open_collection_file_path = string16 + File.separator + open_collection_file_path;
                }
            }
            if (bl2 || isGsdlRemote && open_collection_file_path.equals("")) {
                open_collection_file_path = null;
            }
            if (isWebswing && open_collection_file_path != null && !open_collection_file_path.equals("") && !webswingAuthenticator.canEditCollection(string16 = (string15 = open_collection_file_path.substring(0, open_collection_file_path.lastIndexOf(File.separator))).substring(string15.lastIndexOf(File.separator) + 1))) {
                open_collection_file_path = "";
            }
            Gatherer.initCollectDirectoryPath();
            File file = new File(Gatherer.getGLIUserCacheDirectoryPath());
            System.err.println("User cache dir: " + Gatherer.getGLIUserCacheDirectoryPath());
            if (!file.exists() && !file.mkdir()) {
                System.err.println("Warning: Unable to make directory: " + file);
            }
            if (isGsdlRemote) {
                DebugStream.println("Not checking for perl path/exe");
            } else {
                boolean bl3 = false;
                if (Configuration.perl_path != null) {
                    object5 = new File(Configuration.perl_path);
                    bl3 = ((File)object5).exists();
                    object5 = null;
                }
                if ((Configuration.perl_path == null || !bl3) && ((PerlTest)(object5 = new PerlTest())).found()) {
                    Configuration.perl_path = ((PerlTest)object5).toString();
                    bl3 = true;
                }
                if (!bl3) {
                    Gatherer.missingPERL();
                }
            }
            if (isGsdlRemote) {
                DebugStream.println("Not checking for ImageMagick.");
            } else if (!new ImageMagickTest().found()) {
                Gatherer.missingImageMagick();
            }
            if (isGsdlRemote) {
                DebugStream.println("Not checking for PDFBox.");
            } else {
                String string19 = string;
                object5 = new File(string19 + File.separator + "ext" + File.separator + "pdf-box");
                if (!((File)object5).exists() || !((File)object5).isDirectory()) {
                    object4 = Utility.isWindows() ? "zip" : "tar.gz";
                    Gatherer.missingPDFBox(object4, ((File)object5).getParent());
                }
            }
            if (System.getProperty("file.encoding").equals("UTF-8")) {
                FilenameEncoding.MULTIPLE_FILENAME_ENCODINGS_SUPPORTED = false;
                FilenameEncoding.URL_FILE_SEPARATOR = File.separator;
            } else {
                FilenameEncoding.MULTIPLE_FILENAME_ENCODINGS_SUPPORTED = true;
                FilenameEncoding.URL_FILE_SEPARATOR = "/";
            }
            FontUIResource fontUIResource = Configuration.getFont("general.font", true);
            object5 = UIManager.getDefaults().keys();
            while (object5.hasMoreElements()) {
                object4 = object5.nextElement();
                Object object7 = UIManager.get(object4);
                if (!(object7 instanceof FontUIResource)) continue;
                UIManager.put(object4, fontUIResource);
            }
            if (!isGsdlRemote) {
                Gatherer.setProxy();
                Authenticator.setDefault(new GAuthenticator());
            }
            Gatherer.invokeInEDT_replacesProceedInCurrThread("Gatherer.init() - File/Coll managers", true, new Runnable(){

                @Override
                public void run() {
                    assoc_man = new FileAssociationManager();
                    f_man = new FileManager();
                    c_man = new CollectionManager();
                    recycle_bin = new RecycleBin();
                }
            });
            if (GS3) {
                if (string10 == null) {
                    string10 = Configuration.site_name;
                    string11 = null;
                }
                if (string11 == null) {
                    string11 = Configuration.getServletPath();
                }
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        Gatherer.invokeInEDT_replacesProceedInCurrThread("Gatherer.init() - GUImanager", true, new Runnable(){

            @Override
            public void run() {
                g_man = new GUIManager(size);
            }
        });
        Classifiers.loadClassifiersList(null);
        Plugins.loadPluginsList(null);
        if (string12 != null) {
            string14 = string12;
            if (string14.endsWith(File.separator)) {
                string14 = string14.substring(0, string14.length() - 1);
            }
            if (string12.equals(Gatherer.getDefaultGSCollectDirectoryPath(false))) {
                Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, "");
            } else {
                Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, string14);
            }
            Gatherer.setCollectDirectoryPath(string12);
            if (string14 != null) {
                string14 = "\"" + string14 + "\"";
            }
            Utility.updatePropertyConfigFile(Gatherer.getGsdlSiteConfigFile(), "collecthome", string14);
        }
        if (isGsdlRemote && remoteGreenstoneServer.downloadCollectionConfigurations().equals("")) {
            System.err.println("Error: Could not download collection configurations.");
            if (!isApplet) {
                System.exit(0);
            }
        }
    }

    public static int serverVersionNumber() {
        return GS3 ? 3 : 2;
    }

    public static String getServerVersionAsString() {
        return "Server: v" + Gatherer.serverVersionNumber();
    }

    public void openGUI() {
        Rectangle rectangle = Configuration.getBounds("general.bounds", true);
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 640, 480);
        }
        size = rectangle.getSize();
        if (Gatherer.size.width < 640) {
            Gatherer.size.width = 640;
        } else if (Gatherer.size.width > Configuration.screen_size.width && Configuration.screen_size.width > 0) {
            Gatherer.size.width = Configuration.screen_size.width;
        }
        if (Gatherer.size.height < 480) {
            Gatherer.size.height = 480;
        } else if (Gatherer.size.height > Configuration.screen_size.height && Configuration.screen_size.height > 0) {
            Gatherer.size.height = Configuration.screen_size.height;
        }
        if (!g_man_built) {
            g_man.setSize(size);
            g_man.display();
            g_man.setLocation(rectangle.x, rectangle.y);
            g_man.setVisible(true);
            Point point = g_man.getLocation();
            int n = rectangle.x - point.x;
            int n2 = rectangle.y - point.y;
            if (n > 0 || n2 > 0) {
                g_man.setLocation(rectangle.x + n, rectangle.y + n2);
            }
            g_man.afterDisplay();
            g_man_built = true;
        } else {
            g_man.setVisible(true);
        }
        if (isWebswing) {
            WebswingUtil.getWebswingApi().sendActionEvent("setCursor", "default", null);
        }
        TestingPreparation.setNamesRecursively(g_man);
        if (open_collection_file_path == null || new File(open_collection_file_path).isDirectory()) {
            Gatherer.setMenuBarEnabled(true);
        } else {
            c_man.openCollectionFromLastTime();
        }
    }

    public static void setMenuBarEnabled(final boolean bl) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("Gatherer.init() - enabling menubar", false, new Runnable(){

            @Override
            public void run() {
                Gatherer.g_man.menu_bar.file.setEnabled(bl);
                Gatherer.g_man.menu_bar.edit.setEnabled(bl);
            }
        });
    }

    public static void exit(int n) {
        DebugStream.println("In Gatherer.exit()...");
        exit = true;
        if (n != 0) {
            exit_status = n;
        }
        if (assoc_man != null) {
            assoc_man.save();
            assoc_man = null;
        }
        if (g_man != null) {
            g_man.destroy();
            g_man_built = false;
        }
        DebugStream.closeDebugStream();
        if (LocalLibraryServer.isRunning()) {
            LocalLibraryServer.stop();
        }
        if (isGsdlRemote) {
            remoteGreenstoneServer.exit();
        } else if (GS3) {
            if (!GS3ServerThread.wasServerLaunchedOutsideGLI()) {
                GS3ServerThread.stopServer();
            } else {
                System.err.println("Tomcat was launched outside GLI. Leaving it running...");
            }
        }
        if (apps.size() == 0) {
            if (!isApplet && !TestingPreparation.TEST_MODE) {
                System.exit(exit_status);
            } else if (TestingPreparation.TEST_MODE) {
                g_man.dispose();
            }
        } else {
            JOptionPane.showMessageDialog(g_man, Dictionary.get("General.Outstanding_Processes"), Dictionary.get("General.Outstanding_Processes_Title"), 0);
            g_man.setVisible(false);
        }
    }

    public static void exit() {
        Gatherer.exit(0);
    }

    public static String getCollectDirectoryPath() {
        if (non_standard_collect_directory_path != null) {
            return non_standard_collect_directory_path;
        }
        return Gatherer.getDefaultGSCollectDirectoryPath(true);
    }

    public static boolean isPersistentServer() {
        return !isGsdlRemote && LocalLibraryServer.isPersistentServer();
    }

    public static String getDefaultGSCollectDirectoryPath(boolean bl) {
        String string = GS3 ? Gatherer.getSitesDirectoryPath() + Configuration.site_name + File.separator + "collect" : Configuration.gsdl_path + "collect";
        if (bl) {
            string = string + File.separator;
        }
        return string;
    }

    public static String getGLIDirectoryPath() {
        return gli_directory_path;
    }

    public static String getGLIMetadataDirectoryPath() {
        return Gatherer.getGLIDirectoryPath() + "metadata" + File.separator;
    }

    public static String getGLIUserDirectoryPath() {
        return gli_user_directory_path;
    }

    public static String getGLIUserCacheDirectoryPath() {
        return Gatherer.getGLIUserDirectoryPath() + "cache" + File.separator;
    }

    public static String getGLIUserLogDirectoryPath() {
        return Gatherer.getGLIUserDirectoryPath() + "log" + File.separator;
    }

    public static String getSitesDirectoryPath() {
        return Configuration.gsdl3_web_path + "sites" + File.separator;
    }

    public static String getCurrentSiteDirectoryPath() {
        return Gatherer.getSitesDirectoryPath() + Configuration.site_name + File.separator;
    }

    public static String getCurrentCollectionDirectoryPath() {
        return Gatherer.getCollectDirectoryPath() + File.separator + c_man.getCollection().getName() + File.separator;
    }

    public static void setCollectDirectoryPath(String string) {
        non_standard_collect_directory_path = string;
        if (!non_standard_collect_directory_path.endsWith(File.separator)) {
            non_standard_collect_directory_path = non_standard_collect_directory_path + File.separator;
        }
    }

    public static void setGLIDirectoryPath(String string) {
        gli_directory_path = string;
    }

    public static void setGLIUserDirectoryPath(String string) {
        gli_user_directory_path = string;
        File file = new File(gli_user_directory_path);
        if (!file.exists() && !file.mkdirs()) {
            System.err.println("Error: Unable to make directory: " + file);
        }
    }

    public static void initCollectDirectoryPath() {
        Object object;
        String string;
        String string2 = string = Gatherer.getDefaultGSCollectDirectoryPath(false);
        if (!isGsdlRemote && !open_collection_file_path.startsWith(string)) {
            if (isWebswing) {
                open_collection_file_path = string;
                Gatherer.setCollectDirectoryPath(string);
            } else {
                object = null;
                if (!open_collection_file_path.equals("")) {
                    String string3;
                    object = !open_collection_file_path.endsWith("gli.col") ? new File(open_collection_file_path) : new File(open_collection_file_path).getParentFile().getParentFile();
                    String string4 = string3 = GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
                    if (new File(((File)object).getAbsolutePath() + File.separator + string3).exists()) {
                        object = ((File)object).getParentFile();
                    }
                    Gatherer.nonStandardCollectHomeMessage(((File)object).getAbsolutePath(), string);
                }
                if (object == null || !((File)object).exists()) {
                    open_collection_file_path = string;
                } else {
                    string2 = ((File)object).getAbsolutePath();
                }
                Gatherer.setCollectDirectoryPath(string2);
            }
        }
        if (!isGsdlRemote) {
            object = Gatherer.getGsdlSiteConfigFile();
            gsdlsite_collecthome = string2.equals(string) ? Utility.updatePropertyConfigFile((String)object, "collecthome", null) : Utility.updatePropertyConfigFile((String)object, "collecthome", "\"" + string2 + "\"");
        }
    }

    public static String getGsdlSiteConfigFile() {
        if (GS3) {
            return Configuration.gsdl3_writableweb_path + File.separator + "WEB-INF" + File.separator + "cgi" + File.separator + "gsdl3site.cfg";
        }
        String string = System.getenv("GSDLARCH");
        if (string == null) {
            string = "";
        }
        return Configuration.gsdl_path + "cgi-bin" + File.separator + client_operating_system + string + File.separator + "gsdlsite.cfg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collectDirectoryHasChanged(String string, String string2, final Component component) {
        if (string.equals(string2)) {
            return;
        }
        Cursor cursor = component.getCursor();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                component.setCursor(new Cursor(3));
            }
        };
        Timer timer = new Timer();
        try {
            timer.schedule(timerTask, 500L);
            if (c_man.getCollection() != null) {
                g_man.saveThenCloseCurrentCollection();
            }
            if (string2.equals(Gatherer.getDefaultGSCollectDirectoryPath(true))) {
                Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, "");
            } else {
                Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, string2);
            }
            Gatherer.setCollectDirectoryPath(string2);
            g_man.refreshWorkspaceTreeGreenstoneCollections();
            if (isGsdlRemote) {
                return;
            }
            String string3 = Gatherer.getCollectDirectoryPath();
            if ((string3 = string3.substring(0, string3.length() - 1)) != null) {
                string3 = "\"" + string3 + "\"";
            }
            Utility.updatePropertyConfigFile(Gatherer.getGsdlSiteConfigFile(), "collecthome", string3);
            if (!GS3 && isLocalLibrary) {
                LocalLibraryServer.reconfigure();
            }
        }
        finally {
            timer.cancel();
            component.setCursor(cursor);
        }
    }

    public static void refresh(int n) {
        if (g_man != null) {
            g_man.refresh(n, c_man.ready());
        }
        System.gc();
    }

    public static void configGS3Server(String string, String string2) {
        if (Configuration.library_url == null) {
            System.err.println("Error: you have not provided the Greenstone Library address.");
            return;
        }
        try {
            String string3 = null;
            string3 = !isWebswing ? Configuration.library_url.toString() : Configuration.local_url.toString();
            String string4 = Configuration.getServletPath();
            String string5 = string3 + string4 + string2;
            URL uRL = new URL(string5);
            DebugStream.println("Action: " + string5);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            int n = httpURLConnection.getResponseCode();
            if (200 <= n && n < 300) {
                DebugStream.println("200 - Complete.");
            } else {
                DebugStream.println("404 - Failed.");
            }
            uRL = null;
        }
        catch (ConnectException connectException) {
            JOptionPane.showMessageDialog(g_man, Dictionary.get("Preferences.Connection.Library_Path_Connection_Failure", Configuration.library_url.toString()), Dictionary.get("General.Warning"), 2);
            DebugStream.println(connectException.getMessage());
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public static void spawnApplication(File file) {
        String[] stringArray = assoc_man.getCommand(file);
        if (stringArray != null) {
            ExternalApplication externalApplication = new ExternalApplication(stringArray);
            apps.add(externalApplication);
            externalApplication.start();
        }
    }

    public static void spawnApplication(String string) {
        ExternalApplication externalApplication = new ExternalApplication(string);
        apps.add(externalApplication);
        externalApplication.start();
    }

    public static void spawnApplication(String string, String string2) {
        ExternalApplication externalApplication = new ExternalApplication(string, string2);
        apps.add(externalApplication);
        externalApplication.start();
    }

    public static void spawnApplication(String[] stringArray, String string) {
        ExternalApplication externalApplication = new ExternalApplication(stringArray, string);
        apps.add(externalApplication);
        externalApplication.start();
    }

    public static void terminateApplication(String string) {
        for (int i = 0; i < apps.size(); ++i) {
            ExternalApplication externalApplication = (ExternalApplication)apps.get(i);
            if (externalApplication.getID() == null || !externalApplication.getID().equals(string)) continue;
            externalApplication.stopExternalApplication();
            apps.remove(externalApplication);
        }
    }

    public static void spawnBrowser(String string) {
        String string2 = assoc_man.getBrowserCommand(string);
        if (string2 != null) {
            BrowserApplication browserApplication = new BrowserApplication(string2, string);
            apps.add(browserApplication);
            browserApplication.start();
        }
    }

    public static void missingEXEC(final String string) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    String string3 = "general.library_url" + Configuration.gliPropertyNameSuffix();
                    WarningDialog warningDialog = GS3 ? new WarningDialog("warning.MissingEXEC", Dictionary.get("MissingEXEC_GS3.Title"), Dictionary.get("MissingEXEC_GS3.Message"), string3, false, false) : new WarningDialog("warning.MissingEXEC", Dictionary.get("MissingEXEC.Title"), Dictionary.get("MissingEXEC.Message"), string3, false);
                    URLField.Text text = new URLField.Text(Configuration.getColor("coloring.editable_foreground", false), Configuration.getColor("coloring.editable_background", false));
                    if (string != null) {
                        text.setText(string);
                        text.selectAll();
                    }
                    warningDialog.setValueField(text);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                    String string2 = Configuration.getString(string3, true);
                    if (!string2.equals("")) {
                        try {
                            if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
                                string2 = "http://" + string2;
                                Configuration.setString(string3, true, string2);
                            }
                            Configuration.library_url = new URL(string2);
                        }
                        catch (MalformedURLException malformedURLException) {
                            DebugStream.printStackTrace(malformedURLException);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Properties loadBuildProperties(String string) {
        File file = new File(string + File.separator + "build.properties");
        Properties properties = null;
        if (file.exists()) {
            properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                System.err.println("couldn't load properties " + exception.toString());
                properties = null;
            }
        }
        return properties;
    }

    private static void popupFedoraInfo() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    String string;
                    FedoraLogin fedoraLogin = new FedoraLogin("Fedora Login", false);
                    if (Configuration.library_url == null && !(string = fedoraLogin.getLibraryURL()).equals("")) {
                        try {
                            Configuration.library_url = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            DebugStream.printStackTrace(malformedURLException);
                        }
                    }
                    boolean bl = true;
                    do {
                        String[] stringArray;
                        if (!fedoraLogin.loginRequested()) {
                            System.exit(0);
                            continue;
                        }
                        bl = fedoraLogin.loginRequested();
                        String string2 = fedoraLogin.getHostname();
                        String string3 = fedoraLogin.getPort();
                        String string4 = fedoraLogin.getUsername();
                        String string5 = fedoraLogin.getPassword();
                        String string6 = fedoraLogin.getProtocol();
                        Configuration.fedora_info.setHostname(string2);
                        Configuration.fedora_info.setPort(string3);
                        Configuration.fedora_info.setUsername(string4);
                        Configuration.fedora_info.setPassword(string5);
                        Configuration.fedora_info.setProtocol(string6);
                        String string7 = string6 + "://" + string2 + ":" + string3 + "/fedora";
                        String string8 = string4 + ":" + string5;
                        String string9 = Base64.encodeBytes(string8.getBytes());
                        try {
                            URL uRL = new URL(string7);
                            stringArray = uRL.openConnection();
                            stringArray.setRequestProperty("Authorization", "Basic " + string9);
                            InputStream inputStream = stringArray.getInputStream();
                            bl = false;
                            fedoraLogin.dispose();
                        }
                        catch (Exception exception) {
                            stringArray = new String[]{"Failed to connect to the Fedora server.", "It might not be running, or", "incorrect username and/or password."};
                            fedoraLogin.setErrorMessage(stringArray);
                            fedoraLogin.setVisible(true);
                        }
                    } while (bl);
                    fedoraLogin = null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void requestGLIServerURL() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    String[] stringArray = new String[]{"http://localhost:8383/greenstone3/cgi-bin/gliserver.pl", "http://localhost:8080/gsdl/cgi-bin/gliserver.pl"};
                    WarningDialog warningDialog = new WarningDialog("warning.MissingGLIServer", Dictionary.get("MissingGLIServer.Title"), Dictionary.get("MissingGLIServer.Message"), "general.gliserver_url", false, false);
                    warningDialog.setValueField(new URLField.DropDown(Configuration.getColor("coloring.editable_foreground", false), Configuration.getColor("coloring.editable_background", false), stringArray, "general.gliserver_url", "general.open_collection" + Configuration.gliPropertyNameSuffix(), "gliserver.pl"));
                    if (default_gliserver_url != null) {
                        warningDialog.setValueField(default_gliserver_url.toString());
                    }
                    warningDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            Gatherer.exit();
                        }
                    });
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                    String string = Configuration.getString("general.gliserver_url", true);
                    if (!string.equals("")) {
                        try {
                            Configuration.gliserver_url = new URL(string);
                            Configuration.setString("general.gliserver_url", true, string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            DebugStream.printStackTrace(malformedURLException);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void missingGSDL() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    WarningDialog warningDialog = new WarningDialog("warning.MissingGSDL", Dictionary.get("MissingGSDL.Title"), Dictionary.get("MissingGSDL.Message"), null, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void missingImageMagick() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    WarningDialog warningDialog = new WarningDialog("warning.MissingImageMagick", Dictionary.get("MissingImageMagick.Title"), Dictionary.get("MissingImageMagick.Message"), null, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void missingPDFBox(final String string, final String string2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    String string3 = "";
                    if (!Gatherer.PROGRAM_VERSION.equals("trunk")) {
                        string3 = "main/tags/2.88/";
                    }
                    WarningDialog warningDialog = new WarningDialog("warning.MissingPDFBox", Dictionary.get("MissingPDFBox.Title"), Dictionary.get("MissingPDFBox.Message", new String[]{string3, string, string2}), null, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void missingPERL() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    WarningDialog warningDialog = new WarningDialog("warning.MissingPERL", Dictionary.get("MissingPERL.Title"), Dictionary.get("MissingPERL.Message"), null, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void nonStandardCollectHomeMessage(final String string, final String string2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    WarningDialog warningDialog = new WarningDialog("warning.NonStandardCollectHome", Dictionary.get("NonStandardCollectHome.Title"), Dictionary.get("NonStandardCollectHome.Message", new String[]{string, string2}), null, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void multipleFilenameEncodingsNotSupported() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    WarningDialog warningDialog = new WarningDialog("warning.NoEncodingSupport", Dictionary.get("NoEncodingSupport.Title"), Dictionary.get("NoEncodingSupport.Message"), null, false);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setProxy() {
        try {
            boolean bl = Configuration.get("general.use_proxy", true);
            Gatherer.setProxyForProtocol("http", bl);
            Gatherer.setProxyForProtocol("https", bl);
            Gatherer.setProxyForProtocol("ftp", bl);
        }
        catch (Exception exception) {
            DebugStream.println("Error in Gatherer.initProxy(): " + exception);
            DebugStream.printStackTrace(exception);
        }
    }

    private static void setProxyForProtocol(String string, boolean bl) throws Exception {
        if (bl) {
            if (System.getenv(string + "_proxy") != null) {
                System.err.println("Overriding original " + string + " proxy settings");
            }
            System.setProperty(string + ".proxyHost", Configuration.getString("general." + string.toUpperCase() + "_proxy_host", true));
            System.setProperty(string + ".proxyPort", Configuration.getString("general." + string.toUpperCase() + "_proxy_port", true));
            if (string.equals("http")) {
                System.setProperty(string + ".proxyType", "4");
            }
        } else {
            if (System.getenv(string + "_proxy") != null) {
                System.err.println("Restoring original " + string + " proxy settings");
            }
            System.setProperty(string + ".proxyHost", "");
            System.setProperty(string + ".proxyPort", "");
        }
    }

    static {
        g_man = null;
        g_man_built = false;
        GS3 = false;
        isApplet = false;
        isGsdlRemote = false;
        isLocalLibrary = false;
        isWebswing = false;
        startup_proxy_settings = new Properties();
        isDownloadEnabled = true;
        feedback_enabled = true;
        feedback_dialog = null;
        cgiBase = "";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = JTextComponent.getKeymap("default");
        keymap.removeKeyStrokeBinding(keyStroke);
        default_gliserver_url = null;
        local_tomcat_context_url_string = null;
        PRINT_THREAD_NAMES = false;
    }

    public static class WebswingAuthenticator
    extends GAuthenticator {
        protected static String username = null;
        protected static HashSet<String> groups;
        protected static String userJSessionID;
        protected static String rawgroups;

        protected void displayError(String string) {
            WarningDialog warningDialog = new WarningDialog("warning.AuthenticationError", Dictionary.get("WebswingAuthenticationError.Title"), string, null, false, false);
            warningDialog.display();
            warningDialog.dispose();
            warningDialog = null;
        }

        public WebswingAuthenticator() {
        }

        public WebswingAuthenticator(String string, String string2, String string3) {
            username = string;
            rawgroups = string2;
            userJSessionID = string3;
        }

        public String getUsername() {
            return username;
        }

        public String doRequest(String string, boolean bl) {
            String string2;
            try {
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (bl) {
                    httpURLConnection.setRequestProperty("Cookie", "JSESSIONID=" + userJSessionID);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                string2 = "";
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    string2 = string2 + string3;
                }
            }
            catch (Exception exception) {
                System.err.println("There was an exception " + exception.getMessage());
                this.displayError("There was an exception " + exception.getMessage());
                return null;
            }
            int n = string2.indexOf("id=\"gs_content\"");
            if (n != -1) {
                n = string2.indexOf(">", n);
                int n2 = string2.indexOf("<", n);
                string2 = string2.substring(n + 1, n2);
                string2 = string2.trim();
            }
            if (string2.startsWith("Authentication failed:")) {
                System.err.println("Authentication Error: " + string2);
                this.displayError(string2.replaceAll("&apos;", "'"));
                return null;
            }
            return string2;
        }

        public boolean authenticate(String string) {
            Object object;
            Object object2;
            String string2 = null;
            boolean bl = false;
            if (username != null && (string2 = this.doRequest((String)(object2 = string + "?a=s&sa=get-groups-from-session&excerptid=gs_content&un=" + username), true)) != null) {
                bl = true;
            }
            if (!bl) {
                object2 = this.getPasswordAuthentication();
                if (object2 == null) {
                    System.err.println("Authentication cancelled.");
                    this.displayError(Dictionary.get("WebswingAuthenticationError.Cancelled"));
                    return false;
                }
                username = ((PasswordAuthentication)object2).getUserName();
                String string3 = new String(((PasswordAuthentication)object2).getPassword());
                object = string + "?a=s&sa=authenticated-ping&excerptid=gs_content&un=" + username + "&pw=" + string3;
                string2 = this.doRequest((String)object, false);
                if (string2 == null) {
                    return false;
                }
            }
            groups = new HashSet();
            object2 = string2.split(",");
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = object2[i];
                if (!((String)object).equals("administrator") && !((String)object).equals("all-collections-editor") && !((String)object).equals("personal-collections-editor") && !((String)object).equals("shared-collections-editor") && !((String)object).endsWith("-collection-editor")) continue;
                groups.add((String)object);
            }
            if (groups.size() == 0) {
                System.err.println("User not in any collection editing groups");
                this.displayError(Dictionary.get("WebswingAuthenticationError.NoPermissions"));
                return false;
            }
            return true;
        }

        public boolean canEditCollection(String string) {
            if (groups.contains("administrator") || groups.contains("all-collections-editor")) {
                return true;
            }
            if (groups.contains("shared-collections-editor") && !string.contains("@")) {
                return true;
            }
            if (groups.contains("personal-collections-editor") && string.startsWith(username + "@")) {
                return true;
            }
            return groups.contains(string + "-collection-editor");
        }

        public boolean canEditAllCollections() {
            return groups.contains("administrator") || groups.contains("all-collections-editor");
        }

        public boolean canEditSharedCollections() {
            return groups.contains("administrator") || groups.contains("all-collections-editor") || groups.contains("shared-collections-editor");
        }

        public boolean canEditPersonalCollections() {
            return groups.contains("administrator") || groups.contains("all-collections-editor") || groups.contains("personal-collections-editor");
        }

        public boolean canCreateNewCollections() {
            return groups.contains("administrator") || groups.contains("all-collections-editor") || groups.contains("shared-collections-editor") || groups.contains("personal-collections-editor");
        }

        public PasswordAuthentication getAuthentication(String string, String string2) {
            return this.getPasswordAuthentication(string, string2);
        }

        public PasswordAuthentication getAuthentication() {
            return this.getPasswordAuthentication();
        }

        @Override
        protected String getMessageString() {
            return Dictionary.get("RemoteGreenstoneServer.Authentication_Message");
        }
    }

    public static class ProgramInstalledTest
    implements SafeProcess.ExceptionHandler {
        private final String[] command;
        private boolean returnValue = false;

        public ProgramInstalledTest(String string) {
            this.command = new String[]{string, "--version"};
        }

        public ProgramInstalledTest(String string, String string2) {
            this.command = new String[]{string, string2};
        }

        public boolean found() {
            try {
                SafeProcess safeProcess = new SafeProcess(this.command);
                safeProcess.setExceptionHandler(this);
                int n = safeProcess.runBasicProcess();
                this.returnValue = n == 0 || n == 1;
            }
            catch (Exception exception) {
                this.returnValue = false;
            }
            return this.returnValue;
        }

        @Override
        public void gotException(Exception exception) {
            this.returnValue = false;
            if (!(exception instanceof IOException)) {
                SafeProcess.log("Gatherer.ProgramInstalledTest: got exception" + exception.getMessage(), exception);
            }
        }

        public String toString() {
            return this.command[0];
        }
    }

    private class PerlTest {
        private String[] command = new String[2];

        public PerlTest() {
            this.command[0] = Utility.isWindows() ? "Perl.exe" : "perl";
            this.command[1] = "-version";
        }

        public boolean found() {
            try {
                SafeProcess safeProcess = new SafeProcess(this.command);
                int n = safeProcess.runBasicProcess();
                return n == 0;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public String toString() {
            return this.command[0];
        }
    }

    private class ImageMagickTest {
        private ImageMagickTest() {
        }

        public boolean found() {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!isGsdlRemote) {
                if (Configuration.perl_path != null) {
                    arrayList.add(Configuration.perl_path);
                } else {
                    System.err.println("Warning: ImageMagickTest::found() perl_path not set, calling 'perl' instead.");
                    arrayList.add("perl");
                }
                arrayList.add("-S");
            }
            arrayList.add("gs-magick.pl");
            if (Utility.isWindows()) {
                arrayList.add("identify.exe");
            } else {
                arrayList.add("identify");
            }
            arrayList.add("-version");
            String[] stringArray = arrayList.toArray(new String[0]);
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + " ";
            }
            DebugStream.println("***** Running ImageMagickTest command: " + string);
            SafeProcess safeProcess = new SafeProcess(stringArray);
            int n = safeProcess.runProcess();
            String string2 = safeProcess.getStdOutput().toLowerCase();
            if (string2.indexOf("version") != -1 || string2.indexOf("imagemagick") != -1) {
                bl = true;
            }
            return bl;
        }
    }

    private static class BrowserApplication
    extends Thread {
        private SafeProcess process = null;
        private String command = null;
        private String url = null;
        private String[] commands = null;

        public BrowserApplication(String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            this.commands = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.commands[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            this.url = string2;
        }

        @Override
        public void run() {
            if (this.commands == null) {
                apps.remove(this);
                return;
            }
            try {
                String string = this.commands[0];
                String string2 = string.toLowerCase();
                if (string2.indexOf("mozilla") != -1 || string2.indexOf("netscape") != -1) {
                    DebugStream.println("found mozilla or netscape, trying remote it");
                    String[] stringArray = new String[]{string, "-raise", "-remote", "openURL(" + this.url + ",new-tab)"};
                    this.printArray(stringArray);
                    this.process = new SafeProcess(stringArray);
                    int n = this.process.runProcess();
                    if (n != 0) {
                        DebugStream.println("couldn't do remote, trying original command");
                        this.printArray(this.commands);
                        this.process = null;
                        this.process = new SafeProcess(this.commands);
                        this.process.runProcess();
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < this.commands.length; ++i) {
                        stringBuffer.append(this.commands[i]);
                        stringBuffer.append(" ");
                    }
                    DebugStream.println("Running " + stringBuffer.toString());
                    this.process = new SafeProcess(this.commands);
                    this.process.runProcess();
                }
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
            apps.remove(this);
            if (apps.size() == 0 && exit) {
                System.exit(exit_status);
            }
        }

        public void printArray(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                DebugStream.print(stringArray[i] + " ");
                System.err.println(stringArray[i] + " ");
            }
        }

        public void stopBrowserApplication() {
            if (this.process != null) {
                SafeProcess.log("*** stopBrowserApplication called.");
                this.process.cancelRunningProcess();
            }
        }
    }

    private static class ExternalApplication
    extends Thread {
        private SafeProcess process = null;
        private String command = null;
        private String[] commands = null;
        private String ID = null;

        public ExternalApplication(String string) {
            this.command = string;
        }

        public ExternalApplication(String[] stringArray) {
            this.commands = stringArray;
        }

        public ExternalApplication(String string, String string2) {
            this.command = string;
            this.ID = string2;
        }

        public ExternalApplication(String[] stringArray, String string) {
            this.commands = stringArray;
            this.ID = string;
        }

        public String getID() {
            return this.ID;
        }

        @Override
        public void run() {
            try {
                if (this.commands != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < this.commands.length; ++i) {
                        if (this.commands[i].startsWith("\"") || this.commands[i].startsWith("'")) {
                            this.commands[i] = this.commands[i].substring(1);
                        }
                        if (this.commands[i].endsWith("\"") || this.commands[i].endsWith("'")) {
                            this.commands[i] = this.commands[i].substring(0, this.commands[i].length() - 1);
                        }
                        if (i > 0) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(this.commands[i]);
                    }
                    DebugStream.println("Running " + stringBuffer.toString());
                    this.process = new SafeProcess(this.commands);
                } else {
                    DebugStream.println("Running " + this.command);
                    this.process = new SafeProcess(this.command);
                }
                this.process.runProcess();
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
            apps.remove(this);
            if (apps.size() == 0 && exit) {
                System.exit(exit_status);
            }
        }

        public void stopExternalApplication() {
            if (this.process != null) {
                SafeProcess.log("*** stopExternalApplication called.");
                this.process.cancelRunningProcess();
            }
        }
    }
}

