/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;

public class DebugStream {
    private static boolean debugging_enabled = false;
    private static PrintStream debug_stream = null;

    public static void closeDebugStream() {
        if (debug_stream != null) {
            try {
                debug_stream.flush();
                debug_stream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void enableDebugging() {
        debugging_enabled = true;
    }

    public static void setDebugging(boolean bl, String string) {
        if (bl) {
            System.err.println("**** START DEBUGGING (enabled by: " + string + ")");
        } else {
            System.err.println("**** END DEBUGGING (called by: " + string + ")");
        }
        debugging_enabled = bl;
    }

    public static synchronized boolean isDebuggingEnabled() {
        return debugging_enabled;
    }

    public static synchronized void print(Properties properties) {
        if (debugging_enabled) {
            if (debug_stream != null) {
                properties.list(debug_stream);
            }
            properties.list(System.err);
        }
    }

    public static synchronized void print(String string) {
        if (debugging_enabled) {
            if (debug_stream != null) {
                debug_stream.print(string);
            }
            System.err.print(string);
        }
    }

    public static synchronized void println(String string) {
        if (debugging_enabled) {
            if (debug_stream != null) {
                debug_stream.println(string);
            }
            System.err.println(string);
        }
    }

    public static synchronized void printStackTrace(Exception exception) {
        if (debugging_enabled && debug_stream != null) {
            exception.printStackTrace(debug_stream);
        }
        exception.printStackTrace();
    }

    public static void setDebugFile(String string) {
        try {
            debug_stream = new PrintStream(new FileOutputStream(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

