/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDExternalID;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDNotation;
import com.wutka.dtd.DTDNotationList;
import com.wutka.dtd.DTDOutput;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParser;
import com.wutka.dtd.DTDPublic;
import com.wutka.dtd.DTDSequence;
import com.wutka.dtd.DTDSystem;
import java.io.File;
import java.util.Enumeration;

class Tokenize {
    Tokenize() {
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            DTDOutput dTDOutput;
            DTDParser dTDParser = new DTDParser(new File(stringArray[0]), true);
            DTD dTD = dTDParser.parse(true);
            if (dTD.rootElement != null) {
                System.out.println("Root element is probably: " + dTD.rootElement.name);
            }
            Enumeration enumeration = dTD.elements.elements();
            while (enumeration.hasMoreElements()) {
                dTDOutput = (DTDElement)enumeration.nextElement();
                System.out.println("Element: " + dTDOutput.name);
                System.out.print("   Content: ");
                Tokenize.dumpDTDItem(dTDOutput.content);
                System.out.println();
                if (dTDOutput.attributes.size() <= 0) continue;
                System.out.println("   Attributes: ");
                object = dTDOutput.attributes.elements();
                while (object.hasMoreElements()) {
                    System.out.print("        ");
                    DTDAttribute dTDAttribute = (DTDAttribute)object.nextElement();
                    Tokenize.dumpAttribute(dTDAttribute);
                }
                System.out.println();
            }
            enumeration = dTD.entities.elements();
            while (enumeration.hasMoreElements()) {
                dTDOutput = (DTDEntity)enumeration.nextElement();
                if (((DTDEntity)dTDOutput).isParsed) {
                    System.out.print("Parsed ");
                }
                System.out.println("Entity: " + ((DTDEntity)dTDOutput).name);
                if (((DTDEntity)dTDOutput).value != null) {
                    System.out.println("    Value: " + ((DTDEntity)dTDOutput).value);
                }
                if (((DTDEntity)dTDOutput).externalID != null) {
                    if (((DTDEntity)dTDOutput).externalID instanceof DTDSystem) {
                        System.out.println("    System: " + ((DTDEntity)dTDOutput).externalID.system);
                    } else {
                        object = (DTDPublic)((DTDEntity)dTDOutput).externalID;
                        System.out.println("    Public: " + ((DTDPublic)object).pub + " " + ((DTDExternalID)object).system);
                    }
                }
                if (((DTDEntity)dTDOutput).ndata == null) continue;
                System.out.println("    NDATA " + ((DTDEntity)dTDOutput).ndata);
            }
            enumeration = dTD.notations.elements();
            while (enumeration.hasMoreElements()) {
                dTDOutput = (DTDNotation)enumeration.nextElement();
                System.out.println("Notation: " + ((DTDNotation)dTDOutput).name);
                if (((DTDNotation)dTDOutput).externalID == null) continue;
                if (((DTDNotation)dTDOutput).externalID instanceof DTDSystem) {
                    System.out.println("    System: " + ((DTDNotation)dTDOutput).externalID.system);
                    continue;
                }
                object = (DTDPublic)((DTDNotation)dTDOutput).externalID;
                System.out.print("    Public: " + ((DTDPublic)object).pub + " ");
                if (((DTDExternalID)object).system != null) {
                    System.out.println(((DTDExternalID)object).system);
                    continue;
                }
                System.out.println();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public static void dumpDTDItem(DTDItem dTDItem) {
        if (dTDItem == null) {
            return;
        }
        if (dTDItem instanceof DTDAny) {
            System.out.print("Any");
        } else if (dTDItem instanceof DTDEmpty) {
            System.out.print("Empty");
        } else if (dTDItem instanceof DTDName) {
            System.out.print(((DTDName)dTDItem).value);
        } else if (dTDItem instanceof DTDChoice) {
            System.out.print("(");
            DTDItem[] dTDItemArray = ((DTDChoice)dTDItem).getItems();
            int n = 0;
            while (n < dTDItemArray.length) {
                if (n > 0) {
                    System.out.print("|");
                }
                Tokenize.dumpDTDItem(dTDItemArray[n]);
                ++n;
            }
            System.out.print(")");
        } else if (dTDItem instanceof DTDSequence) {
            System.out.print("(");
            DTDItem[] dTDItemArray = ((DTDSequence)dTDItem).getItems();
            int n = 0;
            while (n < dTDItemArray.length) {
                if (n > 0) {
                    System.out.print(",");
                }
                Tokenize.dumpDTDItem(dTDItemArray[n]);
                ++n;
            }
            System.out.print(")");
        } else if (dTDItem instanceof DTDMixed) {
            System.out.print("(");
            DTDItem[] dTDItemArray = ((DTDMixed)dTDItem).getItems();
            int n = 0;
            while (n < dTDItemArray.length) {
                if (n > 0) {
                    System.out.print(",");
                }
                Tokenize.dumpDTDItem(dTDItemArray[n]);
                ++n;
            }
            System.out.print(")");
        } else if (dTDItem instanceof DTDPCData) {
            System.out.print("#PCDATA");
        }
        if (dTDItem.cardinal == DTDCardinal.OPTIONAL) {
            System.out.print("?");
        } else if (dTDItem.cardinal == DTDCardinal.ZEROMANY) {
            System.out.print("*");
        } else if (dTDItem.cardinal == DTDCardinal.ONEMANY) {
            System.out.print("+");
        }
    }

    public static void dumpAttribute(DTDAttribute dTDAttribute) {
        System.out.print(dTDAttribute.name + " ");
        if (dTDAttribute.type instanceof String) {
            System.out.print(dTDAttribute.type);
        } else if (dTDAttribute.type instanceof DTDEnumeration) {
            System.out.print("(");
            String[] stringArray = ((DTDEnumeration)dTDAttribute.type).getItems();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(stringArray[n]);
                ++n;
            }
            System.out.print(")");
        } else if (dTDAttribute.type instanceof DTDNotationList) {
            System.out.print("Notation (");
            String[] stringArray = ((DTDNotationList)dTDAttribute.type).getItems();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(stringArray[n]);
                ++n;
            }
            System.out.print(")");
        }
        if (dTDAttribute.decl != null) {
            System.out.print(" " + dTDAttribute.decl.name);
        }
        if (dTDAttribute.defaultValue != null) {
            System.out.print(" " + dTDAttribute.defaultValue);
        }
        System.out.println();
    }
}

