/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;

public class PageHeader
implements BlockView {
    private static final short O_MAGIC = 0;
    private static final short O_NEXT = 2;
    private static final short O_PREV = 10;
    protected static final short SIZE = 18;
    protected BlockIo block;

    protected PageHeader(BlockIo blockIo) {
        this.initialize(blockIo);
        if (!this.magicOk()) {
            throw new Error("CRITICAL: page header magic for block " + blockIo.getBlockId() + " not OK " + this.getMagic());
        }
    }

    PageHeader(BlockIo blockIo, short s) {
        this.initialize(blockIo);
        this.setType(s);
    }

    static PageHeader getView(BlockIo blockIo) {
        BlockView blockView = blockIo.getView();
        if (blockView != null && blockView instanceof PageHeader) {
            return (PageHeader)blockView;
        }
        return new PageHeader(blockIo);
    }

    private void initialize(BlockIo blockIo) {
        this.block = blockIo;
        blockIo.setView(this);
    }

    private boolean magicOk() {
        short s = this.getMagic();
        return s >= 4945 && s <= 4949;
    }

    protected void paranoiaMagicOk() {
        if (!this.magicOk()) {
            throw new Error("CRITICAL: page header magic not OK " + this.getMagic());
        }
    }

    short getMagic() {
        return this.block.readShort(0);
    }

    long getNext() {
        this.paranoiaMagicOk();
        return this.block.readLong(2);
    }

    void setNext(long l) {
        this.paranoiaMagicOk();
        this.block.writeLong(2, l);
    }

    long getPrev() {
        this.paranoiaMagicOk();
        return this.block.readLong(10);
    }

    void setPrev(long l) {
        this.paranoiaMagicOk();
        this.block.writeLong(10, l);
    }

    void setType(short s) {
        this.block.writeShort(0, (short)(4945 + s));
    }
}

