/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.PhysicalRowId;

final class Location {
    private long block;
    private short offset;

    Location(long l, short s) {
        this.block = l;
        this.offset = s;
    }

    Location(long l) {
        this.offset = (short)(l & 0xFFFFL);
        this.block = l >> 16;
    }

    Location(PhysicalRowId physicalRowId) {
        this.block = physicalRowId.getBlock();
        this.offset = physicalRowId.getOffset();
    }

    long getBlock() {
        return this.block;
    }

    short getOffset() {
        return this.offset;
    }

    long toLong() {
        return (this.block << 16) + (long)this.offset;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Location)) {
            return false;
        }
        Location location = (Location)object;
        return location.block == this.block && location.offset == this.offset;
    }

    public String toString() {
        return "PL(" + this.block + ":" + this.offset + ")";
    }
}

