/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.LuceneWrapper4;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.FSDirectory;
import org.greenstone.LuceneWrapper4.GS2Analyzer;
import org.greenstone.LuceneWrapper4.GSLuceneUtil;

public class GS2LuceneEditor {
    private boolean debug = true;
    private String index_path;

    public static void main(String[] stringArray) throws Exception {
        int n = -1;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].equals("--index")) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("--nodeid")) {
                String string5 = stringArray[i + 1];
                n = Integer.parseInt(string5);
                string5 = null;
                continue;
            }
            if (stringArray[i].equals("--field")) {
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("--oldvalue")) {
                string4 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("--newvalue")) {
                string3 = stringArray[i + 1];
                continue;
            }
            System.out.println("Error! Unknown argument: " + stringArray[i]);
            GS2LuceneEditor.printUsage();
        }
        if (string2.equals("")) {
            System.out.println("Error! Missing index path");
            GS2LuceneEditor.printUsage();
        }
        if (string.equals("")) {
            System.out.println("Error! Missing field");
            GS2LuceneEditor.printUsage();
        }
        if (n == -1) {
            System.out.println("Error! Missing or invalid Node ID");
            GS2LuceneEditor.printUsage();
        }
        if (string4.equals("") && string3.equals("")) {
            System.out.println("Error! No modification requested");
            GS2LuceneEditor.printUsage();
        }
        GS2LuceneEditor gS2LuceneEditor = new GS2LuceneEditor(string2);
        gS2LuceneEditor.editIndex(n, string, string4, string3);
        gS2LuceneEditor.destroy();
        gS2LuceneEditor = null;
    }

    public GS2LuceneEditor(String string) throws IOException {
        GS2Analyzer gS2Analyzer = new GS2Analyzer();
        this.index_path = string;
    }

    public void debug(String string) {
        if (this.debug) {
            System.err.println(string);
        }
    }

    public void destroy() throws IOException {
    }

    public void editIndex(int n, String string, String string2, String string3) throws IOException {
        this.debug("GS2LuceneEditor.editIndex(" + n + ",'" + string + "','" + string2 + "','" + string3 + "')");
        Term term = new Term("docOID", String.valueOf(n));
        FSDirectory fSDirectory = FSDirectory.open(new File(this.index_path));
        DirectoryReader directoryReader = DirectoryReader.open(fSDirectory);
        IndexSearcher indexSearcher = new IndexSearcher(directoryReader);
        TermQuery termQuery = new TermQuery(term);
        TopDocs topDocs = indexSearcher.search((Query)termQuery, 1);
        int n2 = -1;
        if (topDocs != null && topDocs.scoreDocs.length > 0) {
            n2 = topDocs.scoreDocs[0].doc;
        }
        if (n2 != -1) {
            this.debug("* Found document #" + n2);
            Document document = directoryReader.document(n2);
            directoryReader.close();
            IndexWriter indexWriter = GSLuceneUtil.getIndexWriter(this.index_path, false);
            this.debug("- Initial number of documents in index: " + indexWriter.numDocs());
            indexWriter.deleteDocuments(term);
            this.debug("* Removed document from index prior to editing");
            this.debug("* Modifying the value of the field: " + string);
            this.doEdit(document, string, string2, string3);
            this.debug("* Modifying the value of the field: ZZ");
            this.doEdit(document, "ZZ", string2, string3);
            indexWriter.addDocument(document);
            this.debug("* Reindexing modified document");
            indexWriter.close();
            indexWriter = null;
        } else {
            this.debug("- No such document!");
            Document document = new Document();
            this.debug("* Adding the value to the field: " + string);
            this.doEdit(document, string, string2, string3);
            this.debug("* Adding the value to the field: ZZ");
            this.doEdit(document, "ZZ", string2, string3);
            document.add(new Field("docOID", String.valueOf(n), Field.Store.YES, Field.Index.ANALYZED));
            IndexWriter indexWriter = GSLuceneUtil.getIndexWriter(this.index_path, false);
            indexWriter.addDocument(document);
            this.debug("* Indexing new document");
            indexWriter.close();
            indexWriter = null;
        }
    }

    protected void doEdit(Document document, String string, String string2, String string3) {
        String[] stringArray;
        if (this.debug) {
            this.debug("GS2LuceneEditor.doEdit(Document, \"" + string + "\", \"" + string2 + "\", \"" + string3 + "\")");
        }
        if ((stringArray = document.getValues(string)) != null) {
            int n;
            Vector<String> vector = new Vector<String>(Arrays.asList(stringArray));
            document.removeFields(string);
            if (this.debug) {
                this.debug("- Before modification:");
                for (n = 0; n < vector.size(); ++n) {
                    this.debug("\t" + string + "[" + n + "]: " + vector.get(n));
                }
            }
            if (!string2.equals("")) {
                while (vector.contains(string2)) {
                    vector.remove(string2);
                }
            }
            if (!string3.equals("") && !vector.contains(string3)) {
                vector.add(string3);
            }
            if (this.debug) {
                this.debug("- After modification:");
                for (n = 0; n < vector.size(); ++n) {
                    this.debug("\t" + string + "[" + n + "]: " + vector.get(n));
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                document.add(new Field(string, vector.get(n), Field.Store.YES, Field.Index.ANALYZED));
            }
            vector.clear();
            vector = null;
        } else if (!string3.equals("")) {
            int n;
            Vector<String> vector = new Vector<String>();
            vector.add(string3);
            if (this.debug) {
                this.debug("- Brand spanking new values:");
                for (n = 0; n < vector.size(); ++n) {
                    this.debug("\t" + string + "[" + n + "]: " + vector.get(n));
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                document.add(new Field(string, (String)vector.get(n), Field.Store.YES, Field.Index.ANALYZED));
            }
            vector.clear();
            vector = null;
        } else {
            this.debug("- No such field for this document: " + string);
        }
        stringArray = null;
    }

    public static void printUsage() {
        System.out.println("usage: GS2LuceneEditor --index <path> --nodeid <int> --field <string>");
        System.out.println("                      [--oldvalue <string>] [--newvalue <string>]");
        System.out.println("");
        System.out.println("where:");
        System.out.println("  index    - is the full path to the directory containing the directory");
        System.out.println("             to edit, including the level (ie didx, sidx)");
        System.out.println("  nodeid   - the unique identifier of the document to change. This is the");
        System.out.println("             same as the docnum in the GDBM");
        System.out.println("  field    - the two letter code of the metadata field to edit. These can");
        System.out.println("             found in the build.cfg file. ZZ is not a valid field as it");
        System.out.println("             is handled as a special case");
        System.out.println("  oldvalue - the current value of the metadata field if it is to be");
        System.out.println("             replaced or removed");
        System.out.println("  newvalue - the new value for the metadata field if it is to be replaced");
        System.out.println("             or added");
        System.out.println("");
        System.exit(0);
    }
}

