/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.LuceneWrapper4;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.greenstone.LuceneWrapper4.GS2StandardAnalyzer;
import org.greenstone.LuceneWrapper4.GSLuceneConstants;

public class GS2Analyzer
extends GS2StandardAnalyzer {
    public GS2Analyzer() {
        super(GSLuceneConstants.MATCH_VERSION);
    }

    public GS2Analyzer(String[] stringArray) {
        super(GSLuceneConstants.MATCH_VERSION, StopFilter.makeStopSet(GSLuceneConstants.MATCH_VERSION, stringArray));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String string, Reader reader) {
        final StandardTokenizer standardTokenizer = new StandardTokenizer(GSLuceneConstants.MATCH_VERSION, reader);
        standardTokenizer.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tokenFilter = new StandardFilter(GSLuceneConstants.MATCH_VERSION, standardTokenizer);
        tokenFilter = new LowerCaseFilter(GSLuceneConstants.MATCH_VERSION, tokenFilter);
        tokenFilter = new StopFilter(GSLuceneConstants.MATCH_VERSION, tokenFilter, this.stopwords);
        tokenFilter = new ASCIIFoldingFilter(tokenFilter);
        return new Analyzer.TokenStreamComponents(standardTokenizer, tokenFilter){

            @Override
            protected void setReader(Reader reader) throws IOException {
                standardTokenizer.setMaxTokenLength(GS2Analyzer.this.maxTokenLength);
                super.setReader(reader);
            }
        };
    }
}

