/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.remote;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.GAuthenticator;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.remote.ActionQueue;
import org.greenstone.gatherer.remote.RemoteGreenstoneServerAction;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.util.XMLTools;

public class RemoteGreenstoneServer {
    private static PasswordAuthentication remote_greenstone_server_authentication = null;
    public final String lang_region;
    private ActionQueue remote_greenstone_server_action_queue;
    private ProgressBar progress_bar = new ProgressBar();

    public RemoteGreenstoneServer() {
        this.remote_greenstone_server_action_queue = new ActionQueue();
        String string = System.getenv("LANG");
        this.lang_region = string == null ? "" : string;
    }

    public String deleteCollection(String string) {
        return this.performAction(new RemoteGreenstoneServerAction.DeleteCollectionAction(string));
    }

    public String deleteCollectionFile(String string, File file) {
        return this.performAction(new RemoteGreenstoneServerAction.DeleteCollectionFileAction(string, file));
    }

    public String downloadCollection(String string) {
        return this.performAction(new RemoteGreenstoneServerAction.DownloadCollectionAction(string));
    }

    public String downloadCollectionArchives(String string) {
        return this.performAction(new RemoteGreenstoneServerAction.DownloadCollectionArchivesAction(string));
    }

    public String downloadCollectionConfigurations() {
        return this.performAction(new RemoteGreenstoneServerAction.DownloadCollectionConfigurationsAction());
    }

    public String downloadCollectionFile(String string, File file) {
        return this.performAction(new RemoteGreenstoneServerAction.DownloadCollectionFileAction(string, file));
    }

    public String downloadWebXMLFile() {
        return this.performAction(new RemoteGreenstoneServerAction.DownloadWebXMLFileAction());
    }

    public String getScriptOptions(String string, String string2) {
        return this.performAction(new RemoteGreenstoneServerAction.GetScriptOptionsAction(string, string2));
    }

    public String getSiteNames() {
        return this.performAction(new RemoteGreenstoneServerAction.GetSiteNamesAction());
    }

    public String getDefaultServletPath() {
        return this.performAction(new RemoteGreenstoneServerAction.GetDefaultServletPathAction());
    }

    public String moveCollectionFile(String string, File file, File file2) {
        return this.performAction(new RemoteGreenstoneServerAction.MoveCollectionFileAction(string, file, file2));
    }

    public String newCollectionDirectory(String string, File file) {
        return this.performAction(new RemoteGreenstoneServerAction.NewCollectionDirectoryAction(string, file));
    }

    public String runScript(String string, String string2, String string3, GShell gShell) {
        return this.performAction(new RemoteGreenstoneServerAction.RunScriptAction(string, string2, string3, gShell));
    }

    public String uploadCollectionFile(String string, File file) {
        return this.performAction(new RemoteGreenstoneServerAction.UploadCollectionFilesAction(string, new File[]{file}));
    }

    public String uploadCollectionFiles(String string, File[] fileArray) {
        return this.performAction(new RemoteGreenstoneServerAction.UploadCollectionFilesAction(string, fileArray));
    }

    public String uploadFilesIntoCollection(String string, File[] fileArray, File file) {
        return this.performAction(new RemoteGreenstoneServerAction.UploadFilesIntoCollectionAction(string, fileArray, file));
    }

    public boolean exists(String string, File file) {
        String string2 = this.performAction(new RemoteGreenstoneServerAction.ExistsAction(string, file));
        if (string2.indexOf("exists") != -1) {
            return true;
        }
        if (string2.indexOf("does not exist") != -1) {
            return false;
        }
        return false;
    }

    public int getGreenstoneVersion() {
        String string = this.performAction(new RemoteGreenstoneServerAction.VersionAction());
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(n + 1).trim();
        }
        int n2 = string.equals("") ? -1 : Integer.parseInt(string);
        return n2;
    }

    public String getLibraryURL(String string) {
        String string2 = this.performAction(new RemoteGreenstoneServerAction.LibraryURLSuffixAction());
        int n = string2.indexOf(":");
        if (n != -1) {
            string2 = string2.substring(n + 1).trim();
        }
        n = -1;
        for (int i = 0; i < 3 && (n = string.indexOf("/", n + 1)) != -1; ++i) {
        }
        string = string.substring(0, n);
        return string + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        System.err.println("Exiting, number of jobs on queue: " + this.remote_greenstone_server_action_queue.size());
        while (this.remote_greenstone_server_action_queue.size() > 0) {
            ActionQueue actionQueue = this.remote_greenstone_server_action_queue;
            synchronized (actionQueue) {
                try {
                    DebugStream.println((String)"Waiting for queue to become empty...");
                    this.remote_greenstone_server_action_queue.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String performAction(RemoteGreenstoneServerAction remoteGreenstoneServerAction) {
        if (this.remote_greenstone_server_action_queue.hasExited()) {
            this.remote_greenstone_server_action_queue.clear();
            Gatherer.exit();
            return "";
        }
        this.remote_greenstone_server_action_queue.addAction(remoteGreenstoneServerAction);
        String string = Thread.currentThread().getName();
        try {
            RemoteGreenstoneServerAction remoteGreenstoneServerAction2 = remoteGreenstoneServerAction;
            synchronized (remoteGreenstoneServerAction2) {
                while (!remoteGreenstoneServerAction.processed) {
                    DebugStream.println((String)"Waiting for action to complete...");
                    remoteGreenstoneServerAction.wait();
                }
            }
        }
        catch (Exception exception) {
            System.err.println("RemoteGreenstoneServer.performAction() - exception: " + exception);
            exception.printStackTrace();
        }
        if (!remoteGreenstoneServerAction.processed_successfully) {
            return "";
        }
        return remoteGreenstoneServerAction.action_output;
    }

    public synchronized ProgressBar getProgressBar() {
        return this.progress_bar;
    }

    public void set_remote_greenstone_server_authentication_to_null() {
        remote_greenstone_server_authentication = null;
    }

    private void authenticateUser() throws RemoteGreenstoneServerAction.ActionCancelledException {
        if (remote_greenstone_server_authentication == null) {
            try {
                SwingUtilities.invokeAndWait(new RemoteGreenstoneServerAuthenticateTask());
            }
            catch (Exception exception) {
                System.err.println("Exception occurred when authenticating the user: " + exception);
                DebugStream.printStackTrace((Exception)exception);
            }
            if (remote_greenstone_server_authentication == null) {
                throw new RemoteGreenstoneServerAction.ActionCancelledException();
            }
        }
    }

    public String getUsername() {
        if (remote_greenstone_server_authentication != null) {
            return remote_greenstone_server_authentication.getUserName();
        }
        return null;
    }

    String downloadFile(String string, String string2) throws Exception {
        String string3;
        while (true) {
            if (Configuration.gliserver_url == null) {
                throw new Exception("Empty gliserver URL: please set this in Preferences before continuing.");
            }
            this.authenticateUser();
            String string4 = Configuration.gliserver_url.toString();
            string3 = this.downloadFileInternal(string4, string, string2);
            if (string3.startsWith("ERROR: Authentication failed:")) {
                JOptionPane.showMessageDialog((Component)Gatherer.g_man, Dictionary.get((String)"RemoteGreenstoneServer.Error", (String)string3.substring("ERROR: ".length())), Dictionary.get((String)"RemoteGreenstoneServer.Error_Title"), 0);
                remote_greenstone_server_authentication = null;
                continue;
            }
            if (!string3.startsWith("ERROR: Collection is locked by: ")) break;
            if (JOptionPane.showConfirmDialog((Component)Gatherer.g_man, Dictionary.get((String)"RemoteGreenstoneServer.Steal_Lock_Message", (String)string3.substring("ERROR: Collection is locked by: ".length())), Dictionary.get((String)"RemoteGreenstoneServer.Error_Title"), 0) == 1) {
                throw new RemoteGreenstoneServerAction.ActionCancelledException();
            }
            string = string + "&steal_lock=";
        }
        if (string3.startsWith("ERROR: ")) {
            throw new Exception(string3.substring("ERROR: ".length()));
        }
        return string3;
    }

    private boolean isAuthenticationRequired(String string) {
        return string.indexOf("greenstone-server-version") == -1 && string.indexOf("get-library-url-suffix") == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String sendCommandToServer(String string, GShell gShell) throws Exception {
        Object object;
        while (true) {
            String string2;
            if (Configuration.gliserver_url == null) {
                throw new Exception("Empty gliserver URL: please set this in Preferences before continuing.");
            }
            if (this.isAuthenticationRequired(string)) {
                try {
                    this.authenticateUser();
                }
                catch (RemoteGreenstoneServerAction.ActionCancelledException actionCancelledException) {
                    object = this.remote_greenstone_server_action_queue;
                    synchronized (object) {
                        this.remote_greenstone_server_action_queue.clear();
                    }
                    Gatherer.exit();
                }
            }
            if (((String)(object = this.sendCommandToServerInternal(string2 = Configuration.gliserver_url.toString(), string, gShell))).startsWith("ERROR: Authentication failed:")) {
                JOptionPane.showMessageDialog((Component)Gatherer.g_man, Dictionary.get((String)"RemoteGreenstoneServer.Error", (String)((String)object).substring("ERROR: ".length())), Dictionary.get((String)"RemoteGreenstoneServer.Error_Title"), 0);
                remote_greenstone_server_authentication = null;
                continue;
            }
            if (!((String)object).startsWith("ERROR: Collection is locked by: ")) break;
            if (JOptionPane.showConfirmDialog((Component)Gatherer.g_man, Dictionary.get((String)"RemoteGreenstoneServer.Steal_Lock_Message", (String)((String)object).substring("ERROR: Collection is locked by: ".length())), Dictionary.get((String)"RemoteGreenstoneServer.Error_Title"), 0) == 1) {
                throw new RemoteGreenstoneServerAction.ActionCancelledException();
            }
            string = string + "&steal_lock=";
        }
        if (((String)object).startsWith("ERROR: ")) {
            throw new Exception(((String)object).substring("ERROR: ".length()));
        }
        if (((String)object).indexOf("ERROR: ") != -1) {
            throw new Exception((String)object);
        }
        return object;
    }

    String uploadFile(String string, String string2) throws Exception {
        String string3;
        while (true) {
            if (Configuration.gliserver_url == null) {
                throw new Exception("Empty gliserver URL: please set this in Preferences before continuing.");
            }
            this.authenticateUser();
            String string4 = Configuration.gliserver_url.toString();
            string3 = this.uploadFileInternal(string4, string, string2);
            if (string3.startsWith("ERROR: Authentication failed:")) {
                JOptionPane.showMessageDialog((Component)Gatherer.g_man, Dictionary.get((String)"RemoteGreenstoneServer.Error", (String)string3.substring("ERROR: ".length())), Dictionary.get((String)"RemoteGreenstoneServer.Error_Title"), 0);
                remote_greenstone_server_authentication = null;
                continue;
            }
            if (!string3.startsWith("ERROR: Collection is locked by: ")) break;
            if (JOptionPane.showConfirmDialog((Component)Gatherer.g_man, Dictionary.get((String)"RemoteGreenstoneServer.Steal_Lock_Message", (String)string3.substring("ERROR: Collection is locked by: ".length())), Dictionary.get((String)"RemoteGreenstoneServer.Error_Title"), 0) == 1) {
                throw new RemoteGreenstoneServerAction.ActionCancelledException();
            }
            string = string + "&steal_lock=";
        }
        if (string3.startsWith("ERROR: ")) {
            throw new Exception(string3.substring("ERROR: ".length()));
        }
        return string3;
    }

    private String downloadFileInternal(String string, String string2, String string3) throws Exception {
        Object object;
        Object object2;
        DebugStream.println((String)("gliserver URL: " + string));
        System.err.println("gliserver args: " + string2);
        string2 = string2 + "&un=" + remote_greenstone_server_authentication.getUserName();
        string2 = string2 + "&pw=" + new String(remote_greenstone_server_authentication.getPassword());
        string2 = string2 + "&ts=" + System.currentTimeMillis();
        if (Gatherer.GS3) {
            object2 = Configuration.site_name;
            if (object2 != null && !((String)object2).equals("")) {
                string2 = string2 + "&site=" + Configuration.site_name;
            }
            if ((object = Configuration.servlet_path) != null && !((String)object).equals("")) {
                if (((String)object).charAt(0) == '/') {
                    object = ((String)object).substring(1);
                }
                string2 = string2 + "&servlet=" + (String)object;
            }
        }
        object2 = new URL(string);
        object = ((URL)object2).openConnection();
        ((URLConnection)object).setDoOutput(true);
        OutputStream outputStream = ((URLConnection)object).getOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println(string2);
        printWriter.close();
        InputStream inputStream = ((URLConnection)object).getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        String string4 = "";
        byte[] byArray = new byte[1024];
        int n = dataInputStream.read(byArray);
        if (n >= 0) {
            String string5;
            string4 = string5.substring(0, (string5 = new String(byArray, 0, n)).indexOf("\n") != -1 ? string5.indexOf("\n") : (string5.length() < n ? string5.length() : n));
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while (n >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
                n = dataInputStream.read(byArray);
            }
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        dataInputStream.close();
        bufferedInputStream.close();
        inputStream.close();
        return string4;
    }

    private String sendCommandToServerInternal(String string, String string2, GShell gShell) throws Exception {
        DebugStream.println((String)("gliserver URL: " + string));
        System.err.println("gliserver args: " + string2);
        if (this.isAuthenticationRequired(string2)) {
            string2 = string2 + "&un=" + remote_greenstone_server_authentication.getUserName();
            string2 = string2 + "&pw=" + new String(remote_greenstone_server_authentication.getPassword());
        }
        string2 = string2 + "&ts=" + System.currentTimeMillis();
        if (Gatherer.GS3) {
            string2 = string2 + "&site=" + Configuration.site_name;
        }
        URL uRL = new URL(string + "?" + string2);
        URLConnection uRLConnection = uRL.openConnection();
        StringBuffer stringBuffer = new StringBuffer(2048);
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            if (gShell != null) {
                gShell.fireMessage(string3);
                if (gShell.hasSignalledStop()) {
                    throw new RemoteGreenstoneServerAction.ActionCancelledException();
                }
            }
            stringBuffer.append(string3 + "\n");
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
        int n = stringBuffer.indexOf("<?xml");
        if (n > 0) {
            stringBuffer = XMLTools.readXMLStream((String)stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadFileInternal(String string, String string2, String string3) throws Exception {
        System.err.println("gliserver URL: " + string);
        System.err.println("upload file gliserver args: " + string2);
        System.err.println("file path = " + string3);
        if (Gatherer.GS3) {
            PostMethod postMethod = new PostMethod(string + "?" + string2);
            String[] stringArray = string2.split("&");
            Part[] partArray = new Part[stringArray.length + 5];
            partArray[0] = new FilePart("uploaded_file", "zipFile", new File(string3));
            partArray[1] = new StringPart("un", remote_greenstone_server_authentication.getUserName());
            partArray[2] = new StringPart("pw", new String(remote_greenstone_server_authentication.getPassword()));
            partArray[3] = new StringPart("ts", String.valueOf(System.currentTimeMillis()));
            partArray[4] = new StringPart("site", Configuration.site_name);
            for (int i = 0; i < stringArray.length; ++i) {
                partArray[5 + i] = new StringPart(stringArray[i].substring(0, stringArray[i].indexOf("=")), stringArray[i].substring(stringArray[i].indexOf("=") + 1, stringArray[i].length()));
            }
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(partArray, postMethod.getParams()));
            HttpClient httpClient = new HttpClient();
            httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
            httpClient.getParams().setConnectionManagerTimeout(200000L);
            String string4 = "";
            try {
                httpClient.executeMethod((HttpMethod)postMethod);
                if (postMethod.getStatusCode() == 200) {
                    string4 = postMethod.getStatusLine().toString();
                } else {
                    string4 = postMethod.getStatusLine().toString();
                    System.out.println("Unexpected failure: " + postMethod.getStatusLine().toString());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                postMethod.releaseConnection();
            }
            return string4;
        }
        string2 = string2 + "&un=" + remote_greenstone_server_authentication.getUserName();
        string2 = string2 + "&pw=" + new String(remote_greenstone_server_authentication.getPassword());
        string2 = string2 + "&ts=" + System.currentTimeMillis();
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        File file = new File(string3);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = fileInputStream.available();
        string2 = string2 + "&fs=" + n;
        DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
        dataOutputStream.writeBytes(string2 + "\n");
        int n2 = n;
        int n3 = Math.min(n2, 1024);
        byte[] byArray = new byte[n3];
        int n4 = fileInputStream.read(byArray, 0, n3);
        while (n4 > 0) {
            dataOutputStream.write(byArray, 0, n4);
            n2 = fileInputStream.available();
            n3 = Math.min(n2, 1024);
            n4 = fileInputStream.read(byArray, 0, n3);
        }
        fileInputStream.close();
        dataOutputStream.flush();
        dataOutputStream.close();
        String string5 = "";
        InputStream inputStream = httpURLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string6 = bufferedReader.readLine();
        while (string6 != null) {
            string5 = string5 + string6 + "\n";
            string6 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return string5;
    }

    public String getPathRelativeToDirectory(File file, String string) {
        String string2 = file.getAbsolutePath();
        if (string.equals(string2 + File.separator)) {
            return ".";
        }
        if (!string2.startsWith(string)) {
            System.err.println("ERROR: File path " + string2 + " is not a child of " + string);
            return string2;
        }
        String string3 = string2.substring(string.length());
        if (string3.startsWith(File.separator)) {
            string3 = string3.substring(File.separator.length());
        }
        return string3;
    }

    private static class RemoteGreenstoneServerAuthenticateTask
    extends Thread {
        private RemoteGreenstoneServerAuthenticateTask() {
        }

        @Override
        public void run() {
            remote_greenstone_server_authentication = new RemoteGreenstoneServerAuthenticator().getAuthentication();
        }

        private static class RemoteGreenstoneServerAuthenticator
        extends GAuthenticator {
            private RemoteGreenstoneServerAuthenticator() {
            }

            public PasswordAuthentication getAuthentication(String string, String string2) {
                return this.getPasswordAuthentication(string, string2);
            }

            public PasswordAuthentication getAuthentication() {
                return this.getPasswordAuthentication();
            }

            protected String getMessageString() {
                if (Gatherer.GS3) {
                    return Dictionary.get((String)"RemoteGreenstoneServer.Authentication_Message_gs3") + " " + Configuration.site_name;
                }
                return Dictionary.get((String)"RemoteGreenstoneServer.Authentication_Message");
            }
        }
    }

    static class ProgressBar
    extends JProgressBar {
        public ProgressBar() {
            this.setBackground(Configuration.getColor((String)"coloring.collection_tree_background", (boolean)false));
            this.setForeground(Configuration.getColor((String)"coloring.collection_tree_foreground", (boolean)false));
            this.setString(Dictionary.get((String)"FileActions.No_Activity"));
            this.setStringPainted(true);
        }

        public synchronized void setAction(String string) {
            if (string != null) {
                DebugStream.println((String)string);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                System.err.println("ERROR: RemoteGreenstoneServerProgressBar.setAction() called from event dispatch thread!");
                return;
            }
            if (string == null) {
                this.setString(Dictionary.get((String)"FileActions.No_Activity"));
                this.setIndeterminate(false);
            } else {
                this.setString(string);
                this.setIndeterminate(true);
            }
        }
    }
}

