/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class MacroResolver {
    public static final String SCOPE_TEXT = "text";
    public static final String SCOPE_META = "metadata";
    public static final String SCOPE_ALL = "all";
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_META = 1;
    public static final int TYPE_DICT = 2;
    protected ArrayList text_macros = new ArrayList();
    protected ArrayList metadata_macros = new ArrayList();
    String lang = null;

    public void setSiteDetails(String site_address, String cluster_name, String library_name) {
        if (site_address != null) {
            this.addMacro(0, "_httpsite_", site_address, SCOPE_ALL, false);
        }
        if (cluster_name != null) {
            this.addMacro(0, "_clustername_", cluster_name, SCOPE_ALL, false);
        }
        if (library_name != null) {
            this.addMacro(0, "_libraryname_", library_name, SCOPE_ALL, false);
        }
    }

    public void addMacro(int type, String macro, String text_or_metadata, String scope, boolean resolve) {
        Macro m = new Macro();
        m.type = type;
        m.macro = macro;
        m.text = text_or_metadata;
        m.resolve = resolve;
        this.addMacro(m, scope);
    }

    public void addMacro(int type, String macro, String bundle, String key, String scope, boolean resolve) {
        Macro m = new Macro();
        m.type = type;
        m.macro = macro;
        m.bundle = bundle;
        m.key = key;
        m.resolve = resolve;
        this.addMacro(m, scope);
    }

    public void addMacros(Element replace_list_elem) {
        NodeList replaces = replace_list_elem.getElementsByTagName("replace");
        for (int i = 0; i < replaces.getLength(); ++i) {
            Element e = (Element)replaces.item(i);
            String scope = e.getAttribute("scope");
            if (scope.equals("")) {
                scope = SCOPE_ALL;
            }
            boolean resolve = true;
            String resolve_str = e.getAttribute("resolve");
            if (resolve_str.equals("false")) {
                resolve = false;
            }
            String from = e.getAttribute("macro");
            String to = e.getAttribute(SCOPE_TEXT);
            if (!to.equals("")) {
                this.addMacro(0, from, to, scope, resolve);
                continue;
            }
            String meta = e.getAttribute(SCOPE_META);
            if (!meta.equals("")) {
                this.addMacro(1, from, meta, scope, resolve);
                continue;
            }
            String key = e.getAttribute("key");
            String bundle = e.getAttribute("bundle");
            this.addMacro(2, from, bundle, key, scope, resolve);
        }
    }

    protected void addMacro(Macro m, String scope) {
        if (scope.equals(SCOPE_TEXT)) {
            this.text_macros.add(m);
        } else if (scope.equals(SCOPE_META)) {
            this.metadata_macros.add(m);
        } else if (scope.equals(SCOPE_ALL)) {
            this.text_macros.add(m);
            this.metadata_macros.add(m);
        }
    }

    public abstract String resolve(String var1, String var2, String var3, String var4);

    protected class Macro {
        public int type;
        public String macro = null;
        public String text = null;
        public String key = null;
        public String bundle = null;
        public boolean resolve = true;

        protected Macro() {
        }
    }
}

