/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.comms.Communicator;
import org.greenstone.gsdl3.comms.SOAPCommunicator;
import org.greenstone.gsdl3.core.DefaultReceptionist;
import org.greenstone.gsdl3.core.MessageRouter;
import org.greenstone.gsdl3.core.Receptionist;
import org.greenstone.gsdl3.util.GSParams;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LibraryServlet
extends HttpServlet {
    protected Receptionist recept = null;
    protected String default_lang = null;
    protected final String DEFAULT_LANG = "en";
    protected Document doc = null;
    protected XMLConverter converter = null;
    protected GSParams params = null;
    protected int next_user_id = 0;
    protected Hashtable session_ids_table = new Hashtable();
    protected int session_expiration = 1800;
    static Logger logger = Logger.getLogger((String)LibraryServlet.class.getName());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String library_name = config.getInitParameter("library_name");
        String gsdl3_home = config.getInitParameter("gsdl3_home");
        String interface_name = config.getInitParameter("interface_name");
        this.default_lang = config.getInitParameter("default_lang");
        String sess_expire = config.getInitParameter("session_expiration");
        if (sess_expire != null && !sess_expire.equals("")) {
            this.session_expiration = Integer.parseInt(sess_expire);
        }
        if (library_name == null || interface_name == null) {
            System.err.println("initialisation parameters not all set!");
            System.err.println(" you must have libraryname and interfacename");
            System.exit(1);
        }
        String site_name = config.getInitParameter("site_name");
        String remote_site_name = null;
        String remote_site_type = null;
        String remote_site_address = null;
        if (site_name == null) {
            remote_site_name = config.getInitParameter("remote_site_name");
            remote_site_type = config.getInitParameter("remote_site_type");
            remote_site_address = config.getInitParameter("remote_site_address");
            if (remote_site_name == null || remote_site_type == null || remote_site_address == null) {
                System.err.println("initialisation paramters not all set!");
                System.err.println("if site_name is not set, then you must have remote_site_name, remote_site_type and remote_site_address set");
                System.exit(1);
            }
        }
        if (this.default_lang == null) {
            this.default_lang = "en";
        }
        HashMap<String, String> config_params = new HashMap<String, String>();
        config_params.put("library_name", library_name);
        config_params.put("interface_name", interface_name);
        if (site_name != null) {
            config_params.put("site_name", site_name);
        }
        this.converter = new XMLConverter();
        LibraryServlet libraryServlet = this;
        this.doc = libraryServlet.converter.newDOM();
        String recept_name = config.getInitParameter("receptionist_class");
        if (recept_name == null) {
            this.recept = new DefaultReceptionist();
        } else {
            try {
                this.recept = (Receptionist)Class.forName("org.greenstone.gsdl3.core." + recept_name).newInstance();
            }
            catch (Exception e) {
                System.err.println("LibraryServlet configure exception when trying to use a new Receptionist " + recept_name + ": " + e.getMessage());
                e.printStackTrace();
                this.recept = new DefaultReceptionist();
            }
        }
        this.recept.setConfigParams(config_params);
        if (site_name != null) {
            String mr_name = config.getInitParameter("messagerouter_class");
            MessageRouter message_router = null;
            if (mr_name == null) {
                message_router = new MessageRouter();
            } else {
                try {
                    message_router = (MessageRouter)Class.forName("org.greenstone.gsdl3.core." + mr_name).newInstance();
                }
                catch (Exception e) {
                    System.err.println("LibraryServlet configure exception when trying to use a new MessageRouter " + mr_name + ": " + e.getMessage());
                    e.printStackTrace();
                    message_router = new MessageRouter();
                }
            }
            message_router.setSiteName(site_name);
            message_router.setLibraryName(library_name);
            message_router.configure();
            this.recept.setMessageRouter(message_router);
        } else {
            SOAPCommunicator communicator = null;
            Element site_elem = this.doc.createElement("site");
            site_elem.setAttribute("type", remote_site_type);
            site_elem.setAttribute("name", remote_site_name);
            site_elem.setAttribute("address", remote_site_address);
            if (remote_site_type.equals("soap")) {
                communicator = new SOAPCommunicator();
            } else {
                System.err.println("LibraryServlet.init Error: invalid Communicator type: " + remote_site_type);
                System.exit(1);
            }
            if (!((Communicator)communicator).configure(site_elem)) {
                System.err.println("LibraryServlet.init Error: Couldn't configure communicator");
                System.exit(1);
            }
            this.recept.setMessageRouter(communicator);
        }
        String params_name = config.getInitParameter("params_class");
        if (params_name == null) {
            this.params = new GSParams();
        } else {
            try {
                this.params = (GSParams)Class.forName("org.greenstone.gsdl3.util." + params_name).newInstance();
            }
            catch (Exception e) {
                System.err.println("LibraryServlet configure exception when trying to use a new params thing " + params_name + ": " + e.getMessage());
                e.printStackTrace();
                this.params = new GSParams();
            }
        }
        this.recept.setParams(this.params);
        this.recept.configure();
    }

    private void logUsageInfo(HttpServletRequest request) {
        String usageInfo = "";
        HttpSession session = request.getSession(true);
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            usageInfo = usageInfo + name + "=" + session.getAttribute(name) + " ";
        }
        usageInfo = request.getServletPath() + " " + "[" + request.getQueryString() + "]" + " " + "[" + usageInfo.trim() + "]" + " " + request.getRemoteAddr() + " " + request.getRequestedSessionId() + " " + request.getHeader("user-agent") + " ";
        logger.info((Object)usageInfo);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cache_key;
        this.logUsageInfo(request);
        String query_string = request.getQueryString();
        if (query_string != null) {
            String[] query_arr = query_string.split("&");
            boolean redirect = false;
            String href = null;
            String rl = null;
            for (int i = 0; i < query_arr.length; ++i) {
                if (query_arr[i].startsWith("el=")) {
                    if (!query_arr[i].substring(query_arr[i].indexOf("=") + 1, query_arr[i].length()).equals("direct")) continue;
                    redirect = true;
                    continue;
                }
                if (query_arr[i].startsWith("href=")) {
                    href = query_arr[i].substring(query_arr[i].indexOf("=") + 1, query_arr[i].length());
                    href = href.replaceAll("%2f", "/");
                    href = href.replaceAll("%7e", "~");
                    href = href.replaceAll("%3f", "?");
                    href = href.replaceAll("%3A", "\\:");
                    continue;
                }
                if (!query_arr[i].startsWith("rl=")) continue;
                rl = query_arr[i].substring(query_arr[i].indexOf("=") + 1, query_arr[i].length());
            }
            if (redirect && href != null && rl.equals("0")) {
                response.setContentType("text/xml");
                response.sendRedirect(href);
            }
        }
        HttpSession session = request.getSession(true);
        session.setMaxInactiveInterval(this.session_expiration);
        String uid = (String)session.getAttribute("uid");
        if (uid == null) {
            uid = "" + this.getNextUserId();
            session.setAttribute("uid", (Object)uid);
        }
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String lang = request.getParameter("l");
        if ((lang == null || lang.equals("")) && ((lang = (String)session.getAttribute("l")) == null || lang.equals(""))) {
            lang = this.default_lang;
        }
        session.setAttribute("l", (Object)lang);
        String output = request.getParameter("o");
        if (output == null || output.equals("")) {
            output = "html";
        }
        Element xml_message = this.doc.createElement("message");
        Element xml_request = GSXML.createBasicRequest(this.doc, "page", "", lang, uid);
        xml_request.setAttribute("output", output);
        xml_message.appendChild(xml_request);
        String action = request.getParameter("a");
        String subaction = request.getParameter("sa");
        String collection = request.getParameter("c");
        String service = request.getParameter("s");
        boolean should_cache = true;
        if (action != null && action.equals("s")) {
            String module_name;
            should_cache = false;
            boolean clean_all = true;
            String clean_collection = null;
            String coll = request.getParameter("sc");
            if (coll != null && !coll.equals("")) {
                clean_all = false;
                clean_collection = coll;
            } else if ((subaction.equals("a") || subaction.equals("d")) && (module_name = request.getParameter("sn")) != null && !module_name.equals("")) {
                clean_all = false;
                clean_collection = module_name;
            }
            if (clean_all) {
                this.session_ids_table = new Hashtable();
                session.removeAttribute("user_session_cache");
            } else {
                ArrayList cache_list = new ArrayList(this.session_ids_table.values());
                for (int i = 0; i < cache_list.size(); ++i) {
                    UserSessionCache cache = (UserSessionCache)cache_list.get(i);
                    cache.cleanupCache(clean_collection);
                }
            }
        }
        if ((cache_key = collection) == null || cache_key.equals("")) {
            cache_key = service;
        }
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            if (name.equals("user_session_cache") || name.equals("l") || name.equals("uid")) continue;
            session.removeAttribute(name);
        }
        if (subaction != null && subaction.equals("authen")) {
            cache_key = "0000000000";
        }
        UserSessionCache session_cache = null;
        Hashtable param_table = null;
        Hashtable table = null;
        String sid = session.getId();
        if (should_cache && cache_key != null && !cache_key.equals("")) {
            if (this.session_ids_table.containsKey(sid)) {
                session_cache = (UserSessionCache)this.session_ids_table.get(sid);
                param_table = session_cache.getParamsTable();
                logger.info((Object)("collections in table: " + this.tableToString(param_table)));
                if (param_table.containsKey(cache_key)) {
                    table = (Hashtable)param_table.get(cache_key);
                } else {
                    table = new Hashtable();
                    param_table.put(cache_key, table);
                }
            } else {
                param_table = new Hashtable();
                table = new Hashtable();
                param_table.put(cache_key, table);
                session_cache = new UserSessionCache(sid, param_table);
                this.session_ids_table.put(sid, session_cache);
                session.setAttribute("user_session_cache", (Object)session_cache);
            }
        }
        if (action == null || action.equals("")) {
            xml_request.setAttribute("action", "p");
            xml_request.setAttribute("subaction", "home");
        } else {
            String name;
            xml_request.setAttribute("action", action);
            if (subaction != null) {
                xml_request.setAttribute("subaction", subaction);
            }
            Element xml_param_list = this.doc.createElement("paramList");
            xml_request.appendChild(xml_param_list);
            Enumeration params = request.getParameterNames();
            while (params.hasMoreElements()) {
                name = (String)params.nextElement();
                if (name.equals("a") || name.equals("sa") || name.equals("l") || name.equals("o")) continue;
                String value = "";
                String[] values = request.getParameterValues(name);
                value = values[0];
                if (values.length > 1) {
                    for (int i = 1; i < values.length; ++i) {
                        value = value + "," + values[i];
                    }
                }
                if (this.params.shouldSave(name) && table != null) {
                    table.put(name, value);
                    continue;
                }
                Element param = this.doc.createElement("param");
                param.setAttribute("name", name);
                param.setAttribute("value", GSXML.xmlSafe(value));
                xml_param_list.appendChild(param);
            }
            if (table != null) {
                Enumeration keys = table.keys();
                while (keys.hasMoreElements()) {
                    String name2 = (String)keys.nextElement();
                    session.setAttribute(name2, (Object)((String)table.get(name2)));
                }
            }
            params = session.getAttributeNames();
            while (params.hasMoreElements()) {
                name = (String)params.nextElement();
                if (name.equals("user_session_cache") || name.equals("l") || name.equals("uid")) continue;
                Element param = this.doc.createElement("param");
                param.setAttribute("name", name);
                String value = GSXML.xmlSafe((String)session.getAttribute(name));
                value = value.replaceAll("%3A", "\\:");
                param.setAttribute("value", value);
                xml_param_list.appendChild(param);
            }
        }
        if (!output.equals("html")) {
            response.setContentType("text/xml");
        }
        Node xml_result = this.recept.process(xml_message);
        this.encodeURLs(xml_result, response);
        out.println(XMLConverter.getPrettyString(xml_result));
        this.displaySize(this.session_ids_table);
    }

    private void displaySize(Hashtable table) {
        if (table == null) {
            logger.info((Object)"cached table is null");
            return;
        }
        if (table.size() == 0) {
            logger.info((Object)"cached table size is zero");
            return;
        }
        int num_cached_coll = 0;
        ArrayList cache_list = new ArrayList(table.values());
        for (int i = 0; i < cache_list.size(); ++i) {
            num_cached_coll += ((UserSessionCache)cache_list.get(i)).tableSize();
        }
        logger.info((Object)("Number of sessions : total number of cached collection info = " + table.size() + " : " + num_cached_coll));
    }

    private String tableToString(Hashtable table) {
        String str = "";
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            str = str + name + ", ";
        }
        return str;
    }

    protected void encodeURLs(Node dataNode, HttpServletResponse response) {
        if (dataNode == null) {
            return;
        }
        Element data = null;
        short nodeType = dataNode.getNodeType();
        if (nodeType == 9) {
            Document docNode = (Document)dataNode;
            data = docNode.getDocumentElement();
        } else {
            data = (Element)dataNode;
        }
        NodeList hrefs = data.getElementsByTagName("a");
        for (int i = 0; i < hrefs.getLength(); ++i) {
            Element a = (Element)hrefs.item(i);
            String href = a.getAttribute("href");
            if (href.equals("")) continue;
            if (href.indexOf("?") != -1) {
                String[] parts = href.split("\\?", -1);
                parts[1] = parts[1].replaceAll(":", "%3A");
                href = parts[0] + "?" + parts[1];
            }
            a.setAttribute("href", response.encodeURL(href));
        }
        NodeList forms = data.getElementsByTagName("form");
        for (int i = 0; i < forms.getLength(); ++i) {
            Element form = (Element)forms.item(i);
            form.setAttribute("action", response.encodeURL(form.getAttribute("action")));
        }
    }

    protected synchronized int getNextUserId() {
        ++this.next_user_id;
        return this.next_user_id;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public class UserSessionCache
    implements HttpSessionBindingListener {
        String session_id = "";
        protected Hashtable coll_name_params_table = null;

        public UserSessionCache(String id, Hashtable table) {
            this.session_id = id;
            this.coll_name_params_table = table == null ? new Hashtable() : table;
        }

        protected void cleanupCache(String coll_name) {
            if (this.coll_name_params_table.containsKey(coll_name)) {
                this.coll_name_params_table.remove(coll_name);
            }
        }

        protected Hashtable getParamsTable() {
            return this.coll_name_params_table;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (LibraryServlet.this.session_ids_table.containsKey(this.session_id)) {
                LibraryServlet.this.session_ids_table.remove(this.session_id);
            }
        }

        public int tableSize() {
            return this.coll_name_params_table == null ? 0 : this.coll_name_params_table.size();
        }
    }
}

