/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.raster.LongRasterImage;
import com.sun.jimi.core.util.LongColorModel;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;

public class MemoryLongRasterImage
extends JimiRasterImageSupport
implements LongRasterImage {
    protected long[] imageData;
    protected int[] pixelBuffer;
    protected LongColorModel lcm;
    protected ColorModel rgbcm = ColorModel.getRGBdefault();

    protected void initStorage() throws JimiException {
        this.imageData = new long[this.getWidth() * this.getHeight()];
        this.pixelBuffer = new int[this.getWidth()];
    }

    public void getRectangleRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        try {
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    nArray[n5 + n8 + n7 * n6] = this.lcm.getRGB(this.imageData[n + n8 + (n2 + n7) * this.getWidth()] & 0xFFL);
                    ++n8;
                }
                ++n7;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public void getRowRGB(int n, int[] nArray, int n2) throws ImageAccessException {
        this.getRectangleRGB(0, n, this.getWidth(), 1, nArray, n2, 0);
    }

    public int getPixelRGB(int n, int n2) throws ImageAccessException {
        return this.lcm.getRGB(this.imageData[n + n2 * this.getWidth()]);
    }

    public void getRectangle(int n, int n2, int n3, int n4, long[] lArray, int n5, int n6) throws ImageAccessException {
        try {
            int n7 = 0;
            while (n7 < n4) {
                System.arraycopy(this.imageData, n + (n2 + n7) * this.getWidth(), lArray, n5 + n7 * n6, this.getWidth());
                ++n7;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public void getRow(int n, long[] lArray, int n2) throws ImageAccessException {
        this.getRectangle(0, n, this.getWidth(), 1, lArray, n2, 0);
    }

    public long getPixel(int n, int n2) throws ImageAccessException {
        try {
            return this.imageData[n + n2 * this.getWidth()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ImageAccessException(arrayIndexOutOfBoundsException.toString());
        }
    }

    public void setRectangle(int n, int n2, int n3, int n4, long[] lArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(n, n2, n3, n4, lArray, n5, n6);
        this.storeRectangle(n, n2, n3, n4, lArray, n5, n6);
    }

    public void setRow(int n, long[] lArray, int n2) throws ImageAccessException {
        this.setRectangle(0, n, this.getWidth(), 1, lArray, n2, 0);
    }

    public void setPixel(int n, int n2, long l) throws ImageAccessException {
        this.setModified();
        this.setPixel(n, n2, l);
        this.sendPixel(n, n2, l);
    }

    public void storeRectangle(int n, int n2, int n3, int n4, long[] lArray, int n5, int n6) throws ImageAccessException {
        try {
            int n7 = 0;
            while (n7 < n4) {
                System.arraycopy(lArray, n5 + n7 * n6, this.imageData, n + (n2 + n7) * this.getWidth(), n3);
                ++n7;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public void storeRow(int n, long[] lArray, int n2) throws ImageAccessException {
        this.storeRectangle(0, n, this.getWidth(), 1, lArray, n2, 0);
    }

    public void storePixel(int n, int n2, long l) throws ImageAccessException {
        try {
            this.imageData[n + n2 * this.getWidth()] = l;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ImageAccessException(arrayIndexOutOfBoundsException.toString());
        }
    }

    protected synchronized void sendRectangle(int n, int n2, int n3, int n4, long[] lArray, int n5, int n6) {
        if (this.hasDirectConsumer()) {
            MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    this.pixelBuffer[n8] = this.lcm.getRGB(lArray[n + n5]);
                    ++n8;
                }
                multicastImageConsumer.setPixels(n, n2 + n7, n3, 1, this.rgbcm, this.pixelBuffer, 0, 0);
                ++n7;
            }
        }
    }

    protected void sendRow(int n, long[] lArray, int n2) {
        this.sendRectangle(0, n, this.getWidth(), 1, lArray, n2, 0);
    }

    protected synchronized void sendPixel(int n, int n2, long l) {
        if (this.hasDirectConsumer()) {
            MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
            this.pixelBuffer[0] = this.lcm.getRGB(l);
            multicastImageConsumer.setPixels(n, n2, 1, 1, this.rgbcm, this.pixelBuffer, 0, 1);
        }
    }

    protected void sendToConsumerFully(ImageConsumer imageConsumer) throws ImageAccessException {
        this.sendRectangle(0, 0, this.getWidth(), this.getHeight(), this.imageData, 0, this.getWidth());
    }

    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) throws ImageAccessException {
        this.sendRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.imageData, rectangle.x + rectangle.y * this.getWidth(), this.getWidth());
    }

    public MemoryLongRasterImage(int n, int n2, LongColorModel longColorModel) {
        super(n, n2, longColorModel);
        this.lcm = longColorModel;
        try {
            this.initStorage();
            return;
        }
        catch (JimiException jimiException) {
            this.setError();
            return;
        }
    }
}

