/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.LuceneWrapper4;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.greenstone.LuceneWrapper4.GS2Analyzer;
import org.greenstone.LuceneWrapper4.GSLuceneConstants;
import org.greenstone.LuceneWrapper4.LuceneQueryResult;
import org.greenstone.LuceneWrapper4.SharedSoleneQuery;
import org.greenstone.LuceneWrapper4.SharedSoleneQueryResult;

public class GS2LuceneQuery
extends SharedSoleneQuery {
    public static String SORT_RANK = "rank";
    public static String SORT_NATURAL = "natural";
    protected String full_indexdir = "";
    protected SortField.Type sort_type = SortField.Type.SCORE;
    protected boolean reverse_sort = false;
    protected Sort sorter = new Sort();
    protected Filter filter = null;
    protected QueryParser query_parser = new QueryParser(GSLuceneConstants.MATCH_VERSION, TEXTFIELD, new GS2Analyzer());
    protected QueryParser query_parser_no_stop_words = new QueryParser(GSLuceneConstants.MATCH_VERSION, TEXTFIELD, new GS2Analyzer(new String[0]));
    protected IndexSearcher searcher = null;
    protected IndexReader reader = null;
    protected static boolean query_result_caching_enabled = false;

    public boolean initialise(IndexReader indexReader) {
        if (!super.initialise()) {
            return false;
        }
        if (this.full_indexdir == null || this.full_indexdir.length() == -1) {
            utf8out.println("Index directory is not indicated ");
            utf8out.flush();
            return false;
        }
        if (indexReader == null) {
            return false;
        }
        this.reader = indexReader;
        this.searcher = new IndexSearcher(indexReader);
        this.sorter = new Sort(new SortField(this.sort_field, this.sort_type, this.reverse_sort));
        return true;
    }

    public void setIndexDir(String string) {
        this.full_indexdir = string;
    }

    @Override
    public void setSortField(String string) {
        if (string.equals(SORT_RANK)) {
            this.sort_field = null;
            this.sort_type = SortField.Type.SCORE;
        } else if (string.equals(SORT_NATURAL)) {
            this.sort_field = null;
            this.sort_type = SortField.Type.DOC;
        } else {
            this.sort_field = string;
            this.sort_type = SortField.Type.STRING;
        }
    }

    public void setReverseSort(boolean bl) {
        this.reverse_sort = bl;
    }

    public boolean getReverseSort() {
        return this.reverse_sort;
    }

    @Override
    public void setFilterString(String string) {
        super.setFilterString(string);
        this.filter = this.parseFilterString(string);
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public LuceneQueryResult runQuery(String string) {
        if (string == null || string.equals("")) {
            utf8out.println("The query word is not indicated ");
            utf8out.flush();
            return null;
        }
        LuceneQueryResult luceneQueryResult = new LuceneQueryResult();
        luceneQueryResult.clear();
        if (this.reader == null) {
            System.err.println("#### Reader is null!");
        }
        try {
            int n;
            int n2;
            Object object;
            Object object2;
            Object object3;
            Query query = this.query_parser_no_stop_words.parse(string);
            query = query.rewrite(this.reader);
            Query query2 = this.parseQuery(this.reader, this.query_parser, string, this.fuzziness);
            query2 = this.recursivelyRewriteQuery(query2, this.reader, luceneQueryResult);
            HashSet<Term> hashSet = new HashSet<Term>();
            query2.extractTerms(hashSet);
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            Iterator<Term> iterator = hashSet.iterator();
            Bits bits = null;
            if (this.reader.hasDeletions()) {
                System.err.println("@@@ GS2LuceneQuery.java: There have been deletions in index at " + this.full_indexdir + ". Merging to get liveDocs.");
                bits = MultiFields.getLiveDocs(this.reader);
            }
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = ((Term)object3).bytes();
                object = MultiFields.getTermDocsEnum(this.reader, bits, ((Term)object3).field(), (BytesRef)object2);
                n2 = 0;
                n = 0;
                if (object != null) {
                    int n3 = -1;
                    while ((n3 = ((DocIdSetIterator)object).nextDoc()) != Integer.MAX_VALUE) {
                        if (((DocsEnum)object).freq() == 0) continue;
                        n2 += ((DocsEnum)object).freq();
                        ++n;
                        Integer n4 = new Integer(((DocIdSetIterator)object).docID());
                        int n5 = 0;
                        if (hashMap.containsKey(n4)) {
                            n5 = (Integer)hashMap.get(n4);
                        }
                        hashMap.put(n4, new Integer(n5 += ((DocsEnum)object).freq()));
                    }
                }
                luceneQueryResult.addTerm(((Term)object3).text(), ((Term)object3).field(), n, n2);
            }
            object3 = new HashSet();
            query.extractTerms((Set<Term>)object3);
            object2 = ((HashSet)object3).iterator();
            while (object2.hasNext()) {
                object = (Term)object2.next();
                if (hashSet.contains(object)) continue;
                luceneQueryResult.addStopWord(((Term)object).text());
            }
            if (this.end_results == Integer.MAX_VALUE) {
                object = this.searcher.search(query2, this.filter, this.end_results, this.sorter, true, true);
                luceneQueryResult.setTotalDocs(((TopFieldDocs)object).totalHits);
                luceneQueryResult.setStartResults(this.start_results);
                luceneQueryResult.setEndResults(((TopFieldDocs)object).totalHits);
                for (n2 = this.start_results; n2 < ((TopFieldDocs)object).totalHits; ++n2) {
                    n = ((TopFieldDocs)object).scoreDocs[n2].doc;
                    Document document = this.reader.document(n);
                    int n6 = 0;
                    Integer n7 = (Integer)hashMap.get(new Integer(n));
                    if (n7 != null) {
                        n6 = n7;
                    }
                    luceneQueryResult.addDoc(document.get("docOID").trim(), ((TopFieldDocs)object).scoreDocs[n2].score, n6);
                }
            } else {
                object = this.searcher.search(query2, this.filter, this.end_results, this.sorter, true, true);
                luceneQueryResult.setTotalDocs(((TopFieldDocs)object).totalHits);
                luceneQueryResult.setStartResults(this.start_results);
                luceneQueryResult.setEndResults(this.end_results < ((TopFieldDocs)object).scoreDocs.length ? this.end_results : ((TopFieldDocs)object).scoreDocs.length);
                for (n2 = this.start_results; n2 < ((TopFieldDocs)object).scoreDocs.length && n2 < this.end_results; ++n2) {
                    n = ((TopFieldDocs)object).scoreDocs[n2].doc;
                    Document document = this.reader.document(n);
                    int n8 = 0;
                    Integer n9 = (Integer)hashMap.get(new Integer(n));
                    if (n9 != null) {
                        n8 = n9;
                    }
                    luceneQueryResult.addDoc(document.get("docOID").trim(), ((TopFieldDocs)object).scoreDocs[n2].score, n8);
                }
            }
        }
        catch (ParseException parseException) {
            luceneQueryResult.setError(1);
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            luceneQueryResult.setError(2);
        }
        catch (IOException iOException) {
            luceneQueryResult.setError(3);
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            luceneQueryResult.setError(5);
            exception.printStackTrace();
        }
        return luceneQueryResult;
    }

    @Override
    public void setDefaultConjunctionOperator(String string) {
        super.setDefaultConjunctionOperator(string);
        if (string.equals("AND")) {
            this.query_parser.setDefaultOperator(QueryParser.AND_OPERATOR);
            this.query_parser_no_stop_words.setDefaultOperator(QueryParser.AND_OPERATOR);
        } else {
            this.query_parser.setDefaultOperator(QueryParser.OR_OPERATOR);
            this.query_parser_no_stop_words.setDefaultOperator(QueryParser.OR_OPERATOR);
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.searcher = null;
    }

    protected Query parseQuery(IndexReader indexReader, QueryParser queryParser, String string, String string2) throws IOException, ParseException {
        int n;
        int n2 = 0;
        boolean bl = false;
        for (n = 0; !(n >= string.length() || bl && n2 <= 0); ++n) {
            if (string.charAt(n) == '(') {
                ++n2;
                bl = true;
            }
            if (string.charAt(n) != ')') continue;
            --n2;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n);
        Query query = queryParser.parse(string3);
        query = query.rewrite(indexReader);
        if (string2 != null && query.toString().length() > 0) {
            System.err.println("Rewritten query: " + query.toString());
            StringBuffer stringBuffer = new StringBuffer(query.toString());
            int n3 = 0;
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (n3 == 0 && c == TEXTFIELD.charAt(0)) {
                    n3 = 1;
                    continue;
                }
                if (n3 == 1) {
                    if (c == TEXTFIELD.charAt(1)) {
                        n3 = 2;
                        continue;
                    }
                    n3 = 0;
                    continue;
                }
                if (n3 == 2) {
                    if (c == ':') {
                        n3 = 3;
                        continue;
                    }
                    n3 = 0;
                    continue;
                }
                if (n3 != 3) continue;
                if (c == '\"') {
                    n3 = 0;
                    continue;
                }
                if (!Character.isWhitespace(c) && c != ')') continue;
                stringBuffer.insert(i, '~' + string2);
                ++i;
                n3 = 0;
            }
            if (n3 == 3) {
                stringBuffer.append('~' + string2);
            }
            query = queryParser.parse(stringBuffer.toString() + string4);
        } else {
            query = queryParser.parse(string3 + string4);
        }
        return query;
    }

    protected Query recursivelyRewriteQuery(Query query, IndexReader indexReader, LuceneQueryResult luceneQueryResult) throws IOException {
        Query query2;
        block8: {
            Object object;
            Object object2;
            Query query3;
            query2 = query;
            if (query instanceof BooleanQuery) {
                query3 = (BooleanQuery)query;
                object2 = ((BooleanQuery)query3).clauses();
                object = object2.iterator();
                while (object.hasNext()) {
                    BooleanClause booleanClause = object.next();
                    Query query4 = booleanClause.getQuery();
                    query4 = this.recursivelyRewriteQuery(query4, indexReader, luceneQueryResult);
                    booleanClause.setQuery(query4);
                }
            }
            if (query instanceof MultiTermQuery) {
                query3 = (MultiTermQuery)query;
                ((MultiTermQuery)query3).setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE);
            }
            try {
                query2 = query.rewrite(indexReader);
            }
            catch (BooleanQuery.TooManyClauses tooManyClauses) {
                luceneQueryResult.setError(2);
                if (!(query2 instanceof MultiTermQuery)) break block8;
                object2 = new MultiTermQuery.ConstantScoreAutoRewrite();
                ((MultiTermQuery.ConstantScoreAutoRewrite)object2).setDocCountPercent(100.0);
                ((MultiTermQuery.ConstantScoreAutoRewrite)object2).setTermCountCutoff(350);
                object = (MultiTermQuery)query2;
                ((MultiTermQuery)object).setRewriteMethod((MultiTermQuery.RewriteMethod)object2);
                try {
                    query2 = query2.rewrite(indexReader);
                }
                catch (BooleanQuery.TooManyClauses tooManyClauses2) {
                    ((MultiTermQuery)object).setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
                    query2 = query2.rewrite(indexReader);
                }
            }
        }
        if (query == query2) {
            return query2;
        }
        return this.recursivelyRewriteQuery(query2, indexReader, luceneQueryResult);
    }

    protected Filter parseFilterString(String string) {
        TermRangeFilter termRangeFilter = null;
        Pattern pattern = Pattern.compile("\\s*\\+(\\w+)\\:([\\{\\[])(\\d+)\\s+TO\\s+(\\d+)([\\}\\]])\\s*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            boolean bl = matcher.group(2).equals("[");
            BytesRef bytesRef = new BytesRef(matcher.group(3));
            BytesRef bytesRef2 = new BytesRef(matcher.group(4));
            boolean bl2 = matcher.group(5).equals("]");
            termRangeFilter = new TermRangeFilter(string2, bytesRef, bytesRef2, bl, bl2);
        } else {
            System.err.println("Error: Could not understand filter string \"" + string + "\"");
        }
        return termRangeFilter;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: org.greenstone.LuceneWrapper4.GS2LuceneQuery <index directory> [-fuzziness value] [-filter filter_string] [-sort sort_field] [-reverse_sort][-dco AND|OR] [-startresults number -endresults number] [query]");
            return;
        }
        try {
            Object object;
            String string = stringArray[0];
            GS2LuceneQuery gS2LuceneQuery = new GS2LuceneQuery();
            gS2LuceneQuery.setIndexDir(string);
            if (query_result_caching_enabled) {
                object = new File(string, "cache");
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                if (!((File)object).exists() || !((File)object).isDirectory()) {
                    query_result_caching_enabled = false;
                }
            }
            object = null;
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-sort")) {
                    gS2LuceneQuery.setSortField(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-reverse_sort")) {
                    gS2LuceneQuery.setReverseSort(true);
                    continue;
                }
                if (stringArray[i].equals("-filter")) {
                    gS2LuceneQuery.setFilterString(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-dco")) {
                    gS2LuceneQuery.setDefaultConjunctionOperator(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-fuzziness")) {
                    gS2LuceneQuery.setFuzziness(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-startresults")) {
                    if (!stringArray[++i].matches("\\d+")) continue;
                    gS2LuceneQuery.setStartResults(Integer.parseInt(stringArray[i]));
                    continue;
                }
                if (stringArray[i].equals("-endresults")) {
                    if (!stringArray[++i].matches("\\d+")) continue;
                    gS2LuceneQuery.setEndResults(Integer.parseInt(stringArray[i]));
                    continue;
                }
                object = stringArray[i];
            }
            FSDirectory fSDirectory = FSDirectory.open(new File(string));
            DirectoryReader directoryReader = DirectoryReader.open(fSDirectory);
            if (!gS2LuceneQuery.initialise(directoryReader)) {
                if (directoryReader != null) {
                    directoryReader.close();
                }
                gS2LuceneQuery.cleanUp();
                return;
            }
            if (object != null) {
                GS2LuceneQuery.runQueryCaching(string, gS2LuceneQuery, (String)object);
            } else {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
                while ((object = bufferedReader.readLine()) != null && ((String)object).length() != -1) {
                    GS2LuceneQuery.runQueryCaching(string, gS2LuceneQuery, (String)object);
                }
            }
            if (directoryReader != null) {
                directoryReader.close();
            }
            gS2LuceneQuery.cleanUp();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected static void runQueryCaching(String string, GS2LuceneQuery gS2LuceneQuery, String string2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer();
        File file = null;
        if (query_result_caching_enabled) {
            object3 = string2 + "-";
            object2 = gS2LuceneQuery.getFuzziness();
            object3 = (String)object3 + (String)(object2 != null ? object2 : "") + "-";
            object = gS2LuceneQuery.getFilterString();
            object3 = (String)object3 + (String)(object != null ? object : "") + "-";
            String string3 = gS2LuceneQuery.getSortField();
            object3 = (String)object3 + (string3 != null ? string3 : "") + "-";
            String string4 = gS2LuceneQuery.getReverseSort() ? "1" : "0";
            object3 = (String)object3 + string4 + "-";
            String string5 = gS2LuceneQuery.getDefaultConjunctionOperator();
            object3 = (String)object3 + string5 + "-";
            int n = gS2LuceneQuery.getStartResults();
            int n2 = gS2LuceneQuery.getEndResults();
            object3 = (String)object3 + n + "-" + n2;
            File file2 = new File(string, "cache");
            file = new File(file2, (String)(object3 = GS2LuceneQuery.fileSafe((String)object3)));
            if (file.exists() && file.isFile()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string6 = "";
                while ((string6 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string6 + "\n");
                }
                String string7 = stringBuffer.toString();
                string7 = string7.replaceFirst("cached=\"false\"", "cached=\"true\"");
                utf8out.print(string7);
                utf8out.flush();
                return;
            }
        }
        stringBuffer.append("<ResultSet cached=\"false\">\n");
        stringBuffer.append("<QueryString>" + LuceneQueryResult.xmlSafe(string2) + "</QueryString>\n");
        object3 = gS2LuceneQuery.getFilter();
        if (object3 != null) {
            stringBuffer.append("<FilterString>" + object3.toString() + "</FilterString>\n");
        }
        if ((object2 = gS2LuceneQuery.runQuery(string2)) == null) {
            System.err.println("Couldn't run the query");
            return;
        }
        if (((SharedSoleneQueryResult)object2).getError() != 0) {
            stringBuffer.append("<Error type=\"" + ((SharedSoleneQueryResult)object2).getErrorString() + "\" />\n");
        } else {
            stringBuffer.append(((SharedSoleneQueryResult)object2).getXMLString());
        }
        stringBuffer.append("</ResultSet>\n");
        utf8out.print(stringBuffer);
        utf8out.flush();
        if (query_result_caching_enabled) {
            try {
                object = new FileWriter(file);
                ((Writer)object).write(stringBuffer.toString());
                ((OutputStreamWriter)object).close();
            }
            catch (Exception exception) {
                System.err.println("Warning: Exception occurred trying to write query result cache file (" + exception + ")");
            }
        }
    }

    protected static String fileSafe(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('%');
            stringBuffer.append((int)c);
        }
        return stringBuffer.toString();
    }
}

