/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

class FollowingJTextArea
extends JTextArea {
    private boolean follow = true;

    public FollowingJTextArea() {
        this.jInit();
    }

    private void jInit() {
        final JPopupMenu jPopupMenu = this.getPopupMenu();
        this.add(jPopupMenu);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    jPopupMenu.show(FollowingJTextArea.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public boolean isFollow() {
        return this.follow;
    }

    public void setFollow(boolean bl) {
        this.follow = bl;
    }

    private void scrollToEnd() {
        this.setCaretPosition(this.getDocument().getLength());
    }

    private void toggleFollow() {
        this.setFollow(!this.isFollow());
    }

    @Override
    public void append(String string) {
        super.append(string);
        if (this.follow) {
            this.scrollToEnd();
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu("Options");
        JMenuItem jMenuItem = new JMenuItem("Toggle Follow");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FollowingJTextArea.this.toggleFollow();
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Jump To End");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FollowingJTextArea.this.setCaretPosition(FollowingJTextArea.this.getDocument().getLength());
            }
        });
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem3 = new JMenuItem("Clear Text");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FollowingJTextArea.this.setText("");
            }
        });
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }
}

