/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.Properties;
import java.util.Vector;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.helper.FastIterator;
import jdbm.helper.StringComparator;
import jdbm.htree.HTree;

public class Jdb2Txt {
    static String TNAME = "greenstone";
    RecordManager recman_;
    HTree hashtable_;
    boolean sort_;
    private static PrintWriter utf8out = null;

    public Jdb2Txt(String string) throws IOException {
        this(string, false);
    }

    public Jdb2Txt(String string, boolean bl) throws IOException {
        this.sort_ = bl;
        if (string.endsWith(".jdb")) {
            string = string.substring(0, string.length() - 4);
        }
        Properties properties = new Properties();
        this.recman_ = RecordManagerFactory.createRecordManager((String)string, (Properties)properties);
        long l = this.recman_.getNamedObject(TNAME);
        if (l != 0L) {
            this.hashtable_ = HTree.load((RecordManager)this.recman_, (long)l);
        } else {
            System.err.println("Failed to find database table '" + TNAME + "' ...");
            System.exit(-1);
        }
    }

    public void db2txt() throws IOException {
        String string;
        Vector<String> vector = this.sort_ ? new Vector<String>() : null;
        FastIterator fastIterator = this.hashtable_.keys();
        String string22 = (String)fastIterator.next();
        while (string22 != null) {
            string = (String)this.hashtable_.get((Object)string22);
            if (this.sort_) {
                vector.add(string22);
            } else {
                Jdb2Txt.print_entry(string22, string);
            }
            string22 = (String)fastIterator.next();
        }
        if (this.sort_) {
            Collections.sort(vector, new StringComparator());
            for (String string22 : vector) {
                string = (String)this.hashtable_.get((Object)string22);
                Jdb2Txt.print_entry(string22, string);
            }
        }
        this.recman_.close();
    }

    public static void print_entry(String string, String string2) {
        utf8out.println("[" + string + "]");
        utf8out.println(string2);
        utf8out.println("----------------------------------------------------------------------");
    }

    public static void print_usage() {
        System.err.println("Usage: java Jdb2Txt [options] database-name");
        System.err.println("options: ");
        System.err.println(" -sort\tsort the keys to the database before output\n");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 2) {
            Jdb2Txt.print_usage();
        }
        String string = stringArray[0];
        boolean bl = false;
        if (stringArray.length == 2) {
            if (stringArray[0].equals("-sort")) {
                bl = true;
                string = stringArray[1];
            } else {
                System.err.println(stringArray[0] + " is not a valid option\n");
                Jdb2Txt.print_usage();
            }
        }
        try {
            Jdb2Txt jdb2Txt = new Jdb2Txt(string, bl);
            jdb2Txt.db2txt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
            utf8out = new PrintWriter((Writer)outputStreamWriter, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
    }
}

