/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.util.GLIEntityResolver;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.RemoveContentBeforeRootElementXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTools {
    public static final String WELLFORMED = "well-formed !";
    public static final String NOTWELLFORMED = "not well-formed";
    private static final String HEADER = "<?xml version='1.0' encoding='UTF-8'?><collectionConfig xmlns:gsf='http://www.greenstone.org/greenstone3/schema/ConfigFormat' xmlns:gslib='http://www.greenstone.org/skinning' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>";
    private static final String FOOTER = "</collectionConfig>";

    public static Node getNodeTextNode(Element element) {
        Node node;
        element.normalize();
        for (node = element.getFirstChild(); node != null && node.getNodeType() != 3; node = node.getNextSibling()) {
        }
        return node;
    }

    public static String getNodeText(Element element) {
        Node node = XMLTools.getNodeTextNode(element);
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    public static void setNodeText(Element element, String string) {
        Node node = XMLTools.getNodeTextNode(element);
        if (node != null) {
            element.removeChild(node);
        }
        Text text = element.getOwnerDocument().createTextNode(string);
        element.appendChild(text);
    }

    public static Node getChildByTagName(Node node, String string) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static Node getChildByTagNameIndexed(Node node, String string, int n) {
        if (n == -1) {
            return XMLTools.getChildByTagName(node, string);
        }
        int n2 = 0;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!node2.getNodeName().equals(string)) continue;
            if (n2 == n) {
                return node2;
            }
            ++n2;
        }
        return null;
    }

    public static Element getNamedElement(Element element, String string, String string2, String string3) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(string) || !((Element)node).getAttribute(string2).equals(string3)) continue;
            return (Element)node;
        }
        return null;
    }

    public static ArrayList getNamedElementList(Element element, String string, String string2, String string3) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(string) || !((Element)node).getAttribute(string2).equals(string3)) continue;
            arrayList.add((Element)node);
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        return arrayList;
    }

    public static ArrayList getNamedElementList(Element element, String string, String[] stringArray, String[] stringArray2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        if (stringArray2.length != stringArray.length) {
            System.err.println("getNamedElementList - different number of attribute names and values");
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(string)) continue;
            boolean bl = true;
            for (int j = 0; j < stringArray.length; ++j) {
                if (((Element)node).getAttribute(stringArray[j]).equals(stringArray2[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add((Element)node);
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        return arrayList;
    }

    public static void copyAllChildren(Element element, Element element2) {
        Document document = element.getOwnerDocument();
        for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
            element.appendChild(document.importNode(node, true));
        }
    }

    public static void duplicateElementList(Document document, Element element, NodeList nodeList, boolean bl) {
        int n = nodeList.getLength();
        if (n < 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element element2 = XMLTools.duplicateElement(document, (Element)nodeList.item(i), bl);
            element.appendChild(element2);
        }
    }

    public static Element duplicateElement(Document document, Element element, boolean bl) {
        return XMLTools.duplicateElementNS(document, element, null, bl);
    }

    public static Element duplicateElementNS(Document document, Element element, String string, boolean bl) {
        Node node;
        int n;
        Object object;
        Element element2 = string == null ? document.createElement(element.getTagName()) : document.createElementNS(string, element.getTagName());
        if (bl) {
            object = element.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                node = object.item(n);
                element2.setAttribute(node.getNodeName(), node.getNodeValue());
            }
        }
        object = element.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            node = object.item(n);
            element2.appendChild(document.importNode(node, true));
        }
        return element2;
    }

    public static final void clear(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    public static ArrayList getChildElementsByTagName(Element element, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public static String getElementTextValue(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            return node.getNodeValue();
        }
        return "";
    }

    public static final String getValue(Node node) {
        if (node == null) {
            return "";
        }
        if (node.getNodeName().equals("Subject")) {
            node = XMLTools.getNodeFromNamed(node, "Value");
        }
        if (node != null && node.hasChildNodes()) {
            StringBuffer stringBuffer = new StringBuffer();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals("#text")) continue;
                stringBuffer.append(node2.getNodeValue());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static final Node getNodeFromNamed(Node node, String string) {
        Node node2 = null;
        for (Node node3 = node.getFirstChild(); node3 != null && node2 == null; node3 = node3.getNextSibling()) {
            if (!node3.getNodeName().equals(string)) continue;
            node2 = node3;
        }
        return node2;
    }

    public static Document getDOM(String string) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string));
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    public static String parse(String string) {
        String string2 = WELLFORMED;
        string = HEADER + string + FOOTER;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(new StringReader(string));
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(new DefaultHandler());
            xMLReader.setErrorHandler(new DefaultHandler());
            xMLReader.parse(inputSource);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            string2 = "unable to get a document builder factory";
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string2 = "unable to configure parser";
        }
        catch (SAXParseException sAXParseException) {
            string2 = NOTWELLFORMED + XMLTools.getLocationString(sAXParseException) + sAXParseException.getMessage();
        }
        catch (SAXException sAXException) {
            string2 = string2 + " Fatal error: " + sAXException.toString();
        }
        catch (IOException iOException) {
            string2 = "Unable to read the input, i/o error";
        }
        return string2;
    }

    public static String parseDOM(String string) {
        String string2 = WELLFORMED;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(new StringReader(string));
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(new DefaultHandler());
            xMLReader.setErrorHandler(new DefaultHandler());
            xMLReader.parse(inputSource);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            string2 = "unable to get a document builder factory";
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string2 = "unable to configure parser";
        }
        catch (SAXParseException sAXParseException) {
            string2 = NOTWELLFORMED + XMLTools.getLocationString(sAXParseException) + sAXParseException.getMessage();
        }
        catch (SAXException sAXException) {
            string2 = string2 + " " + sAXException.toString();
        }
        catch (IOException iOException) {
            string2 = "Unable to read the input, i/o error";
        }
        return string2;
    }

    private static String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("(line ");
        stringBuffer.append(sAXParseException.getLineNumber() - 1);
        stringBuffer.append(", column ");
        stringBuffer.append(sAXParseException.getColumnNumber());
        stringBuffer.append("): ");
        return stringBuffer.toString();
    }

    public static Document parseXMLFile(String string, boolean bl) {
        InputStream inputStream;
        if (bl && (inputStream = JarTools.getResourceAsStream("/" + string)) != null) {
            return XMLTools.parseXML(inputStream);
        }
        return XMLTools.parseXMLFile(new File(string));
    }

    public static Document parseXMLFile(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return XMLTools.parseXML(new FileInputStream(file));
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
            return null;
        }
    }

    public static Document parseXML(InputStream inputStream) {
        Document document = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            document = XMLTools.parseXML(inputStreamReader);
            inputStreamReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return document;
    }

    public static Document parseXML(Reader reader) {
        Document document = null;
        String string = "";
        try {
            Object object;
            Object object2;
            BufferedReader bufferedReader = null;
            if (!DebugStream.isDebuggingEnabled()) {
                try {
                    bufferedReader = new BufferedReader(new RemoveContentBeforeRootElementXMLReader(reader));
                }
                catch (Exception exception) {
                    System.err.println("Exception while wrapping the reader in parseXML(Reader)");
                    exception.printStackTrace();
                }
            } else {
                object2 = new StringBuffer();
                object = new char[500];
                int n = reader.read((char[])object, 0, ((char[])object).length);
                while (n != -1) {
                    ((StringBuffer)object2).append((char[])object, 0, n);
                    n = reader.read((char[])object, 0, ((Object)object).length);
                }
                string = ((StringBuffer)object2).toString();
                reader.close();
                reader = null;
                object = null;
                object2 = null;
                bufferedReader = new BufferedReader(new StringReader(string));
            }
            object2 = new InputSource(bufferedReader);
            object = new DOMParser();
            ((DOMParser)object).setFeature("http://xml.org/sax/features/validation", false);
            ((DOMParser)object).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            ((DOMParser)object).setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
            ((DOMParser)object).setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            ((DOMParser)object).setEntityResolver(new GLIEntityResolver());
            ((DOMParser)object).parse((InputSource)object2);
            document = ((AbstractDOMParser)object).getDocument();
        }
        catch (SAXParseException sAXParseException) {
            XMLTools.showXMLParseFailureLine(sAXParseException, string);
        }
        catch (SAXException sAXException) {
            System.err.println("SAX exception: " + sAXException.getMessage());
            if (DebugStream.isDebuggingEnabled()) {
                DebugStream.println("Encountered a SAX exception when parsing the following:\n*********START\n" + string + "\n************END\n");
                DebugStream.println("Debug mode: Exiting the program as there was trouble parsing the XML...");
                System.exit(-1);
            }
            System.out.println("***Turn debugging on (run GLI with -debug) to view the XML contents that could not be parsed.");
            DebugStream.printStackTrace(sAXException);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return document;
    }

    public static void showXMLParseFailureLine(SAXParseException sAXParseException, String string) {
        if (string.startsWith("\n") || string.startsWith(" ") || string.startsWith("\t")) {
            DebugStream.println("ERROR: illegal start of XML. Space/tab/newline should not preceed xml declaration.\n");
            DebugStream.println("xmlContents (length is " + string.length() + "):\n" + string);
            return;
        }
        String string2 = "";
        int n = sAXParseException.getLineNumber();
        DebugStream.print("\n****SAXParseException on LINE NUMBER: " + n);
        if (DebugStream.isDebuggingEnabled()) {
            if (n != -1) {
                String[] stringArray = string.split("\n");
                if (stringArray.length > 0) {
                    DebugStream.println(" (number of lines: " + stringArray.length + ")");
                    string2 = stringArray.length >= n ? stringArray[n - 1] : "Error is past the last line (" + stringArray.length + "): " + stringArray[stringArray.length - 1];
                } else {
                    DebugStream.print("\n");
                }
                stringArray = null;
                DebugStream.println("The parsing error occurred on this line:\n***********START\n" + string2 + "\n***********END");
                DebugStream.println("SAXParseException message: " + sAXParseException.getMessage() + "\n");
            } else {
                DebugStream.println("Encountered a SAX exception when parsing the following:\n*********START\n" + string + "\n************END\n");
            }
            DebugStream.println("\nDebug mode: Exiting the program as there was trouble parsing the XML...");
            System.exit(-1);
        } else {
            System.out.println("***Turn debugging on (run GLI with -debug) to view the XML contents/line that could not be parsed.");
        }
    }

    public static StringBuffer readXMLStream(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            stringBuffer = XMLTools.readXMLStream(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Failed when trying to parse XML stream");
            unsupportedEncodingException.printStackTrace();
        }
        return stringBuffer;
    }

    public static StringBuffer readXMLStream(String string) {
        return XMLTools.readXMLStream(new StringReader(string));
    }

    public static StringBuffer readXMLStream(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = "";
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                    continue;
                }
                if (string.trim().startsWith("<?xml")) {
                    bl = true;
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                    continue;
                }
                System.err.println(string);
            }
            bufferedReader = null;
        }
        catch (Exception exception) {
            System.err.println("Failed when trying to parse XML stream");
            exception.printStackTrace();
        }
        return stringBuffer;
    }

    public static String removeInvalidCharacters(String string) {
        char[] cArray = new char[string.length()];
        int n = 0;
        char[] cArray2 = new char[string.length()];
        string.getChars(0, string.length(), cArray2, 0);
        for (int i = 0; i < cArray2.length; ++i) {
            char c = cArray2[i];
            if (!(c >= ' ' && c <= '\ud7ff' || c == '\t' || c == '\n' || c == '\r' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            cArray[n] = c;
            ++n;
        }
        return new String(cArray, 0, n);
    }

    public static void setElementTextValue(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            element.removeChild(node);
        }
        if (string != null) {
            element.appendChild(element.getOwnerDocument().createTextNode(string));
        }
    }

    public static final void setValue(Element element, String string) {
        XMLTools.clear(element);
        if (string != null) {
            element.appendChild(element.getOwnerDocument().createTextNode(string));
        }
    }

    public static void indentXML(Element element, int n) {
        Node node;
        Node node2;
        Document document = element.getOwnerDocument();
        String string = "\n";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        Text text = document.createTextNode(string);
        String string2 = "\n";
        for (int i = 0; i < n - 1; ++i) {
            string2 = string2 + "\t";
        }
        Text text2 = document.createTextNode(string2);
        boolean bl = false;
        for (node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 3 && node2.getNodeValue().matches("^\\s*$")) {
                node = node2;
                node2 = node2.getNextSibling();
                element.removeChild(node);
                if (node2 == null) break;
            }
            if (node2.getNodeType() != 1) continue;
            bl = true;
            break;
        }
        if (bl) {
            element.appendChild(text2);
        }
        for (node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2 != text2 && node2 != text && node2.getNodeType() == 3 && node2.getNodeValue().matches("^\\s*$")) {
                node = node2;
                node2 = node2.getNextSibling();
                element.removeChild(node);
                if (node2 == null) break;
            }
            if (node2.getNodeType() != 1) continue;
            element.insertBefore(text.cloneNode(false), node2);
            XMLTools.indentXML((Element)node2, n + 1);
        }
    }

    public static void writeXMLFile(File file, Document document, String[] stringArray) {
        XMLTools.indentXML(document.getDocumentElement(), 1);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setEncoding("UTF-8");
            outputFormat.setIndenting(true);
            outputFormat.setLineWidth(0);
            outputFormat.setPreserveSpace(true);
            if (stringArray != null) {
                outputFormat.setNonEscapingElements(stringArray);
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            XMLSerializer xMLSerializer = new XMLSerializer(bufferedWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public static void writeXMLFile(File file, Document document) {
        XMLTools.writeXMLFile(file, document, null);
    }

    public static void printXMLNode(Node node) {
        XMLTools.printXMLNode(node, 0);
    }

    public static void printXMLNode(Node node, int n) {
        NodeList nodeList;
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        if (node.getNodeType() == 3) {
            if (node.getNodeValue() != "") {
                System.out.println(node.getNodeValue());
            }
            return;
        }
        System.out.print('<');
        System.out.print(node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                System.out.print(' ');
                System.out.print(node2.getNodeName());
                System.out.print("=\"");
                System.out.print(node2.getNodeValue());
                System.out.print('\"');
            }
        }
        if ((nodeList = node.getChildNodes()) == null || nodeList.getLength() == 0) {
            System.out.println("/>");
        } else {
            int n2;
            System.out.println('>');
            int n3 = nodeList.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                XMLTools.printXMLNode(nodeList.item(n2), n + 1);
            }
            for (n2 = 0; n2 < n; ++n2) {
                System.out.print(' ');
            }
            System.out.println("</" + node.getNodeName() + ">");
        }
    }

    public static String xmlNodeToString(Node node) {
        StringBuffer stringBuffer = new StringBuffer("");
        XMLTools.xmlNodeToString(stringBuffer, node, true, "\t", 2);
        return stringBuffer.toString();
    }

    public static String xmlNodeListToString(NodeList nodeList) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XMLTools.xmlNodeToString(stringBuffer, nodeList.item(i), true, "\t", 2);
        }
        return stringBuffer.toString();
    }

    public static void xmlNodeToString(StringBuffer stringBuffer, Node node, boolean bl, String string, int n) {
        int n2;
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 4) {
            if (node.getNodeValue() != "") {
                String string2 = node.getNodeValue();
                stringBuffer.append("<![CDATA[");
                stringBuffer.append(string2);
                stringBuffer.append("]]>");
            }
            return;
        }
        if (node.getNodeType() == 3) {
            if (node.getNodeValue() != "") {
                String string3 = node.getNodeValue();
                string3 = string3.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("[\\n\\r\\t\\s]*$", "");
                char[] cArray = string3.toCharArray();
                int n3 = cArray.length;
                for (int i = 0; i < n3; ++i) {
                    Character c = Character.valueOf(cArray[i]);
                    if (c.equals(Character.valueOf('\n'))) {
                        string3 = string3.replaceAll("^[\\n\\r\\t\\s]*", "");
                        break;
                    }
                    if (!Character.isWhitespace(c.charValue())) break;
                }
                stringBuffer.append(string3);
            }
            return;
        }
        if (node.getNodeType() == 8) {
            if (node.getNodeValue() != "") {
                stringBuffer.append("<!--\n" + node.getNodeValue().trim() + "\n-->\n");
            }
            return;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string);
            }
        }
        stringBuffer.append('<');
        stringBuffer.append(node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                stringBuffer.append(' ');
                stringBuffer.append(node2.getNodeName());
                stringBuffer.append("=\"");
                stringBuffer.append(node2.getNodeValue().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                stringBuffer.append('\"');
            }
        }
        NodeList nodeList = node.getChildNodes();
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            if (nodeList.item(n2).getNodeType() == 1) {
                bl2 = true;
            }
            if (nodeList.item(n2).getNodeType() != 3 && nodeList.item(n2).getNodeType() != 4 || !bl || nodeList.item(n2).getNodeValue().trim().length() <= 0) continue;
            bl3 = true;
            bl = false;
        }
        if (nodeList == null || nodeList.getLength() == 0) {
            stringBuffer.append("/>");
            if (bl) {
                stringBuffer.append("\n");
            }
        } else {
            int n4;
            stringBuffer.append(">");
            if (bl2 && bl) {
                stringBuffer.append("\n");
            }
            n2 = nodeList.getLength();
            for (n4 = 0; n4 < n2; ++n4) {
                XMLTools.xmlNodeToString(stringBuffer, nodeList.item(n4), bl, string, n + 1);
            }
            if (bl) {
                for (n4 = 0; n4 < n; ++n4) {
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append("</" + node.getNodeName() + ">");
            if (bl2 && bl || bl3) {
                stringBuffer.append("\n");
            }
        }
    }

    public static String xmlNodeToStringWithoutIndenting(Node node) {
        StringBuffer stringBuffer = new StringBuffer("");
        XMLTools.xmlNodeToStringWithoutNewline(stringBuffer, node, -1);
        return stringBuffer.toString();
    }

    public static String xmlNodeToStringWithoutNewline(Node node) {
        StringBuffer stringBuffer = new StringBuffer("");
        XMLTools.xmlNodeToStringWithoutNewline(stringBuffer, node, 0);
        return stringBuffer.toString();
    }

    private static void xmlNodeToStringWithoutNewline(StringBuffer stringBuffer, Node node, int n) {
        NodeList nodeList;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        if (node.getNodeType() == 3) {
            if (node.getNodeValue() != "") {
                stringBuffer.append(node.getNodeValue().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replace(">", "&gt;"));
            }
            return;
        }
        if (node.getNodeType() == 8) {
            if (node.getNodeValue() != "") {
                stringBuffer.append("<!--" + node.getNodeValue() + "-->");
            }
            return;
        }
        stringBuffer.append('<');
        stringBuffer.append(node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                stringBuffer.append(' ');
                stringBuffer.append(node2.getNodeName());
                stringBuffer.append("=\"");
                stringBuffer.append(node2.getNodeValue());
                stringBuffer.append('\"');
            }
        }
        if ((nodeList = node.getChildNodes()) == null || nodeList.getLength() == 0) {
            stringBuffer.append("/>");
        } else {
            int n2;
            stringBuffer.append(">");
            int n3 = nodeList.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                if (n >= 0) {
                    XMLTools.xmlNodeToStringWithoutNewline(stringBuffer, nodeList.item(n2), n + 1);
                    continue;
                }
                XMLTools.xmlNodeToStringWithoutNewline(stringBuffer, nodeList.item(n2), n);
            }
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("</" + node.getNodeName() + ">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String elementToString(Element element, boolean bl) {
        String string = "";
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            if (bl) {
                transformer.setOutputProperty("indent", "yes");
            } else {
                transformer.setOutputProperty("indent", "no");
            }
            transformer.transform(new DOMSource(element), new StreamResult(stringWriter));
            string = stringWriter.toString();
            return string;
        }
        catch (Exception exception) {
            string = string + "Exception: couldn't write " + element + " to log";
            return string;
        }
        finally {
            return string;
        }
    }
}

