/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.util.SafeProcess;

public class JarTools {
    private static Class root_class = null;
    private static ImageIcon ERROR_ICON = null;

    public static void initialise(Object object) {
        JarTools.initialise(object.getClass());
    }

    public static void initialise(Class clazz) {
        root_class = clazz;
        ERROR_ICON = JarTools.getImage("error.gif");
    }

    public static void extractFromJar(String string, String string2, boolean bl) {
        block3: {
            try {
                int n;
                InputStream inputStream = root_class.getResourceAsStream("/" + string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                String string3 = string2 + string;
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                byte[] byArray = new byte[1024];
                int n2 = 0;
                while ((n = dataInputStream.read(byArray)) >= 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                    n2 += n;
                }
                dataInputStream.close();
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                if (!bl) break block3;
                exception.printStackTrace();
            }
        }
    }

    public static ImageIcon getImage(String string) {
        return JarTools.getImage(string, false);
    }

    public static ImageIcon getImage(String string, boolean bl) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(root_class.getResource("/images/" + string));
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Error: Could not load image " + string);
            DebugStream.println("Error: Could not load image " + string);
        }
        if (imageIcon == null) {
            imageIcon = ERROR_ICON;
        }
        if (bl) {
            int n;
            while ((n = imageIcon.getImageLoadStatus()) != 2 && n != 4 && n != 8) {
            }
        }
        return imageIcon;
    }

    public static URL getResource(String string) {
        return root_class.getResource(string);
    }

    public static InputStream getResourceAsStream(String string) {
        return root_class.getResourceAsStream(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInJar(String string) {
        InputStream inputStream = null;
        try {
            inputStream = root_class.getResourceAsStream("/" + string);
            if (inputStream == null) {
                System.err.println("@@@ JarTools.isInJar(): file inputstream for file /" + string + " is still null. Not in jar file.");
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!SafeProcess.closeResource(inputStream)) {
                System.err.println("@@@ JarTools.isInJar(): Couldn't close file inputstream");
                return false;
            }
        }
        return true;
    }
}

