/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.remote;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipTools {
    public static void zipFiles(String string, String string2, String[] stringArray) {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            NullZipFilter nullZipFilter = new NullZipFilter();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                ZipTools.addFileToZip(zipOutputStream, string2, string3, nullZipFilter);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void addFileToZip(ZipOutputStream zipOutputStream, String string, String string2, ZipFilter zipFilter) {
        File file = new File(string + File.separator + string2);
        if (!file.exists()) {
            System.err.println("File " + file + " does not exist!");
            return;
        }
        try {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    ZipTools.addFileToZip(zipOutputStream, string, string2 + File.separator + fileArray[i].getName(), zipFilter);
                }
                if (fileArray.length == 0) {
                    String string3 = string2.replace('\\', '/') + File.separator + "empty";
                    System.err.println("Zipping empty dir requires dummy file: " + string3);
                    zipOutputStream.putNextEntry(new ZipEntry(string3));
                }
            } else if (zipFilter.shouldIncludeFile(string2)) {
                zipOutputStream.putNextEntry(new ZipEntry(string2.replace('\\', '/')));
                if (zipFilter.shouldIncludeFileContent(string2)) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    zipFilter.filterFileContent(string2, bufferedInputStream, zipOutputStream);
                    bufferedInputStream.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class NullZipFilter
    implements ZipFilter {
        @Override
        public boolean shouldIncludeFile(String string) {
            return true;
        }

        @Override
        public boolean shouldIncludeFileContent(String string) {
            return true;
        }

        @Override
        public void filterFileContent(String string, BufferedInputStream bufferedInputStream, ZipOutputStream zipOutputStream) {
            try {
                int n;
                byte[] byArray = new byte[1024];
                while ((n = bufferedInputStream.read(byArray, 0, 1024)) > -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static interface ZipFilter {
        public boolean shouldIncludeFile(String var1);

        public boolean shouldIncludeFileContent(String var1);

        public void filterFileContent(String var1, BufferedInputStream var2, ZipOutputStream var3);
    }
}

